<?php
namespace App\Model\Table;

use App\Model\Entity\ChestPainProtocol;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use Cake\ORM\TableRegistry;

/**
 * ChestPainProtocols Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 * @property \Cake\ORM\Association\BelongsTo $Screenings
 * @property \Cake\ORM\Association\BelongsToMany $Echocardiograms
 */
class ChestPainProtocolsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('chest_pain_protocols');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id'
        ]);
        $this->belongsTo('Screenings', [
            'foreignKey' => 'screening_id'
        ]);
        $this->belongsToMany('Echocardiograms', [
            'foreignKey' => 'chest_pain_protocol_id',
            'targetForeignKey' => 'echocardiogram_id',
            'joinTable' => 'chest_pain_protocols_echocardiograms'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->time('hora_zero')
            ->allowEmpty('hora_zero');

        $validator
            ->time('hora_ecg')
            ->allowEmpty('hora_ecg');

        $validator
            ->allowEmpty('suspeita_sca');

        $validator
            ->time('hora_trombolitico')
            ->allowEmpty('hora_trombolitico');

        $validator
            ->time('aas_hora')
            ->allowEmpty('aas_hora');

        $validator
            ->time('clopidogrel_hora')
            ->allowEmpty('clopidogrel_hora');

        $validator
            ->integer('ticagrelor')
            ->allowEmpty('ticagrelor');

        $validator
            ->allowEmpty('tmp_medio_permanencia_uci');

        $validator
            ->allowEmpty('tmp_medio_permanencia_hospitalar');

        $validator
            ->allowEmpty('aas_mg');

        $validator
            ->allowEmpty('has');

        $validator
            ->allowEmpty('disapidemia');

        $validator
            ->allowEmpty('sedentarismo');

        $validator
            ->allowEmpty('estresse');

        $validator
            ->allowEmpty('hf');

        $validator
            ->allowEmpty('tabagismo');

        $validator
            ->allowEmpty('ex_tabagista');

        $validator
            ->allowEmpty('obesidade');

        $validator
            ->allowEmpty('angina');

        $validator
            ->allowEmpty('iam');

        $validator
            ->allowEmpty('cat');

        $validator
            ->allowEmpty('avm_data');

        $validator
            ->allowEmpty('avm_ponte');

        $validator
            ->allowEmpty('icp_vasos');

        $validator
            ->boolean('ulcera')
            ->allowEmpty('ulcera');

        $validator
            ->boolean('cancer')
            ->allowEmpty('cancer');

        $validator
            ->boolean('sangramento')
            ->allowEmpty('sangramento');

        $validator
            ->allowEmpty('sangramento_sitio');

        $validator
            ->boolean('outros')
            ->allowEmpty('outros');

        $validator
            ->allowEmpty('outros_text');

        $validator
            ->allowEmpty('pa');

        $validator
            ->allowEmpty('peso');

        $validator
            ->allowEmpty('altura');

        $validator
            ->time('hora')
            ->allowEmpty('hora');

        $validator
            ->allowEmpty('fc');

        $validator
            ->allowEmpty('fr');

        $validator
            ->allowEmpty('sat02');

        $validator
            ->allowEmpty('tamp');

        $validator
            ->allowEmpty('av_de_enfermagem');

        $validator
            ->allowEmpty('anaminese');

        $validator
            ->allowEmpty('hipotese');

        $validator
            ->boolean('has_supra')
            ->allowEmpty('has_supra');

        $validator
            ->time('ecg_hora_1')
            ->allowEmpty('ecg_hora_1');

        $validator
            ->allowEmpty('porta_ecg');

        $validator
            ->allowEmpty('supra_mm');

        $validator
            ->allowEmpty('supra_der');

        $validator
            ->boolean('has_infra')
            ->allowEmpty('has_infra');

        $validator
            ->allowEmpty('infra_mm');

        $validator
            ->allowEmpty('infra_der');

        $validator
            ->boolean('has_tim')
            ->allowEmpty('has_tim');

        $validator
            ->allowEmpty('tim_mm');

        $validator
            ->allowEmpty('tim_der');

        $validator
            ->boolean('has_q_pet')
            ->allowEmpty('has_q_pet');

        $validator
            ->allowEmpty('q_pet_mm');

        $validator
            ->allowEmpty('q_pet_der');

        $validator
            ->boolean('has_bre')
            ->allowEmpty('has_bre');

        $validator
            ->allowEmpty('bre_mm');

        $validator
            ->boolean('has_bavt')
            ->allowEmpty('has_bavt');

        $validator
            ->boolean('has_bro')
            ->allowEmpty('has_bro');

        $validator
            ->allowEmpty('bro_mm');

        $validator
            ->time('ecg_hora_2')
            ->allowEmpty('ecg_hora_2');

        $validator
            ->time('ecg_hora_3')
            ->allowEmpty('ecg_hora_3');

        $validator
            ->boolean('alteracao_dinamica')
            ->allowEmpty('alteracao_dinamica');

        $validator
            ->allowEmpty('enzima_data_1');

        $validator
            ->time('enzima_hora_1')
            ->allowEmpty('enzima_hora_1');

        $validator
            ->allowEmpty('ck_mb_1');

        $validator
            ->allowEmpty('troponima_1');

        $validator
            ->allowEmpty('enzima_data_2');

        $validator
            ->time('enzima_hora_2')
            ->allowEmpty('enzima_hora_2');

        $validator
            ->allowEmpty('ck_mb_2');

        $validator
            ->allowEmpty('troponima_2');

        $validator
            ->allowEmpty('enzima_data_3');

        $validator
            ->time('enzima_hora_3')
            ->allowEmpty('enzima_hora_3');

        $validator
            ->allowEmpty('ck_mb_3');

        $validator
            ->allowEmpty('troponima');

        $validator
            ->allowEmpty('radiologia');

        $validator
            ->allowEmpty('evolucao');

        $validator
            ->allowEmpty('diagnostico_final');

        $validator
            ->allowEmpty('condicao_de_alta');

        $validator
            ->allowEmpty('instrucao_de_alta');

        $validator
            ->allowEmpty('pareceres');

        $validator
            ->allowEmpty('destino');

        $validator
            ->allowEmpty('data_saida');

        $validator
            ->allowEmpty('hora_saida');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        $validator
            ->allowEmpty('betabloq');

        $validator
            ->allowEmpty('eca');

        $validator
            ->allowEmpty('cm');

        $validator
            ->allowEmpty('epidemia');

        //$validator
            //->date('rvm_data')
            //->allowEmpty('rvm_data');

        $validator
            ->allowEmpty('rvm_pontes');

        //$validator
            //->date('icp_data')
            //->allowEmpty('icp_data');

        $validator
            ->boolean('rvm')
            ->allowEmpty('rvm');

        $validator
            ->integer('icp')
            ->allowEmpty('icp');

        $validator
            ->time('ticagrelor_hora')
            ->allowEmpty('ticagrelor_hora');

        return $validator;
    }

    public function getRelatorioData($hospitalizations, $date_before, $date_after) {
        $type_setor_unidade_intensiva = ['12', '13', '14'];
        $data = [
            'ecg'=> [
                'tempo_minino_ate_ecg' => 0,
                'tempo_maximo_ate_ecg' => 0,
                'tempo_medio_ate_ecg' => 0,
                'count_tempo_ate_ecg' => 0,
                'total_tempo_ate_ecg' => 0,
            ],
            'aas'=> [
                'tempo_minino_ate_aas' => 0,
                'tempo_maximo_ate_aas' => 0,
                'tempo_medio_ate_aas' => 0,
                'count_tempo_ate_aas' => 0,
                'total_tempo_ate_aas' => 0,
            ],
            'clopidogrel_ticagrelor'=> [
                'tempo_minino_ate_clopidogrel_ticagrelor' => 0,
                'tempo_maximo_ate_clopidogrel_ticagrelor' => 0,
                'tempo_medio_ate_clopidogrel_ticagrelor' => 0,
                'count_tempo_ate_clopidogrel_ticagrelor' => 0,
                'total_tempo_ate_clopidogrel_ticagrelor' => 0,
            ],
            'trombolitico'=> [
                'tempo_minino_ate_trombolitico' => 0,
                'tempo_maximo_ate_trombolitico' => 0,
                'tempo_medio_ate_trombolitico' => 0,
                'count_tempo_ate_trombolitico' => 0,
                'total_tempo_ate_trombolitico' => 0,
            ],
            'balao_hemodinamica'=> [
                'tempo_minino_ate_balao_hemodinamica' => 0,
                'tempo_maximo_ate_balao_hemodinamica' => 0,
                'tempo_medio_ate_balao_hemodinamica' => 0,
                'count_tempo_ate_balao_hemodinamica' => 0,
                'total_tempo_ate_balao_hemodinamica' => 0,
            ],
            'tempo_medio_unidade_intensiva' => 0,
            'total_tempo_unidade_intensiva' => 0,
            'count_tempo_unidade_intensiva' => 0
        ];


        foreach ($hospitalizations as $hospitalization) {
            //echo "<pre>";
            //print_r($hospitalization);
            $data_admisao =  new \DateTime($hospitalization->date_of_hospitalization->format('Y-m-d'));
            foreach ($hospitalization['chest_pain_protocols'] as $key => $chest_pain_protocol) {
                if($chest_pain_protocol['created'] < $date_after->format("Y-m-d") || $chest_pain_protocol['created'] > $date_before->format("Y-m-d")){
                    //echo "<pre>";
                    //print_r($chest_pain_protocol);
                    //data ECG inicio
                    if(isset($chest_pain_protocol->data_realizar_ecg)){
                        $date_ecg = new \DateTime($chest_pain_protocol->data_realizar_ecg->format('Y-m-d'));
                        $hora_ecg = $chest_pain_protocol->hora_realizar_ecg->i18nFormat('HH:mm');

                        $hora_ecg_array = explode(":", $hora_ecg);

                        $date_ecg->setTime($hora_ecg_array['0'], $hora_ecg_array['1'], '0');

                        $data = $this->dadosEcg($data, $data_admisao, $date_ecg);
                    }
                    //data ECG fim
                    //data aas inicio
                    if(isset($chest_pain_protocol->aas_mg_mastigar_engolir_1_data)){
                        $date_aas = new \DateTime($chest_pain_protocol->aas_mg_mastigar_engolir_1_data->format('Y-m-d'));
                        $hora_aas = $chest_pain_protocol->aas_mg_mastigar_engolir_1_hora->i18nFormat('HH:mm');

                        $hora_aas_array = explode(":", $hora_aas);

                        $date_aas->setTime($hora_aas_array['0'], $hora_aas_array['1'], '0');

                        $data = $this->dadosAas($data, $data_admisao, $date_aas);
                    }
                    //data aas fim

                    //data CLOPIDOGREL OU TICAGRELOR  inicio
                    if(isset($chest_pain_protocol->ticagrelor_data)){
                        //echo "ticagrelor";
                        $date_ticagrelor = new \DateTime($chest_pain_protocol->ticagrelor_data->format('Y-m-d'));
                        $hora_ticagrelor = $chest_pain_protocol->ticagrelor_hora->i18nFormat('HH:mm');

                        $hora_ticagrelor_array = explode(":", $hora_ticagrelor);

                        $date_ticagrelor->setTime($hora_ticagrelor_array['0'], $hora_ticagrelor_array['1'], '0');

                        $data = $this->dadosClopidogrelTicagrelor($data, $data_admisao, $date_ticagrelor);
                    }

                    /*if(isset($chest_pain_protocol->clopidogrel_300mg_data)){
                        echo "clopidogrel_hora";
                        $date_clopidogrel = new \DateTime($chest_pain_protocol->clopidogrel_300mg_data->format('Y-m-d'));
                        $hora_clopidogrel = $chest_pain_protocol->clopidogrel_300mg_hora->i18nFormat('HH:mm');

                        $hora_clopidogrel_array = explode(":", $hora_clopidogrel);

                        $date_clopidogrel->setTime($hora_clopidogrel_array['0'], $hora_clopidogrel_array['1'], '0');

                        $data = $this->dadosClopidogrelTicagrelor($data, $data_admisao, $date_clopidogrel);
                    }*/
                    //data CLOPIDOGREL OU TICAGRELOR  fim

                    //data TROMBOLÍTICO inicio
                    if(isset($chest_pain_protocol->trombolitico_data)){
                        $date_trombolitico = new \DateTime($chest_pain_protocol->trombolitico_data->format('Y-m-d'));
                        $hora_trombolitico = $chest_pain_protocol->trombolitico_hora->i18nFormat('HH:mm');

                        $hora_trombolitico_array = explode(":", $hora_trombolitico);

                        $date_trombolitico->setTime($hora_trombolitico_array['0'], $hora_trombolitico_array['1'], '0');

                        $data = $this->dadosTrombolitico($data, $data_admisao, $date_trombolitico);
                    }
                    //data TROMBOLÍTICO fim
                }


            }

            foreach ($hospitalization['historic_patient_movements'] as $key => $historic_patient_movement) {
                    //echo "<pre>";
                    //print_r($historic_patient_movement);
                    $type_setor = $this->typeSetor($historic_patient_movement['room_id']);
                    echo $type_setor . '<br>';
                    //verifica se pertence ao setor de terapia intensiva
                    if(in_array($type_setor, $type_setor_unidade_intensiva)){
                        if(isset($historic_patient_movement['data_inicio']) && isset($historic_patient_movement['data_termino'])){
                            //echo "<pre>";
                            //print_r($historic_patient_movement['data_inicio']);
                            echo $historic_patient_movement['data_inicio'];
                            $data_inicio = new \DateTime($historic_patient_movement->data_inicio->format('Y-m-d'));
                            if(isset($historic_patient_movement->hora_inicio)){
                                $hora_inicio = $historic_patient_movement->hora_inicio->i18nFormat('HH:mm');
                                $hora_inicio_array = explode(":", $hora_inicio);
                                $data_inicio->setTime($hora_inicio_array['0'], $hora_inicio_array['1'], '0');
                            }

                            $data_termino = new \DateTime($historic_patient_movement->data_termino->format('Y-m-d'));
                            if(isset($historic_patient_movement->hora_termino)){
                                $hora_termino = $historic_patient_movement->hora_termino->i18nFormat('HH:mm');
                                $hora_termino_array = explode(":", $hora_termino);
                                $data_termino->setTime($hora_termino_array['0'], $hora_termino_array['1'], '0');
                            }

                            $data_interval = $data_inicio->diff($data_termino);
                            //echo "<pre>";
                            //print_r($data_interval);
                            $data = $this->calcularTotal($data, $data_interval);
                        }
                    }
                }

            //convertendo em dia
            $total_em_dia = $data['total_tempo_unidade_intensiva'] * 0.041667;
            if ($total_em_dia > 0 &&
                $data['count_tempo_unidade_intensiva'] > 0)
            {
                $data['tempo_medio_unidade_intensiva'] = $total_em_dia / $data['count_tempo_unidade_intensiva'];
            }

            if($data['ecg']['count_tempo_ate_ecg'] !== 0)
            {
                $data['ecg']['tempo_medio_ate_ecg'] = $data['ecg']['total_tempo_ate_ecg'] / $data['ecg']['count_tempo_ate_ecg'];
            }

            if($data['aas']['count_tempo_ate_aas'] !== 0){
                $data['aas']['tempo_medio_ate_aas'] = $data['aas']['total_tempo_ate_aas'] / $data['aas']['count_tempo_ate_aas'];
            }

            if($data['trombolitico']['count_tempo_ate_trombolitico'] !== 0){
                $data['trombolitico']['tempo_medio_ate_trombolitico'] = $data['trombolitico']['total_tempo_ate_trombolitico'] / $data['trombolitico']['count_tempo_ate_trombolitico'];
            }

            if($data['clopidogrel_ticagrelor']['count_tempo_ate_clopidogrel_ticagrelor'] !== 0){
                $data['clopidogrel_ticagrelor']['tempo_medio_ate_clopidogrel_ticagrelor'] = $data['clopidogrel_ticagrelor']['total_tempo_ate_clopidogrel_ticagrelor'] / $data['clopidogrel_ticagrelor']['count_tempo_ate_clopidogrel_ticagrelor'];
            }
        }

        return $data;
    }
    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */

    // public function tempo_ecg(){

    // }

    public function typeSetor($room_id){
        $room_table = TableRegistry::get('Rooms');
        $sector_table = TableRegistry::get('Sectors');
        $room = $room_table->get($room_id);
        $sector = $sector_table->get($room['sector_id']);
        return $sector['type_id'];
    }

    public function calcularTotal($data, $intervalo){
        $ano = $intervalo->y;
        $mes = $intervalo->m;
        $dia = $intervalo->d;
        $hora = $intervalo->h;

        $hora += ($ano * 8760) + ($mes * 730.5);

        $data['total_tempo_unidade_intensiva'] += $hora;
        $data['count_tempo_unidade_intensiva']++;
        return $data;
    }

    public function dadosEcg($data, $data_admisao, $date_ecg){
        $intervalo_ecg = $data_admisao->diff($date_ecg);

        if($data['ecg']['tempo_minino_ate_ecg'] == 0){
            $data['ecg']['tempo_minino_ate_ecg'] = $intervalo_ecg->d;
        }
        else{
            if($intervalo_ecg->d < $data['ecg']['tempo_minino_ate_ecg'] ){
                $data['ecg']['tempo_minino_ate_ecg'] = $intervalo_ecg->d;
            }
        }

        if($data['ecg']['tempo_maximo_ate_ecg'] == 0){
            $data['ecg']['tempo_maximo_ate_ecg'] = $intervalo_ecg->d;
        }
        else{
            if($intervalo_ecg->d > $data['ecg']['tempo_maximo_ate_ecg'] ){
                $data['ecg']['tempo_maximo_ate_ecg'] = $intervalo_ecg->d;
            }
        }

        if($data['ecg']['total_tempo_ate_ecg'] == 0){
            $data['ecg']['total_tempo_ate_ecg'] = $intervalo_ecg->d;
        }
        else{
            $data['ecg']['total_tempo_ate_ecg'] += $intervalo_ecg->d;
        }

        $data['ecg']['count_tempo_ate_ecg']++;

        return $data;
    }

    public function dadosAas($data, $data_admisao, $date_aas){
        $intervalo_aas = $data_admisao->diff($date_aas);

        if($data['aas']['tempo_minino_ate_aas'] == 0){
            $data['aas']['tempo_minino_ate_aas'] = $intervalo_aas->d;
        }
        else{
            if($intervalo_aas->d < $data['aas']['tempo_minino_ate_aas'] ){
                $data['aas']['tempo_minino_ate_aas'] = $intervalo_aas->d;
            }
        }

        if($data['aas']['tempo_maximo_ate_aas'] == 0){
            $data['aas']['tempo_maximo_ate_aas'] = $intervalo_aas->d;
        }
        else{
            if($intervalo_aas->d > $data['aas']['tempo_maximo_ate_aas'] ){
                $data['aas']['tempo_maximo_ate_aas'] = $intervalo_aas->d;
            }
        }

        if($data['aas']['total_tempo_ate_aas'] == 0){
            //echo "asd";
            $data['aas']['total_tempo_ate_aas'] = $intervalo_aas->d;
            //echo $data['aas']['total_tempo_ate_aas'];
        }
        else{
            //echo "fas";
            $data['aas']['total_tempo_ate_aas'] += $intervalo_aas->d;
        }

        $data['aas']['count_tempo_ate_aas']++;

        return $data;
    }

    public function dadosTrombolitico($data, $data_admisao, $date_trombolitico){
        $intervalo_trombolitico = $data_admisao->diff($date_trombolitico);

        if($data['trombolitico']['tempo_minino_ate_trombolitico'] == 0){
            $data['trombolitico']['tempo_minino_ate_trombolitico'] = $intervalo_trombolitico->d;
        }
        else{
            if($intervalo_trombolitico->d < $data['trombolitico']['tempo_minino_ate_trombolitico'] ){
                $data['trombolitico']['tempo_minino_ate_trombolitico'] = $intervalo_trombolitico->d;
            }
        }

        if($data['trombolitico']['tempo_maximo_ate_trombolitico'] == 0){
            $data['trombolitico']['tempo_maximo_ate_trombolitico'] = $intervalo_trombolitico->d;
        }
        else{
            if($intervalo_trombolitico->d > $data['trombolitico']['tempo_maximo_ate_trombolitico'] ){
                $data['trombolitico']['tempo_maximo_ate_trombolitico'] = $intervalo_trombolitico->d;
            }
        }

        if($data['trombolitico']['total_tempo_ate_trombolitico'] == 0){
            //echo "asd";
            $data['trombolitico']['total_tempo_ate_trombolitico'] = $intervalo_trombolitico->d;
            //echo $data['aas']['total_tempo_ate_aasintervalo_trombolitico
        }
        else{
            //echo "fas";
            $data['trombolitico']['total_tempo_ate_trombolitico'] += $intervalo_trombolitico->d;
        }

        $data['trombolitico']['count_tempo_ate_trombolitico']++;

        return $data;
    }

    public function dadosClopidogrelTicagrelor($data, $data_admisao, $date_c_t){
        $intervalo_c_t = $data_admisao->diff($date_c_t);

        if($data['clopidogrel_ticagrelor']['tempo_minino_ate_clopidogrel_ticagrelor'] == 0){
            $data['clopidogrel_ticagrelor']['tempo_minino_ate_clopidogrel_ticagrelor'] = $intervalo_c_t->d;
        }
        else{
            if($intervalo_c_t->d < $data['clopidogrel_ticagrelor']['tempo_minino_ate_clopidogrel_ticagrelor'] ){
                $data['clopidogrel_ticagrelor']['tempo_minino_ate_clopidogrel_ticagrelor'] = $intervalo_c_t->d;
            }
        }

        if($data['clopidogrel_ticagrelor']['tempo_maximo_ate_clopidogrel_ticagrelor'] == 0){
            $data['clopidogrel_ticagrelor']['tempo_maximo_ate_clopidogrel_ticagrelor'] = $intervalo_c_t->d;
        }
        else{
            if($intervalo_c_t->d > $data['clopidogrel_ticagrelor']['tempo_maximo_ate_clopidogrel_ticagrelor'] ){
                $data['clopidogrel_ticagrelor']['tempo_maximo_ate_clopidogrel_ticagrelor'] = $intervalo_c_t->d;
            }
        }

        if($data['clopidogrel_ticagrelor']['total_tempo_ate_clopidogrel_ticagrelor'] == 0){
            $data['clopidogrel_ticagrelor']['total_tempo_ate_clopidogrel_ticagrelor'] = $intervalo_c_t->d;
        }
        else{
            $data['clopidogrel_ticagrelor']['total_tempo_ate_clopidogrel_ticagreloro'] += $intervalo_c_t->d;
        }

        $data['clopidogrel_ticagrelor']['count_tempo_ate_clopidogrel_ticagrelor']++;

        return $data;
    }

    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        $rules->add($rules->existsIn(['screening_id'], 'Screenings'));
        return $rules;
    }
}
