<?php
namespace App\Model\Table;

use App\Model\Entity\DailyItuPreventionBundle;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";

/**
 * DailyItuPreventionBundles Model
 *
 * @property \Cake\ORM\Association\BelongsTo $ItuPreventionBundles
 */
class DailyItuPreventionBundlesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('daily_itu_prevention_bundles');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('ItuPreventionBundles', [
            'foreignKey' => 'itu_prevention_bundle_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('curativo')
            ->allowEmpty('curativo');

        $validator
            ->boolean('presenca_sangue')
            ->allowEmpty('presenca_sangue');

        $validator
            ->boolean('presenca_secrecao')
            ->allowEmpty('presenca_secrecao');

        $validator
            ->boolean('cateter_devidamente')
            ->allowEmpty('cateter_devidamente');

        $validator
            ->boolean('conector_exposto')
            ->allowEmpty('conector_exposto');

        $validator
            ->boolean('via_cateter')
            ->allowEmpty('via_cateter');

        $validator
            ->boolean('administracao')
            ->allowEmpty('administracao');

        $validator
            ->boolean('avaliado_a_retirada')
            ->allowEmpty('avaliado_a_retirada');

        $validator
            ->boolean('active')
            ->allowEmpty('active');

        return $validator;
    }

    public function getRelatorioData($hospitalizations, $date_before, $date_after)
    {
        $calc_obj = new MedidasDispersao();

        $data =
            [
            'total_de_registros' => 0,

            'total_de_bundles_nao_preenchido' => 0,
            //Julio
            'total_de_dias_no_periodo_ate_hoje' => 0,

            //VALOR TOTAL DE BUNDLES DIÁRIOS PREENCHIDOS / DIAS NO PERÍODO
            'percen_bundles_por_dias' => 0,
            'tot_bundles_por_dias' => 0,

            'total_dias_no_periodo' => 0,

            'tot_dispositivos_inseridos' => 0,

            'percen_bundles_por_procedimentos'=>0,
            'tot_bundles_por_procedimentos'=>0,

            //VALOR TOTAL DE BUNDLES DIÁRIOS PREENCHIDOS / TOTAL DE PACIENTES-DIA
            'percen_bundles_por_tempo_de_uso' => 0,
            'tot_bundles_por_tempo_de_uso' => 0,

            //VALOR TOTAL DE BUNDLES DIÁRIOS NÂO PREENCHIDOS / DIAS NO PERÍODO
            'percen_bundles_por_dias_nao_preenchido' => 0,
            'tot_bundles_por_dias_nao_preenchido' => 0,

            //VALOR TOTAL DE BUNDLES DIÁRIOS NÃO PREENCHIDOS / TOTAL DE PACIENTES-DIA
            'tot_bundles_por_tempo_de_uso_nao_preenchido' => 0,
            'percen_bundles_por_tempo_de_uso_nao_preenchido' => 0,

            'tot_tempo_uso_do_bundle'=>0,

            //VALOR TOTAL DE BUNDLES DIÁRIOS NÃo PREENCHIDOS / TOTAL DE PACIENTES COM INSTALAÇÃO DE DISPOSITIVO
            'percen_bundles_por_procedimentos_nao_preenchido' => 0,
            'tot_bundles_por_procedimentos_nao_preenchido' => 0,

        ];

        $data['total_dias_no_periodo'] = $date_before->diff($date_after)->days;

        foreach ($hospitalizations as $hospitalization)
        {
            foreach ($hospitalization["supportive_measures"] as $key_1 => $supportive_measure)
            {
                if ($supportive_measure['data_inicio'] >= $date_before &&
                    $supportive_measure['data_termino'] <= $date_after
                )
                {
                    if (stripos($supportive_measure['type'], 'cateter vesical') !== false)
                    {
                        $data["tot_dispositivos_inseridos"]++;
                        // $data['tot_procedimento_cateter_vesical']++;

                        // if (in_array($hospitalization->id, $data['arr_internacao_procedimento_vesical']) == false)
                        // {
                        //     array_push($data['arr_internacao_procedimento_vesical'], $hospitalization->id);
                        //     $data['tot_internacao_procedimento_vesical']++;
                        // }
                    }
                }
            }

            //$data = $hospitalization["neonatal_checklists"];
            foreach ($hospitalization['itu_prevention_bundles'] as $key_1 => $bundle)
            {
                if (isset($bundle['date_instalation']) &&
                    isset($bundle['date_of_withdrawal']))
                {
                    $bundle['date_instalation'] = new \DateTime($bundle['date_instalation']->format('d-m-Y'));
                    $bundle['date_of_withdrawal'] = new \DateTime($bundle['date_of_withdrawal']->format('d-m-Y'));

                    $data['tot_tempo_uso_do_bundle'] += $bundle['date_instalation']->diff($bundle['date_of_withdrawal'])->d;
                    $data['total_de_dias_no_periodo_ate_hoje'] += $bundle['date_instalation']->diff($bundle['date_of_withdrawal'])->d ;
                }


                foreach ($bundle["daily_itu_prevention_bundles"] as $daily_bundle)
                {
                    if ($daily_bundle['created'] <= $date_after)
                    {
                        $bundle_arr = (array) $daily_bundle;
                        $i = 0;

                        $data['total_de_registros']++;

                        foreach ($bundle_arr as $key_2 => $value_2)
                        {
                            $i++;
                            if ($i == 2) //acessa as propriades do obj
                            {
                                foreach ($value_2 as $key_3 => $value_3)
                                {
                                    formatArr($value_3, $data, $key_3);
                                }
                            }
                        }
                    }


                }
            }
        }

        foreach ($data as $key => $value)
        {
            $marcados = 0;
            if (isset($data[$key]['arr']))
            {
                $len = count($data[$key]['arr']);

                for ($i = 0; $i < $len; $i++)
                {
                    if ($data[$key]['arr'][$i] || $data[$key]['arr'][$i] !== 0)
                    {
                        $marcados++;
                    }
                }
            }


            if (isset($data[$key]['percentual']))
            {
                $data[$key]['total'] = count($data[$key]['arr']);
                $data[$key]['percentual'] = $calc_obj->calculate_percentage($marcados, $data['total_de_registros']);
                $data[$key]['media'] = $calc_obj->calc_average($data[$key]['arr']);
                $data[$key]['mediana'] = $calc_obj->calculate_median($data[$key]['arr']);
                $data[$key]['desvio_padrao'] = $calc_obj->standard_deviation($data[$key]['arr']);
            }
        }

         if ($data['total_de_registros'] > 0 &&
            $data['total_de_dias_no_periodo_ate_hoje'] > 0
        )
        {
            $data['total_de_bundles_nao_preenchido'] = $data['total_de_dias_no_periodo_ate_hoje'] - $data['total_de_registros'];
        }

        if ($data['total_de_registros'] > 0 &&
            $data['tot_dispositivos_inseridos'] > 0
        )
        {
            $data['percen_bundles_por_procedimentos'] = ($data['total_de_registros'] * 100) / $data['tot_dispositivos_inseridos'];
            $data['percen_bundles_por_procedimentos'] = round($data['percen_bundles_por_procedimentos'], 2);

            $data['tot_bundles_por_procedimentos'] = $data['total_de_registros']  / $data['tot_dispositivos_inseridos'];
            $data['tot_bundles_por_procedimentos'] = round($data['tot_bundles_por_procedimentos'], 2);
        }

        if ($data['total_de_registros'] > 0 &&
            $data['tot_tempo_uso_do_bundle'] > 0
        )
        {
            $data['percen_bundles_por_tempo_de_uso'] = ($data['total_de_registros'] * 100) / $data['total_de_dias_no_periodo_ate_hoje'];
            $data['percen_bundles_por_tempo_de_uso'] = round($data['percen_bundles_por_tempo_de_uso'], 2);

            $data['tot_bundles_por_tempo_de_uso'] = $data['total_de_registros']  / $data['total_de_dias_no_periodo_ate_hoje'];
            $data['tot_bundles_por_tempo_de_uso'] = round($data['tot_bundles_por_tempo_de_uso'], 2);
        }

        if ($data['total_de_bundles_nao_preenchido'] > 0 &&
            $data['total_dias_no_periodo'] > 0
        )
        {
            $data['percen_bundles_por_dias_nao_preenchido'] = ($data['total_de_bundles_nao_preenchido'] * 100) / $data['total_dias_no_periodo'];
            $data['percen_bundles_por_dias_nao_preenchido'] = round($data['percen_bundles_por_dias_nao_preenchido'], 2);

            $data['tot_bundles_por_dias_nao_preenchido'] = ($data['tot_bundles_por_dias_nao_preenchido'] * 100) / $data['total_dias_no_periodo'];
            $data['tot_bundles_por_dias_nao_preenchido'] = round($data['tot_bundles_por_dias_nao_preenchido'], 2);
        }

        if ($data['total_de_bundles_nao_preenchido'] > 0 &&
            $data['tot_dispositivos_inseridos'] > 0
        )
        {
            $data['percen_bundles_por_procedimentos_nao_preenchido'] = ($data['total_de_bundles_nao_preenchido'] * 100) / $data['tot_dispositivos_inseridos'];
            $data['percen_bundles_por_procedimentos_nao_preenchido'] = round($data['percen_bundles_por_procedimentos_nao_preenchido'], 2);

            $data['tot_bundles_por_procedimentos_nao_preenchido'] = $data['total_de_bundles_nao_preenchido'] / $data['tot_dispositivos_inseridos'];
            $data['tot_bundles_por_procedimentos_nao_preenchido'] = round($data['tot_bundles_por_procedimentos_nao_preenchido'], 2);

            
        }

        if ($data['total_de_bundles_nao_preenchido'] > 0 &&
            $data['tot_tempo_uso_do_bundle'] > 0
        )
        {
            $data['percen_bundles_por_tempo_de_uso_nao_preenchido'] = ($data['total_de_bundles_nao_preenchido'] * 100) / $data['tot_tempo_uso_do_bundle'];
            $data['percen_bundles_por_tempo_de_uso_nao_preenchido'] = round($data['percen_bundles_por_tempo_de_uso_nao_preenchido'], 2);

            $data['tot_bundles_por_tempo_de_uso_nao_preenchido'] = $data['total_de_bundles_nao_preenchido']  / $data['tot_tempo_uso_do_bundle'];
            $data['tot_bundles_por_tempo_de_uso_nao_preenchido'] = round($data['tot_bundles_por_tempo_de_uso_nao_preenchido'], 2);
        }

        if ($data['total_de_registros'] > 0 &&
            $data['total_dias_no_periodo'] > 0
        )
        {
            $data['percen_bundles_por_dias'] = ($data['total_de_registros'] * 100) / $data['total_dias_no_periodo'];
            $data['percen_bundles_por_dias'] = round($data['percen_bundles_por_dias'], 2);

            $data['tot_bundles_por_dias'] = ($data['total_de_registros']) / $data['total_dias_no_periodo'];
            $data['tot_bundles_por_dias'] = round($data['tot_bundles_por_dias'], 2);
        }

        return $data;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['itu_prevention_bundle_id'], 'ItuPreventionBundles'));
        return $rules;
    }
}
