<?php
namespace App\Model\Table;

use App\Model\Entity\MedicationsCulture;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * MedicationsCultures Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Medications
 * @property \Cake\ORM\Association\BelongsTo $Cultures
 */
class MedicationsCulturesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('medications_cultures');
        $this->displayField('medication_id');
        $this->primaryKey(['medication_id', 'culture_id']);

        $this->belongsTo('Medications', [
            'foreignKey' => 'medication_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Cultures', [
            'foreignKey' => 'culture_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['medication_id'], 'Medications'));
        $rules->add($rules->existsIn(['culture_id'], 'Cultures'));
        return $rules;
    }
}
