<?php
namespace App\Model\Table;

use App\Model\Entity\NutritionalAssessment;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";

/**
 * NutritionalAssessments Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class NutritionalAssessmentsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('nutritional_assessments');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->integer('percentual_de_energia_programado_atingido')
            ->allowEmpty('percentual_de_energia_programado_atingido');

        $validator
            ->boolean('imc_e_menor_do_que_20_5')
            ->allowEmpty('imc_e_menor_do_que_20_5');

        $validator
            ->boolean('paciente_perdeu_peso_nos_ultimos_3_meses')
            ->allowEmpty('paciente_perdeu_peso_nos_ultimos_3_meses');

        $validator
            ->boolean('paciente_teve_sua_ingestao_dietetica')
            ->allowEmpty('paciente_teve_sua_ingestao_dietetica');

        $validator
            ->boolean('paciente_e_gravemente_doente')
            ->allowEmpty('paciente_e_gravemente_doente');

        $validator
            ->boolean('estado_nutricional_normal')
            ->allowEmpty('estado_nutricional_normal');

        $validator
            ->boolean('perda_e_peso_maior_5_em_3_meses')
            ->allowEmpty('perda_e_peso_maior_5_em_3_meses');

        $validator
            ->boolean('perda_e_peso_maior_5_em_2_meses')
            ->allowEmpty('perda_e_peso_maior_5_em_2_meses');

        $validator
            ->boolean('perda_e_peso_maior_5_em_1_meses')
            ->allowEmpty('perda_e_peso_maior_5_em_1_meses');

        return $validator;
    }

    public function getRelatorioDataBySector($hospitalizations, $date_before, $date_after, $sectors)
    {
        $data = [

        ];

        foreach ($sectors as $sector)
        {
            $sector_id = $sector['id'];
            $dummy_arr = [
                'name' => $sector['name'],

                'arr_pacientes' => [],
                'tot_pacientes' => 0,

                'arr_pacientes_receberam_jejum' => [],
                'tot_pacientes_receberam_jejum' => 0,
                'percen_pacientes_receberam_jejum' => 0,
            ];

            $data[$sector_id] = $dummy_arr;
        }

        foreach ($hospitalizations as $hospitalization)
        {
            foreach ($hospitalization["nutritional_assessments"] as $nutrition)
            {
                if ($nutrition['sector_id'])
                {
                    $sector_id = $nutrition['sector_id'];

                    if (!in_array($hospitalization->id, $data[$sector_id]['arr_pacientes']))
                    {
                        array_push($data[$sector_id]['arr_pacientes'], $hospitalization->id);
                        $data[$sector_id]['tot_pacientes']++;
                    }

                    if (!in_array($hospitalization->id, $data[$sector_id]['arr_pacientes_receberam_jejum']))
                    {
                        array_push($data[$sector_id]['arr_pacientes_receberam_jejum'], $hospitalization->id);
                        $data[$sector_id]['tot_pacientes_receberam_jejum']++;
                    }
                }
            }
        }

        foreach ($data as $sector_key => $sector)
        {
            if ($sector['tot_pacientes_receberam_jejum'] > 0)
            {
                $data[$sector_key]['percen_pacientes_receberam_jejum'] = ($sector['tot_pacientes_receberam_jejum'] * 100) / $sector['tot_pacientes'];
                $data[$sector_key]['percen_pacientes_receberam_jejum'] = round($data[$sector_key]['percen_pacientes_receberam_jejum'], 2);
            }
        }

        return $data;
    }

    public function getRelatorioData($hospitalizations, $date_before, $date_after, $sectors)
    {
        $calc_obj = new MedidasDispersao();

        $data = [
            'total_de_registros' => 0,
            'tot_patient_suspeita_me' => [
                'arr' => [],
            ],

            'arr_pacientes' => [],
            'tot_pacientes' => 0,

            'media_tempo_ausencia_nutricao' => 0,
            'arr_tempo_ausencia_nutricao' => [],
            'media_diaria_jejum' => 0,

            'arr_manha_distribuicao_diaria_jejum' => [],
            'tot_manha_distribuicao_diaria_jejum' => 0,
            'percen_manha_distribuicao_diaria_jejum' => 0,

            'arr_tarde_distribuicao_diaria_jejum' => [],
            'tot_tarde_distribuicao_diaria_jejum' => 0,
            'percen_tarde_distribuicao_diaria_jejum' => 0,

            'arr_noite_distribuicao_diaria_jejum' => [],
            'tot_noite_distribuicao_diaria_jejum' => 0,
            'percen_noite_distribuicao_diaria_jejum' => 0,

            'arr_evolucao_leve' => [],
            'tot_evolucao_leve' => 0,
            'percen_evolucao_leve' => 0,

            'arr_evolucao_moderada' => [],
            'tot_evolucao_moderada' => 0,
            'percen_evolucao_moderada' => 0,

            'arr_evolucao_grave' => [],
            'tot_evolucao_grave' => 0,
            'percen_evolucao_grave' => 0,

            'risco_nutricional_eutrofico' => [
                'arr_evolucao_eutrofico' => [],
                'tot_evolucao_eutrofico' => 0,
                'percen_evolucao_eutrofico' => 0,

                'arr_evolucao_leve' => [],
                'tot_evolucao_leve' => 0,
                'percen_evolucao_leve' => 0,

                'arr_evolucao_moderada' => [],
                'tot_evolucao_moderada' => 0,
                'percen_evolucao_moderada' => 0,

                'arr_evolucao_grave' => [],
                'tot_evolucao_grave' => 0,
                'percen_evolucao_grave' => 0,
            ],

            'risco_nutricional_leve' => [
                'arr_evolucao_eutrofico' => [],
                'tot_evolucao_eutrofico' => 0,
                'percen_evolucao_eutrofico' => 0,

                'arr_evolucao_leve' => [],
                'tot_evolucao_leve' => 0,
                'percen_evolucao_leve' => 0,

                'arr_evolucao_moderada' => [],
                'tot_evolucao_moderada' => 0,
                'percen_evolucao_moderada' => 0,

                'arr_evolucao_grave' => [],
                'tot_evolucao_grave' => 0,
                'percen_evolucao_grave' => 0,
            ],

            'risco_nutricional_moderado' => [
                'arr_evolucao_eutrofico' => [],
                'tot_evolucao_eutrofico' => 0,
                'percen_evolucao_eutrofico' => 0,

                'arr_evolucao_leve' => [],
                'tot_evolucao_leve' => 0,
                'percen_evolucao_leve' => 0,

                'arr_evolucao_moderada' => [],
                'tot_evolucao_moderada' => 0,
                'percen_evolucao_moderada' => 0,

                'arr_evolucao_grave' => [],
                'tot_evolucao_grave' => 0,
                'percen_evolucao_grave' => 0,
            ],

            'risco_nutricional_grave' => [
                'arr_evolucao_eutrofico' => [],
                'tot_evolucao_eutrofico' => 0,
                'percen_evolucao_eutrofico' => 0,

                'arr_evolucao_leve' => [],
                'tot_evolucao_leve' => 0,
                'percen_evolucao_leve' => 0,

                'arr_evolucao_moderada' => [],
                'tot_evolucao_moderada' => 0,
                'percen_evolucao_moderada' => 0,

                'arr_evolucao_grave' => [],
                'tot_evolucao_grave' => 0,
                'percen_evolucao_grave' => 0,
            ],

            'nutric_score_values' => [
                '0' => [
                    'arr_evolucao_leve' => [],
                    'tot_evolucao_leve' => 0,
                    'percen_evolucao_leve' => 0,

                    'arr_evolucao_moderada' => [],
                    'tot_evolucao_moderada' => 0,
                    'percen_evolucao_moderada' => 0,

                    'arr_evolucao_grave' => [],
                    'tot_evolucao_grave' => 0,
                    'percen_evolucao_grave' => 0,
                ],

                '1' => [
                    'arr_evolucao_leve' => [],
                    'tot_evolucao_leve' => 0,
                    'percen_evolucao_leve' => 0,

                    'arr_evolucao_moderada' => [],
                    'tot_evolucao_moderada' => 0,
                    'percen_evolucao_moderada' => 0,

                    'arr_evolucao_grave' => [],
                    'tot_evolucao_grave' => 0,
                    'percen_evolucao_grave' => 0,
                ],

                '2' => [
                    'arr_evolucao_leve' => [],
                    'tot_evolucao_leve' => 0,
                    'percen_evolucao_leve' => 0,

                    'arr_evolucao_moderada' => [],
                    'tot_evolucao_moderada' => 0,
                    'percen_evolucao_moderada' => 0,

                    'arr_evolucao_grave' => [],
                    'tot_evolucao_grave' => 0,
                    'percen_evolucao_grave' => 0,
                ],

                '3' => [
                    'arr_evolucao_leve' => [],
                    'tot_evolucao_leve' => 0,
                    'percen_evolucao_leve' => 0,

                    'arr_evolucao_moderada' => [],
                    'tot_evolucao_moderada' => 0,
                    'percen_evolucao_moderada' => 0,

                    'arr_evolucao_grave' => [],
                    'tot_evolucao_grave' => 0,
                    'percen_evolucao_grave' => 0,
                ],

                '4' => [
                    'arr_evolucao_leve' => [],
                    'tot_evolucao_leve' => 0,
                    'percen_evolucao_leve' => 0,

                    'arr_evolucao_moderada' => [],
                    'tot_evolucao_moderada' => 0,
                    'percen_evolucao_moderada' => 0,

                    'arr_evolucao_grave' => [],
                    'tot_evolucao_grave' => 0,
                    'percen_evolucao_grave' => 0,
                ],

                '5' => [
                    'arr_evolucao_leve' => [],
                    'tot_evolucao_leve' => 0,
                    'percen_evolucao_leve' => 0,

                    'arr_evolucao_moderada' => [],
                    'tot_evolucao_moderada' => 0,
                    'percen_evolucao_moderada' => 0,

                    'arr_evolucao_grave' => [],
                    'tot_evolucao_grave' => 0,
                    'percen_evolucao_grave' => 0,
                ],

                '6' => [
                    'arr_evolucao_leve' => [],
                    'tot_evolucao_leve' => 0,
                    'percen_evolucao_leve' => 0,

                    'arr_evolucao_moderada' => [],
                    'tot_evolucao_moderada' => 0,
                    'percen_evolucao_moderada' => 0,

                    'arr_evolucao_grave' => [],
                    'tot_evolucao_grave' => 0,
                    'percen_evolucao_grave' => 0,
                ],

                '7' => [
                    'arr_evolucao_leve' => [],
                    'tot_evolucao_leve' => 0,
                    'percen_evolucao_leve' => 0,

                    'arr_evolucao_moderada' => [],
                    'tot_evolucao_moderada' => 0,
                    'percen_evolucao_moderada' => 0,

                    'arr_evolucao_grave' => [],
                    'tot_evolucao_grave' => 0,
                    'percen_evolucao_grave' => 0,
                ],

                '8' => [
                    'arr_evolucao_leve' => [],
                    'tot_evolucao_leve' => 0,
                    'percen_evolucao_leve' => 0,

                    'arr_evolucao_moderada' => [],
                    'tot_evolucao_moderada' => 0,
                    'percen_evolucao_moderada' => 0,

                    'arr_evolucao_grave' => [],
                    'tot_evolucao_grave' => 0,
                    'percen_evolucao_grave' => 0,
                ],
            ],

            'arr_pacientes_receberam_jejum' => [],
            'tot_pacientes_receberam_jejum' => 0,
            'percen_pacientes_receberam_jejum' => 0,

            'arr_pacientes_geb_calo_indireta' => [],
            'tot_pacientes_geb_calo_indireta' => 0,
            'percen_pacientes_geb_calo_indireta' => 0,

            'arr_pacientes_geb_calo_indireta_circ' => [],
            'tot_pacientes_geb_calo_indireta_circ' => 0,
            'percen_pacientes_geb_calo_indireta_circ' => 0,

            'tot_avaliacoes_geb_calo_indireta' => 0,
            'percen_avaliacoes_geb_calo_indireta' => 0,

            'tot_avaliacoes_geb_calo_indireta_circ' => 0,
            'percen_avaliacoes_geb_calo_indireta_circ' => 0,

            'tot_avalicoes_com_motivo_de_jejum' => 0,
            'motivo_de_jejum' => [
                '0' => ['tot' => 0, 'percen' => 0],
                '1' => ['tot' => 0, 'percen' => 0],
                '2' => ['tot' => 0, 'percen' => 0],
                '3' => ['tot' => 0, 'percen' => 0],
                '4' => ['tot' => 0, 'percen' => 0],
                '5' => ['tot' => 0, 'percen' => 0],
                '6' => ['tot' => 0, 'percen' => 0],
                '7' => ['tot' => 0, 'percen' => 0],
                '8' => ['tot' => 0, 'percen' => 0],
                '9' => ['tot' => 0, 'percen' => 0],
                '10' => ['tot' => 0, 'percen' => 0],
                '11' => ['tot' => 0, 'percen' => 0],
                '12' => ['tot' => 0, 'percen' => 0],
            ],

            'motivo_nao_atingir_vet_pleno' => [
                '0' => ['tot' => 0, 'percen' => 0],
                '1' => ['tot' => 0, 'percen' => 0],
                '2' => ['tot' => 0, 'percen' => 0],
                '3' => ['tot' => 0, 'percen' => 0],
                '4' => ['tot' => 0, 'percen' => 0],
            ],
            'motivo_nao_atingir_vept_pleno' => [
                '0' => ['tot' => 0, 'percen' => 0],
                '1' => ['tot' => 0, 'percen' => 0],
                '2' => ['tot' => 0, 'percen' => 0],
                '3' => ['tot' => 0, 'percen' => 0],
                '4' => ['tot' => 0, 'percen' => 0],
            ],

        ];

        foreach ($sectors as $sector)
        {
            $sector_id = $sector['id'];
            $dummy_arr = [
                'name' => $sector['name'],

// 'arr_pacientes' => [],

// 'tot_pacientes' => 0,

// 'arr_pacientes_receberam_jejum' => [],

// 'tot_pacientes_receberam_jejum' => 0,
                // 'percen_pacientes_receberam_jejum' => 0,

                'geral' => [
                    'arr_pacientes' => [],
                    'tot_pacientes' => 0,

                    'arr_pacientes_receberam_jejum' => [],
                    'tot_pacientes_receberam_jejum' => 0,
                    'percen_pacientes_receberam_jejum' => 0,

                    //Média de variação de risco nutricional por setor
                    'arr_nutri_score' => [],
                    'variancia_nutri_score' => 0,
                ],

                'clinica' => [
                    'arr_pacientes' => [],
                    'tot_pacientes' => 0,

                    'arr_pacientes_receberam_jejum' => [],
                    'tot_pacientes_receberam_jejum' => 0,
                    'percen_pacientes_receberam_jejum' => 0,

                    //Média de variação de risco nutricional por setor
                    'arr_nutri_score' => [],
                    'variancia_nutri_score' => 0,
                ],

                'cirurgica' => [
                    'arr_pacientes' => [],
                    'tot_pacientes' => 0,

                    'arr_pacientes_receberam_jejum' => [],
                    'tot_pacientes_receberam_jejum' => 0,
                    'percen_pacientes_receberam_jejum' => 0,

                    //Média de variação de risco nutricional por setor
                    'arr_nutri_score' => [],
                    'variancia_nutri_score' => 0,
                ],
            ];

            $data['setores'][$sector_id] = $dummy_arr;
        }

        foreach ($hospitalizations as $hospitalization)
        {
            $hospitalization_type = null;

            if (strpos($hospitalization['type'], 'Clínica') !== false)
            {
                $hospitalization_type = 'clinica';
            }
            elseif (strpos($hospitalization['type'], 'Cirúr') !== false)
            {
                $hospitalization_type = 'cirurgica';
            }

            if (!in_array($hospitalization->id, $data['arr_pacientes']))
            {
                array_push($data['arr_pacientes'], $hospitalization->id);
                $data['tot_pacientes']++;
            }

            $estagios_da_nutricao = [];

            if (count($hospitalization["nutritional_assessments"]) == 0)
            {
                $columns = $this->schema()->columns();

                foreach ($columns as $key => $column)
                {
                    $data[$column]['total'] = 0;
                    $data[$column]['percentual'] = 0;
                    $data[$column]['media'] = 0;
                    $data[$column]['mediana'] = 0;
                    $data[$column]['desvio_padrao'] = 0;
                    $data[$column]['soma'] = 0;
                }
            }

            foreach ($hospitalization["nutritional_assessments"] as $key_1 => $protocol)
            {
                if (isset($protocol['motivo_proteina']))
                {
                    $motivo = $protocol['motivo_proteina'];

                    if (isset($data['motivo_nao_atingir_vept_pleno'][$motivo]['tot']))
                    {
                        $data['motivo_nao_atingir_vept_pleno'][$motivo]['tot']++;
                    }
                }

                if (isset($protocol['motivo_energia']))
                {
                    $motivo = $protocol['motivo_energia'];

                    if (isset($data['motivo_nao_atingir_vet_pleno'][$motivo]['tot']))
                    {
                        $data['motivo_nao_atingir_vet_pleno'][$motivo]['tot']++;
                    }
                }

                if ($protocol['motivo_jejum'] && $protocol['motivo_jejum'] != "0")
                {
                    $motivo = $protocol['motivo_jejum'];
                    $data['motivo_de_jejum'][$motivo]['tot']++;
                    $data['tot_avalicoes_com_motivo_de_jejum']++;
                }

                if ($protocol['geb_type'] == 2)
                {
                    $data['tot_avaliacoes_geb_calo_indireta']++;

                    if (!in_array($hospitalization->id, $data['arr_pacientes_geb_calo_indireta']))
                    {
                        array_push($data['arr_pacientes_geb_calo_indireta'], $hospitalization->id);
                        $data['tot_pacientes_geb_calo_indireta']++;
                    }

                    if ($protocol['nutric_score'])
                    {
                        $nutric_score = $protocol['nutric_score'];

                        if (!in_array($hospitalization->id, $data['arr_pacientes_geb_calo_indireta']))
                        {
                            array_push($data['arr_pacientes_geb_calo_indireta'], $hospitalization->id);
                            $data['tot_pacientes_geb_calo_indireta']++;
                        }
                    }
                }
                elseif ($protocol['geb_type'] == 3)
                {
                    $data['tot_avaliacoes_geb_calo_indireta_circ']++;

                    if (!in_array($hospitalization->id, $data['arr_pacientes_geb_calo_indireta_circ']))
                    {
                        array_push($data['arr_pacientes_geb_calo_indireta_circ'], $hospitalization->id);
                        $data['tot_pacientes_geb_calo_indireta_circ']++;
                    }
                }

                if ($protocol['periodo_jejum_data'])
                {
                    if (!in_array($hospitalization->id, $data['arr_pacientes_receberam_jejum']))
                    {
                        array_push($data['arr_pacientes_receberam_jejum'], $hospitalization->id);
                        $data['tot_pacientes_receberam_jejum']++;
                    }
                }

                if ($protocol['sector_id'])
                {
                    $sector_id = $protocol['sector_id'];

//pega o nutric score de cada setor e passa pro array
                    if ($protocol['nutric_score'])
                    {
                        $nutric_score = $protocol['nutric_score'];
                        array_push($data['setores'][$sector_id]['geral']['arr_nutri_score'], $nutric_score);
                    }

                    if (!in_array($hospitalization->id, $data['setores'][$sector_id]['geral']['arr_pacientes']))
                    {
                        array_push($data['setores'][$sector_id]['geral']['arr_pacientes'], $hospitalization->id);
                        $data['setores'][$sector_id]['geral']['tot_pacientes']++;
                    }

//calcula os pacientes que nao receberam nutricao por setor
                    if (!in_array($hospitalization->id, $data['setores'][$sector_id]['geral']['arr_pacientes_receberam_jejum']))
                    {
                        array_push($data['setores'][$sector_id]['geral']['arr_pacientes_receberam_jejum'], $hospitalization->id);
                        $data['setores'][$sector_id]['geral']['tot_pacientes_receberam_jejum']++;
                    }

//verifica o tipo de internacao (clinica ou cirurgica)
                    if ($hospitalization_type)
                    {
                        if (!in_array($hospitalization->id, $data['setores'][$sector_id][$hospitalization_type]['arr_pacientes_receberam_jejum']))
                        {
                            array_push($data['setores'][$sector_id][$hospitalization_type]['arr_pacientes_receberam_jejum'], $hospitalization->id);
                            $data['setores'][$sector_id][$hospitalization_type]['tot_pacientes_receberam_jejum']++;
                        }

                        if (!in_array($hospitalization->id, $data['setores'][$sector_id][$hospitalization_type]['arr_pacientes']))
                        {
                            array_push($data['setores'][$sector_id][$hospitalization_type]['arr_pacientes'], $hospitalization->id);
                            $data['setores'][$sector_id][$hospitalization_type]['tot_pacientes']++;
                        }

                        if ($protocol['nutric_score'])
                        {
                            $nutric_score = $protocol['nutric_score'];
                            array_push($data['setores'][$sector_id][$hospitalization_type]['arr_nutri_score'], $nutric_score);
                        }
                    }
                }

//calc os pacientes que tiveram evolucao no estado nutricional
                if ($protocol['resultado'])
                {
                    //$nutric_score = $protocol['nutric_score'];
                    array_push($estagios_da_nutricao, $protocol['resultado']);
                }

                if ($protocol['hora_inicio_jejum'])
                {
                    $date_1 = strtotime('07:00:00');
                    $date_2 = strtotime('13:00:00');
                    $date_3 = strtotime('19:00:00');

                    $protocol['hora_inicio_jejum'] = strtotime($protocol['hora_inicio_jejum']->format('H:i:s'));

                    if ($protocol['hora_inicio_jejum'] >= $date_1 && $protocol['hora_inicio_jejum'] <= $date_2)
                    {
                        if (!in_array($hospitalization->id, $data['arr_manha_distribuicao_diaria_jejum']))
                        {
                            array_push($data['arr_manha_distribuicao_diaria_jejum'], $hospitalization->id);
                            $data['tot_manha_distribuicao_diaria_jejum']++;
                        }
                    }
                    elseif ($protocol['hora_inicio_jejum'] > $date_2 && $protocol['hora_inicio_jejum'] <= $date_3)
                    {

                        if (!in_array($hospitalization->id, $data['arr_tarde_distribuicao_diaria_jejum']))
                        {
                            array_push($data['arr_tarde_distribuicao_diaria_jejum'], $hospitalization->id);
                            $data['tot_tarde_distribuicao_diaria_jejum']++;
                        }
                    }
                    elseif ($protocol['hora_inicio_jejum'] > $date_3 && $protocol['hora_inicio_jejum'] < $date_1)
                    {

                        if (!in_array($hospitalization->id, $data['arr_noite_distribuicao_diaria_jejum']))
                        {
                            array_push($data['arr_tarde_distribuicao_diaria_jejum'], $hospitalization->id);
                            $data['tot_noite_distribuicao_diaria_jejum']++;
                        }
                    }
                }

                if ($protocol['periodo_jejum_data'] && $protocol['jejum_end_date'])
                {
                    $inicio_jejum = new \DateTime($protocol['periodo_jejum_data']->format('Y-m-d'));
                    $fim_jejum = new \DateTime($protocol['jejum_end_date']->format('Y-m-d'));
                    $days = $inicio_jejum->diff($fim_jejum)->days;

                    if ($days >= 0)
                    {
                        array_push($data['arr_tempo_ausencia_nutricao'], $days);
                        $data['media_tempo_ausencia_nutricao'] = $calc_obj->calc_average($data['arr_tempo_ausencia_nutricao']);
                    }
                }

                if (!in_array($hospitalization['patient_id'], $data['tot_patient_suspeita_me']['arr']))
                {
                    array_push($data['tot_patient_suspeita_me']['arr'], $hospitalization['patient_id']);
                }

                $arr = (array) $protocol;
                $i = 0;

                $data['total_de_registros']++;

                foreach ($arr as $key_2 => $value_2)
                {
                    $i++;

                    if ($i == 2) //acessa as propriades do obj
                    {
                        foreach ($value_2 as $key_3 => $value_3)
                        {
                            //$data[$key_3] = $value_3;
                            formatArr($value_3, $data, $key_3);
                        }
                    }
                }
            }

            $last_resultado = false;

            foreach ($estagios_da_nutricao as $resultado)
            {
                if ($last_resultado)
                {
                    if ($last_resultado == 0 && $resultado == 1)
                    {
                        if (!in_array($hospitalization->id, $data['risco_nutricional_eutrofico']['arr_evolucao_leve']))
                        {
                            array_push($data['risco_nutricional_eutrofico']['arr_evolucao_leve'], $hospitalization->id);
                            $data['risco_nutricional_eutrofico']['tot_evolucao_leve']++;

                            // array_push($data['nutric_score_values'][$nutric_score]['arr_evolucao_leve'], $hospitalization->id);
                            // $data['nutric_score_values'][$nutric_score]['tot_evolucao_leve']++;
                        }
                    }
                    else  if ($last_resultado == 0 && $resultado == 2)
                    {
                        if (!in_array($hospitalization->id, $data['risco_nutricional_eutrofico']['arr_evolucao_moderada']))
                        {
                            array_push($data['risco_nutricional_eutrofico']['arr_evolucao_moderada'], $hospitalization->id);
                            $data['risco_nutricional_eutrofico']['tot_evolucao_moderada']++;
                        }
                    }
                    else  if ($last_resultado == 0 && $resultado > 2)
                    {
                        if (!in_array($hospitalization->id, $data['risco_nutricional_eutrofico']['arr_evolucao_grave']))
                        {
                            array_push($data['risco_nutricional_eutrofico']['arr_evolucao_grave'], $hospitalization->id);
                            $data['risco_nutricional_eutrofico']['tot_evolucao_grave']++;
                        }
                    }
                    else if ($last_resultado == 1 && $resultado == 0)
                    {
                        if (!in_array($hospitalization->id, $data['risco_nutricional_leve']['arr_evolucao_eutrofico']))
                        {
                            array_push($data['risco_nutricional_leve']['arr_evolucao_eutrofico'], $hospitalization->id);
                            $data['risco_nutricional_leve']['tot_evolucao_eutrofico']++;
                        }
                    }
                    else if ($last_resultado == 1 && $resultado == 2)
                    {
                        if (!in_array($hospitalization->id, $data['risco_nutricional_leve']['arr_evolucao_moderada']))
                        {
                            array_push($data['risco_nutricional_leve']['arr_evolucao_moderada'], $hospitalization->id);
                            $data['risco_nutricional_leve']['tot_evolucao_moderada']++;
                        }
                    }
                    else if ($last_resultado == 1 && $resultado > 2)
                    {
                        if (!in_array($hospitalization->id, $data['risco_nutricional_leve']['arr_evolucao_grave']))
                        {
                            array_push($data['risco_nutricional_leve']['arr_evolucao_grave'], $hospitalization->id);
                            $data['risco_nutricional_leve']['tot_evolucao_grave']++;
                        }
                    }
                    elseif ($last_resultado == 2 && $resultado == 0)
                    {
                        if (!in_array($hospitalization->id, $data['risco_nutricional_moderado']['arr_evolucao_eutrofico']))
                        {
                            array_push($data['risco_nutricional_moderado']['arr_evolucao_eutrofico'], $hospitalization->id);
                            $data['risco_nutricional_moderado']['tot_evolucao_eutrofico']++;
                        }
                    }
                    elseif ($last_resultado == 2 && $resultado == 1)
                    {
                        if (!in_array($hospitalization->id, $data['risco_nutricional_moderado']['arr_evolucao_leve']))
                        {
                            array_push($data['risco_nutricional_moderado']['arr_evolucao_leve'], $hospitalization->id);
                            $data['risco_nutricional_moderado']['tot_evolucao_leve']++;
                        }
                    }
                    elseif ($last_resultado == 2 && $resultado > 2)
                    {
                        if (!in_array($hospitalization->id, $data['risco_nutricional_moderado']['arr_evolucao_grave']))
                        {
                            array_push($data['risco_nutricional_moderado']['arr_evolucao_grave'], $hospitalization->id);
                            $data['risco_nutricional_moderado']['tot_evolucao_grave']++;
                        }
                    }
                    elseif ($last_resultado > 2 && $resultado == 0)
                    {

                        if (!in_array($hospitalization->id, $data['risco_nutricional_grave']['arr_evolucao_eutrofico']))
                        {
                            array_push($data['risco_nutricional_grave']['arr_evolucao_eutrofico'], $hospitalization->id);
                            $data['risco_nutricional_grave']['tot_evolucao_eutrofico']++;
                        }
                    }
                    elseif ($last_resultado > 2 && $resultado == 1)
                    {

                        if (!in_array($hospitalization->id, $data['risco_nutricional_grave']['arr_evolucao_leve']))
                        {
                            array_push($data['risco_nutricional_grave']['arr_evolucao_leve'], $hospitalization->id);
                            $data['risco_nutricional_grave']['tot_evolucao_leve']++;
                        }
                    }
                    elseif ($last_resultado > 2 && $resultado == 2)
                    {

                        if (!in_array($hospitalization->id, $data['risco_nutricional_grave']['arr_evolucao_moderada']))
                        {
                            array_push($data['risco_nutricional_grave']['arr_evolucao_moderada'], $hospitalization->id);
                            $data['risco_nutricional_grave']['tot_evolucao_moderada']++;
                        }
                    }
                }
                
                $last_resultado = $resultado;
                
            }
        }

        foreach ($data as $key => $value)
        {
            $marcados = 0;

            if (isset($data[$key]['arr']))
            {
                $len = count($data[$key]['arr']);

                for ($i = 0; $i < $len; $i++)
                {
                    if ($data[$key]['arr'][$i] || $data[$key]['arr'][$i] !== 0)
                    {
                        $marcados++;
                    }
                }

                if (isset($data[$key]['percentual']))
                {
                    $data[$key]['total'] = count($data[$key]['arr']);
                    $data[$key]['percentual'] = $calc_obj->calculate_percentage($marcados, $data['total_de_registros']);
                    $data[$key]['media'] = $calc_obj->calc_average($data[$key]['arr']);
                    $data[$key]['mediana'] = $calc_obj->calculate_median($data[$key]['arr']);
                    $data[$key]['desvio_padrao'] = $calc_obj->standard_deviation($data[$key]['arr']);
                }
            }
        }

        if ($data['media_tempo_ausencia_nutricao'] > 0)
        {
            $date_before = new \DateTime($date_before->format('Y-m-d'));
            $date_after = new \DateTime($date_after->format('Y-m-d'));
            $tot_dias_no_periodos = $date_before->diff($date_after)->days;

            if ($tot_dias_no_periodos > 0)
            {
                $data['media_diaria_jejum'] = round($data['media_tempo_ausencia_nutricao'] / $tot_dias_no_periodos, 2);
            }
        }

        $total_distribuicao_diaria = $data['tot_manha_distribuicao_diaria_jejum'] + $data['tot_tarde_distribuicao_diaria_jejum'] + $data['tot_noite_distribuicao_diaria_jejum'];

        if ($data['tot_manha_distribuicao_diaria_jejum'] > 0)
        {
            $data['percen_manha_distribuicao_diaria_jejum'] = ($data['tot_manha_distribuicao_diaria_jejum'] * 100) / $total_distribuicao_diaria;
            $data['percen_manha_distribuicao_diaria_jejum'] = round($data['percen_manha_distribuicao_diaria_jejum'], 2);
        }

        if ($data['tot_tarde_distribuicao_diaria_jejum'] > 0)
        {
            $data['percen_tarde_distribuicao_diaria_jejum'] = ($data['tot_tarde_distribuicao_diaria_jejum'] * 100) / $total_distribuicao_diaria;
            $data['percen_tarde_distribuicao_diaria_jejum'] = round($data['percen_manha_distribuicao_diaria_jejum'], 2);
        }

        if ($data['tot_noite_distribuicao_diaria_jejum'] > 0)
        {
            $data['percen_noite_distribuicao_diaria_jejum'] = ($data['tot_noite_distribuicao_diaria_jejum'] * 100) / $total_distribuicao_diaria;
            $data['percen_noite_distribuicao_diaria_jejum'] = round($data['percen_manha_distribuicao_diaria_jejum'], 2);
        }
        foreach (['risco_nutricional_eutrofico', 'risco_nutricional_leve', 'risco_nutricional_moderado', 'risco_nutricional_grave'] as $risco_nutricional) 
        {
            $tot_paciente_av_inical = $data[$risco_nutricional]['tot_evolucao_leve'] + $data[$risco_nutricional]['tot_evolucao_eutrofico'] + 
                $data[$risco_nutricional]['tot_evolucao_grave'] + $data[$risco_nutricional]['tot_evolucao_moderada'];

            if ($data[$risco_nutricional]['tot_evolucao_eutrofico'] > 0 && $tot_paciente_av_inical > 0)
            {
                $data[$risco_nutricional]['percen_evolucao_eutrofico'] = ($data[$risco_nutricional]['tot_evolucao_eutrofico'] * 100) / $tot_paciente_av_inical;
                $data[$risco_nutricional]['percen_evolucao_eutrofico'] = round($data[$risco_nutricional]['percen_evolucao_eutrofico'], 2);
            }

            if ($data[$risco_nutricional]['tot_evolucao_leve'] > 0 && $tot_paciente_av_inical > 0)
            {
                $data[$risco_nutricional]['percen_evolucao_leve'] = ($data[$risco_nutricional]['tot_evolucao_leve'] * 100) / $tot_paciente_av_inical;
                $data[$risco_nutricional]['percen_evolucao_leve'] = round($data[$risco_nutricional]['percen_evolucao_leve'], 2);
            }

            if ($data[$risco_nutricional]['tot_evolucao_moderada'] > 0 && $tot_paciente_av_inical > 0)
            {
                $data[$risco_nutricional]['percen_evolucao_moderada'] = ($data[$risco_nutricional]['tot_evolucao_moderada'] * 100) / $tot_paciente_av_inical;
                $data[$risco_nutricional]['percen_evolucao_moderada'] = round($data[$risco_nutricional]['percen_evolucao_moderada'], 2);
            }

            if ($data[$risco_nutricional]['tot_evolucao_grave'] > 0 && $tot_paciente_av_inical > 0)
            {
                $data[$risco_nutricional]['percen_evolucao_grave'] = ($data[$risco_nutricional]['tot_evolucao_grave'] * 100) / $tot_paciente_av_inical;
                $data[$risco_nutricional]['percen_evolucao_grave'] = round($data[$risco_nutricional]['percen_evolucao_grave'], 2);
            }
        }        

        if ($data['tot_pacientes_receberam_jejum'] > 0)
        {
            $data['percen_pacientes_receberam_jejum'] = ($data['tot_pacientes_receberam_jejum'] * 100) / $data['tot_pacientes'];
            $data['percen_pacientes_receberam_jejum'] = round($data['percen_pacientes_receberam_jejum'], 2);
        }

        if ($data['tot_pacientes_geb_calo_indireta'] > 0)
        {
            $data['percen_pacientes_geb_calo_indireta'] = ($data['tot_pacientes_geb_calo_indireta'] * 100) / $data['tot_pacientes'];
            $data['percen_pacientes_geb_calo_indireta'] = round($data['percen_pacientes_geb_calo_indireta'], 2);
        }

        if ($data['tot_pacientes_geb_calo_indireta_circ'] > 0)
        {
            $data['percen_pacientes_geb_calo_indireta_circ'] = ($data['tot_pacientes_geb_calo_indireta_circ'] * 100) / $data['tot_pacientes'];
            $data['percen_pacientes_geb_calo_indireta_circ'] = round($data['percen_pacientes_geb_calo_indireta_circ'], 2);
        }

        if ($data['tot_avaliacoes_geb_calo_indireta'] > 0)
        {
            $data['percen_avaliacoes_geb_calo_indireta'] = ($data['tot_avaliacoes_geb_calo_indireta'] * 100) / $data['total_de_registros'];
            $data['percen_avaliacoes_geb_calo_indireta'] = round($data['percen_avaliacoes_geb_calo_indireta'], 2);
        }

        if ($data['tot_avaliacoes_geb_calo_indireta_circ'] > 0)
        {
            $data['percen_avaliacoes_geb_calo_indireta_circ'] = ($data['tot_avaliacoes_geb_calo_indireta_circ'] * 100) / $data['total_de_registros'];
            $data['percen_avaliacoes_geb_calo_indireta_circ'] = round($data['percen_avaliacoes_geb_calo_indireta_circ'], 2);
        }

        foreach ($data['setores'] as $sector_key => $sector)
        {
            if ($sector['geral']['tot_pacientes_receberam_jejum'] > 0)
            {
                $data['setores'][$sector_key]['geral']['percen_pacientes_receberam_jejum'] = ($sector['geral']['tot_pacientes_receberam_jejum'] * 100) / $sector['geral']['tot_pacientes'];
                $data['setores'][$sector_key]['geral']['percen_pacientes_receberam_jejum'] = round($data['setores'][$sector_key]['geral']['percen_pacientes_receberam_jejum'], 2);
            }

            if ($sector['clinica']['tot_pacientes_receberam_jejum'] > 0)
            {
                $data['setores'][$sector_key]['clinica']['percen_pacientes_receberam_jejum'] = ($sector['clinica']['tot_pacientes_receberam_jejum'] * 100) / $sector['clinica']['tot_pacientes'];
                $data['setores'][$sector_key]['clinica']['percen_pacientes_receberam_jejum'] = round($data['setores'][$sector_key]['clinica']['percen_pacientes_receberam_jejum'], 2);
            }

            if ($sector['cirurgica']['tot_pacientes_receberam_jejum'] > 0)
            {
                $data['setores'][$sector_key]['cirurgica']['percen_pacientes_receberam_jejum'] = ($sector['cirurgica']['tot_pacientes_receberam_jejum'] * 100) / $sector['cirurgica']['tot_pacientes'];
                $data['setores'][$sector_key]['cirurgica']['percen_pacientes_receberam_jejum'] = round($data['setores'][$sector_key]['cirurgica']['percen_pacientes_receberam_jejum'], 2);
            }

            if (count($sector['geral']['arr_nutri_score']) > 0)
            {
                $data['setores'][$sector_key]['geral']['variancia_nutri_score'] = $calc_obj->calc_average($sector['geral']['arr_nutri_score']);
            }

            if (count($sector['clinica']['arr_nutri_score']) > 0)
            {
                $data['setores'][$sector_key]['clinica']['variancia_nutri_score'] = $calc_obj->calc_average($sector['clinica']['arr_nutri_score']);
            }

            if (count($sector['cirurgica']['arr_nutri_score']) > 0)
            {
                $data['setores'][$sector_key]['cirurgica']['variancia_nutri_score'] = $calc_obj->calc_average($sector['cirurgica']['arr_nutri_score']);
            }
        }

        foreach ($data['motivo_de_jejum'] as $key_motiv => $motivo)
        {
            if ($motivo['tot'] > 0)
            {
                $data['motivo_de_jejum'][$key_motiv]['percen'] = ($motivo['tot'] * 100) / $data['tot_avalicoes_com_motivo_de_jejum'];
                $data['motivo_de_jejum'][$key_motiv]['percen'] = round($data['motivo_de_jejum'][$key_motiv]['percen'], 2);
            }
        }

        foreach ($data['motivo_nao_atingir_vept_pleno'] as $vept_key => $vept)
        {
            if ($vept['tot'] > 0)
            {
                $data['motivo_nao_atingir_vept_pleno'][$vept_key]['percen'] = ($vept['tot'] * 100) / $data['total_de_registros'];
                $data['motivo_nao_atingir_vept_pleno'][$vept_key]['percen'] = round($data['motivo_nao_atingir_vept_pleno'][$vept_key]['percen'], 2);
            }
        }

        foreach ($data['motivo_nao_atingir_vet_pleno'] as $vet_key => $vet)
        {
            if ($vet['tot'] > 0)
            {
                $data['motivo_nao_atingir_vet_pleno'][$vet_key]['percen'] = ($vet['tot'] * 100) / $data['total_de_registros'];
                $data['motivo_nao_atingir_vet_pleno'][$vet_key]['percen'] = round($data['motivo_nao_atingir_vet_pleno'][$vet_key]['percen'], 2);
            }
        }

        return $data;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
