<?php
namespace App\Model\Table;

use App\Model\Entity\OrgansSuspectedMeProtocol;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * OrgansSuspectedMeProtocols Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Organs
 * @property \Cake\ORM\Association\BelongsTo $SuspectedMeProtocols
 */
class OrgansSuspectedMeProtocolsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('organs_suspected_me_protocols');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('Organs', [
            'foreignKey' => 'organ_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('SuspectedMeProtocols', [
            'foreignKey' => 'suspected_me_protocol_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->integer('potenciais_orgaos')
            ->allowEmpty('potenciais_orgaos');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['organ_id'], 'Organs'));
        $rules->add($rules->existsIn(['suspected_me_protocol_id'], 'SuspectedMeProtocols'));
        return $rules;
    }
}
