<?php
namespace App\Model\Table;

use App\Model\Entity\PavPreventionBundle;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";

/**
 * PavPreventionBundles Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 * @property \Cake\ORM\Association\BelongsTo $Professionals
 */
class PavPreventionBundlesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */

    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->addBehavior('Timestamp');

        $this->table('pav_prevention_bundles');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER',
        ]);
        $this->belongsTo('Professionals', [
            'foreignKey' => 'professional_id',
            'joinType' => 'INNER',
        ]);

        $this->belongsTo('Screenings', [
            'foreignKey' => 'screening_id',
            'joinType' => 'INNER',
        ]);

        $this->hasMany('PavDiaryChecklists', [
            'foreignKey' => 'pav_prevention_bundle_id',
        ]);

        $this->belongsToMany('ImmediateComplications', [
            'foreignKey' => 'pav_prevention_bundle_id',
            'targetForeignKey' => 'immediate_complication_id',
            'joinTable' => 'immediate_complications_pav_prevention_bundles',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
        // ->date('data_da_instalacao')
        ->requirePresence('data_da_instalacao', 'create')
            ->notEmpty('data_da_instalacao');

        $validator
        // ->time('hora_da_instalacao')
        ->requirePresence('hora_da_instalacao', 'create')
            ->notEmpty('hora_da_instalacao');

        $validator
            ->requirePresence('tipo_de_dispositivo', 'create')
            ->notEmpty('tipo_de_dispositivo');

        $validator
            ->allowEmpty('tamanho_do_tot');

        $validator
            ->allowEmpty('mascara_laringea');

        $validator
            ->allowEmpty('traqueostomia');

        $validator
            ->boolean('verificado_o_risco_de_vad')
            ->allowEmpty('verificado_o_risco_de_vad');

        $validator
            ->boolean('tci_foi_preenchido')
            ->allowEmpty('tci_foi_preenchido');

        $validator
            ->boolean('procedimento_a_ser_realizado_foi_prescrito')
            ->allowEmpty('procedimento_a_ser_realizado_foi_prescrito');

        $validator
            ->allowEmpty('observacao');

        $validator
            ->boolean('higienizacao_adequada_das_maos')
            ->allowEmpty('higienizacao_adequada_das_maos');

        $validator
            ->boolean('uso_de_paramentacao_gorro')
            ->allowEmpty('uso_de_paramentacao_gorro');

        $validator
            ->boolean('esvaziamento_gastrico')
            ->allowEmpty('esvaziamento_gastrico');

        $validator
            ->boolean('uso_de_degermacao')
            ->allowEmpty('uso_de_degermacao');

        $validator
            ->boolean('uso_de_vni_previo_a_intubacao')
            ->allowEmpty('uso_de_vni_previo_a_intubacao');

        $validator
            ->boolean('pococionamento_adequado_do_paciente')
            ->allowEmpty('pococionamento_adequado_do_paciente');

        $validator
            ->boolean('uso_de_laringoscpio')
            ->allowEmpty('uso_de_laringoscpio');

        $validator
            ->boolean('utilizacao_de_bnm')
            ->allowEmpty('utilizacao_de_bnm');

        $validator
            ->boolean('intubacao_esofageana')
            ->allowEmpty('intubacao_esofageana');

        $validator
            ->allowEmpty('durante_procedimento_observacao');

        $validator
            ->allowEmpty('local_de_insercao');

        $validator
            ->boolean('intubacao_unica')
            ->allowEmpty('intubacao_unica');

        $validator
            ->integer('numero_de_tentativas')
            ->allowEmpty('numero_de_tentativas');

        $validator
            ->allowEmpty('uso_do_kit_vad');

        $validator
            ->allowEmpty('sucesso_na_insercao');

        $validator
            ->allowEmpty('controle_radiologico');

        $validator
            ->integer('numero_de_profissionais')
            ->allowEmpty('numero_de_profissionais');

        $validator
            ->allowEmpty('outra_informacao');

        $validator
            ->allowEmpty('complicacoes_imediatas');

        $validator
        // ->date('data_da_retirada')
        ->allowEmpty('data_da_retirada');

        $validator
        // ->time('hora_da_retirada')
        ->allowEmpty('hora_da_retirada');

        $validator
            ->boolean('retirada_acidental')
            ->allowEmpty('retirada_acidental');

        $validator
            ->allowEmpty('motivo_da_retirada_acidental');

        return $validator;
    }

    public function getRelatorioData($hospitalizations, $date_before, $date_after)
    {
        $calc_obj = new MedidasDispersao();

        $data =
        [
            'total_de_bundles' => 0,

            'tot_qtd_complicacao_imediata' => 0,

            'percen_qtd_complicacao_imediata'=>0,

            'percen_houve_complicacao_imediata' => 0,
            'tot_houve_complicacao_imediata' => 0,

            'arr_paciente_vent_mecanica' => [],
            'tot_paciente_vent_mecanica' => 0,

            //VALOR TOTAL DE BUNDLE DE INSTALAÇÃO DE TUBO TRAQUEAL / VALOR TOTAL DE PACIENTES MARCADOS COM VENTILAÇÃO MECÂNICA INVASIVA EM PROCEDIMENTOS
            'percen_tubo_traqueal_por_vent_mecanica' => 0,
            'tot_tubo_traqueal_por_vent_mecanica' => 0,

            'tot_de_tubo_traqueal' => 0,
            'percen_de_tubo_traqueal' => 0,

            'patient_ids' => [],
            'tot_pacientes' => 0,
            'tot_instalacao_por_paciente' => 0,
            'percen_instalacao_por_paciente' => 0,

            'tamanho_do_tot' => [
                'val' => 0,
            ],
            'tentativa_unica' => [
                'percentual' => 0,
                'total' => 0,
            ],
            'numero_de_tentativas' => [
                'sum' => 0,
            ],
            'tipo_de_dispositivo' => [
                'tot_orotraqueal' => 0,
                'percen_orotraqueal' => 0,
                'tot_nasotraqueal' => 0,
                'percen_nasotraqueal' => 0,
                'tot_traqueostomia' => 0,
                'percen_traqueostomia' => 0,
                'tot_mascara_laringea' => 0,
                'percen_mascara_laringea' => 0,
            ],

            'orotraqueal' => [
                'arr_time' =>[],
                'minimo'=> 0,
                'media'=> 0,
                'maximo'=> 0,
            ],
            'nasotraqueal' => [
                'arr_time' =>[],
                'minimo'=> 0,
                'media'=> 0,
                'maximo'=> 0,
            ],

            'complicacoes'=>[
                'tot_efisema' => 0,
                'percen_efisema' => 0,
                'tot_hematoma' => 0,
                'tot_pneumotorax' => 0,
                'percen_pneumotorax' => 0,
                'percen_outras' => 0,
                'percen_outras' => 0,
                'tot_aneurisma' => 0,
                'tot_fistula' => 0,
                'percen_fistula' => 0,
                'tot_hemotorax' => 0,
                'percen_hemotorax' => 0,
                'tot_hidrotorax' => 0,
                'percen_hidrotorax' => 0,
                'tot_cateter_mal' => 0,
                'percen_cateter_mal' => 0,
                'tot_pseusoaneurisma' => 0,
                'percen_pseusoaneurisma' => 0,
                'tot_puncao_arterial' => 0,
                'percen_puncao_arterial' => 0,
                'tot_puncao_nervo' => 0,
                'percen_puncao_nervo' => 0,
                'tot_puncao_peritonial' => 0,
                'percen_puncao_peritonial' => 0,
                'tot_quilotorax' => 0,
                'percen_quilotorax' => 0,
                'tot_transfixacao_vascular' => 0,
                'percen_transfixacao_vascular' => 0,
                'tot_lesao_esofago' => 0,
                'percen_lesao_esofago' => 0,
                'tot_lesao_traqueia' => 0,
                'percen_lesao_traqueia' => 0,
                'tot_lesao_oral' => 0,
                'percen_lesao_oral' => 0,
                'tot_barotrauma' => 0,
                'percen_barotrauma' => 0,
                'tot_volutrauma' => 0,
                'percen_volutrauma' => 0,
                'tot_broncoaspiracao' => 0,
                'percen_broncoaspiracao' => 0,

                'tot_trauma_facial' => 0,
                'percen_trauma_facial' => 0,

                'tot_avulcao_dentaria' => 0,
                'percen_avulcao_dentaria' => 0,

                'tot_trauma_cervical' => 0,
                'percen_trauma_cervical' => 0,
            ],

            //TEMPO MÉDIO, MEDIANO E COM DESVIO PADRÃO DE USO DO DISPOSITIVO
            'arr_dias_retirada' => [],
            'min_dias_retirada' => 0,
            'media_dias_retirada' => 0,
            'max_dias_retirada' => 0,
            'mediana_dias_retirada' => 0,
            'desvio_padrao_dias_retirada' => 0,

            //Pacientes com tempo de uso do dispositivo
            'pacientes_tempo_de_uso_inf_3' => [
                'arr' => [],
                'tot' =>0,
            ],

            'pacientes_tempo_de_uso_inf_7' => [
                'arr' => [],
                'tot' =>0,
            ],

            'pacientes_tempo_de_uso_inf_14' => [
                'arr' => [],
                'tot' =>0,
            ],

            'pacientes_tempo_de_uso_inf_21' => [
                'arr' => [],
                'tot' =>0,
            ],

            'pacientes_tempo_de_uso_sup_30' => [
                'arr' => [],
                'tot' =>0,
            ],


            'arr_paciente_retirada_acidental' => [],
            'tot_paciente_retirada_acidental' => 0,
            'percen_paciente_retirada_acidental' => 0,
        ];


          $columns = $this->schema()->columns();
          foreach ($columns as $key => $column)
          {
              $data[$column]['total'] = 0;
              $data[$column]['percentual'] = 0;
              $data[$column]['media'] = 0;
              $data[$column]['mediana'] = 0;
              $data[$column]['desvio_padrao'] = 0;
              $data[$column]['soma'] = 0;
          }
               
        foreach ($hospitalizations as $hospitalization)
        {
            if (count($hospitalization["pav_prevention_bundles"]) == 0)
            {
              $columns = $this->schema()->columns();
              foreach ($columns as $key => $column)
              {
                  $data[$column]['total'] = 0;
                  $data[$column]['percentual'] = 0;
                  $data[$column]['media'] = 0;
                  $data[$column]['mediana'] = 0;
                  $data[$column]['desvio_padrao'] = 0;
                  $data[$column]['soma'] = 0;
              }
            }

            if (!in_array($hospitalization['patient_id'], $data['patient_ids']))
            {
                array_push($data['patient_ids'], $hospitalization['patient_id']);
                $data['tot_pacientes']++;
            }

            if (isset($hospitalization["supportive_measures"]))
            {
                foreach ($hospitalization["supportive_measures"] as $key_1 => $procedimento)
                {
                    //$type = null;
                    if (stripos($procedimento['type'], 'Ventilação mecânica') !== false)
                    {
                        if (in_array($hospitalization['patient_id'], $data['arr_paciente_vent_mecanica']) == false)
                        {
                            array_push($data['arr_paciente_vent_mecanica'], $hospitalization['patient_id']);
                            $data['tot_paciente_vent_mecanica']++;
                        }
                    }
                }
            }

            //$data = $hospitalization["neonatal_checklists"];
            foreach ($hospitalization["pav_prevention_bundles"] as $bundle)
            {
                if (!$bundle['data_da_instalacao'] >= $date_before )
                {
                    continue;
                }

                if (in_array($hospitalization['patient_id'], $data['arr_paciente_vent_mecanica']))
                {                    
                    $data['tot_tubo_traqueal_por_vent_mecanica']++;
                }

                switch ($bundle['tipo_de_dispositivo'])
                {
                    case 'Tubo Orotraqueal':
                        $data['tipo_de_dispositivo']['tot_orotraqueal']++;
                        $data['tot_de_tubo_traqueal']++;
                        break;

                    case 'Tubo Nasotraqueal':
                        $data['tipo_de_dispositivo']['tot_nasotraqueal']++;
                        $data['tot_de_tubo_traqueal']++;
                        break;

                    case 'Cânula de Traqueostomia':
                        $data['tipo_de_dispositivo']['tot_traqueostomia']++;
                        break;

                    case 'Máscara Laríngea':
                        $data['tipo_de_dispositivo']['tot_mascara_laringea']++;
                        break;
                }


                if ($bundle['retirada_acidental'])
                {
                    if (in_array($hospitalization->id, $data['arr_paciente_retirada_acidental']) == false)
                    {
                        array_push($data['arr_paciente_retirada_acidental'], $hospitalization->id);
                        $data['tot_paciente_retirada_acidental']++;
                    }
                }

                if ($bundle['data_da_instalacao'] &&
                     $bundle['data_da_retirada'] &&
                    $bundle['data_da_retirada'] <= $date_after)
                {
                    $date_instalation = new \DateTime($bundle['data_da_instalacao']->format('Y-m-d'));
                    $date_of_withdrawal = new \DateTime($bundle['data_da_retirada']->format('Y-m-d'));
                    $days = $date_instalation->diff($date_of_withdrawal)->days;
                    if ($days > 0)
                    {
                        array_push($data['arr_dias_retirada'], $days);

                        if ($days < 3)
                        {
                            if (in_array($hospitalization->id, $data['pacientes_tempo_de_uso_inf_3']['arr']) == false)
                            {
                                array_push($data['pacientes_tempo_de_uso_inf_3']['arr'], $hospitalization->id);
                                $data['pacientes_tempo_de_uso_inf_3']['tot']++;
                            }
                        }
                        else if ($days < 7)
                        {
                            if (in_array($hospitalization->id, $data['pacientes_tempo_de_uso_inf_7']['arr']) == false)
                            {
                                array_push($data['pacientes_tempo_de_uso_inf_7']['arr'], $hospitalization->id);
                                $data['pacientes_tempo_de_uso_inf_7']['tot']++;
                            }
                        }
                        else if ($days < 14)
                        {
                            if (in_array($hospitalization->id, $data['pacientes_tempo_de_uso_inf_14']['arr']) == false)
                            {
                                array_push($data['pacientes_tempo_de_uso_inf_14']['arr'], $hospitalization->id);
                                $data['pacientes_tempo_de_uso_inf_14']['tot']++;
                            }
                        }
                        else if ($days < 21)
                        {
                            if (in_array($hospitalization->id, $data['pacientes_tempo_de_uso_inf_21']['arr']) == false)
                            {
                                array_push($data['pacientes_tempo_de_uso_inf_21']['arr'], $hospitalization->id);
                                $data['pacientes_tempo_de_uso_inf_21']['tot']++;
                            }
                        }
                        else if ($days > 30)
                        {
                            if (in_array($hospitalization->id, $data['pacientes_tempo_de_uso_sup_30']['arr']) == false)
                            {
                                array_push($data['pacientes_tempo_de_uso_sup_30']['arr'], $hospitalization->id);
                                $data['pacientes_tempo_de_uso_sup_30']['tot']++;
                            }
                        }
                    }
                }


                // calc
                if (count($bundle['immediate_complications']) > 0
                )
                {
                    $data['tot_houve_complicacao_imediata']++;
                }

                foreach ($bundle['immediate_complications'] as $value)
                {
                    $data['tot_qtd_complicacao_imediata']++;

                    if (isset($data['complicacoes'][$value['nome']]))
                    {
                        $data['complicacoes'][$value['nome']]['total']++;
                    }
                    else
                    {
                        $data['complicacoes'][$value['nome']] = [];
                        $data['complicacoes'][$value['nome']]['total'] = 1;
                    }
                }


                $attr_arr = (array) $bundle;
                $i = 0;

                $data['total_de_bundles']++;

                foreach ($attr_arr as $key_2 => $value_2)
                {
                    $i++;
                    if ($i == 2) //acessa as propriades do obj
                    {
                        foreach ($value_2 as $key_3 => $value_3)
                        {
                            //$data[$key_3] = $value_3;
                            formatArr($value_3, $data, $key_3);
                        }
                    }
                }
            }


        }

        foreach ($data as $key => $value)
        {
            if (isset($data[$key]['arr']))
            {
                $marcados = 0;

                $len = count($data[$key]['arr']);

                for ($i = 0; $i < $len; $i++)
                {
                    if ($data[$key]['arr'][$i] || $data[$key]['arr'][$i] !== 0)
                    {
                        $marcados++;
                    }
                }

                if (isset($data[$key]['percentual']))
                {
                    $data[$key]['total'] = count($data[$key]['arr']);
                    $data[$key]['percentual'] = $calc_obj->calculate_percentage($marcados, $data['total_de_bundles']);
                    $data[$key]['media'] = $calc_obj->calc_average($data[$key]['arr']);
                    $data[$key]['mediana'] = $calc_obj->calculate_median($data[$key]['arr']);
                    $data[$key]['desvio_padrao'] = $calc_obj->standard_deviation($data[$key]['arr']);
                }
            }
        }

        if (isset($data['tipo_de_dispositivo']))
        {

            if ($data['tipo_de_dispositivo']['tot_orotraqueal'] > 0 &&
                $data['total_de_bundles'] > 0 )
            {
                $data['tipo_de_dispositivo']['percen_orotraqueal'] = ($data['tipo_de_dispositivo']['tot_orotraqueal'] * 100) / $data['total_de_bundles'];
                $data['tipo_de_dispositivo']['percen_orotraqueal'] = round($data['tipo_de_dispositivo']['percen_orotraqueal'], 2);
            }

            if ($data['tipo_de_dispositivo']['tot_nasotraqueal'] > 0)
            {
                $data['tipo_de_dispositivo']['percen_nasotraqueal'] = ($data['tipo_de_dispositivo']['tot_nasotraqueal'] * 100) / $data['total_de_bundles'];
                $data['tipo_de_dispositivo']['percen_nasotraqueal'] = round($data['tipo_de_dispositivo']['percen_nasotraqueal'], 2);
            }

            if ($data['tipo_de_dispositivo']['tot_traqueostomia'] > 0)
            {
                $data['tipo_de_dispositivo']['percen_traqueostomia'] = ($data['tipo_de_dispositivo']['tot_traqueostomia'] * 100) / $data['total_de_bundles'];
                $data['tipo_de_dispositivo']['percen_traqueostomia'] = round($data['tipo_de_dispositivo']['percen_traqueostomia'], 2);
            }

            if ($data['tipo_de_dispositivo']['tot_mascara_laringea'] > 0)
            {
                $data['tipo_de_dispositivo']['percen_mascara_laringea'] = ($data['tipo_de_dispositivo']['tot_mascara_laringea'] * 100) / $data['total_de_bundles'];
                $data['tipo_de_dispositivo']['percen_mascara_laringea'] = round($data['tipo_de_dispositivo']['percen_mascara_laringea'], 2);
            }
        }

        if ($data['total_de_bundles'] > 0 && count($data['patient_ids']) > 0)
        {
            $data['percen_instalacao_por_paciente'] = round(($data['total_de_bundles'] * 100) / count($data['patient_ids']), 2);
            $data['tot_instalacao_por_paciente'] = round($data['total_de_bundles'] / count($data['patient_ids']), 2);
        }

        if (isset($data['tamanho_do_tot']['arr']) &&
            count($data['tamanho_do_tot']['arr']) > 0)
        {
            foreach ($data['tamanho_do_tot']['arr'] as $key => $value)
            {
                $data['tamanho_do_tot']['val'] += $value;
            }
        }

        if ($data['tot_de_tubo_traqueal'] >0 &&
            $data['total_de_bundles'] > 0)
        {
            $data['percen_de_tubo_traqueal'] = ($data['tot_de_tubo_traqueal']*100) / $data['total_de_bundles'] ;
            $data['percen_de_tubo_traqueal'] = round($data['percen_de_tubo_traqueal'], 2);
        }

        if (isset($data['numero_de_tentativas']['arr']) &&
            count($data['numero_de_tentativas']['arr']) > 0)
        {
            $tot_tentativa_unica = 0;
            $sum_tentativa = count($data['numero_de_tentativas']['arr']);
            foreach ($data['numero_de_tentativas']['arr'] as $key => $value)
            {
                $data['numero_de_tentativas']['sum'] += $value;
                if ($value == 1)
                {
                    $tot_tentativa_unica++;
                }
            }
            $data['tentativa_unica']['total'] = $tot_tentativa_unica;
            $data['tentativa_unica']['percentual'] = round(($tot_tentativa_unica * 100) / $sum_tentativa, 2);
        }

        if ($data['total_de_bundles'] > 0 &&
            $data['tot_tubo_traqueal_por_vent_mecanica'] > 0)
        {
            $data['percen_tubo_traqueal_por_vent_mecanica'] = ($data['tot_tubo_traqueal_por_vent_mecanica']*100) / $data['total_de_bundles'];
            $data['percen_tubo_traqueal_por_vent_mecanica'] = round($data['percen_tubo_traqueal_por_vent_mecanica'], 2);
        }


         //calcula a porcentagem de bundles com complicacoes imediatas
        if ($data['tot_qtd_complicacao_imediata'] > 0 &&
            $data['total_de_bundles'] > 0 )
        {
            $data['percen_qtd_complicacao_imediata'] = ($data['tot_qtd_complicacao_imediata'] * 100) / $data['total_de_bundles'];
            $data['percen_qtd_complicacao_imediata'] = round($data['percen_qtd_complicacao_imediata'], 2);
        }


        if (count($data['arr_dias_retirada']) > 0)
        {
            $data['media_dias_retirada'] = $calc_obj->calc_average($data['arr_dias_retirada']);
            $data['mediana_dias_retirada'] = $calc_obj->calculate_median($data['arr_dias_retirada']);
            $data['desvio_padrao_dias_retirada'] = $calc_obj->standard_deviation($data['arr_dias_retirada']);
            $data['max_dias_retirada'] = max($data['arr_dias_retirada']);
            $data['min_dias_retirada'] = min($data['arr_dias_retirada']);

        }

        if ($data['tot_pacientes'] > 0 &&
            $data['tot_paciente_retirada_acidental'] > 0)
        {
            $data['percen_paciente_retirada_acidental'] = ($data['tot_paciente_retirada_acidental'] * 100) / $data['tot_pacientes'];
            $data['percen_paciente_retirada_acidental'] = round($data['percen_paciente_retirada_acidental'], 2);
        }

        return $data;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        $rules->add($rules->existsIn(['professional_id'], 'Professionals'));
        return $rules;
    }
}
