<?php
namespace App\Model\Table;

use App\Model\Entity\SafeSurgeryBundlesTypeOfAnesthesia;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * SafeSurgeryBundlesTypeOfAnesthesias Model
 *
 * @property \Cake\ORM\Association\BelongsTo $SafeSurgeryBundles
 * @property \Cake\ORM\Association\BelongsTo $TypeOfAnesthesias
 */
class SafeSurgeryBundlesTypeOfAnesthesiasTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('safe_surgery_bundles_type_of_anesthesias');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('SafeSurgeryBundles', [
            'foreignKey' => 'safe_surgery_bundle_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('TypeOfAnesthesias', [
            'foreignKey' => 'type_of_anesthesia_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['safe_surgery_bundle_id'], 'SafeSurgeryBundles'));
        $rules->add($rules->existsIn(['type_of_anesthesia_id'], 'TypeOfAnesthesias'));
        return $rules;
    }
}
