<?php
namespace App\Model\Table;

use App\Model\Entity\TevOption;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * TevOptions Model
 *
 * @property \Cake\ORM\Association\BelongsToMany $SurgicalTevProtocols
 */
class TevOptionsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('tev_options');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsToMany('SurgicalTevProtocols', [
            'foreignKey' => 'tev_option_id',
            'targetForeignKey' => 'surgical_tev_protocol_id',
            'joinTable' => 'surgical_tev_protocols_tev_options'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('nome');

        $validator
            ->allowEmpty('tipo');

        return $validator;
    }
}
