<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Chest Pain Protocol']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Hospitalizations']), ['controller' => 'Hospitalizations', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Hospitalization']), ['controller' => 'Hospitalizations', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="chestPainProtocols index col-md-10 columns content">
    <h3>Chest Pain Protocols</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('hora_zero') ?></th>
                <th><?= $this->Paginator->sort('hora_ecg') ?></th>
                <th><?= $this->Paginator->sort('suspeita_sca') ?></th>
                <th><?= $this->Paginator->sort('hora_trombolitico') ?></th>
                <th><?= $this->Paginator->sort('aas_hora') ?></th>
                <th><?= $this->Paginator->sort('clopidogrel_hora') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($chestPainProtocols as $chestPainProtocol): ?>
            <tr>
                <td><?= $this->Number->format($chestPainProtocol->id) ?></td>
                <td><?= h($chestPainProtocol->hora_zero) ?></td>
                <td><?= h($chestPainProtocol->hora_ecg) ?></td>
                <td><?= h($chestPainProtocol->suspeita_sca) ?></td>
                <td><?= h($chestPainProtocol->hora_trombolitico) ?></td>
                <td><?= h($chestPainProtocol->aas_hora) ?></td>
                <td><?= h($chestPainProtocol->clopidogrel_hora) ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $chestPainProtocol->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $chestPainProtocol->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $chestPainProtocol->id], ['confirm' => __('Are you sure you want to delete # {0}?', $chestPainProtocol->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>