<?php
  $from = new DateTime($patient['birthday']->i18nFormat('dd-MM-yyyy'));
  $to   = new DateTime('today');
  $age  = null;
  $age  = $from->diff($to)->y;
?>
<div class="container unit-header">
        <div class="bundles form col-sm-4 columns content">
            
            <?= 
             $this->Html->image('uploads/'. $unit_logo, ['alt' => 'GH', 'height'=>'50px', 'style'=>"margin-top: 7px;"])
            ?>
            <br><br>
            <p class="unit-data"><b><?= $unit->name ?></b></p>
            <p class="unit-data"><b><?= $unit->telephone ?></b></p>
            <p class="unit-data"><b><?= $unit->street ?></b></p>
            <p class="unit-data"><b><?= $unit->city ?></b></p>
            <br>
        </div>   
        <div class="col-sm-8">
            <h1>Alta / Óbito</h1>
        </div>
     
</div>

<div class="col-sm-12 data-field">
  <table class="table table-bordered">
    <tr>
      <td><span class="inline-data"><b>Paciente:</b>&nbsp;<?= $patient->nome ?></span></td>
      <td><span class="inline-data"><b>Idade:</b>&nbsp;<?= $age ?></span></td>
      <td><span class="inline-data"><b>Setor:</b>&nbsp;<?= $hospitalization->sector['name'] ?></span></td>
      <td><span class="inline-data"><b>Leito:</b>&nbsp;<?= $hospitalization->roomName($hospitalization['id'])?></span></td>
      <td><span class="inline-data"><b>Prontuário:</b>&nbsp;<?= $hospitalization->numero_do_prontuario ?></span></td>
    </tr>
  </table>
  <br><br>
</div>

<div class="discharges form col-md-12 columns content">
    <?= $this->Form->create($discharge) ?>
    <fieldset>
        <?php

            if(isset($discharge['hora_previsao_alta_unidade'])){$discharge['hora_previsao_alta_unidade']=$discharge['hora_previsao_alta_unidade']->i18nFormat('HH:mm');}

            if(isset($discharge['hora_decisao_alta_unidade'])){$discharge['hora_decisao_alta_unidade']=$discharge['hora_decisao_alta_unidade']->i18nFormat('HH:mm');}


             if(isset($discharge['hora_saida_unidade'])){$discharge['hora_saida_unidade']=$discharge['hora_saida_unidade']->i18nFormat('HH:mm');}
             
             $checked_img = $this->Html->image('checked.png', ['class' => 'tick-box','alt' => 'GH', 'height'=>'22px', 'style'=>""]);

             $not_checked_img = $this->Html->image('not-checked.png', ['class' => 'tick-box','alt' => 'GH', 'height'=>'22px', 'style'=>""]);


            $condicao_clinica=["Curado", "Melhorado", "Inalterado", "Necessitando de assitência", "Paliativo"];
            $destino_apos_alta=['Residência', "Óbito", "Setor"];
                

            echo '<div class="col-sm-12 data-field">';
               echo '<b>Data da previsão da alta da unidade:</b>'.$discharge['data_previsao_alta_unidade'];
            echo '</div>';

            echo '<div class="col-sm-12 data-field">';
               echo '<b>Hora da previsão da alta da unidade:</b>'.$discharge['hora_previsao_alta_unidade'];
            echo '</div>';

            echo '<div class="col-sm-12 data-field">';
               echo '<b>Data da decisão da alta da unidade:</b>'.$discharge['data_decisao_alta_unidade'];
            echo '</div>';


            echo '<div class="col-sm-12 data-field">';
               echo '<b>Hora da decisão da alta da unidade:</b>'.$discharge['hora_decisao_alta_unidade'];
            echo '</div>';


            echo '<div class="col-sm-12 data-field">';
               echo '<b>Data de saída da unidade:</b>'.$discharge['data_saida_unidade'];
            echo '</div>';


            echo '<div class="col-sm-12 data-field">';
               echo '<b>Hora da saída da unidade:</b>'.$discharge['hora_saida_unidade'];
            echo '</div>';


            echo '<div class="col-sm-12 data-field">';
              if($discharge['entregue_o_resumo']){
                echo $checked_img.'<b>Entregue o resumo de internação hospitalar</b>';
              }else{
                echo $not_checked_img.'<b>Entregue o resumo de internação hospitalar</b>';
              }
            echo '</div>'; 


            echo '<div class="col-sm-12 data-field">';
              if($discharge['atendimento_ambulatorial']){
                echo $checked_img.'<b>Encaminhado ao atendimento ambulatorial</b>';
              }else{
                echo $not_checked_img.'<b>Encaminhado ao atendimento ambulatorial</b>';
              }
            echo '</div>'; 

            echo '<div class="col-sm-12 data-field">';
              if($discharge['entregue_prescricao_domiciliar']){
                echo $checked_img.'<b>Entregue a prescrição domiciliar</b>';
              }else{
                echo $not_checked_img.'<b>Entregue a prescrição domiciliar</b>';
              }
            echo '</div>'; 

            echo '<div class="col-sm-12 data-field">';
              if($discharge['entregue_as_orientacoes']){
                echo $checked_img.'<b>Entregues as orientações multidisciplinares de alta</b>';
              }else{
                echo $not_checked_img.'<b>Entregues as orientações multidisciplinares de alta</b>';
              }
            echo '</div>';

            echo '<div class="col-sm-12 data-field">';
              if($discharge['houve_decisao_para_cuidados']){
                echo $checked_img.'<b>Houve decisão para cuidados paliativos na unidade</b>';
              }else{
                echo $not_checked_img.'<b>Houve decisão para cuidados paliativos na unidade</b>';
              }
            echo '</div>';  


            echo '<div class="col-sm-12 data-field">';
               echo '<b>Data da decisão para cuidados paliativos na setor:</b>'.$discharge['data_decisao_para_cuidados'];
            echo '</div>';


            echo '<div class="col-sm-12 data-field">';
              if($discharge['realizado_pps2']){
                echo $checked_img.'<b>PPS2 realizado</b>';
              }else{
                echo $not_checked_img.'<b>PPS2 realizado</b>';
              }
            echo '</div>';  

            echo '<div class="col-sm-12 data-field">';
               echo '<b>Resultado PPS (%):</b>'.$discharge['resultado_pps'];
            echo '</div>';


            echo '<div class="col-sm-12 data-field">';
               echo '<b>Destino:</b>'.$destino_apos_alta[$discharge['destino_apos_alta']];
            echo '</div>';

            echo '<div class="col-sm-12 data-field">';
               echo '<b>Setor de Destino após a alta da unidade:</b>'.$sectors[$discharge['sector_id']];
            echo '</div>';


            echo '<div class="col-sm-12 data-field">';
               echo '<b>Condição clinica após a alta da unidade:</b>'.$condicao_clinica[$discharge['condicao_clinica']];
            echo '</div>';


        ?>
      
    </fieldset>

    <?= $this->Form->end() ?>
</div>

<script>
    (function() {

        $("form :input").prop('readonly', true);
        $("form :input").css('readonly', true);
        $('nav').css('display','none');
        window.print();
        setTimeout(function () { window.close(); },300);

    })();
</script>