<?php
	$accordion_id = null;
	if (isset($title)) {
		$avaliacaoArray = ['Bundles', 'Checklist', 'Enfermagem', 'Protocolos', 'Fisioterapia', 'Avaliação Nutricional'];
		$ccihArray = ['Culturas', 'Infecções'];
		$cirurgiaArray = ['TCI', 'Risco Cirúrgico', 'Visita Anestésica', 'Cirurgia'];
		$evolucaoArray = ['Boletim Médico', 'Escores', 'Medidas de Suporte e Procedimentos', 'Parecer Médico', 'Prescrições', 'Evolução'];

		//if($title == "Bundles" || $title == "Checklist")
		if(in_array($title, $avaliacaoArray)) {
			echo "<script>console.log('$title');</script>";
			$accordion_id = 'accordion2';
		}
		else if(in_array($title, $ccihArray)) {
			echo "<script>console.log('$title');</script>";
			$accordion_id = 'accordion3';
		}
		else if(in_array($title, $cirurgiaArray)) {
			echo "<script>console.log('$title');</script>";
			$accordion_id = 'accordion5';
		}
		else if(in_array($title, $evolucaoArray)) {
			echo "<script>console.log('$title');</script>";
			$accordion_id = 'accordion4';
		}
	}
	else {
		$accordion_id = '#tttt';
	}

	$hosp_date = date_create($hospitalization_date);

	$from = $selected_patient_birthday;
	$to = new DateTime('today');
	$age = $from->diff($to)->y;
?>
<script>
document.addEventListener('DOMContentLoaded', function() { 
	var ele = document.getElementById('<?php echo $accordion_id; ?>');
	//alert(ele);
	//console.log(ele);
	if(ele != null) {
		ele.click();
	}
}, false);

</script>
 
 <div class="col-sm-3 col-md-3">
    <p class="menu-text-padding"><b>Nome: </b><span class="text-right"><?= $patient_name; ?></span></p>
	<p class="menu-text-padding"><b>Idade: </b><span class="text-right"><?= $age; ?></span></p>
    <p class="menu-text-padding"><b>Data de Internação: </b><span class="text-right"><?= date_format($hosp_date,"d/m/Y"); ?></span></p>

	<div class="panel-group" id="accordion">
		<div class="panel panel-default">
			<div class="panel-heading">
				<h4 class="panel-title">
					<a class="collapseAccordion" data-toggle="collapse" id="accordion1" data-parent="#accordion" href="#collapseOne">
					<!-- <span class="glyphicon glyphicon-folder-close"></span>-->
					<?php
						echo $this->Html->image('internacao.png', ['alt' => 'CakePHP', 'height'=>'22px']);                   
					 ?>
						Internação</a>
				</h4>
			</div>

			<div id="collapseOne" class="panel-collapse collapse in">
				<div class="list-group">                
					<?php 
						echo $this->Html->link(__('Cadastro', true), array('controller' => 'Hospitalizations', 'action' => 'edit', $hospitalization_id), array('class' => 'list-group-item')); 
						echo $this->Html->link(__('Diagnóstico', true), array('controller' => 'Diagnostics', 'action' => 'index'), array('class' => 'list-group-item'));                                                            
						?>                                                          
				</div>
			</div>
		</div>

		<div class="panel panel-default">
			<div class="panel-heading">
				<h4 class="panel-title">
					<a class="collapseAccordion" id="accordion2" data-toggle="collapse" data-parent="#accordion" href="#collapseTwo">                  
					<?php
						echo $this->Html->image('bundles.png', ['alt' => 'CakePHP', 'height'=>'22px']);                   
					 ?>
					 Avaliações</a>
				</h4>
			</div>
			<div id="collapseTwo" class="panel-collapse collapse">
				<div class="list-group">                   
					 <?php 
							echo $this->Html->link(__('Bundles', true), array('controller' => 'Bundles', 'action' => 'index'), array('class' => 'list-group-item')); 

							echo $this->Html->link(__('Checklists', true), array('controller' => 'surgical-checklists', 'action' => 'index'), array('class' => 'list-group-item'));                                      
							echo $this->Html->link(__('Enfermagem', true), array('controller' => 'FugulinBradenScales', 'action' => 'index'), array('class' => 'list-group-item'));
							echo $this->Html->link(__('Fisioterapia', true), array('controller' => 'strengthAssessmentScales', 'action' => 'index'), array('class' => 'list-group-item'));
							echo $this->Html->link(__('Nutrição', true), array('controller' => 'NutritionalAssessments', 'action' => 'index'), array('class' => 'list-group-item'));
							echo $this->Html->link(__('Protocolos', true), array('controller' => 'SepseProtocols', 'action' => 'index'), array('class' => 'list-group-item')); 
							// echo $this->Html->link(__('Identificação de Riscos', true), array('controller' => 'IdentificationOfRisks', 'action' => 'index'), array('class' => 'list-group-item'));

						?>                                       
				</div>
			</div>
		</div>

		<div class="panel panel-default">
			<div class="panel-heading">
				<h4 class="panel-title">
					<a class="collapseAccordion" data-toggle="collapse" id="accordion3" data-parent="#accordion" href="#collapseThree" >
					<?php
						echo $this->Html->image('ccih.png', ['alt' => 'CakePHP', 'height'=>'22px']);                   
					 ?>
						CCIH
						</a>
				</h4>
			</div>
			<div id="collapseThree" class="panel-collapse collapse">
				<div class="list-group">                
						<!-- <a href="#" class="list-group-item">Culturas</a>                     -->
						<?php 
							echo $this->Html->link(__('Culturas', true), array('controller' => 'Cultures', 'action' => 'index'), array('class' => 'list-group-item'));
							echo $this->Html->link(__('Infecções', true), array('controller' => 'Infections', 'action' => 'index'), array('class' => 'list-group-item'));
						?>                                                  
				</div>
			</div>
		</div>

		<div class="panel panel-default">
			<div class="panel-heading">
				<h4 class="panel-title">
					<a class="collapseAccordion" data-toggle="collapse" id="accordion5" data-parent="#accordion" href="#collapseFive">                  
					<?php
						echo $this->Html->image('cirurgia.png', ['alt' => 'CakePHP', 'height'=>'22px']);                   
					 ?>
						Cirurgia 
						</a>
				</h4>
			</div>
			<div id="collapseFive" class="panel-collapse collapse">
				<div class="list-group">
						
						<?php 

							echo $this->Html->link(__('Cirurgia', true), array('controller' => 'surgeries', 'action' => 'index'), array('class' => 'list-group-item'));

							echo $this->Html->link(__('Visita Pré-Anestésica', true), array('controller' => 'PreAnestheticVisits', 'action' => 'index'), array('class' => 'list-group-item'));

							echo $this->Html->link(__('Risco Cirúrgico', true), array('controller' => 'SurgicalRisks', 'action' => 'index'), array('class' => 'list-group-item'));

							echo $this->Html->link(__('TCI', true), array('controller' => 'InformedConsentForms', 'action' => 'index'), array('class' => 'list-group-item'));


						?>
						<!-- <a href="#" class="list-group-item">Cirurgia</a> -->   
														
				</div>
			</div>
		</div>


		 <div class="panel panel-default">
			<div class="panel-heading">
				<h4 class="panel-title">
					<a class="collapseAccordion" data-toggle="collapse" id="accordion4" data-parent="#accordion" href="#collapseFour">                  
					<?= $this->Html->image('boletim-medico.png', ['alt' => 'CakePHP', 'height'=>'22px']); ?>
						Evolução
					</a>
				</h4>
			</div>
			<div id="collapseFour" class="panel-collapse collapse">
				<div class="list-group">                  
					<?php 
                            echo $this->Html->link(__('Evolução multiprofissional', true), array('controller' => 'Evolutions', 'action' => 'index'), array('class' => 'list-group-item'));  

							echo $this->Html->link(__('Boletim Médico', true), array('controller' => 'MedicalBulletins', 'action' => 'index'), array('class' => 'list-group-item'));  

							echo $this->Html->link(__('Escores', true), array('controller' => 'apache-ii-scores', 'action' => 'index'), array('class' => 'list-group-item'));   

							echo $this->Html->link(__('Medidas de Suporte', true), array('controller' => 'SupportiveMeasures', 'action' => 'index'), array('class' => 'list-group-item')); 

							echo $this->Html->link(__('Parecer Médico', true), array('controller' => 'medical-opinion-requests', 'action' => 'index'), array('class' => 'list-group-item'));

							echo $this->Html->link(__('Prescrições', true), array('controller' => 'Prescriptions', 'action' => 'index'), array('class' => 'list-group-item'));
					?>
				 <!-- <a href="#" class="list-group-item">Prescrições</a>                                                       -->
				</div>
			</div>
		</div>


		<div class="panel panel-default">
			<div class="panel-heading">
				<h4 class="panel-title">
					<a class="collapseAccordion">
					<?php 
						echo $this->Html->image('sihdot.png', ['alt' => 'CakePHP', 'height'=>'22px']);                   
					 ?>
						
						
						&nbsp;<?php
						echo $this->Html->link(
								'CIHDOTT',
								['controller' => 'SuspectedMeProtocols', 'action' => 'index']
						);
					?>
						</a>
				</h4>
			</div>                                
		</div>    

	 <div class="panel panel-default">
			<div class="panel-heading">
				<h4 class="panel-title">
					<a class="collapseAccordion" href="http://localhost/gh-backoffice/Historic-Patient-Movements/index">
					<?php
						echo $this->Html->link(
								$this->Html->image('evolucao.png', ['alt' => 'GH', 'height'=>'22px'])
								,array('controller'=>'HistoricPatientMovements','action'=>'index'),
								['escape' => false, 'escapeTitle' => false, 'title' => 'hi "howdy"']
						);   

						?>&nbsp;<?php
						echo $this->Html->link(
								'Saída',
								['controller' => 'HistoricPatientMovements', 'action' => 'index']
						);
					?>
						</a>
				</h4>
			</div>                                
	 </div>            


	</div>
</div>
