<?php
use Cake\Core\Configure;
use Cake\Error\Debugger;

$this->layout = 'custom_error';

if (Configure::read('debug')):
    $this->layout = 'dev_error';

    $this->assign('title', $message);
    $this->assign('templateName', 'error500.ctp');

    $this->start('file');?>

    <?php if (!empty($error->queryString)) : ?>
        <p class="notice">
            <strong>SQL Query: </strong>
            <?= h($error->queryString) ?>
        </p>
    <?php endif; ?>

    <?php if (!empty($error->params)) : ?>
            <strong>SQL Query Params: </strong>
            <?= Debugger::dump($error->params) ?>
    <?php endif; ?>

    <?php if ($error instanceof Error) : ?>
            <strong>Error in: </strong>
            <?= sprintf('%s, line %s', str_replace(ROOT, 'ROOT', $error->getFile()), $error->getLine()) ?>
    <?php endif; ?>

    <?php
        echo $this->element('auto_table_warning');

        if (extension_loaded('xdebug')):
            xdebug_print_function_stack();
        endif;

        $this->end();
endif;?>


<div class="center_content">
    <?= $this->Html->image('custom_error.png', array('id'=>'custom_error', 'alt' => 'CakePHP', 'border' => '0', 'data-src' => 'holder.js/100%x100')); ?>

    <p class="error error-center error-msg">
        <strong><?= __d('cake', 'Erro') ?>: </strong>
        <?= h($message) ?>
    </p>
    <br>
    <button class="btn error-center" type="button" id="goback">Voltar</button>
</div>

<script>
$( document ).ready(function() {

    $("#goback").click(function()
    {        
        console.log("voltar");
        window.history.back();
    });

     if( navigator.userAgent.match(/Android/i)
         || navigator.userAgent.match(/webOS/i)
         || navigator.userAgent.match(/iPhone/i)
         || navigator.userAgent.match(/iPad/i)
         || navigator.userAgent.match(/iPod/i)
         || navigator.userAgent.match(/BlackBerry/i)
         || navigator.userAgent.match(/Windows Phone/i)
        ) {
            $("#custom_error").css("width", "100%");
        }
});
</script>