<?php 
$professions = ["Administrador", "Enfermagem", "Engenheiro", "Estagiário Enfermagem", "Estagiário Farmácia", "Estagiário Fisioterapia", "Estagiário Fonoaudiologia", "Estagiário Medicina", "Estagiário Nutrição", "Estagiário Odontologia", "Estagiário Psicologia", "Estagiário Serviço Social", "Estagiário Terapia Ocupacional", "Estudante Enfermagem", "Estudante Farmácia", "Estudante Fisioterapia", "Estudante Fonoaudiologia", "Estudante Medicina", "Estudante Nutrição", "Estudante Odontologia", "Estudante Psicologia", "Estudante Serviço Social", "Estudante Terapia Ocupacional", "Farmaceutico", "Fisioterapia", "Fonoaudiólogo", "Médico", "Nutrição", "Odontólogo", "Psicólogo", "Serviço Social", "Téc. de Imobilização", "Téc. Enfermagem", "Téc. Radiologia", "Terapia Ocupacional", "Adm da Ouvidoria", "Administrativo", "Atendente de Público", "Recepcionista", "Téc. de Engenharia Clinica", "Téc. Manutenção", "Telefonista"];
$status_options = ["Ativa" => "Ativa", "Salva" => "Salva", "Suspensa" => "Suspensa"] 
?>

<div class="row">
<?=$this->element('internacao-menu');?>

<div class="evolutions index col-md-9 columns content">
    <div class="row">
        <div class="col-sm-3 input-group pad-left-15" style="display:inline-block;" >        
            <?= $this->Form->create('index', ['type'=>'get']) ?>
            <?= $this->Form->input('profession', ['label'=>'', 'placeholder'=>'Profissão', 'options' => $professions, 'empty' => true]); ?>
        </div>

        <div class="col-sm-3 input-group pad-left-15" style="display:inline-block;">        
            <?= $this->Form->input('date_of_completion', ['class' => 'date', 'label'=>'', 'placeholder'=>'Data']); ?>        
        </div>

        <div class="col-sm-3 input-group pad-left-15" style="display:inline-block;">        
            <?= $this->Form->input('status',['label'=>'','options' => $status_options,'empty'=>'Status']); ?>        
        </div>
        

      
        <?= $this->Form->button(__('Pesquisar',true), array('class'=>'bt-search')) ?>
    </div>
    <br><br>

    <?= $this->Html->link('Nova Evolução', ['controller' => 'Evolutions', 'action' => 'add', $unit_id], array('class' => 'link-bt')); ?>
    <br><br>

    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?=$this->Paginator->sort('nome_prof', ['label' => 'Nome do Profissional'])?></th>
                <th><?=$this->Paginator->sort('profissao', ['label' => 'Profissão'])?></th>
                <th><?=$this->Paginator->sort('date_of_completion', ['label' => 'Data'])?></th>
                <th><?=$this->Paginator->sort('hour_of_completion', ['label' => 'Hora'])?></th>
                <th><?=$this->Paginator->sort('status')?></th>
                <th class="actions"><?=__('Actions')?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($evolutions as $evolution): ?>
            <tr>
                <td><?=h($evolution->nome_prof)?></td>
                <td><?= h($professions[$evolution->profissao]) ?></td>
                <td><?=h($evolution->date_of_completion)?></td>
                <td><?php if ($evolution->hour_of_completion) echo $evolution->hour_of_completion; ?> </td>
                <!-- <td><?=$evolution->has('professional') ? $this->Html->link($evolution->professional->id, ['controller' => 'Professionals', 'action' => 'view', $evolution->professional->id]) : ''?></td> -->
                <td><?= h($evolution->status) ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?=$this->Html->link(__('Edit'), ['action' => 'edit', $evolution->id], ['class' => 'btn btn-primary btn-xs'])?>
                    <!--?=$this->Form->postLink(__('Delete'), ['action' => 'delete', $evolution->id], ['confirm' => __('Are you sure you want to delete # {0}?', $evolution->id), 'class' => 'btn btn-danger btn-xs'])?-->
                </td>
            </tr>
            <?php endforeach;?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?=$this->Paginator->prev('&laquo; ' . __('previous'), ['escape' => false])?>
                <?=$this->Paginator->numbers(['escape' => false])?>
                <?=$this->Paginator->next(__('next') . ' &raquo;', ['escape' => false])?>
            </ul>

        </div>
    </center>
</div>
</div>

<script >
        (function() {
           // your page initialization code here
           // the DOM will be available here
            var link1 =' <?=$this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
    ['controller' => 'Users', 'action' => 'login'], ['class' => 'btn btn-default ', 'escape' => false])?> ';

            var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

            var link3 =' <?=$this->Html->link('Internações', ['controller' => 'Hospitalizations', 'action' => 'index', $hospitalization_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

            var html = '';
                html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                html+= link1;
                html+= link2;
                html+= link3;
                html+= '<a href="#" class="breadcumb-active btn btn-default">Evoluções</a>';
                html+= '</div>';
                    document.getElementById("breadcumb").innerHTML =html;
        })();
    </script>