<?php
  $age = null;
  if ($patient['birthday']) {
    $from = new DateTime($patient['birthday']->i18nFormat('dd-MM-yyyy'));
    $to   = new DateTime('today');
    $age = null;
    $age = $from->diff($to)->y;
  }  
?>

<div class="container unit-header">
        <div class="bundles form col-sm-4 columns content">

            <?=
             $this->Html->image('uploads/'. $unit_logo, ['alt' => 'GH', 'height'=>'50px', 'style'=>"margin-top: 7px;"])
            ?>
            <br><br>
            <p class="unit-data"><b><?= $unit->name ?></b></p>
            <p class="unit-data"><b><?= $unit->telephone ?></b></p>
            <p class="unit-data"><b><?= $unit->street ?></b></p>
            <p class="unit-data"><b><?= $unit->city ?></b></p>
            <br>
        </div>
        <div class="col-sm-8">
            <h1>Evolução Multiprofissional</h1>
        </div>

</div>

<div class="col-sm-12 data-field">
  <table class="table table-bordered">
    <tr>
      <td><span class="inline-data"><b>Paciente:</b>&nbsp;<?= $patient->nome ?></span></td>
      <td><span class="inline-data"><b>Idade:</b>&nbsp;<?= $age ?></span></td>
      <td><span class="inline-data"><b>Setor:</b>&nbsp;<?= $hospitalization->sector['name'] ?></span></td>
      
      <?php if ($hospitalization['id']) : ?>
        <td><span class="inline-data"><b>Leito:</b>&nbsp;<?= $hospitalization->roomName($hospitalization['id'])?></span></td>
      <?php endif; ?>
      
      <td><span class="inline-data"><b>Prontuário:</b>&nbsp;<?= $hospitalization->numero_do_prontuario ?></span></td>
    </tr>
  </table>
  <br><br>
</div>

<div class="bundles form col-sm-12 columns content">

        <?php

            $professions = ["Administrador", "Enfermagem", "Engenheiro", "Estagiário Enfermagem", "Estagiário Farmácia", "Estagiário Fisioterapia", "Estagiário Fonoaudiologia", "Estagiário Medicina", "Estagiário Nutrição", "Estagiário Odontologia", "Estagiário Psicologia", "Estagiário Serviço Social", "Estagiário Terapia Ocupacional", "Estudante Enfermagem", "Estudante Farmácia", "Estudante Fisioterapia", "Estudante Fonoaudiologia", "Estudante Medicina", "Estudante Nutrição", "Estudante Odontologia", "Estudante Psicologia", "Estudante Serviço Social", "Estudante Terapia Ocupacional", "Farmaceutico", "Fisioterapia", "Fonoaudiólogo", "Médico", "Nutrição", "Odontólogo", "Psicólogo", "Serviço Social", "Téc. de Imobilização", "Téc. Enfermagem", "Téc. Radiologia", "Terapia Ocupacional", "Adm da Ouvidoria", "Administrativo", "Atendente de Público", "Recepcionista", "Téc. de Engenharia Clinica", "Téc. Manutenção", "Telefonista"];



            $checked_img = $this->Html->image('checked.png', ['class' => 'tick-box','alt' => 'GH', 'height'=>'22px', 'style'=>""]);

            $not_checked_img = $this->Html->image('not-checked.png', ['class' => 'tick-box','alt' => 'GH', 'height'=>'22px', 'style'=>""]);

            echo '<div class="col-sm-6 data-field">';
               echo '<b>Profissão: </b>'.$professions[$evolution['profissao']];
            echo '</div>';

            echo '<div class="col-sm-6 data-field">';
               echo '<b>Nome do profissional: </b>'.$evolution['nome_prof'];
            echo '</div>';

            echo '<div class="col-sm-6 data-field">';
               echo '<b>Número de registro: </b>'.$evolution['numero_do_conselho'];
            echo '</div><br><br>';

            echo '<div class="col-sm-6 data-field">';
               echo '<b>Data de preenchimento: </b>'.$evolution['date_of_completion'];
            echo '</div>';

            echo '<div class="col-sm-6 data-field">';
               echo '<b>Hora de preenchimento: </b>'.$evolution['hour_of_completion'];
            echo '</div>';
            

            echo '<br><br><div class="col-sm-12 data-field">';
               echo '<b>Evolução:</b>';
            echo '</div>';

            echo '<div class="col-sm-12 data-field">';
              echo '<div class="textos">'.$evolution['evolution_text'].'</div>';
            echo '</div>';




        ?>

</div>

<script>
window.onload = setTimeout(function(){$.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});},1);

(function() {
    //url da listagem
    var urlIndex = '<?= $this->Html->linkUrl(['controller'=>'Evolutions','action' => 'index']); ?>';

    $("form :input").prop('readonly', true);
    $("form :input").css('readonly', true);
    $('nav').css('display','none');

    // definindo a função de Print
    function PrintPage() {
        window.print();
        setTimeout(function () {
          $.LoadingOverlay("show");
          window.location.href=urlIndex;
        },900);
    }

    //chamando o spinner e a função de imprimir
    setTimeout(function(){ 
      PrintPage();
    },600);

  })();

</script>