<div class="row">

<div class="hospitalizations index col-md columns content">
    <br>
    <?php
echo $this->Html->link('Internar Paciente',
    ['controller' => 'hospitalizations', 'action' => 'add']
    , ['class' => 'link-bt']);
?>
    <br><br>
    <div class="table-responsive">
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?=$this->Paginator->sort('created', ['label' => "Data da Internação"])?></th>
                <th><?=$this->Paginator->sort('type', ['label' => "Tipo"])?></th>
                <th><?=$this->Paginator->sort('complementary_health', ['label' => "Convênio"])?></th>
                <th><?=$this->Paginator->sort('expected_discharge_day', ['label' => 'Previsão de Alta'])?></th>
                <th><?php //echo  $this->Paginator->sort('screening_id') ?></th>
                <th class="actions"><?=__('Ações')?></th>
            </tr>
        </thead>
        <tbody>
            <?php if ($hospitalizations): ?>
                <?php foreach ($hospitalizations as $hospitalization): ?>
                <tr>
                    <td>
                        <?php if (isset($hospitalization->date_of_hospitalization)): ?>
                            <?=h($hospitalization->date_of_hospitalization->format('d/m/Y'));?>
                        <?php endif;?>
                    </td>
                    <td><?=h($hospitalization->type)?></td>
                    <td><?=h($hospitalization->complementary_health)?></td>
                    <td>
                         <?php if (isset($hospitalization->expected_discharge_day)): ?>
                            <?=h($hospitalization->expected_discharge_day->format('d/m/Y'));?>
                        <?php endif;?>
                    <td>
                    <td class="actions" style="white-space:nowrap">

                        <?=$this->Html->link(__('Editar'), ['action' => 'selectHospitalization', $hospitalization->id, 'edit', $hospitalization->created->format('d-m-Y')], ['class' => 'btn btn-primary btn-xs'])?>

                    </td>
                </tr>
                <?php endforeach;?>
            <?php endif;?>

        </tbody>
    </table>
    </div>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?=$this->Paginator->prev('&laquo; ' . __('Anterior'), ['escape' => false])?>
                <?php if ($hospitalizations): ?>
                <?=$this->Paginator->numbers(['escape' => false])?>
                <?php endif;?>
                <?=$this->Paginator->next(__('Próximo') . ' &raquo;', ['escape' => false])?>
            </ul>

        </div>
    </center>
</div>
</div>

<script >
(function() {
   // your page initialization code here
   // the DOM will be available here
   var link1 =' <?=$this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
    ['controller' => 'Users', 'action' => 'login'], ['class' => 'btn btn-default ', 'escape' => false])?> ';

   var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

    var html = '';
        html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
        html+= link1;
        html+= link2;
        html+= '<a href="#" class="breadcumb-active btn btn-default">Internação</a>';
        html+= '</div>';
            document.getElementById("breadcumb").innerHTML =html;
})();
</script>