<?php

   $from = new DateTime($patient['birthday']->i18nFormat('dd-MM-yyyy'));
   $to   = new DateTime('today');
   $age = null;
   $age = $from->diff($to)->y;

   $bairro = (!empty($patient['bairro'])) ? $patient['bairro'].', ' : '';
   $street = (!empty($patient['street'])) ? $patient['street'].', ' : '';
   $logradouro = (!empty($patient['logradouro'])) ? $patient['logradouro'].', ' : '';
   $address_number = (!empty($patient['address_number'])) ? $patient['address_number'].', ' : '';
   $city = (!empty($patient['city'])) ? $patient['city'].', ' : '';
   $country = (!empty($patient['country'])) ? $patient['country'].', ' : '';
   $cep = (!empty($patient['cep'])) ? $patient['cep'].', ' : '';

   $endereco = $bairro.$street.$logradouro.$address_number.$city.$country.$cep;
   $endereco = trim($endereco,', ');

   $dias_internacao = '';

   if ( isset($hospitalization['date_of_hospitalization']) &&
        isset($hospitalization['data_saida_unidade']) ) {

      $date_of_hospitalization    = new \DateTime($hospitalization['date_of_hospitalization']->format('Y-m-d'));
      $data_saida_unidade         = new \DateTime($hospitalization['data_saida_unidade']->format('Y-m-d'));
      $dias_internacao            = $date_of_hospitalization->diff($data_saida_unidade)->days;

   }
   else if ( isset($hospitalization['date_of_hospitalization']) ) {

      $date_of_hospitalization    = new \DateTime($hospitalization['date_of_hospitalization']->format('Y-m-d'));
      $dataAtual                  = new \DateTime(date ("Y-m-d"));
      $dias_internacao            = $date_of_hospitalization->diff($dataAtual)->days;

   }


    // criar a string da medicação

    $ant='';
    $via='';
    $dias_uso='';
    $cultura = 0;
    $resultado_cultura = '';
    $justificativa_antibiotico='';

    if(!empty($prescription['medications'])){

        foreach ($prescription['medications'] as $key => $medication) {
          
          if($medication['is_antibiotic'] == true || $medication['is_antibiotic'] == 1){
              $ant .= $medication['name'].', ';
              $via .= $medication['channel'].', ';
              $dias_uso .= $medication['using_time'].', ';
              $justificativa_antibiotico .= $medication['justificativa_antibiotico'].'; ';

              if($medication['cultura'] == true || $medication['cultura'] == 1){
                $cultura++;
                if(!empty($medication['cultures'])){
                    foreach ($medication['cultures'] as $key2 => $culture) {
                      $resultado_cultura .= $culture['germe'].', ';
                    }
                }
                
              }

          }

        }

        $ant      = trim($ant,", ");
        $via      = trim($via,", ");
        $dias_uso = trim($dias_uso,", ");
        $resultado_cultura = trim($resultado_cultura,", ");
        $justificativa_antibiotico = trim($justificativa_antibiotico,"; ");

    }

    // criar a string da medicação

?>


<style>
    
    .form-group {
      margin-bottom:5px!important;
    }

    .row .form-group  {
      width:100%!important;
    }

    label{
      width:auto;
    }

    input {
      height: 13px;
      width: 100%;
      border: 0!important;
      outline: 0!important;
      background: transparent!important;
      border-bottom: 1px solid black!important;
      border-radius: none!important;
      margin-bottom: 0px!important;
    }

    .bordered-div{
      padding-top: 20px;
      font-size:12px;
      margin-bottom:15px;
      border:1px solid #000!important;
      min-height: 130px;
      max-height: 130px;
    }

    .bordered-div-2{
      padding-top: 20px;
      font-size:12px;
      margin-bottom:15px;
      border:1px solid #000!important;
      min-height: 130px;
    }

    .footer-info{
      font-size:12px;
      /*margin-bottom:15px;*/
      border:1px solid #000!important;
      min-height: 80px;
      max-height: 80px;
    }

    .date-container{
      display:flex;
      align-items:center;
      font-size:12px;
    }

    .cultura-div{
      display:flex;
      align-items:center;
      font-size:15px;
    }

    .top-divs{
     max-width: 45%;
      min-height: 110px;
      max-height: 110px;
    }

    .aling-inline-items{
      display:flex;
      flex-direction:row;
      justify-content:center;
    }

    #justificativa-title{
      font-size:24px;
      text-transform: uppercase;
      line-height: 2.8;
      margin-right: 48px;
    }

    .prefeitura{
      padding-top:10px;
      height:auto!important;
    }

    .prefeitura p {
       line-height: 0.6;
       font-size:20px;
    }

    .page{
      margin-bottom:0px;
    }

    .flex-inputs{
      display: flex;
      flex-direction:row;
      justify-content:flex-start;
    }

    .bottom-cont{
      margin-top: 23px;
    }

    
    @page {
      size: auto;   /* auto is the initial value */ 
      /* this affects the margin in the printer settings */ 
      margin: 3mm 10mm 3mm 10mm;  
      size:landscape;
    }

</style>


<div class="no-break" style="margin-top: -20px">
  
  <!-- <div class="col-sm-2"> -->
    <!--?= $this->Html->image('logo-rio.png', ['alt' => 'GH', 'height'=>'70px','width'=>'80px']) ?-->
  <!--</div>-->
  
  <div class="col-sm-12 prefeitura">
    <p><b>Prefeitura</b></p>
    <p><b>da Cidade do Rio de Janeiro</b></p>
    <p><b>Secretaria Municipal de Saúde</b></p>
  </div>

  <div class="col-sm-12">
    <div class="aling-inline-items">
      <h1 id="justificativa-title"><b>Justificativa para emprego de antibióticos</b></h1>
      <?=
       $this->Html->image('sus.png', ['alt' => 'GH', 'height'=>'100px'])
      ?>
    </div>
  </div>
  <div class="row">

    <div class="col-sm-6 bordered-div pull-left top-divs">
     
      <div class="flex-inputs">
        <label for="example-text-input">Unidade:&nbsp;</label>
        <input value="<?=$unit['name']?>" type="text">
      </div>

      <div class="flex-inputs">
        <label for="example-text-input">Serviço:&nbsp;</label>
        <input type="text">
      </div>

      <div class="flex-inputs">
        <label for="example-email-input">Enfermaria:&nbsp;</label>
        <input type="text">

        <label style="padding-left:15px;padding-right:15px;" for="example-url-input">Leito:</label>
        <input value="<?= $hospitalization->roomName($hospitalization['id'])?>" type="text">
      </div>

    </div>
    
    <div class="col-sm-6 bordered-div pull-right top-divs">

    <p><center><h4>Dados de identificação</h4></center></p>

      <div class="flex-inputs">
        <label for="example-text-input">Nome:&nbsp;</label>
        <input value="<?= $patient['nome'] ?>" type="text">
      </div>

      <div class="flex-inputs">
        <label for="example-search-input">Prontuário:&nbsp;</label>
        <input value="<?= $hospitalization['numero_do_prontuario'] ?>"  type="text">
      </div>

    </div>

  </div> 

  <div class="row">

    <div class="col-sm-12 bordered-div">

      <div class="flex-inputs">
        <label for="example-search-input">Antibióticos:&nbsp;</label>
        <input value="<?= $ant ?>" type="text">
      </div>

      <div class="flex-inputs">
        <label style="width:220px!important;" for="example-search-input">Posologia e V.adiministração:</label>
        <input value="<?= $via ?>" type="text">
      </div>

      <div class="flex-inputs">
        <label style="width:170px!important;" for="example-search-input">Tempo provável pra uso:</label>
        <input value="<?= $dias_uso ?>" type="text">
      </div>

    </div>
    
    <div class="col-sm-12 bordered-div-2">


        <div class="flex-inputs">
          <label for="example-search-input">Justificativa(s):&nbsp;</label>
          <!-- <input value="<?= $justificativa_antibiotico ?>" type="text"> -->
          <div class="textos-lineares"><?= $justificativa_antibiotico ?>.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>
          
        </div>

        <!-- <div class="flex-inputs">
          <input type="text">
        </div> -->
        <br>
        <div class="flex-inputs">
          
          <div style="width:5%;" class="cultura-div">
            <span>Cultura</span>
          </div>  
        

          <div style="padding-left:25px;width:10%;">

            <div class="flex-inputs">
              <label for="example-search-input">S:&nbsp;</label>
              <input value="<?= ($cultura > 0) ? __('X') : __('');?>" type="text">
            </div>

            <div class="flex-inputs">
              <label for="example-search-input">N:&nbsp;</label>
              <input value="<?= ($cultura == 0) ? __('X') : __('');?>" type="text">
            </div>

          </div>

          <div style="padding-left: 33px;width: 85%;">

            <div class="flex-inputs bottom-cont">
              <label for="example-search-input">Resultado:&nbsp;</label>
              <div class="textos-lineares"><?= $resultado_cultura ?>.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>
            </div>

          </div>

       </div> 

      </div>

    </div><!-- row end -->

    <div class="row"> 

      <div class="col-sm-4 pull-left date-container footer-info">
        <p class="date-filler">Data:_____/_____/_____</p>
      </div>
      
      <div class="col-sm-7 pull-right footer-info" >
          <p>
            <center>
              <span>Assinatura e Carimbo</span>
            </center>
          </p>
      </div>
    
    </div>
  
</div>


<script type="text/javascript">


window.onload = setTimeout(function(){$.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});},1);
  
  (function(){
    $(".pad-top-20").removeClass('container');
    $(".pad-top-20").addClass('container-fluid');
    $(".pad-top-20").css('padding-top','0px');
    
    $("form :input").prop('readonly', true);
    $("form :input").css('readonly', true);
    $('nav').css('display','none');

    // definindo a função de Print
    function PrintPage() {
        window.print();
        setTimeout(function () {
          $.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});
          window.close();
        },900);
    }

    // chamando a função de imprimir
    setTimeout(function(){ 
      PrintPage();
    },600);

  })();
</script>
