<!DOCTYPE html>
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<?=$this->Html->css('pdf', ['fullBase' => true]);?>
		<?=$this->fetch('css')?>
	</head>
	<body>
		<?=$this->element('header-logo', ['report_title' => 'Relatório de Bundle Vascular Diário']);?>
		<div class="container">
			<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
				<thead>
					<tr>
						 <th class="title  th-left">Item</th>
						 <th class="title th-middle">Valor</th>
						 <th class="title th-middle">%</th>
				  </tr>
				</thead>

				<tbody>

					<tr >
	                    <td class="line-separator title" style="font-weight: bold" colspan=3>  Seção única  </td>
	                </tr>

					 <tr >
						<td >Valor total de bundles diários preenchidos</td>
						<td><?=$data['total_de_registros']?> </td>
						<td> - </td>
					 </tr>

					  <tr >
							<td >Bundles diários preenchidos por dias no período</td>
							<td> - </td>
							<td> <?=$data['percen_bundles_por_dias']?>% </td>
					  </tr>

					  <tr>
							<td >Bundles diários preenchidos por pacientes com instalação de dispositivo</td>
							<td> - </td>
							<td> <?=$data['percen_bundles_por_procedimentos'] ?>%  </td>
					  </tr>

					  <tr >
							<td >Bundles diários preenchidos por total de pacientes-dia </td>
							<td> - </td>
							<td> <?=$data['tot_bundles_por_tempo_de_uso'] ?>%  </td>
					  </tr>

					  <tr >
							<td >Valor total de bundles diários não preenchidos </td>
							<td><?=$data['total_de_bundles_nao_preenchido']?> </td>
							<td> - </td>
					  </tr>

					   <tr >
							<td >Valor total de bundles diários não preenchidos por dias período </td>
							<td> - </td>
							<td><?=$data['percen_bundles_por_dias_nao_preenchido']?>%</td>
					  </tr>

					  <tr >
							<td >Valor total de bundles diários não preenchidos por total de pacientes com instalação de dispositivo</td>
							<td> - </td>
							<td> <?=$data['percen_bundles_por_procedimentos_nao_preenchido']?>% </td>
					  </tr>

					   <tr >
							<td >Valor total de bundles diários não preenchidos por total de pacientes-dia (total de todos os dias somados por todos os pacientes com este dispositivo instalado no período) </td>
							<td> </td>
							<td> <?=$data['tot_bundles_por_tempo_de_uso_nao_preenchido']?>% </td>
					  </tr>


				  	<tr >
	                    <td class="line-separator title" style="font-weight: bold" colspan=3>  Seção de verificação diária  </td>
	                </tr>
	               <tr>
	               		<td>Curativo diário com técnica asséptica</td>
	               		<td><?=$data['curativo']['total']?></td>
						 <td><?=$data['curativo']['percentual']?>%</td>
	               </tr>


				  <tr>
						<td>Presença de sangue no curativo</td>
						<td><?=$data['presenca_sangue']['total']?></td>
						 <td><?=$data['presenca_sangue']['percentual']?>%</td>
				  </tr>

				  <tr>
						<td>Presença de secreção no curativo</td>
						<td><?=$data['presenca_secrecao']['total']?></td>
						 <td><?=$data['presenca_secrecao']['percentual']?>%</td>
				  </tr>

				  <tr>
						<td>Cateter devidamente fixado na pele </td>
						<td><?=$data['cateter_devidamente']['total']?></td>
						 <td><?=$data['cateter_devidamente']['percentual']?>%</td>
				  </tr>

				   <tr>
						 <td>Conector exposto </td>
						<td><?=$data['conector_exposto']['total']?></td>
						 <td><?=$data['conector_exposto']['percentual']?>%</td>
				  </tr>

					<tr>
						 <td>Via de catéter sem utilização</td>
						<td><?=$data['via_cateter']['total']?></td>
						 <td><?=$data['via_cateter']['percentual']?>%</td>
				     </tr>

					<tr>
						 <td>Administração de conteúdo lipidico em via exclusiva</td>
						<td><?=$data['administracao']['total']?></td>
						 <td><?=$data['administracao']['percentual']?>%</td>
			        </tr>

			   		<tr>
						 <td>Avaliado a retirada do cateter </td>
						<td><?=$data['avaliado_a_retirada']['total']?></td>
						 <td><?=$data['avaliado_a_retirada']['percentual']?>%</td>
			        </tr>

				</tbody>


			</table>
		</div>
	</body>
</html>