<!DOCTYPE html>
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<?=$this->Html->css('pdf', ['fullBase' => true]);?>
		<?=$this->fetch('css')?>
	</head>
	<body>
		<?=$this->element('header-logo', ['report_title' => 'Relatório de Cateter Vesical']);?>
		<div class="container">
			<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
				<thead>
					<tr>
						<th class="title th-left">Item</th>
						<th class="title th-middle" style="margin-left:100px;">VA</th>
						<th class="title th-right" >%</th>
					</tr>
				</thead>

				<tbody>
					<tr >
	                    <td class="line-separator title t-center" style="font-weight: bold" colspan=3> Seção única</td>
	                </tr>
					<tr >
						<td>Total de bundles de passagem de cateter vesical de demora </td>
						<td> <?=$data['consolidado']['tot_bundle_vesical_demora']?> </td>
						<td> - </td>
					</tr>

					<tr >
						<td>Percentual de bundle de cateter vesical de demora por paciente</td>
						<td> - </td>
						<td> <?=$data['consolidado']['percen_bundle_vesical_paciente']?> </td>
					</tr>

					<tr >
						<td>Pacientes com bundle de cateter vesical de demora por pacientes com cateter vesical marcado em procedimentos</td>
						<td> <?=$data['consolidado']['percen_pacient_bundle_vesical_procedimento']?> </td>
						<td> - </td>
					</tr>

					<tr >
						<td>Dispositivos inseridos no periodo em relacao ao total de bundles</td>
						<td> <?=$data['consolidado']['tot_dispositivos_inseridos']?> </td>
						<td> <?=$data['consolidado']['percen_dispositivos_inseridos']?> </td>
					</tr>

					<tr>
						<td>Bundles realizados de forma emergencial</td>
						<td> <?=$data['consolidado']['emergency']['total']?> </td>
						<td> <?=$data['consolidado']['emergency']['percentual']?> </td>
					</tr>

					<!--  <tr >
						item nao existo no sistema
						<td>Tamanho do cateter </td>
						<td> </td>
						<td> </td>
					</tr>-->

					<tr >
	                    <td class="line-separator title t-center" style="font-weight: bold" colspan=3> Checklist pré-procedimento </td>
	                </tr>

					<tr>
						<td>Risco de sangramento verificado</td>
						<td> <?=$data['consolidado']['is_risk_of_bleeding_verified']['total']?> </td>
						<td> <?=$data['consolidado']['is_risk_of_bleeding_verified']['percentual']?> </td>
					</tr>

					<!--
					sandro falou pra desconsiderar esse item
					<tr>
						<td>TCI foi preenchido</td>
						<td></td>
						<td></td>
					</tr>
					-->

					<tr>
						<td>Procedimento foi prescrito</td>
						<td> <?=$data['consolidado']['is_the_procedure_prescribed']['total']?> </td>
						<td> <?=$data['consolidado']['is_the_procedure_prescribed']['percentual']?> </td>
					</tr>

					<tr >
	                    <td class="line-separator title t-center" style="font-weight: bold" colspan=3> Checklist durante o procedimento</td>
	                </tr>

					<tr>
						<td>Higienização adequada das mãos</td>
						<td> <?=$data['consolidado']['proper_handwashing']['total']?> </td>
						<td> <?=$data['consolidado']['proper_handwashing']['percentual']?> </td>
					</tr>

					<tr>
						<td>Uso de paramentação: gorro, máscara e luvas estéreis</td>
						<td> <?=$data['consolidado']['use_of_paramentation']['total']?> </td>
						<td> <?=$data['consolidado']['use_of_paramentation']['percentual']?> </td>
					</tr>

					<tr>
						<td>Uso de degermação de cavidade genitália</td>
						<td> <?=$data['consolidado']['degermacao_da_genitalia']['total']?> </td>
						<td> <?=$data['consolidado']['degermacao_da_genitalia']['percentual']?> </td>
					</tr>

					<tr>
						<td>Uso de campo com barreira máxima</td>
						<td> <?=$data['consolidado']['use_of_field_with_maxium_barrier']['total']?> </td>
						<td> <?=$data['consolidado']['use_of_field_with_maxium_barrier']['percentual']?> </td>
					</tr>

					<tr>
						<td>Uso de gel estéril de xilocaína</td>
						<td> <?=$data['consolidado']['use_of_sterile_gel']['total']?> </td>
						<td> <?=$data['consolidado']['use_of_sterile_gel']['percentual']?> </td>
					</tr>

					<tr>
						<td>Progressão adequada de cateter</td>
						<td> <?=$data['consolidado']['suitable_catheter_progression']['total']?> </td>
						<td> <?=$data['consolidado']['suitable_catheter_progression']['percentual']?> </td>
					</tr>



					<tr>
						<td>Saída de urina de imediato a cateterização</td>
						<td> <?=$data['consolidado']['urine_output_cauterization']['total']?> </td>
						<td> <?=$data['consolidado']['urine_output_cauterization']['percentual']?> </td>
					</tr>

					<tr>
						<td>Fixação adequada de cateter</td>
						<td> <?=$data['consolidado']['adequate_catheter_fixation']['total']?> </td>
						<td> <?=$data['consolidado']['adequate_catheter_fixation']['percentual']?> </td>
					</tr>

					<tr>
						<td>Confirmação da posição com ultrassom</td>
						<td> <?=$data['consolidado']['ultrasom_durante_procedimento']['total']?> </td>
						<td> <?=$data['consolidado']['ultrasom_durante_procedimento']['percentual']?> </td>
					</tr>




					<tr >
	                    <td class="line-separator title t-center" style="font-weight: bold" colspan=3> Descrição orientada</td>
	                </tr>

	                <tr >
	                    <td  style="font-weight: bold; text-align: left; padding-left: 10px;" colspan=3>Tentativas:</td>
	                </tr>

	                <tr >
						<td>&#8226; Média</td>
						<td> <?=$data['consolidado']['number_of_retries']['media']?> </td>
						<td>- </td>
					</tr>
					<tr >
						<td>&#8226; Mediana</td>
						<td> <?=$data['consolidado']['number_of_retries']['mediana']?> </td>
						<td>- </td>
					</tr>

					<tr >
						<td>&#8226; Desvio padrão</td>
						<td> <?=$data['consolidado']['number_of_retries']['desvio_padrao']?> </td>
						<td>- </td>
					</tr>

					<tr >
						<td>Procedimentos com uma única tentativa </td>
						<td> <?=$data['consolidado']['tot_tentativa_unica']?> </td>
						<td> <?=$data['consolidado']['percen_tentativa_unica']?> </td>
					</tr>

					<tr >
	                    <td  style="font-weight: bold; text-align: left; padding-left: 10px;" colspan=3>Profissionais participantes:</td>
	                </tr>

	                <tr >
						<td>&#8226; Média</td>
						<td> <?=$data['consolidado']['number_of_professionals']['media']?> </td>
						<td>- </td>
					</tr>
					<tr >
						<td>&#8226; Mediana</td>
						<td> <?=$data['consolidado']['number_of_professionals']['mediana']?> </td>
						<td>- </td>
					</tr>

					<tr >
						<td>&#8226; Desvio padrão</td>
						<td> <?=$data['consolidado']['number_of_professionals']['desvio_padrao']?> </td>
						<td>- </td>
					</tr>

					<tr>
						<td>Presença de sangue no sistema coletor</td>
						<td> <?=$data['consolidado']['blood_on_catheter']['total']?> </td>
						<td> <?=$data['consolidado']['blood_on_catheter']['percentual']?> </td>
					</tr>

					<!--tr >
						<td>Sucesso na inserção</td>
						<td> <?=$data['consolidado']['sucesso_na_insercao']['total']?></td>
						<td> <?=$data['consolidado']['sucesso_na_insercao']['percentual']?></td>
					</tr-->

	                <tr >
						<td>Procedimentos em que houve complicação imediata</td>
						<td> <?=$data['consolidado']['tot_houve_complicacao_imediata']?></td>
						<td> <?=$data['consolidado']['percen_houve_complicacao_imediata']?></td>
					</tr>

					<tr>
						<td>Total de das complicações imediatas</td>
						<td> <?=$data['consolidado']['tot_qtd_complicacao_imediata']?></td>
						<td> - </td>
					</tr>


					<tr >
	                    <td class="line-separator title t-center" style="font-weight: bold" colspan=3> Retirada do cateter vesical ou citostomia</td>
	                </tr>

					<tr >
	                    <td  style="font-weight: bold; text-align: left; padding-left: 10px;" colspan=3> Tempo de uso do dispositivo:</td>
	                </tr>

	                <tr >
						<td>&#8226; Média</td>
						<td><?=$data['consolidado']['media_dias_retirada']?></td>
						<td>-</td>
					</tr>
					<tr >
						<td>&#8226; Mediana</td>
						<td><?=$data['consolidado']['mediana_dias_retirada']?></td>
						<td>-</td>
					</tr>

					<tr >
						<td>&#8226; Desvio padrão</td>
						<td><?=$data['consolidado']['desvio_padrao_dias_retirada']?></td>
						<td>-</td>
					</tr>

					<tr >
						<td>Bundles com retirada acidental </td>
						<td> <?=$data['consolidado']['accidental_removal']['total']?></td>
						<td> <?=$data['consolidado']['accidental_removal']['percentual']?></td>
					</tr>


					<tr >
						<td  style="font-weight: bold; text-align: left; padding-left: 10px;" colspan=3>Pacientes com tempo de uso do dispositivo:</td>
	                </tr>

	                <tr class="tr-indent">
						<td >&#8226; Inferior a 5 dias</td>
						<td> <?=$data['consolidado']['pacientes_tempo_de_uso_inf_5']['tot']?> </td>
						<td> - </td>
					</tr>

					<tr class="tr-indent">
						<td >&#8226; Inferior a 7 dias</td>
						<td> <?=$data['consolidado']['pacientes_tempo_de_uso_inf_7']['tot']?> </td>
						<td> - </td>
					</tr>

					<tr class="tr-indent">
						<td >&#8226; Inferior a 10 dias</td>
						<td> <?=$data['consolidado']['pacientes_tempo_de_uso_inf_10']['tot']?> </td>
						<td> - </td>
					</tr>

					<!--Sandro falou pra desonsiderr tempo de uso nesse momento-->
					<!-- <tr >
	                    <td class="line-separator title" style="font-weight: bold" colspan=3> Reinserção</td>
	                </tr>

					<tr >
						<td>Dispositivos reinseridos</td>
						<td>- </td>
						<td>- </td>
					</tr>

					<tr >
						<td>Dispositivos reinseridos em tempo inferior a 24h</td>
						<td>- </td>
						<td>- </td>
					</tr> -->

				</tbody>
			</table>
		</div>
	</body>
</html>