<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
	<?=$this->Html->css('pdf', ['fullBase' => true]);?>
	<?=$this->fetch('css')?>
</head>
<body>
	<?= $this->element( 'header-logo', ['report_title'=>'Relatório de Checklist de Segurança'] ); ?>	
	<div class="container">
		<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
			<thead>
				<tr>
					 <th class="title  th-left">Item</th>
					 <th class="title th-middle">Valor</th>
					 <th class="title th-middle">%</th>
			  </tr>
			</thead>		 
			<tbody>
				<tr>
					<td >Internações no Setor Durante o Período</td>
					<td><?=$data['geral']['total']?></td>
					<td>-</td>
			    </tr>
			    
			 	<tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan=6> Total de pacientes por Tipo de Internação</td>
                </tr>

			  <tr>
					 <td>Clínica</td>
					 <td><?=$data['clinica']['total']?></td>
					 <td><?=$data['clinica']['percentual']?></td>
			  </tr>

			  <tr>
					<td>Cirurgia eletiva</td>
					<td> <?=$data['eletiva']['total']?> </td>
					<td> <?=$data['eletiva']['percentual']?> </td>
			  </tr>

			  <tr>
					<td>Cirurgia de urgência / emergência</td>
					<td> <?=$data['emergencia']['total']?> </td>
					<td> <?=$data['emergencia']['percentual']?> </td>
			  </tr> 
			   <tr>
					<td>Total de avaliações do Checklist</td>
					<td> <?=$data['total_de_registros']?> </td>
					<td> - </td>
			  </tr> 
			  <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan="3"> Total de avaliações por Tipo de Internação</td>
                </tr>

			  <tr class="td-indent">
					 <td >&#8226; Clínica</td>
					 <td><?=$data['clinica']['total_avaliacao']?></td>
					 <td><?=$data['clinica']['percentual_avaliacao']?></td>
			  </tr>

			  <tr class="td-indent">
					<td >&#8226; Cirurgia eletiva</td>
					<td> <?=$data['eletiva']['total_avaliacao']?> </td>
					<td> <?=$data['eletiva']['percentual_avaliacao']?> </td>
			  </tr>

			  <tr class="td-indent">
					<td >&#8226; Cirurgia de urgência / emergência</td>
					<td> <?=$data['emergencia']['total_avaliacao']?> </td>
					<td> <?=$data['emergencia']['percentual_avaliacao']?> </td>
			  </tr> 
			    <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan="3">Profilaxias</td>
                </tr>

			  <tr>
					<td>Cabeceira do leito elevada</td>
					<td> <?=$data['cabeceira_de_leito_elevado']['total']?> </td>
					<td> <?=$data['cabeceira_de_leito_elevado']['percentual']?> </td>
			  </tr>

			  <tr>
					<td>Protocolo de higiene oral com clorexidina</td>
					<td> <?=$data['protocolo_higienico_oral']['total']?> </td>
					<td> <?=$data['protocolo_higienico_oral']['percentual']?> </td>
			  </tr>

			  <tr>
					<td>Aspiração da secreção subglótica</td>
					<td> <?=$data['aspiracao_da_secrecao']['total']?> </td>
					<td> <?=$data['aspiracao_da_secrecao']['percentual']?> </td>
			  </tr>

			  <tr>
					<td>Necessita de profilaxia lesão aguda de mucosa gástrica</td>
					<td> <?=$data['necessidade_de_profilaxia']['total']?> </td>
					<td> <?=$data['necessidade_de_profilaxia']['percentual']?> </td>
			  </tr>

			    <tr>
					<td> Necessita de profilaxia lesão aguda de mucosa gástrica </td>
					<td> <?=$data['necessidade_de_profilaxia']['total']?> </td>
					<td> <?=$data['necessidade_de_profilaxia']['percentual']?> </td>
			    </tr>

			    <tr>
					<td> Bloqueador de H2 </td>
					<td> <?=$data['bloq_bloqueador']['total']?> </td>
					<td> <?=$data['bloq_bloqueador']['percentual']?> </td>
			    </tr>

			    <tr>
					<td> Protetor de H2 </td>
					<td> <?=$data['incluir_outro_item_protetor']['total']?> </td>
					<td> <?=$data['incluir_outro_item_protetor']['percentual']?> </td>
			    </tr>

			     <tr >
                    <td class="line-separator title " style="font-weight: bold" colspan="3">Profilaxia para TEV</td>
                </tr>

			    <tr class="td-indent">
                    <td >&#8226; Heparina Baixo Peso Molecular </td>
                    <td> <?=$data['profilaxia_tev']['0']['tot']?> </td>
					<td> <?=$data['profilaxia_tev']['0']['percen']?> </td>
                </tr>

                <tr class="td-indent">
                    <td >&#8226; Heparina Não Fracionada</td>
                    <td> <?=$data['profilaxia_tev']['1']['tot']?> </td>
					<td> <?=$data['profilaxia_tev']['1']['percen']?> </td>
                </tr>

                <tr class="td-indent">
                    <td >&#8226; Compressor Pneumático Intermitente</td>
                    <td> <?=$data['profilaxia_tev']['2']['tot']?> </td>
					<td> <?=$data['profilaxia_tev']['2']['percen']?> </td>
                </tr>

                <tr class="td-indent">
                    <td >&#8226; Fondaparinux</td>
                    <td> <?=$data['profilaxia_tev']['3']['tot']?> </td>
					<td> <?=$data['profilaxia_tev']['3']['percen']?> </td>
                </tr>

                <tr class="td-indent">
                    <td >&#8226; Rivaroxaban</td>
                    <td> <?=$data['profilaxia_tev']['4']['tot']?> </td>
					<td> <?=$data['profilaxia_tev']['4']['percen']?> </td>
                </tr>

                <tr class="td-indent">
                    <td >&#8226; Não</td>
                    <td> <?=$data['profilaxia_tev']['5']['tot']?> </td>
					<td> <?=$data['profilaxia_tev']['5']['percen']?> </td>
                </tr>

                 <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan=3>Suporte Nutricional</td>
                </tr>

                <tr>
					<td> Atingiu VET pleno</td>
					<td> <?=$data['atingiu_vet_pleno']['total']?> </td>
					<td> <?=$data['atingiu_vet_pleno']['percentual']?> </td>
			    </tr>

			    <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan="3">Via de nutrição</td>
                </tr>

			    <tr class="td-indent">
                    <td >&#8226; Oral </td>
                    <td> <?=$data['via_de_nutricaoicao']['0']['tot']?> </td>
					<td> <?=$data['via_de_nutricaoicao']['0']['percen']?> </td>
                </tr>

                <tr class="td-indent">
                    <td >&#8226; Enteral</td>
                    <td> <?=$data['via_de_nutricaoicao']['1']['tot']?> </td>
					<td> <?=$data['via_de_nutricaoicao']['1']['percen']?> </td>
                </tr>

                <tr class="td-indent">
                    <td >&#8226; Parenteral</td>
                    <td> <?=$data['via_de_nutricaoicao']['2']['tot']?> </td>
					<td> <?=$data['via_de_nutricaoicao']['2']['percen']?> </td>
                </tr>

                <tr class="td-indent">
                    <td >&#8226; Conjugada Oral e Enteral</td>
                    <td> <?=$data['via_de_nutricaoicao']['3']['tot']?> </td>
					<td> <?=$data['via_de_nutricaoicao']['3']['percen']?> </td>
                </tr>

                <tr class="td-indent">
                    <td >&#8226; Conjugada Enteral e Parenteral</td>
                    <td> <?=$data['via_de_nutricaoicao']['4']['tot']?> </td>
					<td> <?=$data['via_de_nutricaoicao']['4']['percen']?> </td>
                </tr>

                <tr class="td-indent">
                    <td >&#8226; Zero</td>
                    <td> <?=$data['via_de_nutricaoicao']['5']['tot']?> </td>
					<td> <?=$data['via_de_nutricaoicao']['5']['percen']?> </td>
                </tr>

                <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan="3">Dispositivos Invasivos</td>
                </tr>

                <tr>
					<td> Uso de cateter venoso central  </td>
					<td> <?=$data['cateter_venoso_central']['total']?> </td>
					<td> <?=$data['cateter_venoso_central']['percentual']?> </td>
			    </tr>

			    <tr>
					<td>Uso de cateter arterial </td>
					<td> <?=$data['cateter_arterial']['total']?> </td>
					<td> <?=$data['cateter_arterial']['percentual']?> </td>
			    </tr>

			    <tr>
					<td> Uso de cateter vesical de demora  </td>
					<td> <?=$data['cateter_vesical_de_demora']['total']?> </td>
					<td> <?=$data['cateter_vesical_de_demora']['percentual']?> </td>
			    </tr>

			    <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan="3">Uso de medicações</td>
                </tr>

			    <tr>
					<td> Antibióticos  </td>
					<td> <?=$data['antibioticos']['total']?> </td>
					<td> <?=$data['antibioticos']['percentual']?> </td>
			    </tr>

			    <tr>
					<td> Corticoesteroides</td>
					<td> <?=$data['corticoesteroides']['total']?> </td>
					<td> <?=$data['corticoesteroides']['percentual']?> </td>
			    </tr>

			    <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan="3">Controle Glicêmico: Protocolo glicêmico</td>
                </tr>

			    <tr>
					<td>Protocolo glicêmico</td>
					<td> <?=$data['protocolo_glicemico']['total']?> </td>
					<td> <?=$data['protocolo_glicemico']['percentual']?> </td>
			    </tr>

			     <tr>
					<td>Fez uso de insulina nas 24 horas</td>
					<td> <?=$data['fez_insulina_ultimas_24_h']['total']?> </td>
					<td> <?=$data['fez_insulina_ultimas_24_h']['percentual']?> </td>
			    </tr>

			    <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan="3">Sedação Analgesia Delirium:</td>
                </tr>

			     <tr>
					<td>Uso de sedação</td>
					<td> <?=$data['sedacao']['total']?> </td>
					<td> <?=$data['sedacao']['percentual']?> </td>
			    </tr>

			     <tr>
					<td>Sob analgesia</td>
					<td> <?=$data['sob_analgesia']['total']?> </td>
					<td> <?=$data['sob_analgesia']['percentual']?> </td>
			    </tr>

			     <tr>
					<td>Avaliação de delirium pelo CAM-ICU</td>
					<td> <?=$data['avaliacao_delirium_pelo_camicu']['total']?> </td>
					<td> <?=$data['avaliacao_delirium_pelo_camicu']['percentual']?> </td>
			    </tr>

			  	 <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan="3">Ventilação Mecânica:</td>
                </tr>

                <tr>
					<td>Uso de ventilação mecânica invasiva</td>
					<td> <?=$data['ventilacao_mecanica_invasiva']['total']?> </td>
					<td> <?=$data['ventilacao_mecanica_invasiva']['percentual']?> </td>
			    </tr>

			</tbody>		  
		</table>
	</div>
</body>
</html>