<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <?=  $this->Html->css('pdf', ['fullBase' => true]); ?>
        <?= $this->fetch('css') ?>
    </head>
    <body>
    <?= $this->element( 'header-logo', ['report_title'=>'Relatório do Protocolo de Dor Torácica'] ); ?>
       <div class="container">
            <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
                <thead>
                    <tr>
                         <th>Item</th>
                         <th colspan="3">Valor</th>
                  </tr>
                </thead>
                <tbody>
                    <tr>
                        <td></td>
                         <td style="font-weight: bold; text-align:center;">Minimo</td>
                         <td  style="font-weight: bold; text-align:center;">Máximo</td>
                         <td  style="font-weight: bold; text-align:center;">Media</td>
                    </tr>

                    <tr>
                        <td  style="text-align:center;" >Até ECG</td>
                        <td style='text-align:center'><?= $data['ecg']['tempo_minino_ate_ecg'] ?></td>
                        <td style='text-align:center'><?= $data['ecg']['tempo_maximo_ate_ecg'] ?></td>
                        <td style='text-align:center'><?= $data['ecg']['tempo_medio_ate_ecg'] ?></td>
                    </tr>

                    <tr>
                        <td  style="text-align:center;">Até AAS</td>
                        <td style='text-align:center'><?= $data['aas']['tempo_minino_ate_aas'] ?></td>
                        <td style='text-align:center'><?= $data['aas']['tempo_maximo_ate_aas'] ?></td>
                        <td style='text-align:center'><?= $data['aas']['tempo_medio_ate_aas'] ?></td>
                    </tr>

                    <tr>
                        <td  style="text-align:center;">Até Clopidogrel ou Ticagrelor </td>
                         <td style='text-align:center'><?= $data['clopidogrel_ticagrelor']['tempo_minino_ate_clopidogrel_ticagrelor'] ?></td>
                         <td style='text-align:center'><?= $data['clopidogrel_ticagrelor']['tempo_maximo_ate_clopidogrel_ticagrelor'] ?></td>
                         <td style='text-align:center'><?= $data['clopidogrel_ticagrelor']['tempo_medio_ate_clopidogrel_ticagrelor'] ?></td>
                    </tr>

                    <tr>
                        <td  style="text-align:center;">Até trombolítico</td>
                         <td style='text-align:center'><?= $data['trombolitico']['tempo_minino_ate_trombolitico'] ?></td>
                         <td style='text-align:center'><?= $data['trombolitico']['tempo_maximo_ate_trombolitico'] ?></td>
                         <td style='text-align:center'><?= $data['trombolitico']['tempo_medio_ate_trombolitico'] ?></td>
                    </tr>

                    <tr>
                        <td  style="text-align:center;">Até balão da hemodinâmica</td>
                         <td style='text-align:center'><?= $data['balao_hemodinamica']['tempo_minino_ate_balao_hemodinamica'] ?></td>
                         <td style='text-align:center'><?= $data['balao_hemodinamica']['tempo_maximo_ate_balao_hemodinamica'] ?></td>
                         <td style='text-align:center'><?= $data['balao_hemodinamica']['tempo_medio_ate_balao_hemodinamica'] ?></td>
                    </tr>

                    <tr>
                        <td  style="text-align:center;">Dor torácica na emergência</td>
                         <td style='text-align:center'><?= $data['emergencia']['tempo_minino_dor_toraxica_emergencia'] ?></td>
                         <td style='text-align:center'><?= $data['emergencia']['tempo_maximo_dor_toraxica_emergencia'] ?></td>
                         <td style='text-align:center'><?= $data['emergencia']['tempo_medio_dor_toraxica_emergencia'] ?></td>
                    </tr>

                    <tr>
                         <td style="text-align:center; font-weight:bold; font-size:14px !important; background: #e8eaeb;" >Item</td>
                         <td style="text-align:center; font-weight: bold; font-size:14px !important; background: #e8eaeb;" colspan="3">Valor</td>
                    </tr>

                    <tr>
                        <td  style="text-align:center;" >Taxa de captação na unidade intensiva</td>
                        <td style='text-align:center' colspan="3"><?= number_format($data['taxa_captacao_unidade_intensiva'], 2) ?>%</td>
                    </tr>
                    <tr>
                        <td  style="text-align:center;" >Tempo médio de permanência na unidade intensiva</td>
                        <td style='text-align:center' colspan="3"><?= $data['tempo_medio_unidade_intensiva'] ?></td>
                    </tr>
                    <tr>
                        <td  style="text-align:center;" >Tempo médio de internação hospitalar</td>
                        <td style='text-align:center' colspan="3"><?= $data['tempo_medio_internacao_hospitalar'] ?></td>
                    </tr>

                    <tr>
                        <td  style="text-align:center;" >Taxa de exclusão de SCA</td>
                        <td style='text-align:center' colspan="3"><?= number_format($data['taxa_exclusao_de_sca'], 2) ?>%</td>
                    </tr>

                    <tr>
                        <td  style="text-align:center;" >Taxa de alta hospitalar</td>
                        <td style='text-align:center' colspan="3"><?= number_format($data['taxa_alta_hospitalar'], 2) ?>%</td>
                    </tr>

                    <tr>
                        <td  style="text-align:center;" >Taxa óbito por doença isquêmica</td>
                        <td style='text-align:center' colspan="3"><?= number_format($data['taxa_obito_isquemica'], 2) ?>%</td>
                    </tr>

                    <tr>
                        <td  style="text-align:center;" >Taxa de óbito</td>
                        <td style='text-align:center' colspan="3"><?= number_format($data['taxa_obito'], 2) ?>%</td>
                    </tr>
                <tbody>
            </table>
        </div>
    </body>
</html>