<!DOCTYPE html>
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<?=$this->Html->css('pdf', ['fullBase' => true]);?>
		<?=$this->fetch('css')?>
		<style type="text/css">
			table {
			    border-collapse: collapse;
			}


			tbody tr td, .border th {
			  border-right: solid 1px #ccc;
			  border-left: solid 1px #ccc;
			}

			 .border th {
			  border-top: solid 1px #ccc;
			}

			tbody tr td {
			    text-align: center;
			}

			tbody tr td:first-child {
			    text-align: left;
			}
		</style>
	</head>
	<body>
		<?=$this->element('header-logo', ['report_title' => 'Relatório de Cateter Vesical']);?>
		<div class="container">
			<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
				<thead>
					<tr class="border">
                         <th rowspan="2" class="title  th-left">Item</th>
                         <?php foreach ($data['dates'] as $key => $month): ?>
                             <th colspan="2" class="title th-spread"> <?=$month_name[$key];?>  </th>
                         <?php endforeach;?>
                    </tr>
                    <tr class="border">
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <th class="title  th-left">VA</th>
                            <th class="title  th-left">%</th>
                         <?php endforeach;?>
                    </tr>
				</thead>

				<tbody>
					<tr >
	                    <td class="line-separator title t-center" style="font-weight: bold" colspan=<?= $count_mes ?>> Seção única</td>
	                </tr>
					<tr >
						<td>Total de bundles de passagem de cateter vesical de demora </td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['tot_bundle_vesical_demora']?> </td>
							<td> - </td>
						<?php endforeach;?>
					</tr>

					<tr >
						<td>Percentual de bundle de cateter vesical de demora por paciente</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> - </td>
							<td> <?=$month['percen_bundle_vesical_paciente']?> </td>
						<?php endforeach;?>
					</tr>

					<tr >
						<td>Pacientes com bundle de cateter vesical de demora por pacientes com cateter vesical marcado em procedimentos</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['percen_pacient_bundle_vesical_procedimento']?> </td>
							<td> - </td>
						<?php endforeach;?>
					</tr>

					<tr >
						<td>Dispositivos inseridos no periodo em relacao ao total de bundles</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['tot_dispositivos_inseridos']?> </td>
							<td> <?=$month['percen_dispositivos_inseridos']?> </td>
						<?php endforeach;?>
					</tr>

					<tr>
						<td>Bundles realizados de forma emergencial</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['emergency']['total']?> </td>
							<td> <?=$month['emergency']['percentual']?> </td>
						<?php endforeach;?>
					</tr>

					<!--  <tr >
						item nao existo no sistema
						<td>Tamanho do cateter </td>
						<td> </td>
						<td> </td>
					</tr>-->

					<tr >
	                    <td class="line-separator title t-center" style="font-weight: bold" colspan=<?= $count_mes ?>> Checklist pré-procedimento </td>
	                </tr>

					<tr>
						<td>Risco de sangramento verificado</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['is_risk_of_bleeding_verified']['total']?> </td>
							<td> <?=$month['is_risk_of_bleeding_verified']['percentual']?> </td>
						<?php endforeach;?>
					</tr>

					<!--
					sandro falou pra desconsiderar esse item
					<tr>
						<td>TCI foi preenchido</td>
						<td></td>
						<td></td>
					</tr>
					-->

					<tr>
						<td>Procedimento foi prescrito</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['is_the_procedure_prescribed']['total']?> </td>
							<td> <?=$month['is_the_procedure_prescribed']['percentual']?> </td>
						<?php endforeach;?>
					</tr>

					<tr >
	                    <td class="line-separator title t-center" style="font-weight: bold" colspan=<?= $count_mes ?>> Checklist durante o procedimento</td>
	                </tr>

					<tr>
						<td>Higienização adequada das mãos</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['proper_handwashing']['total']?> </td>
							<td> <?=$month['proper_handwashing']['percentual']?> </td>
						<?php endforeach;?>
					</tr>

					<tr>
						<td>Uso de paramentação: gorro, máscara e luvas estéreis</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['use_of_paramentation']['total']?> </td>
							<td> <?=$month['use_of_paramentation']['percentual']?> </td>
						<?php endforeach;?>
					</tr>

					<tr>
						<td>Uso de degermação de cavidade genitália</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['degermacao_da_genitalia']['total']?> </td>
							<td> <?=$month['degermacao_da_genitalia']['percentual']?> </td>
						<?php endforeach;?>
					</tr>

					<tr>
						<td>Uso de campo com barreira máxima</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['use_of_field_with_maxium_barrier']['total']?> </td>
							<td> <?=$month['use_of_field_with_maxium_barrier']['percentual']?> </td>
						<?php endforeach;?>
					</tr>

					<tr>
						<td>Uso de gel estéril de xilocaína</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['use_of_sterile_gel']['total']?> </td>
							<td> <?=$month['use_of_sterile_gel']['percentual']?> </td>
						<?php endforeach;?>
					</tr>

					<tr>
						<td>Progressão adequada de cateter</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['suitable_catheter_progression']['total']?> </td>
							<td> <?=$month['suitable_catheter_progression']['percentual']?> </td>
						<?php endforeach;?>
					</tr>



					<tr>
						<td>Saída de urina de imediato a cateterização</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['urine_output_cauterization']['total']?> </td>
							<td> <?=$month['urine_output_cauterization']['percentual']?> </td>
						<?php endforeach;?>
					</tr>

					<tr>
						<td>Fixação adequada de cateter</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['adequate_catheter_fixation']['total']?> </td>
							<td> <?=$month['adequate_catheter_fixation']['percentual']?> </td>
						<?php endforeach;?>
					</tr>

					<tr>
						<td>Confirmação da posição com ultrassom</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['ultrasom_durante_procedimento']['total']?> </td>
							<td> <?=$month['ultrasom_durante_procedimento']['percentual']?> </td>
						<?php endforeach;?>
					</tr>

					<tr >
	                    <td class="line-separator title t-center" style="font-weight: bold" colspan=<?= $count_mes ?>> Descrição orientada</td>
	                </tr>

	                <tr >
	                    <td  style="font-weight: bold; text-align: left; padding-left: 10px;" colspan=<?= $count_mes ?>>Tentativas:</td>
	                </tr>

	                <tr >
						<td>&#8226; Média</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['number_of_retries']['media']?> </td>
							<td>- </td>
						<?php endforeach;?>
					</tr>
					<tr >
						<td>&#8226; Mediana</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['number_of_retries']['mediana']?> </td>
							<td>- </td>
						<?php endforeach;?>
					</tr>

					<tr >
						<td>&#8226; Desvio padrão</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['number_of_retries']['desvio_padrao']?> </td>
							<td>- </td>
						<?php endforeach;?>
					</tr>

					<tr >
						<td>Procedimentos com uma única tentativa </td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['tot_tentativa_unica']?> </td>
							<td> <?=$month['percen_tentativa_unica']?> </td>
						<?php endforeach;?>
					</tr>

					<tr >
	                    <td  style="font-weight: bold; text-align: left; padding-left: 10px;" colspan=<?= $count_mes ?>>Profissionais participantes:</td>
	                </tr>

	                <tr >
						<td>&#8226; Média</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['number_of_professionals']['media']?> </td>
							<td>- </td>
						<?php endforeach;?>
					</tr>
					<tr >
						<td>&#8226; Mediana</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['number_of_professionals']['mediana']?> </td>
							<td>- </td>
						<?php endforeach;?>
					</tr>

					<tr >
						<td>&#8226; Desvio padrão</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['number_of_professionals']['desvio_padrao']?> </td>
							<td>- </td>
						<?php endforeach;?>
					</tr>

					<tr>
						<td>Presença de sangue no sistema coletor</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['blood_on_catheter']['total']?> </td>
							<td> <?=$month['blood_on_catheter']['percentual']?> </td>
						<?php endforeach;?>
					</tr>

					<!--tr >
						<td>Sucesso na inserção</td>
						<td> <?=$month['sucesso_na_insercao']['total']?></td>
						<td> <?=$month['sucesso_na_insercao']['percentual']?></td>
					</tr-->

	                <tr >
						<td>Procedimentos em que houve complicação imediata</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['tot_houve_complicacao_imediata']?></td>
							<td> <?=$month['percen_houve_complicacao_imediata']?></td>
						<?php endforeach;?>
					</tr>

					<tr>
						<td>Total de das complicações imediatas</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['tot_qtd_complicacao_imediata']?></td>
							<td> - </td>
						<?php endforeach;?>
					</tr>


					<tr >
	                    <td class="line-separator title t-center" style="font-weight: bold" colspan=<?= $count_mes ?>> Retirada do cateter vesical ou citostomia</td>
	                </tr>

					<tr >
	                    <td  style="font-weight: bold; text-align: left; padding-left: 10px;" colspan=<?= $count_mes ?>> Tempo de uso do dispositivo:</td>
	                </tr>

	                <tr >
						<td>&#8226; Média</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td><?=$month['media_dias_retirada']?></td>
							<td>-</td>
						<?php endforeach;?>
					</tr>
					<tr >
						<td>&#8226; Mediana</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td><?=$month['mediana_dias_retirada']?></td>
							<td>-</td>
						<?php endforeach;?>
					</tr>

					<tr >
						<td>&#8226; Desvio padrão</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td><?=$month['desvio_padrao_dias_retirada']?></td>
							<td>-</td>
						<?php endforeach;?>
					</tr>

					<tr >
						<td>Bundles com retirada acidental </td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['accidental_removal']['total']?></td>
							<td> <?=$month['accidental_removal']['percentual']?></td>
						<?php endforeach;?>
					</tr>


					<tr >
						<td  style="font-weight: bold; text-align: left; padding-left: 10px;" colspan=<?= $count_mes ?>>Pacientes com tempo de uso do dispositivo:</td>
	                </tr>

	                <tr class="tr-indent">
						<td >&#8226; Inferior a 5 dias</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['pacientes_tempo_de_uso_inf_5']['tot']?> </td>
							<td> - </td>
						<?php endforeach;?>
					</tr>

					<tr class="tr-indent">
						<td >&#8226; Inferior a 7 dias</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['pacientes_tempo_de_uso_inf_7']['tot']?> </td>
							<td> - </td>
						<?php endforeach;?>
					</tr>

					<tr class="tr-indent">
						<td >&#8226; Inferior a 10 dias</td>
						<?php foreach ($data['dates'] as $key => $month): ?>
							<td> <?=$month['pacientes_tempo_de_uso_inf_10']['tot']?> </td>
							<td> - </td>
						<?php endforeach;?>
					</tr>

					<!--Sandro falou pra desonsiderr tempo de uso nesse momento-->
					<!-- <tr >
	                    <td class="line-separator title" style="font-weight: bold" colspan=<?= $count_mes ?>> Reinserção</td>
	                </tr>

					<tr >
						<td>Dispositivos reinseridos</td>
						<td>- </td>
						<td>- </td>
					</tr>

					<tr >
						<td>Dispositivos reinseridos em tempo inferior a 24h</td>
						<td>- </td>
						<td>- </td>
					</tr> -->

				</tbody>
			</table>
		</div>
	</body>
</html>