<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <?=$this->Html->css('pdf', ['fullBase' => true]);?>
    <?=$this->fetch('css')?>
    <style type="text/css">
        table {
            border-collapse: collapse;
        }

        tbody tr td, .border th {
          border-right: solid 1px #ccc;
          border-left: solid 1px #ccc;
        }

         .border th {
          border-top: solid 1px #ccc;
        }

        tbody tr td {
            text-align: center;
        }

        tbody tr td:first-child {
            text-align: left;
        }
    </style>
</head>
<body>
    <?= $this->element( 'header-logo', ['report_title'=>'Relatório de Protocolo de Sepse'] ); ?>
    <div class="container">
        <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
            <thead>
                <tr class="border">
                     <th rowspan="2" class="title  th-left">Item</th>
                     <?php foreach ($data['dates'] as $key => $month): ?>
                         <th colspan="2" class="title th-spread"> <?=$month_name[$key];?>  </th>
                     <?php endforeach;?>
                </tr>
                <tr class="border">
                    <?php foreach ($data['dates'] as $key => $month): ?>
                        <th class="title  th-left">VA</th>
                        <th class="title  th-left">%</th>
                     <?php endforeach;?>
                </tr>
            </thead>

             
            <tbody>
                <tr>
                    <td >Indice de pacientes com sepse</td>
                    <?php foreach ($data['dates'] as $key => $month): ?>
                        <td> <?=$month['indice_paciente_sepse']?> </td>
                        <td> <?=$month['indice_paciente_sepse_percentual']?> </td>
                    <?php endforeach;?>
                </tr>
                <!-- fora do escopo
                <tr>
                    <td >Taxa de realização de volume rápido </td>
                    <td>  </td>
                    <td>  </td>
                </tr>


                <tr >
                    <td > Taxa de realização de volume rápido em sepse grave </td>
                    <td>  </td>
                    <td></td>
                </tr>


                <tr>
                    <td > MÉDIA DE VOLUME EM ETAPA RÁPIDA </td>
                    <td>  </td>
                    <td>  </td>
                </tr>
                 -->

                <tr>
                    <td > Média percentual do clareamento do lactato</td>
                    <?php foreach ($data['dates'] as $key => $month): ?>
                        <td> - </td>
                        <td> <?=$month['taxa_clareamento_lactato']['media']?>% </td>
                    <?php endforeach;?>
                </tr>
                <tr >
                    <td style="font-weight: bold; text-align: left; padding-left: 10px;" colspan=<?= $count_d ?> >Distribuição absoluta e percentual do clareamento do lactato em 6 horas por:</td>
                </tr>

                <tr class="td-indent" >
                    <td>&#8226;> Menor que 20%</td>
                    <?php foreach ($data['dates'] as $key => $month): ?>
                        <td> <?=$month['distribuicao_lactato']['menor_20']['tot']?> </td>
                        <td> -</td>
                    <?php endforeach;?>
                </tr>
                <tr class="td-indent" >
                    <td>&#8226; De 21% a 40%</td>
                    <?php foreach ($data['dates'] as $key => $month): ?>
                        <td> <?=$month['distribuicao_lactato']['21_a_40']['tot']?> </td>
                        <td> - </td>
                    <?php endforeach;?>
                </tr>
                <tr class="td-indent" >
                    <td>&#8226;> De 41% a 60%</td>
                    <?php foreach ($data['dates'] as $key => $month): ?>
                        <td> <?=$month['distribuicao_lactato']['41_a_60']['tot']?> </td>
                        <td> - </td>
                    <?php endforeach;?>
                </tr>
                <tr class="td-indent" >
                    <td>&#8226;Maior que 60%</td>
                    <?php foreach ($data['dates'] as $key => $month): ?>
                        <td> <?=$month['distribuicao_lactato']['maior_60']['tot']?> </td>
                        <td> - </td>
                    <?php endforeach;?>
                </tr>


                <tr>
                    <td > Taxa de adesão ao protocolo de sepse</td>
                    <?php foreach ($data['dates'] as $key => $month): ?>
                        <td> - </td>
                        <td> <?=$month['taxa_adesao_prot_sepse']?> </td>
                    <?php endforeach;?>
                </tr>


                <tr>
                    <td > Taxa de efetividade do protocolo de sepse </td>
                    <?php foreach ($data['dates'] as $key => $month): ?>
                        <td> - </td>
                        <td> <?=$month['taxa_efetividade']['percentual']?> </td>
                    <?php endforeach;?>
                </tr>

                <tr>
                    <td > Taxa de mortalidade dos pacientes com sepse </td>
                    <?php foreach ($data['dates'] as $key => $month): ?>
                        <td> - </td>
                        <td> <?=$month['mortalidade']['percentual']?> </td>
                    <?php endforeach;?>
                </tr>

                <!-- <tr >
                    <td style="font-weight: bold; text-align: left; padding-left: 10px;" colspan=3>Protocolos abertos por tipo de sepse :</td>
                </tr>
                <tr class="td-indent" >
                    <td>&#8226; Sepse</td>
                    <td> <?=$data['local_insercao']['tot_arteria_axilar']?> </td>
                    <td> <?=$data['local_insercao']['percen_arteria_axilar']?>% </td>
                </tr>

                <tr class="td-indent" >
                    <td>&#8226; Severa</td>
                    <td> <?=$data['local_insercao']['tot_arteria_axilar']?> </td>
                    <td> <?=$data['local_insercao']['percen_arteria_axilar']?>% </td>
                </tr>

                <tr class="td-indent" >
                    <td>&#8226; Choque Séptico</td>
                    <td> <?=$data['local_insercao']['tot_arteria_axilar']?> </td>
                    <td> <?=$data['local_insercao']['percen_arteria_axilar']?>% </td>
                </tr> -->


                <tr >
                    <td style="font-weight: bold; text-align: left; padding-left: 10px;" colspan=<?= $count_d ?>>SOFA nas primeiras 24h:</td>
                </tr>
                <tr class="td-indent" >
                    <td>&#8226; Mínimo</td>
                    <?php foreach ($data['dates'] as $key => $month): ?>
                        <td>  <?=$month['sofa']['minimo']?> </td>
                        <td>- </td>
                    <?php endforeach;?>
                </tr>

                <tr class="td-indent" >
                    <td>&#8226; Médio</td>
                    <?php foreach ($data['dates'] as $key => $month): ?>
                        <td>  <?=$month['sofa']['medio']?> </td>
                        <td> -</td>
                    <?php endforeach;?>
                </tr>

                <tr class="td-indent" >
                    <td>&#8226; Máximo</td>
                    <?php foreach ($data['dates'] as $key => $month): ?>
                        <td>  <?=$month['sofa']['maximo']?> </td>
                        <td> - </td>
                    <?php endforeach;?>
                </tr>

                <tr>
                    <td > Taxa média de variação do SOFA durante a internação</td>
                    <?php foreach ($data['dates'] as $key => $month): ?>
                        <td> - </td>
                        <td> <?=$month['pontuacao_sofa']['variacao']?> </td>
                    <?php endforeach;?>
                </tr>

                <tr>
                    <td > Pacientes com aumento do SOFA  </td>
                    <!--td>  <?=$data['paciente_aumento_sofa']['media']?> </td-->
                    <?php foreach ($data['dates'] as $key => $month): ?>
                        <td>  <?=$month['paciente_aumento_sofa']['paciente_aumento']?> </td>
                        <td>  <?=$month['paciente_aumento_sofa']['percentual']?> </td>
                    <?php endforeach;?>
                </tr>

                 <tr>
                    <td > Tempo médio de permanência do paciente com sepse </td>
                    <?php foreach ($data['dates'] as $key => $month): ?>
                        <td>  <?=$month['paciente_permanencia_sepse']['media']?> <?= $month['paciente_permanencia_sepse']['media'] <= 1 ? 'dia' : 'dias' ?> </td>
                        <td> - </td>
                    <?php endforeach;?>
                </tr>

                <!-- <tr >
                    <td style="font-weight: bold; text-align: left; padding-left: 10px;" colspan=3>Tempo médio de permanência no hospital do paciente com sepse pelo tipo de sepse:</td>
                </tr>
                <tr class="td-indent" >
                    <td>&#8226; Sepse</td>
                    <td></td>
                    <td> - </td>
                </tr>

                <tr class="td-indent" >
                    <td>&#8226; Severa</td>
                   <td></td>
                    <td> - </td>
                </tr>

                <tr class="td-indent" >
                    <td>&#8226; Choque Séptico</td>
                    <td></td>
                    <td> - </td>
                </tr> -->

                <!-- <tr >
                    <td style="fo-nt-weight: bold; text-align: left; padding-left: 10px;" colspan=3>Reinternação na uti do paciente com sepse pelo tipo de sepse :</td>
                </tr>
                <tr class="td-indent" >
                    <td>&#8226; Sepse</td>
                    <td></td>
                    <td> - </td>
                </tr>

                <tr class="td-indent" >
                    <td>&#8226; Severa</td>
                    <td></td>
                    <td> - </td>
                </tr>

                <tr class="td-indent" >
                    <td>&#8226; Choque Séptico</td>
                    <td></td>
                    <td> - </td>
                </tr>
                -->
                <tr>
                    <td > Taxa de mortalidade dos pacientes com sepse </td>
                    <?php foreach ($data['dates'] as $key => $month): ?>
                        <td> - </td>
                        <td> <?=$month['mortalidade']['percentual']?> </td>
                    <?php endforeach;?>
                </tr>

                <!--tr class="td-indent" >
                    <td>&#8226; Sepse</td>
                    <td></td>
                    <td> - </td>
                </tr>

                <tr class="td-indent" >
                    <td>&#8226; Severa</td>
                    <td></td>
                    <td> - </td>
                </tr>

                <tr class="td-indent" >
                    <td>&#8226; Choque Séptico</td>
                    <td></td>
                    <td> - </td>
                </tr-->

            </tbody>


        </table>
    </div>
</body>
</html>