<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <?=  $this->Html->css('pdf', ['fullBase' => true]); ?>
        <?= $this->fetch('css') ?>
    </head>
    <body>
        <?= $this->element( 'header-logo', ['report_title'=>'Relatório de Escores'] ); ?>
        <div class="container">
            <?php
                $arr_gravidade = ['apache', 'saps', 'crib', 'snap', 'sofa'];
                $arr_gravidade_apache_saps = ['apache', 'saps'];
                foreach ($arr_gravidade as $key => $gravidade) {
                    if ($gravidade == 'apache') {
                        $tipo = "APACHE II";
                    }
                    else if($gravidade == 'saps'){
                        $tipo = "SAPS III";
                    }
                    else if($gravidade == 'crib'){
                        $tipo = "CRIB";
                    }
                    else if($gravidade == 'snap'){
                        $tipo = "SNAP II";
                    }
                    else if($gravidade == 'sofa'){
                        $tipo = "SOFA";
                    }
                ?>
                    <!-- faixa etária ( <?= $gravidade ?> ) START -->
                    <table class="aileron_thin relatorio_geral" style="width:100%; border-collapse: collapse; page-break-after: always;">
                        <thead>
                            <tr>
                                <th colspan='12' >  Tabela entre escore de gravidade e faixa etária ( <?= $tipo ?> ) </th>
                            </tr>
                        </thead>

                        <tbody>
                            <tr >
                                <td style='width:180px;'>Taxa de óbito</td>
                                <td class="title linha_td">0 - 9</td>
                                <td class="title linha_td">10 - 19</td>
                                <td class="title linha_td">20 - 29</td>
                                <td class="title linha_td">30 - 39</td>
                                <td class="title linha_td">40 - 49</td>
                                <td class="title linha_td">50 - 59</td>
                                <td class="title linha_td">60 - 69</td>
                                <td class="title linha_td">70 - 79</td>
                                <td class="title linha_td">80 - 89</td>
                                <td class="title linha_td">90 - 99</td>
                                <td class="title linha_td"> > 100</td>
                            </tr>

                            <?php
                                $arr_faixa = [];
                                foreach ($data['consolidado'] as $key => $value) {
                                    if (in_array($key, $arr_gravidade)) {
                                      foreach ($value['gravidade_faixa_etaria'] as $key_2 => $gravidade_faixa_etaria) {
                                            $arr_faixa[$key_2]['nome'] = $key_2;
                                            $arr_faixa[$key_2][$key] = $gravidade_faixa_etaria;

                                        }
                                    }
                                }
                                foreach ($arr_faixa as $key_3 => $value_3) {
                                    echo "<tr>";
                                    echo "<td style='width:180px;'> ". $value_3['nome'] ."% </td>";
                                    echo "<td class='linha_td'> ". $value_3[$gravidade]['0 - 9'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3[$gravidade]['10 - 19'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3[$gravidade]['20 - 29'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3[$gravidade]['30 - 39'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3[$gravidade]['40 - 49'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3[$gravidade]['50 - 59'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3[$gravidade]['60 - 69'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3[$gravidade]['70 - 79'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3[$gravidade]['80 - 89'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3[$gravidade]['90 - 99'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3[$gravidade]['> 100'] ." </td>";
                                    echo "</tr>";
                                }
                            ?>
                        </tbody>
                    </table>
            <!-- Faixa etária ( <?= $gravidade ?> ) end -->
            <?php } ?>
            <!-- obito alta START -->
            <table class="aileron_thin relatorio_geral" style="width:100%; border-collapse: collapse; page-break-after: always;">
                <!-- <thead>
                    <tr>
                        <th class="line-separator" style="font-weight: bold"  colspan="13" >  Tabela entre escore de gravidade e óbitos e alta  </th>
                    <tr >
                </thead>  -->
                <thead>
                    <tr>
                        <th style="font-weight: bold"  colspan="5">
                            Tabela entre escore de gravidade e óbitos e alta
                        </th>
                    </tr>
                </thead>
                <tbody >
                    <tr>
                        <td rowspan="2">Taxa de óbito</td>
                        <td colspan="2">APACHE II</td>
                        <td colspan="2">SAPS III</td>
                        <!-- <td colspan="2">SOFA</td>
                        <td colspan="2">CRIB</td>
                        <td colspan="2">SNAP II</td>
                        <td colspan="2">SNAP II PE</td> -->
                    </tr>
                    <tr >
                        <td class='linha_td'>Obito</td>
                        <td class='linha_td'>Alta</td>
                        <td class='linha_td'>Obito</td>
                        <td class='linha_td'>Alta</td>
                        <!-- <td>Obito</td>
                        <td>Alta</td>
                        <td>Obito</td>
                        <td>Alta</td>
                        <td>Obito</td>
                        <td>Alta</td>
                        <td>Obito</td>
                        <td>Alta</td> -->
                    </tr>

                    <?php
                        //$arr_gravidade = ['sofa', 'crib', 'apache', 'snap', 'saps'];

                        $arr_obito_alta = [];
                        foreach ($data['consolidado'] as $key => $value) {
                            if (in_array($key, $arr_gravidade)) {
                              foreach ($value['obito_alta'] as $key_2 => $obito_alta) {
                                    $arr_obito_alta[$key_2]['nome'] = $key_2;
                                    $arr_obito_alta[$key_2][$key] = $obito_alta;
                                    //$arr_obito_alta[$key_2][$key]['alta']
                                }
                            }
                        }

                        foreach ($arr_obito_alta as $key_3 => $value_3) {
                            echo "<tr>";
                            echo "<td > ". $value_3['nome'] ." </td>";
                            echo "<td class='linha_td'> ". $value_3['apache']['obito'] ." </td>";
                            echo "<td class='linha_td'> ". $value_3['apache']['alta'] ." </td>";
                            echo "<td class='linha_td'> ". $value_3['saps']['obito'] ." </td>";
                            echo "<td class='linha_td'> ". $value_3['saps']['alta'] ." </td>";
                            // echo "<td> ". $value_3['apache']['obito'] ." </td>";
                            // echo "<td> ". $value_3['apache']['alta'] ." </td>";
                            // echo "<td> ". $value_3['saps']['obito'] ." </td>";
                            // echo "<td> ". $value_3['saps']['alta'] ." </td>";
                            // echo "<td> ". $value_3['apache']['obito'] ." </td>";
                            // echo "<td> ". $value_3['apache']['alta'] ." </td>";
                            // echo "<td> ". $value_3['apache']['obito'] ." </td>";
                            // echo "<td> ". $value_3['apache']['alta'] ." </td>";
                            echo "</tr>";
                        }
                    ?>
                </tbody>
            </table>
            <!-- obito alta end -->
            <?php foreach ($arr_gravidade as $key => $gravidade) {
                if ($gravidade == 'apache') {
                    $tipo = "APACHE II";
                }
                else if($gravidade == 'saps'){
                    $tipo = "SAPS III";
                }
                else if($gravidade == 'crib'){
                    $tipo = "CRIB";
                }
                else if($gravidade == 'snap'){
                    $tipo = "SNAP II";
                }
                else if($gravidade == 'sofa'){
                    $tipo = "SOFA";
                }
            ?>
                <!-- Origem START -->
                <table class="aileron_thin relatorio_geral" style="width:100%; border-collapse: collapse; page-break-after: always;">
                    <thead>
                        <tr>
                            <th colspan='11' >  Tabela entre escore de gravidade e origem ( <?= $tipo ?> )</th>
                        </tr>
                    </thead>
                    <tbody >
                        <tr >
                            <td>Taxa de óbito</td>
                            <td class="title linha_td">0 - 9</td>
                            <td class="title linha_td">10 - 19</td>
                            <td class="title linha_td">20 - 29</td>
                            <td class="title linha_td">30 - 39</td>
                            <td class="title linha_td">40 - 49</td>
                            <td class="title linha_td">50 - 59</td>
                            <td class="title linha_td">60 - 69</td>
                            <td class="title linha_td">70 - 79</td>
                            <td class="title linha_td">80 - 89</td>
                            <td class="title linha_td">90 - 100</td>
                        </tr>
                        <?php
                            $arr_origem = [];
                            foreach ($data['consolidado'] as $key => $value) {
                                if (in_array($key, $arr_gravidade)){
                                    foreach ($value['origem'] as $key_2 => $origem) {
                                        //echo "<pre>";
                                        //print_r($origem);
                                        //print_r($origem['0']);
                                        foreach ($origem['0'] as $key_3 => $or) {
                                            //echo "<pre>";
                                            //print_r($or);
                                            $arr_origem[$key][$key_3]['nome'] = $or['name'];
                                            $arr_origem[$key][$key_3][$key_2]['value'] = $or['value'];
                                        }
                                        //$arr_origem[$key_2]['nome'] = $origem['0'][$key]['name'];
                                        //$arr_origem[$key_2][$key]['valor'] = $origem['value'];
                                    }
                                }
                            }
                            //echo "<pre>";
                            //print_r($arr_origem[$gravidade]);
                            foreach ($arr_origem[$gravidade] as $key_4 => $value_4) {
                                echo "<tr>";
                                echo "<td> ". $value_4['nome'] ." </td>";
                                echo "<td class='linha_td'> ". $value_4['0 - 9']['value'] ." </td>";
                                echo "<td class='linha_td'> ". $value_4['10 - 19']['value'] ." </td>";
                                echo "<td class='linha_td'> ". $value_4['20 - 29']['value'] ." </td>";
                                echo "<td class='linha_td'> ". $value_4['30 - 39']['value'] ." </td>";
                                echo "<td class='linha_td'> ". $value_4['40 - 49']['value'] ." </td>";
                                echo "<td class='linha_td'> ". $value_4['50 - 59']['value'] ." </td>";
                                echo "<td class='linha_td'> ". $value_4['60 - 69']['value'] ." </td>";
                                echo "<td class='linha_td'> ". $value_4['70 - 79']['value'] ." </td>";
                                echo "<td class='linha_td'> ". $value_4['80 - 89']['value'] ." </td>";
                                echo "<td class='linha_td'> ". $value_4['90 - 100']['value'] ." </td>";
                                echo "</tr>";
                            }
                        ?>
                    </tbody>
                </table>
            <?php } ?>
            <!-- Origem end -->
            <?php $count_t = 0; ?>
            <?php foreach ($data['consolidado'] as $key => $value) {  ?>
                <?php if (in_array($key, $arr_gravidade)) {  ?>
                    <?php
                        if ($key == 'apache') {
                            $tipo = "APACHE II";
                        }
                        else if($key == 'saps'){
                            $tipo = "SAPS III";
                        }
                        else if($key == 'crib'){
                            $tipo = "CRIB";
                        }
                        else if($key == 'snap'){
                            $tipo = "SNAP II";
                        }
                        else if($key == 'sofa'){
                            $tipo = "SOFA";
                        }
                    ?>
                    <table class="aileron_thin relatorio_geral relatorio_geral_suporte" style="width:100%; border-collapse: collapse; page-break-after: always;">
                        <thead>
                            <tr>
                                <th colspan='11'>Tabela entre escore de gravidade e medida de suporte na internação ( <?= $tipo ?> )</th>
                            </tr>
                            <tr >
                                <td style='width:160px;' >Taxa de óbito</td>
                                <td class="title linha_td">  0 - 9  </td>
                                <td class="title linha_td"> 10 - 19 </td>
                                <td class="title linha_td"> 20 - 29 </td>
                                <td class="title linha_td"> 30 - 39 </td>
                                <td class="title linha_td"> 40 - 49 </td>
                                <td class="title linha_td"> 50 - 59 </td>
                                <td class="title linha_td"> 60 - 69 </td>
                                <td class="title linha_td"> 70 - 79 </td>
                                <td class="title linha_td"> 80 - 89 </td>
                                <td class="title linha_td"> 90 - 100 </td>
                            </tr>
                        </thead>

                        <tbody>

                            <?php
                                foreach ($value['medida_suporte'] as $key_2 => $medida_suporte) {
                                    //$count_t++;
                                     echo "<tr>";
                                     echo "<td style='width:160px;'> ". $key_2 ." </td>";
                                     echo "<td class='linha_td'> ". $medida_suporte['0 - 9'] ." </td>";
                                     echo "<td class='linha_td'> ". $medida_suporte['10 - 19'] ." </td>";
                                     echo "<td class='linha_td'> ". $medida_suporte['20 - 29'] ." </td>";
                                     echo "<td class='linha_td'> ". $medida_suporte['30 - 39'] ." </td>";
                                     echo "<td class='linha_td'> ". $medida_suporte['40 - 49'] ." </td>";
                                     echo "<td class='linha_td'> ". $medida_suporte['50 - 59'] ." </td>";
                                     echo "<td class='linha_td'> ". $medida_suporte['60 - 69'] ." </td>";
                                     echo "<td class='linha_td'> ". $medida_suporte['70 - 79'] ." </td>";
                                     echo "<td class='linha_td'> ". $medida_suporte['80 - 89'] ." </td>";
                                     echo "<td class='linha_td'> ". $medida_suporte['90 - 100'] ." </td>";
                                     echo "</tr>";
                                }
                            ?>
                        </tbody>
                    </table>
                <?php } ?>
            <?php } ?>


            <table class="aileron_thin relatorio_geral" style="width:100%; border-collapse: collapse; page-break-after: always;">
                <thead>
                    <tr>
                        <th colspan='13'>Tabela entre escore de gravidade APACHE II e SAPS III</th>
                    </tr>
                </thead>
                <tbody>
                    <tr >
                        <td colspan='2'>Taxa de óbito</td>
                        <td class="title linha_td">0 - 9</td>
                        <td class="title linha_td">10 - 19</td>
                        <td class="title linha_td">20 - 29</td>
                        <td class="title linha_td">30 - 39</td>
                        <td class="title linha_td">40 - 49</td>
                        <td class="title linha_td">50 - 59</td>
                        <td class="title linha_td">60 - 69</td>
                        <td class="title linha_td">70 - 79</td>
                        <td class="title linha_td">80 - 89</td>
                        <td class="title linha_td">90 - 99</td>
                        <td class="title linha_td"> > 100</td>
                    </tr>
                    <?php
                        $arr_faixa = [];
                        //foreach ($arr_gravidade_apache_saps as $key => $gravidade) { ?>
                        <?php

                            foreach ($data['consolidado'] as $key => $value) {
                                if (in_array($key, $arr_gravidade_apache_saps)) {
                                  foreach ($value['gravidade_faixa_etaria'] as $key_2 => $gravidade_faixa_etaria) {
                                    //echo "$arr_gravidade = " . $arr_gravidade;
                                        $arr_faixa[$key_2]['nome'] = $key_2;
                                        $arr_faixa[$key_2][$key] = $gravidade_faixa_etaria;

                                    }
                                }
                            }

                            foreach ($arr_faixa as $key_3 => $value_3) {
                                //echo "<pre>";
                                //print_r($value_3);
                                echo "<tr>";
                                    echo "<td rowspan='2'> ". $value_3['nome'] ."% </td>";
                                    echo '<td class="linha_td">APACHE II</td>';
                                    echo "<td class='linha_td'> ". $value_3['apache']['0 - 9'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3['apache']['10 - 19'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3['apache']['20 - 29'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3['apache']['30 - 39'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3['apache']['40 - 49'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3['apache']['50 - 59'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3['apache']['60 - 69'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3['apache']['70 - 79'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3['apache']['80 - 89'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3['apache']['90 - 99'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3['apache']['> 100'] ." </td>";
                                echo "</tr>";
                                echo "<tr>";
                                    echo '<td class="linha_td">SAPS III</td>';
                                    echo "<td class='linha_td'> ". $value_3['saps']['0 - 9'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3['saps']['10 - 19'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3['saps']['20 - 29'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3['saps']['30 - 39'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3['saps']['40 - 49'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3['saps']['50 - 59'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3['saps']['60 - 69'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3['saps']['70 - 79'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3['saps']['80 - 89'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3['saps']['90 - 99'] ." </td>";
                                    echo "<td class='linha_td'> ". $value_3['saps']['> 100'] ." </td>";
                                echo "</tr>";
                            }
                        ?>

                    <?php //} ?>
                </tbody>
            </table>
            <!-- Apache e saps ( <?= $gravidade ?> ) END -->
            <!-- Comorbidades Inicio -->
            <?php foreach ($arr_gravidade as $key => $gravidade) {
                if ($gravidade == 'apache') {
                    $tipo = "APACHE II";
                }
                else if($gravidade == 'saps'){
                    $tipo = "SAPS III";
                }
                else if($gravidade == 'crib'){
                    $tipo = "CRIB";
                }
                else if($gravidade == 'snap'){
                    $tipo = "SNAP II";
                }
                else if($gravidade == 'sofa'){
                    $tipo = "SOFA";
                }
            ?>
                <!-- Apache e saps ( <?= $gravidade ?> ) END -->
                <table class="aileron_thin relatorio_geral" style="width:100%; border-collapse: collapse; page-break-after: always;">
                    <thead>
                        <tr>
                            <th colspan='4'>Tabela entre escore de gravidade e comorbidades ( <?= $tipo ?> )</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr >
                            <td >Taxa de óbito</td>
                            <td class="title linha_td">1</td>
                            <td class="title linha_td">2</td>
                            <td class="title linha_td">>=3</td>
                        </tr>
                        <?php
                            foreach ($data['consolidado'] as $key => $value) {
                                if(isset($value['comorbidades'])){
                                    foreach ($value['comorbidades'] as $key_2 => $comorbidade) {
                                        if($gravidade == $key){
                                            echo "<tr>";
                                            echo "<td>$key_2</td>";
                                            echo "<td class='linha_td'>$comorbidade[1]</td>";
                                            echo "<td class='linha_td'>$comorbidade[2]</td>";
                                            echo "<td class='linha_td'>$comorbidade[3]</td>";
                                            echo "</tr>";
                                        }

                                    }
                                }

                            }
                        ?>
                    </tbody>
                </table>
            <?php } ?>

            <!-- Comorbidades Fim -->

            <!-- tempo permanencia Inicio -->
            <?php foreach ($arr_gravidade as $key => $gravidade) {
                if ($gravidade == 'apache') {
                    $tipo = "APACHE II";
                }
                else if($gravidade == 'saps'){
                    $tipo = "SAPS III";
                }
                else if($gravidade == 'crib'){
                    $tipo = "CRIB";
                }
                else if($gravidade == 'snap'){
                    $tipo = "SNAP II";
                }
                else if($gravidade == 'sofa'){
                    $tipo = "SOFA";
                }
            ?>
                <!-- Apache e saps ( <?= $gravidade ?> ) END -->
                <table class="aileron_thin relatorio_geral" style="width:100%; border-collapse: collapse; page-break-after: always;">
                    <thead>
                        <tr>
                            <th colspan='4'>Tabela entre escore de gravidade e tempo de permanência ( <?= $tipo ?> )</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr >
                            <td >Taxa de óbito</td>
                            <td class="title linha_td">  &lt; 24h </td>
                            <td class="title linha_td">  &lt; 72h </td>
                            <td class="title linha_td"> > 12 dias </td>
                        </tr>
                        <?php
                            foreach ($data['consolidado'] as $key => $value) {
                                if(isset($value['tempo_permanencia'])){
                                    foreach ($value['tempo_permanencia'] as $key_2 => $tempo_permanencia) {
                                        if($gravidade == $key){
                                            echo "<tr>";
                                            echo "<td>$key_2</td>";
                                            echo "<td class='linha_td'>" .$tempo_permanencia['< 24h']. "</td>";
                                            echo "<td class='linha_td'>" .$tempo_permanencia['< 72h']. "</td>";
                                            echo "<td class='linha_td'>" .$tempo_permanencia['> 12 dias']. "</td>";
                                            echo "</tr>";
                                        }
                                    }
                                }   
                            }
                        ?>
                    </tbody>
                </table>
            <?php } ?>

            <!-- tempo permanencia Fim -->
            <!-- Pre Deliric START -->
            <table class="aileron_thin relatorio_geral" style="width:100%; border-collapse: collapse; ">
                <thead>
                    <tr>
                        <th class="title th-left">Item</th>
                        <th class="title th-middle">Total</th>
                        <th class="title">%</th>
                    </tr>
                </thead>

                <tbody class="yolo" >
                    <tr >
                        <td class="line-separator" style="font-weight: bold;"  colspan=3 >  Pré Deliric  </td>
                    </tr>
                    <tr >
                        <td >Pacientes com escore</td>
                        <td> <?= $data['consolidado']['pre_deliric']['total_pacientes'] ?> </td>
                        <td> <?= number_format($data['consolidado']['pre_deliric']['percentual_pacientes'], 2) ?> </td>
                    </tr>
                    <tr>
                        <td >Média do escore</td>
                        <td><?= $data['consolidado']['pre_deliric']['escore']['media'] ?></td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Mediana do escore</td>
                        <td><?= $data['consolidado']['pre_deliric']['escore']['mediana'] ?></td>
                        <td> - </td>
                    </tr>

                    <tr>
                        <td >Desvio padrão do escore</td>
                        <td><?= $data['consolidado']['pre_deliric']['escore']['desvio_padrao'] ?></td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Pacientes com valor superior a 40%</td>
                        <td> <?= $data['consolidado']['pre_deliric']['probabilidade_de_obito_acima_40']['total'] ?> </td>
                        <td> <?= number_format($data['consolidado']['pre_deliric']['probabilidade_de_obito_acima_40']['percentual'], 2) ?> </td>
                    </tr>

                </tbody>
            </table>
            <!-- Pre Deliric END -->

            <!-- Sofa START -->
            <table class="aileron_thin relatorio_geral" style="width:100%; border-collapse: collapse;">
                <thead>
                    <tr>
                        <th class="title th-left">Item</th>
                        <th class="title th-middle">Total</th>
                        <th class="title">%</th>
                    </tr>
                </thead>

                <tbody class="yolo">
                    <tr >
                        <td class="line-separator" style="font-weight: bold"  colspan=3 >  SOFA  </td>
                    </tr>
                    <tr >
                        <td >Total de pacientes com escore preenchido</td>
                        <td> <?= $data['consolidado']['sofa']['total_pacientes'] ?> </td>
                        <td> <?= number_format($data['consolidado']['sofa']['percentual_pacientes'], 2) ?> </td>
                    </tr>
                    <tr >
                        <td>Mínimo do escore</td>
                        <td> <?= $data['consolidado']['sofa']['minimo_score'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Máximo do escore</td>
                        <td> <?= $data['consolidado']['sofa']['maximo_score'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Média do escore</td>
                        <td> <?= $data['consolidado']['sofa']['escore']['media'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Mediana do escore</td>
                        <td> <?= $data['consolidado']['sofa']['escore']['mediana'] ?> </td>
                        <td> - </td>
                    </tr>

                    <tr >
                        <td>Desvio padrão do escore</td>
                        <td> <?= $data['consolidado']['sofa']['escore']['desvio_padrao'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Pacientes com aumento maior/igual a dois pontos durante a internação</td>
                        <td><?= $data['consolidado']['sofa']['pacientes_aumento']['total'] ?></td>
                        <td><?= $data['consolidado']['sofa']['pacientes_aumento']['percentual'] ?></td>
                    </tr>
                </tbody>
            </table>
            <!-- Sofa END -->

            <!-- Curb START -->
            <table class="aileron_thin relatorio_geral" style="width:100%; border-collapse: collapse; page-break-after: always;">
                <thead>
                    <tr>
                        <th class="title th-left">Item</th>
                        <th class="title th-middle">Total</th>
                        <th class="title">%</th>
                    </tr>
                </thead>

                <tbody class="yolo">
                    <tr >
                        <td class="line-separator" style="font-weight: bold"  colspan=3 >  Curb 65  </td>
                    </tr>
                    <tr >
                        <td >Total de pacientes com escore preenchido</td>
                        <td> <?= $data['consolidado']['curb']['total_pacientes'] ?> </td>
                        <td> <?= number_format($data['consolidado']['curb']['percentual_pacientes'], 2) ?> </td>
                    </tr>
                    <tr >
                        <td>Média do escore</td>
                        <td> <?= $data['consolidado']['curb']['escore']['media'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Mediana do escore</td>
                        <td> <?= $data['consolidado']['curb']['escore']['mediana'] ?> </td>
                        <td> - </td>
                    </tr>

                    <tr >
                        <td>Desvio padrão do escore</td>
                        <td> <?= $data['consolidado']['curb']['escore']['desvio_padrao'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Total de pacientes com valor superior a 2</td>
                        <td> <?= $data['consolidado']['curb']['total_superior_2'] ?> </td>
                        <td> <?= number_format($data['consolidado']['curb']['percentual_superior_2'], 2) ?> </td>
                    </tr>
                    <tr >
                        <td>Total de pacientes com valor superior a 3</td>
                        <td> <?= $data['consolidado']['curb']['total_superior_3'] ?> </td>
                        <td> <?= number_format($data['consolidado']['curb']['percentual_superior_3'], 2) ?> </td>
                    </tr>
                    <tr >
                        <td>Total de pacientes com valor superior a 4</td>
                        <td> <?= $data['consolidado']['curb']['total_superior_4'] ?> </td>
                        <td> <?= number_format($data['consolidado']['curb']['percentual_superior_4'], 2) ?> </td>
                    </tr>
                </tbody>
            </table>
            <!-- Curb END -->


            <!-- Apache START -->
            <table class="aileron_thin relatorio_geral" style="width:100%; border-collapse: collapse;">
                <thead>
                    <tr>
                        <th class="title th-left">Item</th>
                        <th class="title th-middle">Total</th>
                        <th class="title">%</th>
                    </tr>
                </thead>

                <tbody class="yolo">
                    <tr >
                        <td class="line-separator" style="font-weight: bold" colspan=3>  APACHE II </td>
                    </tr>
                    <tr >
                        <td >Pacientes com escore preenchido</td>
                        <td> <?= $data['consolidado']['apache']['total_pacientes'] ?> </td>
                        <td> <?= number_format($data['consolidado']['apache']['percentual_pacientes'], 2) ?> </td>
                    </tr>
                    <tr >
                        <td>Mínimo do escore</td>
                        <td> <?= $data['consolidado']['apache']['minimo_score'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Máximo do escore</td>
                        <td> <?= $data['consolidado']['apache']['maximo_score'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Média do escore</td>
                        <td> <?= $data['consolidado']['apache']['escore']['media'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Mediana do escore</td>
                        <td> <?= $data['consolidado']['apache']['escore']['mediana'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Desvio padrão do escore</td>
                        <td> <?= $data['consolidado']['apache']['escore']['desvio_padrao'] ?> </td>
                        <td> - </td>
                    </tr>

                    <tr >
                        <td>Mínimo de previsão de óbito do escore e previsão para América Latina</td>
                        <td> <?= $data['consolidado']['apache']['taxa_letalidade_america_latina']['minimo'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Máximo de previsão de óbito do escore e previsão para América Latina</td>
                        <td> <?= $data['consolidado']['apache']['taxa_letalidade_america_latina']['maximo'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Média de previsão de óbito do escore e previsão para América Latina</td>
                        <td> <?= $data['consolidado']['apache']['taxa_letalidade_america_latina']['media'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Mediana de previsão de óbito do escore e previsão para América Latina</td>
                        <td> <?= $data['consolidado']['apache']['taxa_letalidade_america_latina']['mediana'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Desvio padrão de previsão de óbito do escore e previsão para América Latina</td>
                        <td> <?= $data['consolidado']['apache']['taxa_letalidade_america_latina']['desvio_padrao'] ?> </td>
                        <td> - </td>
                    </tr>

                    <tr >
                        <td>Taxa de letalidade padronizada para América Latina</td>
                        <td> - </td>
                        <td> <?= $data['consolidado']['apache']['taxa_letalidade_america_latina']['taxa'] ?> </td>
                    </tr>

                    <tr >
                        <td>Pacientes com valor superior a 40%</td>
                        <td> <?= $data['consolidado']['apache']['probabilidade_de_obito_acima_40']['total'] ?> </td>
                        <td> <?= $data['consolidado']['apache']['probabilidade_de_obito_acima_40']['percentual'] ?> </td>
                    </tr>
                </tbody>
            </table>
            <!-- Apache II END -->
            <br><br><br><br><br>
            <!-- Saps START -->
            <table class="aileron_thin relatorio_geral" style="width:100%; border-collapse: collapse;">
                <thead>
                    <tr>
                        <th class="title th-left">Item</th>
                        <th class="title th-middle">Total</th>
                        <th class="title">%</th>
                    </tr>
                </thead>

                <tbody class="yolo">
                    <tr >
                        <td class="line-separator" style="font-weight: bold" colspan=3>  SAPS III </td>
                    </tr>
                    <tr >
                        <td >Pacientes com escore preenchido</td>
                        <td> <?= $data['consolidado']['saps']['total_pacientes'] ?> </td>
                        <td> <?= number_format($data['consolidado']['saps']['percentual_pacientes'], 2) ?> </td>
                    </tr>
                    <tr >
                        <td>Mínimo do escore</td>
                        <td> <?= $data['consolidado']['saps']['minimo_score'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Máximo do escore</td>
                        <td> <?= $data['consolidado']['saps']['maximo_score'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Média do escore</td>
                        <td> <?= $data['consolidado']['saps']['escore']['media'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Mediana do escore</td>
                        <td> <?= $data['consolidado']['saps']['escore']['mediana'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Desvio padrão do escore</td>
                        <td> <?= $data['consolidado']['saps']['escore']['desvio_padrao'] ?> </td>
                        <td> - </td>
                    </tr>

                    <tr >
                        <td>Pacientes com valor superior a 40%</td>
                        <td> <?= $data['consolidado']['saps']['probabilidade_de_obito_acima_40']['total'] ?> </td>
                        <td> <?= $data['consolidado']['saps']['probabilidade_de_obito_acima_40']['percentual'] ?> </td>
                    </tr>
                </tbody>
            </table>
            <!-- Saps III END -->

            <!-- Nas START -->
            <table class="aileron_thin relatorio_geral" style="width:100%; border-collapse: collapse;">
                <thead>
                    <tr>
                        <th class="title th-left">Item</th>
                        <th class="title th-middle">Total</th>
                        <th class="title">%</th>
                    </tr>
                </thead>

                <tbody class="yolo">
                    <tr >
                        <td class="line-separator" style="font-weight: bold" colspan=3>  NAS </td>
                    </tr>
                    <tr >
                        <td >Pacientes com escore preenchido</td>
                        <td> <?= $data['consolidado']['nas']['total_pacientes'] ?> </td>
                        <td> <?= number_format($data['consolidado']['nas']['percentual_pacientes'], 2) ?> </td>
                    </tr>
                    <tr >
                        <td>Média do escore</td>
                        <td> <?= $data['consolidado']['nas']['escore']['media'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Mediana do escore</td>
                        <td> <?= $data['consolidado']['nas']['escore']['mediana'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Desvio padrão do escore</td>
                        <td> <?= $data['consolidado']['nas']['escore']['desvio_padrao'] ?> </td>
                        <td> - </td>
                    </tr>

                    <tr >
                        <td>Pacientes com valor superior a 25 pontos</td>
                        <td> <?= $data['consolidado']['nas']['pacientes_superior_25_pontos']['total'] ?> </td>
                        <td> <?= $data['consolidado']['nas']['pacientes_superior_25_pontos']['percentual'] ?> </td>
                    </tr>
                </tbody>
            </table>
            <!-- Nas END -->

            <!-- Crib Start -->
            <table class="aileron_thin relatorio_geral" style="width:100%; border-collapse: collapse;">
                <thead>
                    <tr>
                        <th class="title th-left">Item</th>
                        <th class="title th-middle">Total</th>
                        <th class="title">%</th>
                    </tr>
                </thead>

                <tbody class="yolo">
                    <tr >
                        <td class="line-separator" style="font-weight: bold"  colspan=3 >  CRIB  </td>
                    </tr>
                    <tr >
                        <td >Pacientes com escore preenchido</td>
                        <td> <?= $data['consolidado']['crib']['total_pacientes'] ?> </td>
                        <td> <?= number_format($data['consolidado']['crib']['percentual_pacientes'], 2) ?> </td>
                    </tr>
                    <tr >
                        <td>Média do escore</td>
                        <td> <?= $data['consolidado']['crib']['escore']['media'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Mediana do escore</td>
                        <td> <?= $data['consolidado']['crib']['escore']['mediana'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Desvio padrão do escore</td>
                        <td> <?= $data['consolidado']['crib']['escore']['desvio_padrao'] ?> </td>
                        <td> - </td>
                    </tr>

                    <tr >
                        <td>Mínimo de previsão de obito do escore</td>
                        <td> <?= $data['consolidado']['crib']['taxa_letalidade']['minimo'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Máximo de previsão de obito do escore</td>
                        <td> <?=$data['consolidado']['crib']['taxa_letalidade']['maximo'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Média de previsão de obito do escore</td>
                        <td> <?= $data['consolidado']['crib']['taxa_letalidade']['media'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Mediana de previsão de obito do escore</td>
                        <td> <?= $data['consolidado']['crib']['taxa_letalidade']['mediana'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Desvio padrão de previsão de obito do escore</td>
                        <td> <?= $data['consolidado']['crib']['taxa_letalidade']['desvio_padrao'] ?> </td>
                        <td> - </td>
                    </tr>

                    <tr >
                        <td>Taxa de letalidade</td>
                        <td> - </td>
                        <td> <?= $data['consolidado']['crib']['taxa_letalidade']['taxa'] ?> </td>
                    </tr>

                    <tr >
                        <td>Total de pacientes com valor superior a 40%</td>
                        <td> <?= $data['consolidado']['crib']['probabilidade_de_obito_acima_40']['total'] ?> </td>
                        <td> <?= $data['consolidado']['crib']['probabilidade_de_obito_acima_40']['percentual'] ?> </td>
                    </tr>
                </tbody>
            </table>
            <!-- Crib END -->

            <!-- SNAP II Start -->
            <table class="aileron_thin relatorio_geral" style="width:100%; border-collapse: collapse;">
                <thead>

                    <tr>
                        <th class="title th-left">Item</th>
                        <th class="title th-middle">Total</th>
                        <th class="title">%</th>
                    </tr>
                </thead>

                <tbody class="yolo">
                    <tr >
                        <td class="line-separator" style="font-weight: bold"  colspan=3 >  SNAP II  </td>
                    </tr>
                    <tr >
                        <td >Pacientes com escore preenchido</td>
                        <td> <?= $data['consolidado']['snap']['total_pacientes'] ?> </td>
                        <td> <?= number_format($data['consolidado']['snap']['percentual_pacientes'], 2) ?> </td>
                    </tr>

                    <tr >
                        <td>Média do escore</td>
                        <td> <?= $data['consolidado']['snap']['escore']['media'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Mediana do escore</td>
                        <td> <?= $data['consolidado']['snap']['escore']['mediana'] ?> </td>
                        <td> - </td>
                    </tr>

                    <tr >
                        <td>Desvio padrão do escore</td>
                        <td> <?= $data['consolidado']['snap']['escore']['desvio_padrao'] ?> </td>
                        <td> - </td>
                    </tr>

                    <tr >
                        <td>Mínimo de previsão de obito do escore</td>
                        <td> <?= $data['consolidado']['snap']['taxa_letalidade']['minimo'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Máximo de previsão de obito do escore</td>
                        <td> <?=$data['consolidado']['snap']['taxa_letalidade']['maximo'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Média de previsão de obito do escore</td>
                        <td> <?= $data['consolidado']['snap']['taxa_letalidade']['media'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Mediana de previsão de obito do escore</td>
                        <td> <?= $data['consolidado']['snap']['taxa_letalidade']['mediana'] ?> </td>
                        <td> - </td>
                    </tr>
                    <tr >
                        <td>Desvio padrão de previsão de obito do escore</td>
                        <td> <?= $data['consolidado']['snap']['taxa_letalidade']['desvio_padrao'] ?> </td>
                        <td> - </td>
                    </tr>

                    <tr >
                        <td>Taxa de letalidade</td>
                        <td> - </td>
                        <td> <?= $data['consolidado']['snap']['taxa_letalidade']['taxa'] ?> </td>
                    </tr>

                    <tr >
                        <td>Total de pacientes com valor superior a 70 pontos ou previsão de óbito superior a 40%</td>
                        <td> <?= $data['consolidado']['snap']['probabilidade_de_obito_acima_40']['total'] ?> </td>
                        <td> <?= $data['consolidado']['snap']['probabilidade_de_obito_acima_40']['percentual'] ?> </td>
                    </tr>
                </tbody>
            </table>
            <!-- SNAPII END -->
        </div>
    </body>
</html>