<?php
use Cake\Routing\Router;

/**
* R -> Realizado
* i -> Indicador
* m -> Meta
**/

if ( isset($unit_logo) ) 
{
	$url_image = WWW_ROOT . 'img/uploads/' . $unit_logo ;
}
else {
	$url_image = WWW_ROOT . 'img/default.png';
}

$converted_data = [
    'taxa_internacoes' => [
        'r' => '',
        'm' => '',
        'd' => '',
    ],
    'total_de_internacoes' => [
        'r' => '',
        'm' => '',
        'd' => '',
    ],
    'taxa_de_reinternacao' => [
        'r' => '',
        'm' => '',
        'd' => '',
    ],
    'taxa_ocupacao' => [
        'r' => '',
        'm' => '',
        'd' => '',
    ],
    'taxa_desocupacao' => [
        'r' => '',
        'm' => '',
        'd' => '',
    ],

    'tempo_medio_permanencia' => [
        'r' => '',
        'm' => '',
        'd' => '',
    ],

    'indice_de_giro_de_leito' => [
        'r' => '',
        'm' => '',
        'd' => '',
    ],

    'densidade_cateter_vesical' => [
        'r' => '',
        'm' => '',
        'd' => '',
    ],

    'densidade_cateter_vascular' => [
        'r' => '',
        'm' => '',
        'd' => '',
    ],

    'intervalo_de_substituicao' => [
        'r' => '',
        'm' => '',
        'd' => '',
    ],

    'faixa_de_internacao_menor_que_24h' => [
        'r' => '',
        'm' => '',
        'd' => '',
    ],

    'taxa_mortalidade' => [
        'r' => '',
        'm' => '',
        'd' => '',
    ],

    'taxa_cesariana' => [
        'r' => '',
        'm' => '',
        'd' => '',
    ],

];

foreach ($data['dates'] as $key => $month)
{
    foreach ($converted_data as $indicator_key => $indicator)
    {
        $cicle_color = "circle_green";

        //verifica se o indicador existe
        if (isset($data['dates'][$key][$indicator_key]) && 
        	isset($converted_data[$indicator_key]['r']))
        {
            $meta = 0.0;
            if ($data['unit']['indicators_unit'][$indicator_key])
            {
                $meta = $data['unit']['indicators_unit'][$indicator_key];
            }

            //verifica se atingiu a meta do indicador
            if ((float) $data['dates'][$key][$indicator_key] < (float) $meta)
            {
                $cicle_color = "circle_red";
            }

            $is_saved =false;

            foreach ($data['dates'][$key]['indicators'] as $saved_indicator) {
            	if ($saved_indicator['indicator_name'] == $indicator_key) {
            		$is_saved = true;
            	}
            }

            $converted_data[$indicator_key]['r'] .= '<td class="indicador_observacao menu_links" data-indicator-name="' . $indicator_key . '"';
            if ($is_saved)
            {
            	$converted_data[$indicator_key]['r'] .= 'style="font-weight:600"';
            }
            $converted_data[$indicator_key]['r'] .= 'data-indicator-fulldate="' . $data['dates'][$key]['full_date']->format('Y-m-d') . '"'; 
            $converted_data[$indicator_key]['r'] .= 'data-indicator-month="' . $data['dates'][$key]['full_date']->format('m') . '"';            
            $converted_data[$indicator_key]['r'] .=  'data-indicator-year="' . $data['dates'][$key]['full_date']->format('Y') . '">' . $data['dates'][$key][$indicator_key] . '</td>';	
            
            
            
            $converted_data[$indicator_key]['m'] .= '<td>' . $meta . '</td>';
            $converted_data[$indicator_key]['d'] .= '<td class="' . $cicle_color . '"><div></div></td>';
        }
        else
        {
            $converted_data[$indicator_key]['r'] .= '<td>0</td>';
            $converted_data[$indicator_key]['m'] .= '<td>0</td>';
            $converted_data[$indicator_key]['d'] .= '<td class="circle_green"><div></div></td>';
        }
    }
}
?>



<style type="text/css">
	td, th {
		text-align: center;
	}

	tr td:first-child {
		text-align: left;
	}

	.circle_red div {
		margin: 0 auto;
		width: 16px;
		height: 16px;
		border-radius: 50%;
		background: #eb1b23
	}

	.circle_green div {
		margin: 0 auto;
		width: 16px;
		height: 16px;
		border-radius: 50%;
		background: #339933
	}
</style>

<!DOCTYPE html>
<html>

<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
	<?=$this->Html->css('pdf', ['fullBase' => true]);?>
	<?=$this->fetch('css')?>
</head>

<body>

	<div class="logo">
		<div style="float: left" >			
			<?php 
				if ( isset($unit_logo) && !isset($default_logo) ) 
				{		
					echo $this->Html->image('uploads/'. $unit_logo, array('alt' => 'GH', 'border' => '0', 'style' => 'float: left; margin-left: 14%;'));
				}
				else 
				{
					echo $this->Html->image('uploads/default.png', array('alt' => 'GH', 'border' => '0', 'style' => 'float: left; margin-left: 14%;'));

				}
			?>
		</div>
		<div style="float: right; text-align: right">
			<span style="text-align: center" class='title-dark f-size-32 underline_text'> 
				Relatório de Indicadores da Terapia Intensiva
			</span>

			<p style="text-align: right; font-size: 0.8em; line-height: 20px;" class='title f-size-32 underline_text'> 
				Período de análise: <?= $date_before->format("d/m/Y") ?>  a <?= $date_after->format("d/m/Y") ?> 
			</p>
		</div>
	</div>

	<div class="tabbable-panel">            
        <div class="tabbable-line">	                
            <ul class="nav nav-tabs " >
                <li >
                    <a href='<?=$this->Url->build(["action" => "indicadores-unidade"])?>'>
                    Indicadores da Unidade
                    </a>
                </li>
                <li class="active">
                    <a href="#tab_default_5" data-toggle="tab">
                    Setor de Terapia Intensiva
                    </a>
                </li>
                <!-- <li>
                   <a >
                   Meta de Indicadores do Setor Emergência
                    </a>
                </li> -->
                <li >
	                <a href='<?=$this->Url->build(["action" => "indicadores-unidade-internacao"])?>'>
	                Setor Unidade de Internação
	                </a>
	            </li>
                <li>
                    <a href='<?=$this->Url->build(["action" => "indicadores-centro-cirurgico"])?>'>
                    Centro Cirúrgico
                    </a>
                </li>
                <!-- <li>
                    <a href="#tab_default_8" data-toggle="tab">
                   	Meta de Indicadores dos Protocolos
                    </a>
                </li>
                <li>
                    <a href="#tab_default_8" data-toggle="tab">
                   	Meta de Indicadores da CCIH
                    </a>
                </li>
                <li>
                    <a href="#tab_default_8" data-toggle="tab">
                   	Meta de Indicadores da SIHDOT
                    </a>
                </li>
                <li>
                    <a href="#tab_default_8" data-toggle="tab">
                   	Meta de Indicadores da Enfermagem
                    </a>
                </li>
                <li>
                    <a href="#tab_default_8" data-toggle="tab">
                   	Meta de Indicadores da Fisioterapia
                    </a>
                </li>
                <li>
                    <a href="#tab_default_8" data-toggle="tab">
                   	Meta de Indicadores da Farmácia

                    </a>
                </li> -->
            </ul>
        </div>
    </div>

	<div class="container">		                		                    
    	<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
			<thead>
				<tr>
					 <th class="title  th-left">Tema / Objetivo / Indicador</th>
					 <th  class="title  th-left indicadores">Info&nbsp;</th>

					 <?php foreach ($data['dates'] as $key => $month): ?>
						 <th class="title th-spread"> <?=$month_name[$key];?>  </th>
					 <?php endforeach;?>
			  </tr>
			</thead>
			<tbody>								
	            <tr>
					<td rowspan="3">
						Total de Internações
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['total_de_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['total_de_internacoes']['m']?>
				</tr>
				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['total_de_internacoes']['d']?>
				</tr>
				
				<tr>
					<td rowspan="3">
						Taxa de Ocupação
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_ocupacao']['r']?>
				</tr>
				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_ocupacao']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Índice de Giro de Leito
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['indice_de_giro_de_leito']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['indice_de_giro_de_leito']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['indice_de_giro_de_leito']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Intervalo de Substituição
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['intervalo_de_substituicao']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['intervalo_de_substituicao']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['intervalo_de_substituicao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Tempo Médio de Permanência
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['tempo_medio_permanencia']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['tempo_medio_permanencia']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['tempo_medio_permanencia']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Taxa de Reinternação
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_de_reinternacao']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_de_reinternacao']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_de_reinternacao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Taxa de Reinternação em < 24 horas
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['faixa_de_internacao_menor_que_24h']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['faixa_de_internacao_menor_que_24h']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['faixa_de_internacao_menor_que_24h']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Taxa de Saída Hospitalar
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_internacoes']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Taxa de Mortalidade em pacientes cirúrgicos
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_mortalidade']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_mortalidade']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_mortalidade']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Taxa de Letalidade Padronizada
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_internacoes']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>
											

				<span style="page-break-after: always;"></span>

				<tr>
					<td rowspan="3">
						Taxa de Infecção de Corrente Sanguínea por Cateter Vascular
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_internacoes']['m']?>
				</tr>

				<tr>
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Densidade de Uso de Cateter Vascular
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['densidade_cateter_vascular']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['densidade_cateter_vascular']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['densidade_cateter_vascular']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Taxa de Infecção de Trato Urinário por Cateter Vesical
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_internacoes']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Densidade de Uso de Cateter Vesical
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['densidade_cateter_vesical']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['densidade_cateter_vesical']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['densidade_cateter_vesical']['d']?>
				</tr>

				<tr>
					<td rowspan="3">
						Taxa de Pneumonia Associada a Ventilação Mecânica
					</td>
					<td class="indicadores" >R</td>
					<?=$converted_data['taxa_internacoes']['r']?>
				</tr>

				<tr>
					<td class="indicadores">M</td>
					<?=$converted_data['taxa_internacoes']['m']?>
				</tr>

				<tr >
					<td class="indicadores">D</td>
					<?=$converted_data['taxa_ocupacao']['d']?>
				</tr>								
			</tbody>
		</table>		
	</div>


	<!-- Modal -->
	<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
	  <div class="modal-dialog" role="document">
	    <div class="modal-content">
	      <div class="modal-header">

	        <h4 class="modal-title" id="exampleModalLabel"> 
	        	Indicador: <span id="indicator-name"></span> 
	        </h4>
	        <h5 class="modal-title"> <!-- Data: --> <span id="indicator-fulldate"></span>
	        </h5>

	        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
	          <span aria-hidden="true">&times;</span>
	        </button>

	      </div>
	      <div class="modal-body">
	      	<div class="form-group">
			  <label for="comment">Observação:</label>
			  <textarea required="required" maxlength="500" class="form-control" rows="7" id="indicator-observation"></textarea>
			</div>
	      </div>
	      <div class="modal-footer">
	        <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
	        <button type="button" class="btn btn-primary" id="save-indicator">Salvar</button>
	      </div>
	    </div>
	  </div>
	</div>
</body>
	<script>
		function getIndicatorname(indicator_name) {
			switch(indicator_name) {
			    case 'taxa_internacoes':
			        return 'Taxa de internações'
			        break;
			    case 'taxa_cesariana':
			        return 'Taxa de cesarianas'
			        break;
			    case 'taxa_mortalidade':
			        return 'Taxa de mortalidade'
			        break;
			    case 'faixa_de_internacao_menor_que_24h':
			        return 'Faixa de internação menor que 24h'
			        break;
			    case 'intervalo_de_substituicao':
			        return 'Intervalo de substituição'
			        break;
			    case 'densidade_cateter_vascular':
			        return 'Densidade de cateter vascular'
			        break;
			    case 'densidade_cateter_vesical':
			        return 'Densidade de cateter vesical'
			        break;
			    case 'indice_de_giro_de_leito':
			        return 'Índice de giro de leito'
			        break;
			    case 'tempo_medio_permanencia':
			        return 'Tempo médio de permanência'
			        break;
			    case 'taxa_desocupacao':
			        return 'Taxa de desocupação'
			        break;
				case 'taxa_ocupacao':
			        return 'Taxa de ocupação'
			        break;	
			    case 'taxa_de_reinternacao':
			        return 'Taxa de reinternação'
			        break;	
			    case 'total_de_internacoes':
			        return 'Taxa de internações'
			        break;	

			    case 'Taxa de internações':
			        return 'taxa_internacoes'
			        break;
			    case 'Taxa de cesarianas':
			        return 'taxa_cesariana'
			        break;
			    case 'taxa_mortalidade':
			        return 'Taxa de mortalidade'
			        break;
			    case 'Faixa de internação menor que 24h':
			        return 'faixa_de_internacao_menor_que_24h'
			        break;
			    case 'Intervalo de substituição':
			        return 'intervalo_de_substituicao'
			        break;
			    case 'Densidade de cateter vascular':
			        return 'densidade_cateter_vascular'
			        break;
			    case 'Densidade de cateter vesical':
			        return 'densidade_cateter_vesical'
			        break;
			    case 'Índice de giro de leito':
			        return 'indice_de_giro_de_leito'
			        break;
			    case 'Tempo médio de permanência':
			        return 'tempo_medio_permanencia'
			        break;
			    case 'Taxa de desocupação':
			        return 'taxa_desocupacao'
			        break;
				case 'Taxa de ocupação':
			        return 'taxa_ocupacao'
			        break;	
			    case 'Taxa de reinternação':
			        return 'taxa_de_reinternacao'
			        break;	
			    case 'Taxa de internações':
			        return 'total_de_internacoes'
			        break;			     
			}
		}

		function showIndicatorModal(indicator_name, indicator_fulldate) {
			console.log("showIndicatorModal INIT");

			//inicia as variaveis
			const url = "<?= Router::url(['controller' => 'Relatorios', 'action' => 'getHospitalIndicator']); ?>";
			const indicator_month =   moment(indicator_fulldate).format('MM');						
			const indicator_year = moment(indicator_fulldate).format('YYYY');
			const indicator_fulldate_formatted = moment(indicator_fulldate).format('MMMM YYYY');
			// console.log("indicator_month = " + indicator_month);
			// console.log("indicator_year = " + indicator_year);			

			//abre o modal
			$('#exampleModal').modal({
			  	focus: true,
			  	backdrop: true
			});

			//reseta os campos
			$("#indicator-observation").val("");
			$("#indicator-fulldate").text(indicator_fulldate_formatted);
			$("#indicator-name").text( getIndicatorname(indicator_name) );	

			
			
			const data_send = {
				indicator_name: indicator_name,
				year: indicator_year,
				month: indicator_month,
			};
			//console.log(data_send);

			//faz a chamada no servidor
			$.ajax({
		        url: url,
		        data: data_send,
		        dataType: 'json',
		        async: false,
		        statusCode: {
		            200: (data) => {
		            	console.log("sucesso get 1");
		                console.log(data);
	                	$("#indicator-observation").val(data.observation);
	                	$("#indicator-name").text( getIndicatorname(data.indicator_name) );
	                	return true;			
		            } // Ok

		            ,400: (msg) => {
		                console.log("log1");
		                console.log(msg);
		            } // Bad Request

		            ,404: (msg) => {
		                console.log("log2");
		                console.log(msg);
		            } // Not Found
		        }
		    });		
		    return false;
		}

		//salva
		$("#save-indicator").click( () => {			
			$('#exampleModal').modal('toggle');

			const indicator_fulldate = moment( $("#indicator-fulldate").text(), "MMMM YYYY" );
			const indicator_name = getIndicatorname( $("#indicator-name").text() );
			const indicator_month = indicator_fulldate.format('MM');
			const indicator_year = indicator_fulldate.format('YYYY');
			const url = "<?= Router::url(['controller' => 'Relatorios', 'action' => 'setHospitalIndicator']); ?>";
			//console.log("full date  = " + indicator_fulldate.format("DD/MM/YYYY"));			
			const data = {
				observation: $("#indicator-observation").val(),
				month:  indicator_month,
				year: indicator_year,
				indicator_name: indicator_name,
			};

			$.ajax({
		        url: url,
		        data: data,
		        dataType: 'json',
		        async:false,
		        statusCode: {
		            200: (data) => {
		            	console.log("sucesso send");
		                console.log(data);		                
		            } // Ok

		            ,400: (msg) => {
		                console.log("log1");
		                console.log(msg);
		             } // Bad Request

		            ,404: (msg) => {
		                console.log("log2");
		                console.log(msg);
		             } // Not Found
		        }
		    });
		});

		setTimeout( () => {
			$('.indicador_observacao').click(  function() {				
				const indicator_name = $(this).data("indicator-name");
				const indicator_fulldate = $(this).data("indicator-fulldate");
				const indicator_year = $(this).data("indicator-year");
				const indicator_month = $(this).data("indicator-month");
				
			  	if (showIndicatorModal(indicator_name, indicator_fulldate)) {
			  		$(this).css('font-weight', 600);
			  		console.log("yoo");
			  	}
			  	
			});
		}, 1000);
		
	</script>

	<style >
		.container:before {
			content: none !important;
		}
		
		@media print and (color) { * { -webkit-print-color-adjust: exact; print-color-adjust: exact; } }
	</style>
</html>