<!DOCTYPE html>
<html>
<head>	
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>	
	<?=  $this->Html->css('pdf', ['fullBase' => true]); ?>
	<?= $this->fetch('css') ?>
</head>
<body>
	<?= $this->element( 'header-logo', ['report_title'=>'Relatório de Parecer Médico'] ); ?> 

	<div class="container">			
		<table class="aileron_thin" style="width:100%;   border-collapse: collapse;" >
			<thead>
				<tr>
					 <th class="title th-left">Item</th>
					 <th class="title th-middle" style="margin-left:100px;" >VA</th>
					 <th class="title th-right"> % </th>
	 
				</tr>
			</thead>						
			<tbody>
				<tr>
					<td >Total de pareceres solicitados</td>
					<td> <?=$data['total_de_registros']?> </td>
					<td> - </td>
				</tr>

				<tr>
					<td>Total de pareceres solicitados por internação</td>
					<td> <?=$data['total_de_registros']?> </td>
					<td> - </td>
				</tr>

				<tr>
					<td >Total de pareceres solicitados por dia</td>
					<td> <?=$data['total_de_registros']?> </td>
					<td> - </td>
				</tr>

				<tr>
					<td >Pareceres solicitados não respondidos</td>
					<td>0</td>
					<td> 0 %</td>
				</tr>
			</tbody>
		</table>

		<h3 class="title-dark t-center sub-size"> Pareceres solicitados não respondidos por setor </h3>
		<table class="aileron_thin" style="width:100%;   border-collapse: collapse;" >
			<thead>
				<!-- <tr >                    
                    <th class="title-dark" colspan="2">Pareceres solicitados não respondidos por setor</th>
                </tr> -->
				<tr>
					 <th class="title th-left">Setor</th>
					 <th class="title th-middle">VA</th>	 
				</tr>
			</thead>
				
		
			<tbody>
				<?php foreach ($data['tab_parecer_setor'] as $value): ?>
					<tr>
						<td ><?=$value['name']?></td>
						<td> <?=$value['total']?> </td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>

		<h3 class="title-dark t-center sub-size" >Pareceres solicitados não respondidos por especialidade de destino</h3>
		<table class="aileron_thin break" style="width:100%;   border-collapse: collapse;" >
			<thead>
				<tr>
					 <th class="title th-left">Setor</th>
					 <th class="title th-middle" >VA</th>	 
				</tr>
			</thead>
				
		
			<tbody>
				<?php foreach ($data['tab_especialidade_destino'] as $value): ?>
					<tr>
						<td ><?=$value['name']?></td>
						<td> <?=$value['total']?> </td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>

		<h3 class="title-dark t-center sub-size" >Pareceres solicitados por setor</h3>
		<table class="aileron_thin" style="width:100%;   border-collapse: collapse;" >
			<thead>
		<!-- 		<tr>
					<th colspan="2">Pareceres solicitados por setor</th>	
				</tr> -->
			
				<tr>
					 <th class="title th-left">Setor</th>
					 <th class="title th-right">VA</th>	 
				</tr>
			</thead>
				
		
			<tbody>
				<?php foreach ($data['tab_parecer_setor'] as $value): ?>
					<tr>
						<td ><?=$value['name']?></td>
						<td> <?=$value['total']?> </td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>

		<h3 class="title-dark t-center sub-size" >Pareceres solicitados não respondidos por setor</h3>
		<table class="aileron_thin" style="width:100%;   border-collapse: collapse;" >
			<thead>
			<!-- 	<tr>
					<th colspan="2">Pareceres solicitados não respondidos por setor</th>	
				</tr> -->
				<tr>
					 <th class="title th-left">Especialidade</th>
					 <th class="title th-right">VA</th>	 
				</tr>
			</thead>
				
		
			<tbody>
				<?php foreach ($data['tab_especialidade_destino'] as $value): ?>
					<tr>
						<td ><?=$value['name']?></td>
						<td> <?=$value['total']?> </td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>

		<h3 class="title-dark t-center sub-size" >Tempo de resposta do parecer</h3>
		<table class="aileron_thin yolo" style="width:100%;   border-collapse: collapse;" >
			<thead>
				<!-- <tr>
					<th colspan="3">Tempo de resposta do parecer</th>	
				</tr> -->
				<tr>
					 <th class="title th-left">Item</th>
					 <th class="title th-middle" style="margin-left:100px;" >VA</th>	 
					 <th class="title th-right" >Desvio padrão</th>	 
				</tr>
			</thead>						
			<tbody>
				<tr>
					<td >Tempo mínimo</td>
					<td> 0 </td>
					<td> 0 </td>
				</tr>
				<tr>
					<td >Tempo médio</td>
					<td> 0 </td>
					<td> 0 </td>
				</tr>
				<tr>
					<td >Tempo máximo</td>
					<td> 0 </td>
					<td> 0 </td>
				</tr>
			</tbody>
		</table>

		<h3 class="title-dark t-center sub-size" >Tempo de resposta do parecer por setor solicitante</h3>
		<table class="aileron_thin" style="width:100%;   border-collapse: collapse;" >
			<thead>
				<!-- <tr>
					<th colspan="3">Tempo de resposta do parecer por setor solicitante</th>	
				</tr> -->
				<tr>
					 <th class="title th-left">Item</th>
					 <th class="title th-middle" style="margin-left:100px;" >VA</th>	 
					 <th class="title th-right">Desvio padrão</th>	 
				</tr>
			</thead>
				
		
			<tbody>
				<?php foreach ($data['tab_parecer_setor'] as $value): ?>
					<tr >
	                    <td class="line-separator title" style="font-weight: bold" colspan=3> <?= $value['name'] ?></td>
	                </tr>
					<tr>
						<td >Tempo mínimo</td>
						<td> 0 </td>
						<td> 0 </td>
					</tr>
					<tr>
						<td >Tempo médio</td>
						<td> 0 </td>
						<td> 0 </td>
					</tr>
					<tr>
						<td >Tempo máximo</td>
						<td> 0 </td>
						<td> 0 </td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>

		<h3 class="title-dark t-center sub-size" >Tempo de resposta do parecer por especialidade</h3>
		<table class="aileron_thin" style="width:100%;   border-collapse: collapse;" >
			<thead>
				<!-- <tr>
					<th colspan="3">Tempo de resposta do parecer por especialidade</th>	
				</tr> -->
				<tr>
					 <th class="title th-left">Item</th>
					 <th class="title th-middle" style="margin-left:100px;" >VA</th>	 
					 <th class="title th-right" >Desvio padrão</th>	 
				</tr>
			</thead>
				
		
			<tbody>
				<?php foreach ($data['tab_especialidade_destino'] as $value): ?>
					<tr >
	                    <td class="line-separator title" style="font-weight: bold" colspan=3> <?= $value['name'] ?></td>
	                </tr>
					<tr>
						<td >Tempo mínimo</td>
						<td> 0 </td>
						<td> 0 </td>
					</tr>
					<tr>
						<td >Tempo médio</td>
						<td> 0 </td>
						<td> 0 </td>
					</tr>
					<tr>
						<td >Tempo máximo</td>
						<td> 0 </td>
						<td> 0 </td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>

	</div> 
</body>
</html>

<style type="text/css">
	table {
		margin-bottom: 100px
	}
</style>	