<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <?=$this->Html->css('pdf', ['fullBase' => true]);?>
    <?=$this->fetch('css')?>
</head>
<body>
    <?= $this->element( 'header-logo', ['report_title'=>'Relatório de Farmácia'] ); ?>
    <div class="container">
        <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
            <thead>
                <tr>
                     <th class="title  th-left">Item</th>
                     <th class="title th-middle">Valor</th>
                     <th class="title th-middle">%</th>
              </tr>
            </thead>                 
            <tbody>
                <tr>
                    <td >Sinalização de interação medicamentosa</td>
                    <td> <?=$data['tipo_medicacao']['interacao_medicamentosa']['total']?> </td>
                    <td> <?=$data['tipo_medicacao']['interacao_medicamentosa']['percentual']?>% </td>
                </tr>

                <tr>
                    <td >Média de interação medicamentosa por prescrição com interação medicamentosa</td>
                    <td> <?=$data['tipo_medicacao']['interacao_medicamentosa']['media_total_interacao_por_prescricao_interacao_medicamentosa']?> </td>
                    <td> - </td>
                </tr>

                <tr>
                    <td >Média de interação medicamentosa por prescrição</td>
                    <td> <?=$data['tipo_medicacao']['interacao_medicamentosa']['media_total_interacao_por_prescricao']?> </td>
                    <td> - </td>
                </tr>

            
                <tr>
                    <td >Total de sinalizações de medicações de alta vigilância </td>
                    <td> <?=$data['tipo_medicacao']['alta_vigilancia']['total']?> </td>
                    <td> <?=$data['tipo_medicacao']['alta_vigilancia']['percentual']?>% </td>
                </tr>
                    
                <tr>
                    <td >Total de medicações de alta vigilância por prescrição com alta vigilância</td>
                     <td> <?=$data['tipo_medicacao']['alta_vigilancia']['media_medicacoes_por_prescricao_com_alta_vigilancia']?> </td>
                    <td> - </td>
                </tr>

                <tr>
                    <td >Total de medicações de alta vigilância por prescrição </td>
                     <td> <?=$data['tipo_medicacao']['alta_vigilancia']['media_medicacoes_por_prescricao']?> </td>
                    <td> - </td>
                </tr>

                 <tr>
                    <td >Total de medicações de alta vigilância por paciente</td>
                     <td> <?=$data['tipo_medicacao']['alta_vigilancia']['media_pacientes_com_alta_vigilancia']?> </td>
                    <td> - </td>
                </tr>

                 <tr>
                    <td >Total de sinalizações de medicação com baixo estoque</td>
                    <td> <?=$data['tipo_medicacao']['baixo_estoque']['total']?> </td>
                    <td> <?=$data['tipo_medicacao']['baixo_estoque']['percen_total_por_prescricao_baix_esto']?>% </td>
                </tr> 

                <tr>
                    <td >Total de medicações com baixo estoque por prescrições com baixo estoque</td>
                    <td> <?=$data['tipo_medicacao']['baixo_estoque']['media_medicacoes_prescricao_com_baixo_estoque']?> </td>
                    <td> - </td>
                </tr>

                <tr>
                    <td >Total de medicações com baixo estoque por prescrições</td>
                    <td> <?=$data['tipo_medicacao']['baixo_estoque']['media_medicacoes_prescricao']?> </td>
                    <td> - </td>
                </tr>

                <tr>
                    <td >Total de medicação com baixo estoque por paciente</td>
                    <td> <?=$data['tipo_medicacao']['baixo_estoque']['media_medicacao_por_paciente'] ?> </td>
                    <td> - </td>
                </tr>

                

                <tr>
                    <td >Total de sinalização de medicação com estoque zerado</td>
                    <td> <?=$data['tipo_medicacao']['estoque_zerado']['total']?> </td>
                    <td> <?=$data['tipo_medicacao']['estoque_zerado']['percentual']?>% </td>
                </tr>

                <tr>
                    <td >Total de medicação com estoque zerado por prescrição com estoque zerado</td>
                    <td> <?=$data['tipo_medicacao']['estoque_zerado']['media_medicacoes_prescricao_com_estoque_zerado']?> </td>
                    <td> - </td>
                </tr>

                <tr>
                    <td >Total de medicação com estoque zerado por prescrição</td>
                    <td> <?=$data['tipo_medicacao']['estoque_zerado']['media_medicacoes_prescricao']?> </td>
                    <td> - </td>
                </tr>

                <tr>
                    <td >Total de medicação com estoque zerado por paciente</td>
                    <td> <?=$data['tipo_medicacao']['estoque_zerado']['media_medicacao_por_paciente']?> </td>
                    <td> - </td>
                </tr>

                <tr>
                    <td> Total medicações com sinalizações não padronizadas </td>
                    <td> <?=$data['tipo_medicacao']['nao_padronizada']['total']?> </td>
                    <td> <?=$data['tipo_medicacao']['nao_padronizada']['percentual']?>% </td>
                </tr>

                <tr>
                    <td> Total medicações com sinalizações não padronizadas por prescrição</td>
                    <td> <?=$data['tipo_medicacao']['nao_padronizada']['media_medicacoes_prescricao']?> </td>
                    <td> <?=$data['tipo_medicacao']['nao_padronizada']['percen_total_por_prescricao']?>% </td>
                </tr>

                <tr>
                    <td> Total de medicação com não padronizadas dispensadas por medicações prescritas dispensadas  </td>
                    <td> <?=$data['tipo_medicacao']['nao_padronizada']['media_medic_n_padro_por_med_prescritas']?> </td>
                    <td> <?=$data['tipo_medicacao']['nao_padronizada']['percen_medic_n_padro_por_med_prescritas']?>% </td>
                </tr>

                <tr>
                    <td> Total de medicações dispensadas no período</td>
                    <td> <?=$data['total_medicacoes']?> </td>
                    <td>-</td>
                </tr>

                <tr>
                     <td colspan="7" class="title" style="font-weight: bold" >Total de medicações dispensadas por setor</td>
                </tr>

                <?php foreach($data['setores'] as $setor) : ?>
                    <tr class="tr-indent">
                        <td>&#8226; <?= $setor['name'] ?> </td>
                        <td> <?= $setor['total_medicacoes'] ?> </td>
                        <td> <?= $setor['percen_medicacoes'] ?>% </td>
                    </tr>
                <?php endforeach ?>

                <tr>
                     <td colspan="7" class="title" style="font-weight: bold" >Total de medicações dispensadas por turno</td>
                </tr>

                <tr class="tr-indent">
                    <td>&#8226; Madrugada</td>
                    <td><?=$data['medicacoes_dispensadas']['tot_madrugada']?></td>
                    <td><?=$data['medicacoes_dispensadas']['percen_madrugada']?>%</td>
                </tr>
                
                <tr class="tr-indent">                
                    <td>&#8226; Manhã</td>
                    <td><?=$data['medicacoes_dispensadas']['tot_manha']?></td>
                    <td><?=$data['medicacoes_dispensadas']['percen_manha']?>%</td>
                </tr>

                <tr class="tr-indent">   
                    <td>&#8226; Tarde</td>
                    <td><?=$data['medicacoes_dispensadas']['tot_tarde']?></td>
                    <td><?=$data['medicacoes_dispensadas']['percen_tarde']?>%</td>
                </tr>
                <tr class="tr-indent">   
                    <td>&#8226; Noite</td>
                    <td><?=$data['medicacoes_dispensadas']['tot_noite']?></td>
                    <td><?=$data['medicacoes_dispensadas']['percen_noite']?>%</td>
                </tr>

                <tr>
                    <td> Total de medicações dispensadas por prescrição </td>
                    <td> <?=$data['media_medicacao_por_prescricao']?> </td>
                    <td>-</td>
                </tr>


                <tr>
                     <td colspan="7" class="title" style="font-weight: bold" >Total de medicações dispensadas por prescrição  por setor</td>
                </tr>

                <?php foreach($data['setores'] as $setor) : ?>
                    <tr class="tr-indent">
                        <td>&#8226; <?= $setor['name'] ?> </td>
                        <td> <?= $setor['media_medicacao_por_prescricao'] ?> </td>
                        <td> - </td>
                    </tr>
                <?php endforeach ?>

            </tbody>


        </table>


    </div>
</body>
</html>