<?php
	$queixa_principal       = ['alteracao_estado_mental' => 'Alteração de estado mental', 'dispneia' => 'Dispneia', 'hiperglicemia' => 'Hiperglicemia', 'alt_sinais_vitais' => 'Alt. sinais vitais isolados', 'tosse' => 'Tosse', 'lesoes_de_pele' => 'Lesões de pele', 'dor' => 'Dor', 'febre' => 'Febre', 'hipoglicemia' => 'Hipoglicemia', 'diarreia' => 'Diarreia', 'casos_especiais' => 'Casos especiais', 'procura_da_unidade' => 'Procura da unidade p/ procedimentos', 'hemorragia' => 'Hemorragia', 'alteracao_de_pressao' => 'Alteração de pressão', 'parada_cardiorrespiratoria' => 'Parada cardiorrespiratória', 'hemorragia_digestiva' => 'Hemorragia digestiva', 'queixas_cronicas' => 'Queixas crônicas'];
	$ultimo_atendimento =null;
?>
<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
	<?=  $this->Html->css('pdf', ['fullBase' => true]); ?>
	<?= $this->fetch('css') ?>
</head>
<body>
	<?= $this->element( 'header-logo', ['report_title'=>'Visualização da emergência'] ); ?>

	<div class="container">
		<table class="aileron_thin" style="width:100%;  border-collapse: collapse;">
			<thead>
				<tr>
					 <th class="title th-left">Nome</th>
					 <th class="title th-middle">Classificação de risco</th>
					 <th class="title th-right" >Diagnóstico</th>
					 <th class="title th-right" >Status</th>
					 <th class="title th-right" >Nome do médico</th>
					 <th class="title th-right" >Data e hora do ultimo atendimento médico</th>
			  	</tr>
			</thead>

		 

		 <?php
		 	foreach ($data as $key => $screening) {
		 		echo "<tr>";

		 		echo "<td>". $screening["patient"]["nome"] ."</td>";


		 		if ( isset( $screening["classificacao_selecionada"] ) ) {
		 			echo "<td>".$screening["classificacao_selecionada"] . "</td>";
		 		} else {
		 			echo "<td>".$screening["classificacao_sugerida"] . "</td>";
		 		}

		 		// echo "<td>".$screening["queixa_principal"] . "</td>";

		 		if ( isset( $queixa_principal[$screening["queixa_principal"]] ) ) {
		 			echo "<td>". $queixa_principal[$screening["queixa_principal"]] . "</td>";
		 		} else {
		 			echo "<td></td>";
		 		}


		 		if ( isset( $screening["medical_cares"]["status"] ) ) {
		 			echo "<td>".$screening["medical_cares"]["status"] . "</td>";
		 		} else {
		 			echo "<td></td>";
		 		}

		 		if ( isset( $screening["professional"]["user"] ) ) {
		 			echo "<td>".$screening["professional"]["user"]["name"] . "</td>";
		 		} else {
		 			echo "<td></td>";
		 		}


		 		foreach ($screening["medical_cares"] as $key => $medical_care) {
		 			$ultimo_atendimento = $medical_care["created"];
		 		}
		 		echo "<td>". $ultimo_atendimento ."</td>";

		 		echo "</tr>";
		 	}
		 ?>

		</table>
	</div>
</body>
</html>