<!DOCTYPE html>
<html>
    <head>
        <meta content="text/html; charset=utf-8" http-equiv="Content-Type"/>
        <?=$this->Html->css('pdf', ['fullBase' => true]);?>
        <?=$this->fetch('css')?>
        <!--link rel="stylesheet" type="text/css" href="print.css" media="print" /-->
        <style type="text/css">

            @media print and (color) {
                * {
                    -webkit-print-color-adjust: exact;
                    print-color-adjust: exact;
                }
            }

            @media print {
                * {
                    -webkit-print-color-adjust: exact;
                    print-color-adjust: exact;
                }
            }

            body {
              -webkit-print-color-adjust: exact;
               print-color-adjust: exact;
            }

            table {
                border-collapse: collapse;
                -webkit-print-color-adjust: exact;
            }


            tbody tr td, .border th {
              border-right: solid 1px #ccc;
              border-left: solid 1px #ccc;
              -webkit-print-color-adjust: exact;
            }

             .border th {
              border-top: solid 1px #ccc;
            }

            tbody tr td {
                text-align: center;
                -webkit-print-color-adjust: exact;
            }

            .thead_pdf{
                background-color: #e8eaeb !important;
            }

            .thead_pdf th{
                border-right: solid 1px #ccc;
                border-left: solid 1px #ccc;
            }

            tbody tr td:first-child {
                text-align: left;
            }

            .sticky-wrap{
                overflow-y: inherit;
                overflow-x: inherit;
            }

            td.title{
                font-weight: bold;
            }
        </style>

    </head>
    <body>
        <div class="logo">
            <div style="float: left" >
                <?php

if (isset($unit_logo) && !isset($default_logo))
{
    echo $this->Html->image('uploads/' . $unit_logo, ['alt' => 'GH', 'border' => '0', 'style' => 'float: left; margin-left: 14%;']);
}
else
{
    echo $this->Html->image('uploads/default.png', ['alt' => 'GH', 'border' => '0', 'style' => 'float: left; margin-left: 14%;']);
}

?>
            </div>
            <div style="float: right; text-align: right">
                <span style="text-align: center" class='title-dark f-size-32 underline_text'>
                    Relatório Geral
                </span>

                <p style="text-align: right; font-size: 0.8em; line-height: 20px;" class='title f-size-32 underline_text'>
                    Período de análise: <?=$date_before->format("d/m/Y")?>  a <?=$date_after->format("d/m/Y")?>
                </p>
            </div>
        </div>
        <div class="container">
            <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
                <thead class="thead_pdf">
                    <tr>
                        <th class="title th-left">
                            Item
                        </th>
                        <th class="title th-middle">
                            Valor
                        </th>
                        <th class="title th-right">
                            %
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <!-- <tr >
                        <td class="line-separator title t-center" style="font-weight: bold" colspan="3">  Seção Geral</td>
                    </tr> -->
                    <?php

foreach ($data['sectors'] as $sector): ?>
                        <tr>
                            <td class="title" style="font-weight: bold" colspan="7"> <?=$sector['name']?> </td>
                        </tr>
                        <tr>
                            <td>
                                Total de pacientes atendidos no período
                            </td>
                            <td>
                                <?=$sector['tot_pacientes_atendidos']?>
                            </td>
                            <td>
                               -
                            </td>
                        </tr>

                        <tr>
                            <td>
                                Total de internações
                            </td>
                            <td>
                                <?=$sector['tot_internacoes_no_periodo']?>
                            </td>
                            <td>
                               -
                            </td>
                        </tr>

                        <tr>
                            <td>
                                 Total de altas
                            </td>
                            <td>
                                <?=$sector['tot_alta']?>
                            </td>
                            <td>
                               <?=$sector['percen_alta']?>
                            </td>
                        </tr>

                        <tr>
                            <td>
                                 Total de óbitos
                            </td>
                            <td>
                                <?=$sector['tot_obito']?>
                            </td>
                            <td>
                               <?=$sector['percen_obito']?>
                            </td>
                        </tr>

                        <tr>
                            <td class="title" colspan="3"> - Faixa de internação </td>
                        </tr>
                        <?php

foreach ($sector['faixa_internacao'] as $key_internacao => $internacao): ?>
                            <tr class="tr-indent">
                                <?php

if ($key_internacao == "< 24h"): ?>
                                    <td> &bull; &lt; <?=$internacao['nome']?></td>
                                <?php elseif ($key_internacao == "> 28 dias"): ?>
                                    <td> &bull; &gt; <?=$internacao['nome']?></td>
                                <?php else: ?>
                                    <td> &bull; <?=$internacao['nome']?></td>
                                <?php endif;?>
                                <td> <?=$internacao['count']?> </td>
                                <td>-</td>
                            </tr>
                        <?php endforeach;?>

                        <tr>
                            <td>
                                Tempo mínimo de permanência (dias)
                            </td>
                            <td>
                                <?=$sector['tempo_minimo_permanencia']?>
                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td>
                                Tempo médio de permanência (dias)
                            </td>
                            <td>
                                <?=$sector['tempo_medio_permanencia']?>
                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td>
                                Tempo máximo de permanência (dias)
                            </td>
                            <td>
                                <?=$sector['tempo_maximo_permanencia']?>
                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td>
                                Tempo médio de permanência (dias) dos pacientes de óbito
                            </td>
                            <td>
                                <?=$sector['tempo_medio_permanencia_obito']?>
                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td>
                                Taxa de ocupação
                            </td>
                            <td>
                                -
                            </td>
                            <td>
                                <?=$sector['taxa_ocupacao']?>
                            </td>
                        </tr>

                        <tr>
                            <td>
                                Intervalo de substituição
                            </td>
                            <td>
                                <?=$sector['intervalo_de_substituicao']?>
                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td>
                                Idade média
                            </td>
                            <td>
                                <?=$sector['idade_media']?>
                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td>
                                Sexo masculino
                            </td>
                            <td>
                                <?=$sector['tot_paciente_sexo_masculino']?>
                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td class="title" colspan='3'>
                             - 5 principais origens de internação + outros
                            </td>
                        </tr>

                        <?php

foreach ($sector['5_principais_origin_internacao'] as $key_origem => $origem): ?>
                            <tr class="tr-indent">
                                <td> &bull; <?=$origem['name']?></td>
                                <td> <?=$origem['count']?></td>
                                <td> <?=$origem['percentual']?></td>
                            </tr>
                        <?php endforeach?>

                        <tr>
                            <td class="title" colspan='3'>
                               - Saúde complementar ( 5 principais planos + outros )
                            </td>
                        </tr>

                        <?php

foreach ($sector['5_principais_saude_complementares'] as $saude_complementares): ?>
                            <tr class="tr-indent">
                                <td> &bull; <?=$saude_complementares['name']?></td>
                                <td> <?=$saude_complementares['tot']?></td>
                                <td> <?=$saude_complementares['percen']?></td>
                            </tr>
                        <?php endforeach?>

                        <tr>
                            <td class="title" colspan='3'>
                              - 5 principais diagnósticos sistêmicos + outros
                            </td>
                        </tr>

                        <?php

foreach ($sector['5_principais_diagnosticos_sistemicos'] as $principal_diagnostico): ?>
                            <tr class="tr-indent">
                                <td> &bull; <?=$principal_diagnostico['name']?></td>
                                <td> <?=$principal_diagnostico['tot_pacientes']?></td>
                                <td> <?=$principal_diagnostico['percen_pacientes']?></td>
                            </tr>
                        <?php endforeach?>

                        <tr>
                            <td class="title" colspan='3'>
                                - 5 principais diagnósticos + outros
                            </td>
                        </tr>

                        <?php

foreach ($sector['5_principais_diagnosticos'] as $principal_diagnostico): ?>
                            <tr class="tr-indent">
                                <td> &bull; <?=$principal_diagnostico['name']?></td>
                                <td> <?=$principal_diagnostico['tot']?></td>
                                <td> <?=$principal_diagnostico['percen']?></td>
                            </tr>
                        <?php endforeach?>

                        <tr>
                            <td class="title" colspan='3'>
                                - 5 principais comorbidades + outros
                            </td>
                        </tr>

                        <?php

foreach ($sector['5_principais_comorbidades'] as $diagnostic): ?>
                            <tr class="tr-indent" >
                                <td> &bull; <?=$diagnostic['name']?></td>
                                <td> <?=$diagnostic['tot_comorbidade']?></td>
                                <td> <?=$diagnostic['percen_comorbidade']?></td>
                            </tr>
                        <?php endforeach?>

                        <tr>
                            <td class="title" colspan='3'>
                                - 5 principais destinos de alta + outros
                            </td>
                            <?php $count_destino = 0;?>
                            <?php

foreach ($data['principais_destinos'] as $key_destino => $total): ?>
                                <?php

if ($key_destino == "total"): ?>
                                    <?php

foreach ($total as $key_total => $value): ?>
                                        <?php

foreach ($value as $key_value => $destino): ?>
                                            <?php

if ($count_destino < 5): ?>
                                                <tr class="tr-indent">
                                                    <td> &bull; <?=$destino['name']?> </td>
                                                    <td> <?=$destino['total']?> </td>
                                                    <td> <?=$destino['percentual']?> </td>
                                                </tr>
                                            <?php endif;?>
                                            <?php $count_destino++;?>
                                        <?php endforeach;?>
                                    <?php endforeach;?>
                                <?php endif;?>
                            <?php endforeach;?>
                        </tr>

                        <tr>
                            <td class="title" colspan="3"> - Retorno hospitalar </td>
                        </tr>

                        <?php

foreach ($sector['tempo_reinteracao'] as $tempo): ?>
                            <tr class="tr-indent">
                                <td> &bull; &lt; <?=$tempo['nome']?></td>
                                <td> <?=$tempo['count']?> </td>
                                <td>-</td>
                            </tr>
                        <?php endforeach;?>

                        <tr>
                            <td>
                            Tempo médio de duração da decisão de alta e alta efetiva
                            </td>
                            <td> <?=$sector['tempo_medio_duracao_alta_e_alta_efetiva']?> </td>
                            <td> - </td>
                        </tr>

                        <tr>
                            <td class="title" colspan="3">
                                - Gênero
                            </td>
                        </tr>

                        <?php

foreach ($sector['genero'] as $genero): ?>
                            <tr class="tr-indent">
                                <td> &bull; <?=$genero['tipo']?></td>
                                <td> <?=$genero['count']?> </td>
                                <td> <?=$genero['percentual']?> </td>
                            </tr>
                        <?php endforeach;?>

                        <tr>
                            <td class="title" colspan="3">
                                - Total de internação por faixa etária
                            </td>
                        </tr>

                        <?php

foreach ($sector['intenacao_faixa_etaria'] as $key_f => $faixa_etaria): ?>
                            <tr class="tr-indent">
                                <?php

if ($key_f == 1): ?>
                                    <td> &bull; &lt; <?=$faixa_etaria['faixa_etaria']?></td>
                                <?php elseif ($key_f == 12): ?>
                                    <td> &bull; &gt; <?=$faixa_etaria['faixa_etaria']?></td>
                                <?php else: ?>
                                    <td> &bull; <?=$faixa_etaria['faixa_etaria']?></td>
                                <?php endif?>
                                <td> <?=$faixa_etaria['count']?> </td>
                                <td> <?=$faixa_etaria['percentual']?> </td>
                            </tr>
                        <?php endforeach;?>


                        <tr>
                            <td>
                            Idade mediana
                            </td>
                            <td>

                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td>
                            Idade média dos pacientes de óbito
                            </td>
                            <td>
                                <?=$sector['media_idade_obito']?>
                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td class="title" colspan='3'>
                                 - Idade média dos pacientes de óbito das 5 principais origens
                            </td>
                        </tr>

                        <?php

foreach ($sector['arr_idade_obito_origem'] as $key_obito => $obito): ?>
                            <tr class="tr-indent">
                                <td> &bull; <?=$obito['nome']?></td>
                                <td> <?=$obito['media']?></td>
                                <td> - </td>
                            </tr>
                        <?php endforeach?>

                        <tr>
                            <td>
                            Idade média dos pacientes de alta
                            </td>
                            <td>
                                <?=$sector['media_idade_alta']?>
                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td class="title" colspan='3'>
                                - Idade média dos pacientes de alta das 5 principais origens
                            </td>
                        </tr>
                        <?php

foreach ($sector['arr_idade_alta_origem'] as $key_obito => $obito): ?>
                            <tr class="tr-indent">
                                <td> &bull; <?=$obito['nome']?></td>
                                <td> <?=$obito['media']?></td>
                                <td> - </td>
                            </tr>
                        <?php endforeach?>

                        <tr>
                            <td class="title" colspan='3'>
                            - Origem de internação ( 10 principais + outros )
                            </td>
                        </tr>
                        <?php

foreach ($sector['10_principais_origin_internacao'] as $key_origem => $origem): ?>
                            <tr class="tr-indent">
                                <td> &bull; <?=$origem['name']?></td>
                                <td> <?=$origem['count']?></td>
                                <td> <?=$origem['percentual']?></td>
                            </tr>
                        <?php endforeach?>

                        <tr>
                            <td class="title" colspan='3'>
                                - Saúde complementar: ( 20 principais + outros )
                            </td>
                        </tr>

                        <?php

foreach ($sector['20_principais_saude_complementares'] as $saude_complementares): ?>
                            <tr class="tr-indent" >
                                <td> &bull; <?=$saude_complementares['name']?></td>
                                <td> <?=$saude_complementares['tot']?></td>
                                <td> <?=$saude_complementares['percen']?></td>
                            </tr>
                        <?php endforeach?>

                        <tr>
                            <td colspan='3'>
                              Tabela de origem e saúde complementar
                            </td>
                        </tr>
                        <?php

foreach ($sector['arr_origem'] as $origin): ?>
                            <tr>
                                <td class="title" colspan='3'>
                                  - <?=$origin['name']?>
                                </td>
                            </tr>
                            <?php

foreach ($origin['health_insurance'] as $health_insurance): ?>
                                <tr class="tr-indent" >
                                    <td> &bull; <?=$health_insurance['name']?></td>
                                    <td> <?=$health_insurance['tot']?></td>
                                    <td> <?=$health_insurance['percen']?></td>
                                </tr>
                            <?php endforeach?>
                        <?php endforeach?>


                         <!-- <tr>
                            <td>
                                Grupos de diagnósticos: clinico, cirurgicos emergenciais, cirúrgicos rotina, obstétrico emergencial, obstrético rotina, terapeutica, paleativo -> valor absoluto e percentual frente ao total de internações
                            </td>
                            <td>

                            </td>
                            <td>
                                -
                            </td>
                        </tr> -->

                        <tr>
                            <td>
                               Tabela origem e grupos de diagnósticos
                            </td>
                            <td>

                            </td>
                            <td>
                                -
                            </td>
                        </tr>


                        <tr>
                            <td class="title" colspan='3'>
                              Tabela diagnóstico sistêmico e origem
                            </td>
                        </tr>
                        <?php

foreach ($sector['arr_origem'] as $origin): ?>
                            <tr>
                                <td class="title" colspan='3'>
                                  - <?=$origin['name']?>
                                </td>
                            </tr>
                            <?php

foreach ($origin['systemic_diagnosis'] as $diagnostic): ?>
                                <tr class="tr-indent">
                                    <td> &bull; <?=$diagnostic['name']?></td>
                                    <td> <?=$diagnostic['tot_pacientes']?></td>
                                    <td> <?=$diagnostic['percen_pacientes']?></td>
                                </tr>
                            <?php endforeach?>
                        <?php endforeach?>

                        <tr>
                            <td class="title" colspan='3'>
                              - 15 principais diagnósticos em cada um acima + outros
                            </td>
                        </tr>
                        <?php

foreach ($sector['15_principais_diagnosticos'] as $diagnostic): ?>
                            <tr class="tr-indent" >
                                <td> &bull; <?=$diagnostic['name']?></td>
                                <td> <?=$diagnostic['tot']?></td>
                                <td> <?=$diagnostic['percen']?></td>
                            </tr>
                        <?php endforeach?>

                        <tr>
                            <td class="title" colspan='3'>
                              - 15 principais diagnósticos secundários em cada um acima + outros
                            </td>
                        </tr>
                        <?php

foreach ($sector['15_principais_diagnosticos_sec'] as $diagnostic): ?>
                            <tr class="tr-indent" >
                                <td> &bull; <?=$diagnostic['name']?></td>
                                <td> <?=$diagnostic['tot_secundario']?></td>
                                <td> <?=$diagnostic['percen_secundario']?></td>
                            </tr>
                        <?php endforeach?>

                        <tr>
                            <td class="title" colspan='3'>
                              - 15 principais diagnósticos sistêmicos em cada um acima + outros
                            </td>
                        </tr>
                        <?php

foreach ($sector['15_principais_diagnosticos_sis'] as $diagnostic): ?>
                            <tr class="tr-indent" >
                                <td> &bull; <?=$diagnostic['name']?></td>
                                <td> <?=$diagnostic['tot_pacientes']?></td>
                                <td> <?=$diagnostic['percen_pacientes']?></td>
                            </tr>
                        <?php endforeach?>

                        <tr>
                            <td class="title" colspan='3'>
                              - 15 principais comorbidades em cada um acima + outros
                            </td>
                        </tr>
                        <?php

foreach ($sector['15_principais_comorbidades'] as $diagnostic): ?>
                            <tr class="tr-indent" >
                                <td> &bull; <?=$diagnostic['name']?></td>
                                <td> <?=$diagnostic['tot_comorbidade']?></td>
                                <td> <?=$diagnostic['percen_comorbidade']?></td>
                            </tr>
                        <?php endforeach?>

                        <tr>
                            <td>
                              Índice de comorbidade dos pacientes internados
                            </td>
                            <td>

                            </td>
                            <td>
                                -
                            </td>
                        </tr>
                    <?php endforeach;?>
                </tbody>
            </table>
        </div>
        <script>

            window.onload = setTimeout(function(){$.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});},1);

            (function(){

                $("form :input").prop('readonly', true);
                $("form :input").css('readonly', true);
                $('nav').css('display','none');

                // definindo a função de Print
                function PrintPage() {
                    window.print();
                    setTimeout(function () {
                      $.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});
                      window.close();
                    },900);
                }

                //chamando a função de imprimir
                setTimeout(function(){
                  PrintPage();
                },600);

            })();


        </script>
    </body>
</html>
