<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <?=$this->Html->css('pdf', ['fullBase' => true]);?>
    <?=$this->fetch('css')?>
</head>
<body>
    <?= $this->element( 'header-logo', ['report_title'=>'Relatório de Protocolo de Sepse'] ); ?>
    <div class="container">
        <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
            <thead>
                <tr>
                     <th class="title  th-left">Item</th>
                     <th class="title th-middle">VA</th>
                     <th class="title th-middle">%</th>
              </tr>
            </thead>

             
            <tbody>
                <tr>
                    <td >Indice de pacientes com sepse</td>
                    <td> <?=$data['consolidado']['indice_paciente_sepse']?> </td>
                    <td> <?=$data['consolidado']['indice_paciente_sepse_percentual']?> </td>
                </tr>
                <!-- fora do escopo
                <tr>
                    <td >Taxa de realização de volume rápido </td>
                    <td>  </td>
                    <td>  </td>
                </tr>


                <tr >
                    <td > Taxa de realização de volume rápido em sepse grave </td>
                    <td>  </td>
                    <td></td>
                </tr>


                <tr>
                    <td > MÉDIA DE VOLUME EM ETAPA RÁPIDA </td>
                    <td>  </td>
                    <td>  </td>
                </tr>
                 -->

                <tr>
                    <td > Média percentual do clareamento do lactato</td>
                    <td> - </td>
                    <td> <?=$data['consolidado']['taxa_clareamento_lactato']['media']?>% </td>
                </tr>
                <tr >
                    <td style="font-weight: bold; text-align: left; padding-left: 10px;" colspan=3>Distribuição absoluta e percentual do clareamento do lactato em 6 horas por:</td>
                </tr>

                <tr class="td-indent" >
                    <td>&#8226;> Menor que 20%</td>
                    <td> <?=$data['consolidado']['distribuicao_lactato']['menor_20']['tot']?> </td>
                    <td> -</td>
                </tr>
                <tr class="td-indent" >
                    <td>&#8226; De 21% a 40%</td>
                    <td> <?=$data['consolidado']['distribuicao_lactato']['21_a_40']['tot']?> </td>
                    <td> - </td>
                </tr>
                <tr class="td-indent" >
                    <td>&#8226;> De 41% a 60%</td>
                    <td> <?=$data['consolidado']['distribuicao_lactato']['41_a_60']['tot']?> </td>
                    <td> - </td>
                </tr>
                <tr class="td-indent" >
                    <td>&#8226;Maior que 60%</td>
                    <td> <?=$data['consolidado']['distribuicao_lactato']['maior_60']['tot']?> </td>
                    <td> - </td>
                </tr>


                <tr>
                    <td > Taxa de adesão ao protocolo de sepse</td>
                    <td> - </td>
                    <td> <?=$data['consolidado']['taxa_adesao_prot_sepse']?> </td>
                </tr>


                <tr>
                    <td > Taxa de efetividade do protocolo de sepse </td>
                    <td> - </td>
                    <td> <?=$data['consolidado']['taxa_efetividade']['percentual']?> </td>
                </tr>

                <tr>
                    <td > Taxa de mortalidade dos pacientes com sepse </td>
                    <td> - </td>
                    <td> <?=$data['consolidado']['mortalidade']['percentual']?> </td>
                </tr>

                <tr >
                    <td style="font-weight: bold; text-align: left; padding-left: 10px;" colspan=3>Protocolos abertos por tipo de sepse:</td>
                </tr>

                <?php foreach($data['consolidado']['distribuicao_sepse']['tipo'] as $key_tipo => $tipo) : ?>
                    <tr class="td-indent" >
                        <td>&#8226; <?= $key_tipo ?></td>
                        <td> <?= $tipo['count'] ?> </td>
                        <td> <?= $tipo['percentual'] ?> </td>
                    </tr>

                <?php endforeach; ?>
                <!-- <tr >
                    <td style="font-weight: bold; text-align: left; padding-left: 10px;" colspan=3>Protocolos abertos por tipo de sepse :</td>
                </tr>
                <tr class="td-indent" >
                    <td>&#8226; Sepse</td>
                    <td> <?=$data['local_insercao']['tot_arteria_axilar']?> </td>
                    <td> <?=$data['local_insercao']['percen_arteria_axilar']?>% </td>
                </tr>

                <tr class="td-indent" >
                    <td>&#8226; Severa</td>
                    <td> <?=$data['local_insercao']['tot_arteria_axilar']?> </td>
                    <td> <?=$data['local_insercao']['percen_arteria_axilar']?>% </td>
                </tr>

                <tr class="td-indent" >
                    <td>&#8226; Choque Séptico</td>
                    <td> <?=$data['local_insercao']['tot_arteria_axilar']?> </td>
                    <td> <?=$data['local_insercao']['percen_arteria_axilar']?>% </td>
                </tr> -->


                <tr >
                    <td style="font-weight: bold; text-align: left; padding-left: 10px;" colspan=3>SOFA nas primeiras 24h:</td>
                </tr>
                <tr class="td-indent" >
                    <td>&#8226; Mínimo</td>
                    <td>  <?=$data['consolidado']['sofa']['minimo']?> </td>
                    <td>- </td>
                </tr>

                <tr class="td-indent" >
                    <td>&#8226; Médio</td>
                    <td>  <?=$data['consolidado']['sofa']['medio']?> </td>
                    <td> -</td>
                </tr>

                <tr class="td-indent" >
                    <td>&#8226; Máximo</td>
                    <td>  <?=$data['consolidado']['sofa']['maximo']?> </td>
                    <td> - </td>
                </tr>

                <tr>
                    <td > Taxa média de variação do SOFA durante a internação</td>
                    <td> - </td>
                    <td> <?=$data['consolidado']['pontuacao_sofa']['variacao']?> </td>
                </tr>

                <tr>
                    <td > Pacientes com aumento do SOFA  </td>
                    <!--td>  <?=$data['paciente_aumento_sofa']['media']?> </td-->
                    <td>  <?=$data['consolidado']['paciente_aumento_sofa']['paciente_aumento']?> </td>
                    <td>  <?=$data['consolidado']['paciente_aumento_sofa']['percentual']?> </td>
                </tr>

                 <tr>
                    <td > Tempo médio de permanência do paciente com sepse </td>
                    <td>  <?=$data['consolidado']['paciente_permanencia_sepse']['media']?> <?= $data['consolidado']['paciente_permanencia_sepse']['media'] <= 1 ? 'dia' : 'dias' ?> </td>
                    <td> -</td>
                </tr>

                <tr >
                    <td style="font-weight: bold; text-align: left; padding-left: 10px;" colspan=3>Tempo médio de permanência na UTI do paciente com sepse pelo tipo de sepse:</td>
                </tr>

                <?php foreach($data['consolidado']['tempo_medio_uti']['tipo'] as $key_tipo => $tipo) : ?>
                    <tr class="td-indent" >
                        <td>&#8226; <?= $key_tipo ?></td>
                        <td> <?= $tipo['media'] ?> </td>
                        <td> - </td>
                    </tr>

                <?php endforeach; ?>

                <tr >
                    <td style="font-weight: bold; text-align: left; padding-left: 10px;" colspan=3>Tempo médio de permanência no hospital do paciente com sepse pelo tipo de sepse:</td>
                </tr>

                <?php foreach($data['consolidado']['tempo_medio']['tipo'] as $key_tipo => $tipo) : ?>
                    <tr class="td-indent" >
                        <td>&#8226; <?= $key_tipo ?></td>
                        <td> <?= $tipo['media'] ?> </td>
                        <td> - </td>
                    </tr>

                <?php endforeach; ?>

                <tr >
                    <td style="font-weight: bold; text-align: left; padding-left: 10px;" colspan=3>Reinternação na uti do paciente com sepse pelo tipo de sepse:</td>
                </tr>

                <?php foreach($data['consolidado']['reinternacao_uti']['tipo'] as $key_tipo => $tipo) : ?>
                    <tr class="td-indent" >
                        <td>&#8226; <?= $key_tipo ?></td>
                        <td> <?= $tipo['count'] ?> </td>
                        <td> - </td>
                    </tr>

                <?php endforeach; ?>

                <!-- <tr >
                    <td style="font-weight: bold; text-align: left; padding-left: 10px;" colspan=3>Tempo médio de permanência no hospital do paciente com sepse pelo tipo de sepse:</td>
                </tr>
                <tr class="td-indent" >
                    <td>&#8226; Sepse</td>
                    <td></td>
                    <td> - </td>
                </tr>

                <tr class="td-indent" >
                    <td>&#8226; Severa</td>
                   <td></td>
                    <td> - </td>
                </tr>

                <tr class="td-indent" >
                    <td>&#8226; Choque Séptico</td>
                    <td></td>
                    <td> - </td>
                </tr> -->

                <!-- <tr >
                    <td style="fo-nt-weight: bold; text-align: left; padding-left: 10px;" colspan=3>Reinternação na uti do paciente com sepse pelo tipo de sepse :</td>
                </tr>
                <tr class="td-indent" >
                    <td>&#8226; Sepse</td>
                    <td></td>
                    <td> - </td>
                </tr>

                <tr class="td-indent" >
                    <td>&#8226; Severa</td>
                    <td></td>
                    <td> - </td>
                </tr>

                <tr class="td-indent" >
                    <td>&#8226; Choque Séptico</td>
                    <td></td>
                    <td> - </td>
                </tr>
                -->
                <tr>
                    <td > Taxa de mortalidade dos pacientes com sepse </td>
                    <td> - </td>
                    <td> <?=$data['consolidado']['mortalidade']['percentual']?> </td>
                </tr>

                <tr >
                    <td style="font-weight: bold; text-align: left; padding-left: 10px;" colspan=3>Taxa de mortalidade do paciente com sepse pelo tipo de sepse:</td>
                </tr>

                <?php foreach($data['consolidado']['mortalidade']['tipo'] as $key_tipo => $tipo) : ?>
                    <tr class="td-indent" >
                        <td>&#8226; <?= $key_tipo ?></td>
                        <td></td>
                        <td> <?= $tipo['percentual'] ?> </td>
                    </tr>

                <?php endforeach; ?>

                <!--tr class="td-indent" >
                    <td>&#8226; Sepse</td>
                    <td></td>
                    <td> - </td>
                </tr>

                <tr class="td-indent" >
                    <td>&#8226; Severa</td>
                    <td></td>
                    <td> - </td>
                </tr>

                <tr class="td-indent" >
                    <td>&#8226; Choque Séptico</td>
                    <td></td>
                    <td> - </td>
                </tr-->

            </tbody>


        </table>
    </div>
</body>
</html>