<style type="text/css">
@media print and (color) { 
    * { 
        -webkit-print-color-adjust: exact; 
        print-color-adjust: exact; 
    } 
}

@media print { 
    * { 
        -webkit-print-color-adjust: exact; 
        print-color-adjust: exact; 
    } 
}

body {
  -webkit-print-color-adjust: exact;
   print-color-adjust: exact; 
}

table {
    border-collapse: collapse;
    -webkit-print-color-adjust: exact;
}


tbody tr td, .border th {
  border-right: solid 1px #ccc;
  border-left: solid 1px #ccc;
  -webkit-print-color-adjust: exact;
}

 .border th {
  border-top: solid 1px #ccc;
}

tbody tr td {
    text-align: center;
    -webkit-print-color-adjust: exact;
}

tbody tr td:first-child {
    text-align: left;
}

.sticky-wrap {
    overflow: hidden !important;
    margin: none;
}

.td-same-size td {
    width: 5%;
}

.container:before
{
    content: none;
}
.th-middle {
    text-align: center !important;
}
</style>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <?=  $this->Html->css('pdf', ['fullBase' => true]); ?>
        <?= $this->fetch('css') ?>
    </head>
    <body>        
        <div class="logo">
            <div style="float: left" >          
                <?php 
                    if ( isset($unit_logo) && !isset($default_logo) ) 
                    {       
                        echo $this->Html->image('uploads/'. $unit_logo, array('alt' => 'GH', 'border' => '0', 'style' => 'float: left; margin-left: 14%;'));
                    }
                    else 
                    {
                        echo $this->Html->image('uploads/default.png', array('alt' => 'GH', 'border' => '0', 'style' => 'float: left; margin-left: 14%;'));

                    }
                ?>
            </div>
            <div style="float: right; text-align: right">
                <span style="text-align: center" class='title-dark f-size-32 underline_text'> 
                    Relatório de Centro Cirúrgico
                </span>

                <p style="text-align: right; font-size: 0.8em; line-height: 20px;" class='title f-size-32 underline_text'> 
                    Período de análise: <?= $date_before->format("d/m/Y") ?>  a <?= $date_after->format("d/m/Y") ?> 
                </p>
            </div>
        </div>

       <div class="container">
            <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
                <thead>  
                    <tr>
                        <th class="title th-left">Item</th>
                        <th class="title th-right">Valor</th>                   
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td >Tempo médio de cadastro de cirurgia e liberação da cirurgia</td>
                        <td> <?= $surgeries['totalTempoMedia'] ?> </td>
                    </tr>
                    <tr>
                         <td class="title" style="font-weight: bold" colspan="2">Tempo médio de cadastro de cirurgia e liberação da cirurgia por tipo de cirurgia</td>
                         <!-- <td ></td> -->
                    </tr>
                    <?php 
                        $html = '';
                        foreach ($surgeries['tipoCirurgia'] as $key => $tipoCirurgia) {
                            $html .= '<tr class="tr-indent">';
                            $html .= '<td>&#8226; ' . $tipoCirurgia['nome'] . '</td>';
                            $html .= '<td>' . $tipoCirurgia['mediaTotalDiasTipo'] . '</td>';
                            $html .= '</tr>';
                        }
                        echo $html;
                    ?>
                    <tr>
                         <td class="title" style="font-weight: bold" colspan="2">Tempo médio de cadastro de cirurgia e liberação da cirurgia por porte de cirurgia</td>
                         <!-- <td ></td> -->
                    </tr>
                    <?php 
                        $html = '';
                        foreach ($surgeries['porte'] as $key => $porte) {
                            //echo 'porte = ' . $key;
                            //echo "<pre>";
                            //print_r($porte);
                            $html .= '<tr>';
                            $html .= '<td>&#8226; ' . $key . '</td>';
                            $html .= '<td>' . $porte['mediaDiasPorte'] . '</td>';
                            $html .= '</tr>';
                        }
                        echo $html;
                    ?>
                    <tr>
                         <td class="title" style="font-weight: bold" colspan="2">Tempo médio de cadastro de cirurgia e liberação da cirurgia por convênio</td>
                    </tr>
                    <?php 
                        $html = '';
                        foreach ($surgeries['convenio'] as $key => $convenio) {
                            $html .= '<tr>';
                            $html .= '<td>&#8226; ' . $key . '</td>';
                            $html .= '<td>' . $convenio['totalDiasConvenio'] . '</td>';
                            $html .= '</tr>';
                        }
                        echo $html;
                    ?>

                    <tr>
                        <td >Tempo médio de cadastro de cirurgia e realização da cirurgia por cirurgia</td>
                        <td> <?= $surgeries['cirurgia_cadastro_realizado']['totalTempoMedia'] ?> </td>
                    </tr>
                    <tr>
                         <td class="title" style="font-weight: bold" colspan="2">Tempo médio de cadastro de cirurgia e realização da cirurgia por tipo de cirurgia</td>
                    </tr>
                    <?php 
                        $html = '';
                        foreach ($surgeries['cirurgia_cadastro_realizado'] as $key => $cirurgia_cadastro_realizado) {
                            if($key == 'tipoCirurgia'){                                
                                foreach ($cirurgia_cadastro_realizado as $key2 => $tipoCirurgia) {
                                    $html .= '<tr>';
                                    $html .= '<td>&#8226; ' . $tipoCirurgia['nome'] . '</td>';
                                    $html .= '<td>' . $tipoCirurgia['media'] . '</td>';
                                    $html .= '</tr>';
                                }
                            }
                        }
                        echo $html;
                    ?>

                    <tr>
                        <td class="title" style="font-weight: bold" colspan="2">Tempo médio de cadastro de cirurgia e realização da cirurgia por porte de cirurgia</td>
                    </tr>

                    <?php 
                        $html = '';
                        foreach ($surgeries['cirurgia_cadastro_realizado'] as $key => $cirurgia_cadastro_realizado) {
                            if($key == 'porte'){                                
                                foreach ($cirurgia_cadastro_realizado as $key3 => $porte) {
                                    $html .= '<tr>';
                                    $html .= '<td>&#8226; ' . $key3 . '</td>';
                                    $html .= '<td>' . $porte['media'] . '</td>';
                                    $html .= '</tr>';
                                }
                            }
                        }
                        echo $html;
                    ?>

                    <tr>
                        <td class="title" style="font-weight: bold" colspan="2">Tempo médio de cadastro de cirurgia e realização da cirurgia por convenio</td>
                    </tr>

                    <?php 
                        $html = '';
                        foreach ($surgeries['cirurgia_cadastro_realizado'] as $key => $cirurgia_cadastro_realizado) {
                            if($key == 'convenio'){                                
                                foreach ($cirurgia_cadastro_realizado as $key4 => $convenio) {
                                    $html .= '<tr>';
                                    $html .= '<td>&#8226; ' . $key4 . '</td>';
                                    $html .= '<td>' . $convenio['media'] . '</td>';
                                    $html .= '</tr>';
                                }
                            }
                        }
                        echo $html;
                    ?>

                    <tr>
                        <td >Taxa de cancelamento de cirurgia eletiva</td>
                        <td> <?= $surgeries['taxaCancelamentoCirurgia'] ?> </td>
                    </tr>
                    <tr>
                        <td class="title" style="font-weight: bold" colspan="2">Cancelamento de cirurgia por tipo de cirurgia</td>
                    </tr>
                    <?php 
                        $html = '';
                        foreach ($surgeries['tipoCirurgia'] as $key => $tipoCirurgia) {
                            $html .= '<tr class="tr-indent">';
                            $html .= '<td>&#8226; ' . $tipoCirurgia['nome'] . '</td>';
                            $html .= '<td>' . $tipoCirurgia['cancelamento'] . '</td>';
                            $html .= '</tr>';
                        }
                        echo $html;
                    ?>
                    
                    <tr>
                        <td class="title" style="font-weight: bold" colspan="2">Cancelamento de cirurgia por porte de cirurgia</td>
                    </tr>
                    <?php 
                        $html = '';
                        foreach ($surgeries['porte'] as $key => $porte) {
                            $html .= '<tr class="tr-indent">';
                            $html .= '<td>&#8226; ' . $key . '</td>';
                            $html .= '<td>' . $porte['cancelamento'] . '</td>';
                            $html .= '</tr>';
                        }
                        echo $html;
                    ?>

                    <tr>
                        <td class="title" style="font-weight: bold" colspan="2">Cancelamento de cirurgia por convenio</td>
                    </tr>
                    <?php 
                        $html = '';
                        foreach ($surgeries['convenio'] as $key => $convenio) {
                            $html .= '<tr class="tr-indent">';
                            $html .= '<td>&#8226; ' . $key . '</td>';
                            $html .= '<td>' . $convenio['cancelamento'] . '</td>';
                            $html .= '</tr>';
                        }
                        echo $html;
                    ?>

                    <tr>
                        <td >Taxa de atraso da cirurgia</td>
                        <td> <?= $surgeries['tempoTotalAtrasoCirurgia'] ?> </td>
                    </tr>

                    <tr>
                        <td >Tempo médio de atraso de cirurgia</td>
                        <td> <?= $surgeries['tempoMedioAtrasoCirurgia'] ?> </td>
                    </tr>
                    <tr>
                        <td class="title" style="font-weight: bold" colspan="2">Tempo médio de atraso de cirurgia por porte de cirurgia</td>
                    </tr>
                    <?php 
                        $html = '';
                        foreach ($surgeries['porte'] as $key => $porte) {
                            $html .= '<tr class="tr-indent">';
                            $html .= '<td>&#8226; ' . $key . '</td>';
                            $html .= '<td>' . $porte['tempoMedioAtrasoCirurgia'] . '</td>';
                            $html .= '</tr>';
                        }
                        echo $html;
                    ?>

                    <tr>
                        <td class="title" style="font-weight: bold" colspan="2">Tempo médio de atraso de cirurgia por convenio</td>
                    </tr>
                    <?php 
                        $html = '';
                        foreach ($surgeries['convenio'] as $key => $convenio) {
                            $html .= '<tr class="tr-indent">';
                            $html .= '<td>&#8226; ' . $key . '</td>';
                            $html .= '<td>' . $convenio['tempoMedioAtrasoCirurgia'] . '</td>';
                            $html .= '</tr>';
                        }
                        echo $html;
                    ?>

                    <tr>
                        <td class="title" style="font-weight: bold" colspan="2">Tempo médio de atraso de cirurgia por tipo de cirurgia</td>
                    </tr>
                    <?php 
                        $html = '';
                        foreach ($surgeries['tipoCirurgia'] as $key => $tipoCirurgia) {
                            $html .= '<tr class="tr-indent">';
                            $html .= '<td>&#8226; ' . $key . '</td>';
                            $html .= '<td>' . $porte['tempoMedioAtrasoCirurgia'] . '</td>';
                            $html .= '</tr>';
                        }
                        echo $html;
                    ?>

                    <tr>
                        <td class="title" style="font-weight: bold" colspan="2">Tempo médio de atraso de cirurgia por dia de semana</td>
                    </tr>
                    <?php 
                        $html = '';
                        foreach ($surgeries['diaDeSemana'] as $key => $diaDeSemana) {
                            $html .= '<tr class="tr-indent">';
                            $html .= '<td>&#8226; ' . $key . '</td>';
                            $html .= '<td>' . $diaDeSemana['media'] . '</td>';
                            $html .= '</tr>';
                        }
                        echo $html;
                    ?>

                    <!-- <tr>
                        <td>Taxa de uso de sala cirúrgica</td>
                        <td></td>
                    </tr>

                    <tr>
                        <td>Taxa de uso da sala cirúrgica por dia da semana</td>
                        <td></td>
                    </tr>

                    <tr>
                        <td>Taxa de uso da sala cirúrgica por dia da semana</td>
                        <td></td>
                    </tr>

                    <tr>
                        <td>Taxa de uso da sala cirúrgica por horário manha tarde noite e macrugada</td>
                        <td></td>
                    </tr>

                    <tr>
                        <td>Taxa de uso da sala cirúrgica por especialidade</td>
                        <td></td>
                    </tr>

                    <tr>
                        <td>Taxa de uso da sala cirúrgica por especialidade</td>
                        <td></td>
                    </tr>

                    <tr>
                        <td>Taxa de uso da sala cirúrgica por porte de cirurgia</td>
                        <td></td>
                    </tr>

                    <tr>
                        <td>Taxa de ociosidade da sala cirúrgica</td>
                        <td></td>
                    </tr>

                    <tr>
                        <td>Taxa de ociosidade da sala cirúrgica por dia da semana</td>
                        <td></td>
                    </tr>

                    <tr>
                        <td>Taxa de ociosidade da sala cirúrgica por horário manha tarde noite e macrugada</td>
                        <td></td>
                    </tr>

                    <tr>
                        <td>Taxa de ociosidade da sala cirúrgica por especialidade</td>
                        <td></td>
                    </tr>

                    <tr>
                        <td>Taxa de ociosidade da sala cirúrgica por cirurgião</td>
                        <td></td>
                    </tr>

                    <tr>
                        <td>Taxa de ociosidade da sala cirúrgica por porte de cirurgia</td>
                        <td></td>
                    </tr> -->

                    <tr>
                        <td>Taxa de cirurgia contaminada ( cirurgia contaminada / total de cirurgia )</td>
                        <td><?= $data['taxa_de_cirurgias_contaminadas'] ?></td>
                    </tr>

                    <!-- <tr>
                        <td>Tempo médio de liberação de sala pos cirurgia contaminada</td>
                        <td></td>
                    </tr> -->

                    <!-- <tr>
                        <td>Tempo médio de atraso de liberação de sala pós cirurgia contaminada ( média de tempo após o periodo progamado )</td>
                        <td></td>
                    </tr> -->

                    <tr>
                        <td>Taxa de adesão a antibiotico terapia 60 min antes da cirurgia</td>
                        <td> <?= $data['taxa_anti_60m_antes_cirurgia'] ?>% </td>
                    </tr>

                    <tr>
                        <td>Taxa de adesão a antibiotico terapia 90 min antes da cirurgia</td>
                        <td> <?= $data['taxa_anti_90m_antes_cirurgia'] ?>% </td>
                    </tr>

                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" >Não aderência a antibiótico terapia profilática 60 min antes da cirurgia por anestesia</td>
                    </tr>
                                                            
                    <?php foreach($data['anestesias'] as $anestesia) : ?>                        
                        <tr class="tr-indent">
                            <td>&#8226; <?=$anestesia['name']?></td>                            
                            <td> <?=$anestesia['taxa_anti_60m_antes_cirurgia']?>% </td>
                        </tr>
                    <?php endforeach; ?>
                    
                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" >Não aderência a antibiótico terapia profilática 60 min antes da cirurgia por porte de cirurgica</td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Porte pequeno </td>                            
                        <td> <?= $data['taxa_anti_60m_antes_cirurgia_porte_pequeno'] ?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Porte médio </td>                            
                        <td> <?= $data['taxa_anti_60m_antes_cirurgia_porte_medio'] ?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Porte grande </td>                            
                        <td> <?= $data['taxa_anti_60m_antes_cirurgia_porte_grande'] ?>% </td>
                    </tr>


                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" >Não aderência a antibiótico terapia profilática 60 min antes da cirurgia por especialidade cirúrgica</td>
                    </tr>
                                                            
                    <?php foreach($data['specialties'] as $specialty) : ?>                        
                        <tr class="tr-indent">
                            <td>&#8226; <?=$specialty['name']?></td>                            
                            <td> <?= $specialty['taxa_anti_60m_antes_cirurgia'] ?>% </td>
                        </tr>
                    <?php endforeach; ?>

                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" >Não aderência a antibiótico terapia profilática 60 min antes da cirurgia por horário de cirurgia</td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Manhã </td>                            
                        <td> <?= $data['turnos']['manha']['taxa_anti_60m_antes_cirurgia'] ?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Tarde </td>                            
                        <td> <?= $data['turnos']['tarde']['taxa_anti_60m_antes_cirurgia'] ?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Noite </td>                            
                        <td> <?= $data['turnos']['noite']['taxa_anti_60m_antes_cirurgia'] ?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Madrugada </td>                            
                        <td> <?= $data['turnos']['madrugada']['taxa_anti_60m_antes_cirurgia'] ?>% </td>
                    </tr>

                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" > 
                            Não aderência a antibiótico terapia profilática 60 min antes da cirurgia por dia da semana
                        </td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Segunda </td>                            
                        <td> <?= $data['dia_da_semana'][0]['taxa_anti_60m_antes_cirurgia'] ?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Terça </td>                            
                        <td> <?= $data['dia_da_semana'][1]['taxa_anti_60m_antes_cirurgia'] ?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Quarta </td>                            
                        <td> <?= $data['dia_da_semana'][2]['taxa_anti_60m_antes_cirurgia'] ?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Quinta </td>                            
                        <td> <?= $data['dia_da_semana'][3]['taxa_anti_60m_antes_cirurgia'] ?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Sexta </td>                            
                        <td> <?= $data['dia_da_semana'][4]['taxa_anti_60m_antes_cirurgia'] ?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Sábado </td>                            
                        <td> <?= $data['dia_da_semana'][5]['taxa_anti_60m_antes_cirurgia'] ?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Domingo </td>                            
                        <td> <?= $data['dia_da_semana'][6]['taxa_anti_60m_antes_cirurgia'] ?>% </td>
                    </tr>

                   <!--  <tr>
                        <td>Não aderência a antibiótico terapia profilática 60 min antes da cirurgia por sala</td>
                        <td></td>
                    </tr> -->


                   <!--  <tr>
                        <td>Tipos de anestesia realizados no periodo ( gráfico de pizza )</td>
                        <td></td>
                    </tr> -->
                </tbody>
            </table>

            <h3 class="title" style="font-weight: bold">Tipo de anestesia por porte cirúrgico</h3>
            <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
                <thead>  
                    <tr>
                        <th rowspan="2" class="title th-left">Anestesia</th>
                        <th colspan="2" class="title ">Porte pequeno</th>                   
                        <th colspan="2" class="title">Porte médio</th>                   
                        <th colspan="2" class="title ">Porte grande</th>                   
                    </tr>

                    <tr class="border">
                        <th class="title  ">VA</th>
                        <th class="title ">%</th>

                        <th class="title  ">VA</th>
                        <th class="title ">%</th>

                        <th class="title ">VA</th>
                        <th class="title ">%</th>
                </tr>
                </thead>
                <tbody>
                    <!-- <tr>
                        <td colspan="8" class="title" style="font-weight: bold" >Tipo de anestesia por porte cirúrgico</td>
                    </tr>    -->             
                    <?php foreach($data['anestesias'] as $anestesia) : ?>                        
                        <tr class="tr-indent">
                            <td>&#8226; <?=$anestesia['name']?></td>
                            <td> <?=$anestesia['tot_porte_da_cirurgia_pequeno']?> </td>
                            <td> <?=$anestesia['percen_porte_da_cirurgia_pequeno']?>% </td>

                            <td> <?=$anestesia['tot_porte_da_cirurgia_medio']?> </td>
                            <td> <?=$anestesia['percen_porte_da_cirurgia_medio']?>% </td>

                            <td> <?=$anestesia['tot_porte_da_cirurgia_grande']?> </td>
                            <td> <?=$anestesia['percen_porte_da_cirurgia_grande']?>% </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

            <h3 class="title" style="font-weight: bold">Tipo de anestesia por característica da cirurgia</h3>
            <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
                <thead>  
                    <tr>
                        <th rowspan="2" class="title th-left">Anestesia</th>
                        <th colspan="2" class="title ">Urgência</th>                   
                        <th colspan="2" class="title">Rotina</th>                   
                        <th colspan="2" class="title ">Emergência</th>                   
                    </tr>

                    <tr class="border">
                        <th class="title  ">VA</th>
                        <th class="title ">%</th>

                        <th class="title  ">VA</th>
                        <th class="title ">%</th>

                        <th class="title ">VA</th>
                        <th class="title ">%</th>
                </tr>
                </thead>
                <tbody>
                    <!-- <tr>
                        <td colspan="8" class="title" style="font-weight: bold" >Tipo de anestesia por característica da cirurgia</td>
                    </tr> -->                
                    <?php foreach($data['anestesias'] as $anestesia) : ?>                        
                        <tr class="tr-indent">
                            <td>&#8226; <?=$anestesia['name']?></td>
                            <td> <?=$anestesia['tot_cirurgia_urgencia']?> </td>
                            <td> <?=$anestesia['percen_cirurgia_urgencia']?>% </td>

                            <td> <?=$anestesia['tot_cirurgia_rotina']?> </td>
                            <td> <?=$anestesia['percen_cirurgia_rotina']?>% </td>

                            <td> <?=$anestesia['tot_cirurgia_emergencia']?> </td>
                            <td> <?=$anestesia['percen_cirurgia_emergencia']?>% </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>      

            <h3 class="title" style="font-weight: bold">Tipo de anestesia por turno</h3>
            <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
                <thead>  
                    <tr>
                        <th rowspan="2" class="title th-left">Anestesia</th>
                        <th colspan="2" class="title ">Madrugada</th>                   
                        <th colspan="2" class="title">Manhã</th>                   
                        <th colspan="2" class="title ">Tarde</th>                   
                        <th colspan="2" class="title ">Noite</th>                   
                    </tr>

                    <tr class="border">
                        <th class="title  ">VA</th>
                        <th class="title ">%</th>

                        <th class="title  ">VA</th>
                        <th class="title ">%</th>

                        <th class="title ">VA</th>
                        <th class="title ">%</th>

                        <th class="title ">VA</th>
                        <th class="title ">%</th>
                </tr>
                </thead>
                <tbody>
                    <!-- <tr>
                        <td colspan="8" class="title" style="font-weight: bold" >Tipo de anestesia por característica da cirurgia</td>
                    </tr> -->                
                    <?php foreach($data['anestesias'] as $anestesia) : ?>                        
                        <tr class="tr-indent">
                            <td>&#8226; <?=$anestesia['name']?></td>
                            <td> <?=$anestesia['tot_madrugada']?> </td>
                            <td> <?=$anestesia['percen_madruaga']?>% </td>

                            <td> <?=$anestesia['tot_manha']?> </td>
                            <td> <?=$anestesia['percen_manha']?>% </td>

                            <td> <?=$anestesia['tot_tarde']?> </td>
                            <td> <?=$anestesia['percen_tarde']?>% </td>

                            <td> <?=$anestesia['tot_noite']?> </td>
                            <td> <?=$anestesia['percen_noite']?>% </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

            <h3 class="title" style="font-weight: bold">Tipo de anestesia por dia da semana</h3>
            <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
                <thead>  
                    <tr>
                        <th rowspan="2" class="title th-left">Anestesia</th>
                        <th colspan="2" class="title ">Seg</th>                   
                        <th colspan="2" class="title">Ter</th>                   
                        <th colspan="2" class="title ">Qua</th>                   
                        <th colspan="2" class="title ">Qui</th>                   
                        <th colspan="2" class="title ">Sex</th>                   
                        <th colspan="2" class="title ">Sab</th>                   
                        <th colspan="2" class="title ">Dom</th>                   
                    </tr>

                    <tr class="border">
                        <th class="title  ">VA</th>
                        <th class="title ">%</th>

                        <th class="title  ">VA</th>
                        <th class="title ">%</th>

                        <th class="title ">VA</th>
                        <th class="title ">%</th>

                        <th class="title ">VA</th>
                        <th class="title ">%</th>

                        <th class="title ">VA</th>
                        <th class="title ">%</th>

                        <th class="title ">VA</th>
                        <th class="title ">%</th>

                        <th class="title ">VA</th>
                        <th class="title ">%</th>
                </tr>
                </thead>
                <tbody>          
                    <?php foreach($data['anestesias'] as $anestesia) : ?>                        
                        <tr class="tr-indent">
                            <td>&#8226; <?=$anestesia['name']?></td>

                            <?php foreach($anestesia['dia_da_semana'] as $dia) : ?> 
                                <td> <?=$dia['tot']?> </td>
                                <td> <?=$dia['percen']?>% </td>
                            <?php endforeach; ?>     
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

            <h3 class="title" style="font-weight: bold">Tipo de anestesia por especialidade cirúrgica</h3>
            <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
                <thead>  
                    <tr>
                        <th rowspan="2" class="title th-left">Anestesia</th>
                        <?php foreach($data['main_specialties'] as $main_specialty) : ?>  
                            <th colspan="2" class="title "> <?= $main_specialty['name'] ?> </th>                   
                        <?php endforeach; ?>                     
                    </tr>

                    <tr class="border">
                        <th class="title  ">VA</th>
                        <th class="title ">%</th>

                        <th class="title  ">VA</th>
                        <th class="title ">%</th>

                        <th class="title ">VA</th>
                        <th class="title ">%</th>

                        <th class="title ">VA</th>
                        <th class="title ">%</th>

                        <th class="title ">VA</th>
                        <th class="title ">%</th>

                        <th class="title ">VA</th>
                        <th class="title ">%</th>
                </tr>
                </thead>
                <tbody>          
                    <?php foreach($data['anestesias'] as $anestesia) : ?>                        
                        <tr class="tr-indent">
                            <td>&#8226; <?=$anestesia['name']?></td>

                            <?php foreach($anestesia['specialties'] as $specialty) : ?>                        
                                <td> <?=$dia['tot']?> </td>
                                <td> <?=$dia['percen']?>% </td>
                            <?php endforeach; ?>     
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>        


            <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
                <thead>  
                    <tr>
                        <th class="title th-left">Item</th>
                        <th class="title th-right">VA</th>                   
                        <th class="title th-right">%</th>    
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td colspan="3" class="title" style="font-weight: bold" >Tipo de anestesia por especialidade </td>
                    </tr>                
                <?php foreach($data['anestesias'] as $anestesia) : ?>    
                    <tr>
                        <td colspan="3" class="title" style="font-weight: bold"> <?=$anestesia['name']?> </td>
                    </tr>       
          
                    <?php foreach($anestesia['specialties'] as $specialty) : ?> 
                        <tr class="tr-indent">
                            <td>&#8226; <?=$specialty['name']?></td>                        
                            <td> <?=$specialty['tot']?> </td>
                            <td> <?=$specialty['percen']?>% </td>                                            
                        </tr>
                    <?php endforeach; ?>  
                <?php endforeach; ?>


                    <!-- <tr>
                        <td>Tipo de anestesia por anestesista</td>
                        <td></td>
                    </tr> -->

                    <!-- <tr>
                        <td>Tipo de anestesia por sala cirúrgica</td>
                        <td></td>
                        <td></td>
                    </tr> -->

                    <tr>
                        <td>Tempo médio de realização da anestesia</td>
                        <td> <?= $data['media_tempo_realizacao_anestesia'] ?> h </td>
                        <td> - </td>
                    </tr>

                     <tr>
                        <td colspan="3" class="title" style="font-weight: bold" >Tempo médio de realização da anestesia por especialidade cirurgica</td>
                    </tr>                
              
                    <?php foreach($data['specialties'] as $specialty) : ?> 
                        <tr class="tr-indent">
                            <td>&#8226; <?=$specialty['name']?></td>                        
                            <td> <?=$specialty['media_tempo_realizacao_anestesia']?> h </td>
                            <td> - </td>                                            
                        </tr>
                    <?php endforeach; ?>  

                    <tr>
                        <td colspan="3" class="title" style="font-weight: bold" >Tempo médio de realização da anestesia por anestesista</td>
                    </tr> 

                    <tr class="tr-indent">
                            <td>&#8226; </td>  
                        <td> 0 </td>
                    </tr>

                    <!-- <tr>
                        <td>Tempo médio de realização da anestesia por sala</td>
                        <td></td>
                    </tr> -->

                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" >Tempo médio de realização da anestesia por horário</td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Manhã </td>                            
                        <td> <?= $data['turnos']['manha']['media_tempo_realizacao_anestesia'] ?> h </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Tarde </td>                            
                        <td> <?= $data['turnos']['tarde']['media_tempo_realizacao_anestesia'] ?> h </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Noite </td>                            
                        <td> <?= $data['turnos']['noite']['media_tempo_realizacao_anestesia'] ?> h </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Madrugada </td>                            
                        <td> <?= $data['turnos']['madrugada']['media_tempo_realizacao_anestesia'] ?> h </td>
                    </tr>
                </tbody>
            </table>


            <h3 class="title" style="font-weight: bold">Tempo médio de realização da anestesia por horário e especialidade cirurgica</h3>
            <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
                <thead>  
                    <tr>
                        <th class="title th-left">Especialidade</th>
                        <th class="title "> Manhã </th>
                        <th class="title "> Tarde </th>
                        <th class="title "> Noite </th>
                        <th class="title "> Madrugada </th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($data['specialties'] as $specialty) : ?> 
                        <tr>
                            <td> <?= $specialty['name'] ?> </td>
                            <?php foreach($specialty['turnos'] as $turno) : ?> 
                                <td> <?= $turno['media_tempo_realizacao_anestesia'] ?> h </td>
                            <?php endforeach; ?>
                        </tr>
                    <?php endforeach; ?>  
                </tbody>
            </table>

            <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
                <thead>  
                    <tr>
                        <th class="title th-left">Item</th>
                        <th class="title th-right">VA</th>                   
                        <th class="title th-right">%</th>    
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>Tempo médio de realização da anestesia por horário e anestesista</td>
                        <td></td>
                    </tr>

                    <tr>
                        <td>Tempo médio de realização da anestesia por dia de semana</td>
                        <td></td>
                    </tr>

                    <tr>
                        <td>Distribuição das cirurgias por tipo de cirurgia rotina urgencia e emergencia</td>
                        <td></td>
                    </tr>

                    <tr>
                        <td>Distribuição das cirurgias por convenio</td>
                        <td></td>
                    </tr>

                    <tr>
                        <td>Distribuição das cirurgias por cirurgião</td>
                        <td></td>
                    </tr>

                    <tr>
                        <td>Distribuição das cirurgias por horário manha tarde noite e madrugada</td>
                        <td></td>
                    </tr>

                    <tr>
                        <td>Distribuição das cirurgias por dia de semana</td>
                        <td></td>
                    </tr>

                    <tr>
                        <td>Distribuição das cirurgias por sala de cirurgia</td>
                        <td></td>
                    </tr>

                    <tr>
                        <td>Tempo médio de realização de cirurgia</td>
                        <td></td>
                    </tr>

                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" >Tempo médio de realização de cirurgia por especialidade cirurgica</td>
                    </tr>
                                                            
                    <?php foreach($data['specialties'] as $specialty) : ?>                        
                        <tr class="tr-indent">
                            <td>&#8226; <?=$specialty['name']?></td>                            
                            <td> 0h </td>
                        </tr>
                    <?php endforeach; ?>

                    <tr>
                        <td></td>
                        <td></td>
                    </tr>

                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" >Tempo médio de realização de cirurgia por cirurgião</td>
                    </tr>                                                                                                    
                    <tr class="tr-indent">
                        <td>&#8226;  </td>                            
                        <td> 0h </td>
                    </tr>

                    <!-- <tr>
                        <td>Tempo médio de realização de cirurgia por sala</td>
                        <td></td>
                    </tr> -->

                    <tr>
                        <td>Tempo médio de realização de cirurgia por horário </td>
                        <td></td>
                    </tr>


                    <tr>
                        <td>Tempo médio de realização de cirurgia por horário e cirurgião</td>
                        <td></td>
                    </tr>

                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" > 
                            Tempo médio de realização de cirurgia por dia de semana
                        </td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Segunda </td>                            
                        <td> 0h </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Terça </td>                            
                        <td> 0h </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Quarta </td>                            
                        <td> 0h </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Quinta </td>                            
                        <td> 0h </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Sexta </td>                            
                       <td> 0h </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Sábado </td>                            
                        <td> 0h </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Domingo </td>                            
                       <td> 0h </td>
                    </tr>

                    <tr>
                        <td>Time in -out médio das cirurgias</td>
                        <td> 0h </td>
                    </tr>

                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" >Time in -out médio das cirurgias por especialidade cirurgicas</td>
                    </tr>
                    <?php foreach($data['specialties'] as $specialty) : ?>                        
                        <tr class="tr-indent">
                            <td>&#8226; <?=$specialty['name']?></td>                            
                            <td> 0h </td>
                        </tr>
                    <?php endforeach; ?>

                    <tr>
                        <td>Time in -out médio das cirurgias por cirugião</td>
                        <td></td>
                    </tr>

                    <!-- <tr>
                        <td>Time in -out médio das cirurgias por sala cirúrgica</td>
                        <td></td>
                    </tr> -->

                    <tr>
                        <td>Time in -out médio das cirurgias por horário</td>
                        <td></td>
                    </tr>

                    <tr>
                        <td>Time in -out médio das cirurgias por horário e especialidade</td>
                        <td></td>
                    </tr>

                    <tr>
                        <td>Time in -out médio das cirurgias por horário e cirurgião</td>
                        <td></td>
                    </tr>

                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" > 
                            Time in -out médio das cirurgias por dia de semana
                        </td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Segunda </td>                            
                        <td> 0h </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Terça </td>                            
                        <td> 0h </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Quarta </td>                            
                        <td> 0h </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Quinta </td>                            
                        <td> 0h </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Sexta </td>                            
                       <td> 0h </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Sábado </td>                            
                        <td> 0h </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Domingo </td>                            
                       <td> 0h </td>
                    </tr>

                    <tr>
                        <td>Consumo médio de compressa por cirurgião</td>
                        <td></td>
                    </tr>

                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" > 
                            Consumo médio de compressa por porte cirúrgico
                        </td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Porte pequeno </td>                            
                        <td> 0 </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Porte médio </td>                            
                        <td> 0h </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Porte grande </td>                            
                        <td> 0h </td>
                    </tr>

                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" >Consumo médio de compressa por especialidade cirurgica</td>
                    </tr>
                    <?php foreach($data['specialties'] as $specialty) : ?>                        
                        <tr class="tr-indent">
                            <td>&#8226; <?=$specialty['name']?></td>                            
                            <td> 0 </td>
                        </tr>
                    <?php endforeach; ?>

                    <tr>
                        <td>Consumo médio de compressa por tipo de cirurgia rotina urgência e emergência</td>
                        <td></td>
                    </tr>

                    <tr>
                        <td>Consumo médio de compressa por horário</td>
                        <td></td>
                    </tr>

                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" > 
                            Consumo médio de compressa por dia da semana
                        </td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Segunda </td>                            
                        <td> 0 </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Terça </td>                            
                        <td> 0 </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Quarta </td>                            
                        <td> 0 </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Quinta </td>                            
                        <td> 0 </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Sexta </td>                            
                       <td> 0 </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Sábado </td>                            
                        <td> 0 </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Domingo </td>                            
                       <td> 0 </td>
                    </tr>

                    <tr>
                        <td>Total de uso de pinça extra em cirurgia</td>
                        <td> 0 </td>
                    </tr>

                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" >Total de uso de pinça extra em cirurgia por cirurgião</td>
                    </tr>                                        
                    <tr class="tr-indent">
                        <td>&#8226;  </td>                            
                        <td> 0 </td>
                    </tr>

                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" >Total de uso de pinça extra em cirurgia por especialidade cirúrgica</td>
                    </tr>
                    <?php foreach($data['specialties'] as $specialty) : ?>                        
                        <tr class="tr-indent">
                            <td>&#8226; <?=$specialty['name']?></td>                            
                            <td> 0 </td>
                        </tr>
                    <?php endforeach; ?>

                    <tr>
                        <td>Total de uso de pinça extra em cirurgia por porte de cirurgia</td>
                        <td></td>
                    </tr> 
                    <tr>
                        <td>Total de uso de pinça extra em cirurgia por tipo de cirurgia</td>
                        <td></td>
                    </tr> 

                    <tr>
                        <td>Total de uso de pinça extra em cirurgia por horário</td>
                        <td></td>
                    </tr> 

                    <tr>
                        <td>Total de abertura de caixa extra em cirurgia</td>
                        <td> 0 </td>
                    </tr> 

                    <tr>
                        <td>Total de abertura de caixa extra em cirurgia por cirurgião</td>
                        <td> </td>
                    </tr> 

                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" >Total de abertura de caixa extra em cirurgia por especialidade cirúrgica</td>
                    </tr>
                    <?php foreach($data['specialties'] as $specialty) : ?>                        
                        <tr class="tr-indent">
                            <td>&#8226; <?=$specialty['name']?> </td>                            
                            <td> 0 </td>
                        </tr>
                    <?php endforeach; ?>

                     <tr>
                        <td>Total de abertura de caixa extra em cirurgia por porte de cirurgia</td>
                        <td></td>
                    </tr> 

                    <tr>
                        <td>Total de abertura de caixa extra em cirurgia por tipo de cirurgia</td>
                        <td></td>
                    </tr> 
                    <tr>
                        <td>Total de abertura de caixa extra em cirurgia por horário</td>
                        <td></td>
                    </tr> 

                    <tr>
                        <td>Total de cirurgias com uso de aparelho de video</td>
                        <td> 0 </td>
                    </tr> 

                    <tr>
                        <td>Tempo médio de uso de aparelho de video em sala operatória</td>
                        <td> 0h </td>
                    </tr> 

                    <tr>
                        <td>Relação de tempo de uso de aparelho de video / tempo de ocupação de sala cirúrgica</td>
                        <td></td>
                    </tr> 

                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" >Total de cirurgias com uso de aparelho de video por cirurgião</td>
                    </tr>                
                    <tr class="tr-indent">
                        <td>&#8226;  </td>                            
                        <td> 0 </td>
                    </tr>


                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" >Total de cirurgias com uso de aparelho de video por especialidade cirúrgica</td>
                    </tr>
                    <?php foreach($data['specialties'] as $specialty) : ?>                        
                        <tr class="tr-indent">
                            <td>&#8226; <?=$specialty['name']?> </td>                            
                            <td> 0 </td>
                        </tr>
                    <?php endforeach; ?>

                    <tr>
                        <td>Total de cirurgias com uso de aparelho de video por porte de cirurgia</td>
                        <td></td>
                    </tr> 
                    <tr>
                        <td>Total de cirurgias com uso de aparelho de video por tipo de cirurgia rotina urgencia e emergência</td>
                        <td></td>
                    </tr> 

                    <tr>
                        <td>Total de cirurgias com uso de aparelho de video por dia da semana</td>
                        <td></td>
                    </tr> 

                    <!-- <tr>
                        <td>Total de cirurgias com uso de aparelho de video por sala</td>
                        <td></td>
                    </tr>  -->

                    <tr>
                        <td>Total de cirurgias com uso de aparelho bis</td>
                        <td> 0 </td>
                    </tr> 

                    <tr>
                        <td>Tempo médio de uso de bis em sala</td>
                        <td> 0h </td>
                    </tr> 

                     <tr>
                        <td>Relação de tempo de uso de bis / tempo de total de anestesia</td>
                        <td></td>
                    </tr> 

                    <tr>
                        <td>Relação de tempo de uso de bis / tempo de ocupação de sala cirúrgica</td>
                        <td></td>
                    </tr> 
                    <tr>
                        <td>Total de cirurgias com uso de aparelho de bis por anestesista</td>
                        <td></td>
                    </tr> 

                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" >Total de cirurgias com uso de aparelho de bis por especialidade cirúrgica</td>
                    </tr>
                    <?php foreach($data['specialties'] as $specialty) : ?>                        
                        <tr class="tr-indent">
                            <td>&#8226; <?=$specialty['name']?> </td>                            
                            <td> 0 </td>
                        </tr>
                    <?php endforeach; ?>

                    <tr>
                        <td>Total de cirurgias com uso de aparelho de bis por porte de cirurgia</td>
                        <td></td>
                    </tr> 

                    <tr>
                        <td>Total de cirurgias com uso de aparelho de bis por tipo de cirurgia rotina urgencia e emergência</td>
                        <td></td>
                    </tr> 

                    <tr>
                        <td>Total de cirurgias com uso de aparelho de bis por dia da semana</td>
                        <td></td>
                    </tr> 

                     <tr>
                        <td>Total de cirurgias com uso de aparelho de bis por sala</td>
                        <td></td>
                    </tr> 

                    <tr>
                        <td>Total de cirurgias com uso de compressor pneumático intermitende de membros inferiores</td>
                        <td></td>
                    </tr> 
                    <tr>
                        <td>10 principais cirurgias com uso de compressor pneumático intermitende de membros inferiores</td>
                        <td></td>
                    </tr> 

                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" >
                            Total de cirurgias com uso de compressor pneumático intermitende de membros inferiores por cirurgião
                        </td>
                    </tr>                    
                    <tr class="tr-indent">
                        <td>&#8226;  </td>                            
                        <td> 0 </td>
                    </tr>

                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" >
                            Total de cirurgias com uso de compressor pneumático intermitende de membros inferiores por especialidade cirúrgica
                        </td>
                    </tr>
                    <?php foreach($data['specialties'] as $specialty) : ?>                        
                        <tr class="tr-indent">
                            <td>&#8226; <?=$specialty['name']?> </td>                            
                            <td> 0 </td>
                        </tr>
                    <?php endforeach; ?>

                    <tr>
                        <td>Total de cirurgias com uso de compressor pneumático intermitende de membros inferiores por porte de cirurgia</td>
                        <td></td>
                    </tr> 

                    <tr>
                        <td>Total de cirurgias com uso de compressor pneumático intermitende de membros inferiores por tipo de cirurgia rotina urgencia e emergência</td>
                        <td></td>
                    </tr>                     


                     <tr>
                        <td>Total de cirurgias com uso de compressor pneumático intermitende de membros inferiores por dia da semana</td>
                        <td></td>
                    </tr> 

                    <!-- <tr>
                        <td>Total de cirurgias com uso de compressor pneumático intermitende de membros inferiores por sala</td>
                        <td></td>
                    </tr>  -->

                    <tr>
                        <td>Total de cirurgias com uso de manta térmica</td>
                        <td> 0 </td>
                    </tr> 

                    <!-- <tr>
                        <td>10 principais cirurgias com uso demanta térmica</td>
                        <td></td>
                    </tr>  -->

                    <tr>
                        <td>Relação de tempo de uso de manta térmica / tempo de total de anestesia</td>
                        <td> 0h </td>
                    </tr> 

                    <tr>
                        <td>Relação de tempo de uso de manta termica / tempo de ocupação de sala cirúrgicas</td>
                        <td></td>
                    </tr> 

                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" >
                            Total de cirurgias com uso de manta térmica por cirurgião
                        </td>
                    </tr>                    
                    <tr class="tr-indent">
                        <td>&#8226;  </td>                            
                        <td> 0 </td>
                    </tr>

                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" >
                            Total de cirurgias com uso de manta térmica por especialidade cirúrgica
                        </td>
                    </tr>
                    <?php foreach($data['specialties'] as $specialty) : ?>                        
                        <tr class="tr-indent">
                            <td>&#8226; <?=$specialty['name']?> </td>                            
                            <td> 0 </td>
                        </tr>
                    <?php endforeach; ?>

                    <tr>
                        <td>Total de cirurgias com uso de manta térmica por porte de cirurgia</td>
                        <td></td>
                    </tr> 

                    <tr>
                        <td>Total de cirurgias com uso de manta térmica por tipo de cirurgia rotina urgencia e emergência</td>
                        <td></td>
                    </tr> 

                    <tr>
                        <td>Total de cirurgias com uso de manta térmica por dia da semana</td>
                        <td></td>
                    </tr> 

                    <!-- <tr>
                        <td>Total de cirurgias com uso de manta térmica por sala</td>
                        <td></td>
                    </tr>  -->


                    <tr>
                        <td>Total de cirurgias com uso de prótese</td>
                        <td> 0 </td>
                    </tr> 

                    <tr>
                        <td>Taxa de cirurgias com uso de prótese ( total que usaram prótese / total de cirurgias no periodo )</td>
                        <td> 0 </td>
                    </tr> 


                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" >
                            Uso de ortese e protese por cirurgião
                        </td>
                    </tr>                    
                    <tr class="tr-indent">
                        <td>&#8226;  </td>                            
                        <td> 0 </td>
                    </tr>


                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" >
                            Uso de ortese e prótese por especialidade cirurgica
                        </td>
                    </tr>
                    <?php foreach($data['specialties'] as $specialty) : ?>                        
                        <tr class="tr-indent">
                            <td>&#8226; <?=$specialty['name']?> </td>                            
                            <td> 0 </td>
                        </tr>
                    <?php endforeach; ?>

                   <!--  <tr>
                        <td>Uso de ortese protese por sitio de insersão ( cirurgia plastica seio, cirurgia plastica gluteo, cirurgia plastica face, cirurgia plastica membro, \coluna cervical , torácica, lombar, ombro, cotovelo, punho, quadril, joelho e tornozelo, cranio, vascular, cardíaca, neurológica, diafragmática, auricular, faringea, traqueal, mandibular, facial, tronco, abdome,  membro superior, menbro inferior )</td>
                        <td></td>
                    </tr>  -->


                    <tr>
                        <td>Taxa de uso de cec ( total de cirurgias com cec/ total de cirurgias)</td>
                        <td> 0 </td>
                    </tr> 

                    <tr>
                        <td>Tempo médio de uso de cec</td>
                        <td> 0h </td>
                    </tr> 

                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" >
                            Tempo médio de uso de cec por cirurgião
                        </td>
                    </tr>                    
                    <tr class="tr-indent">
                        <td>&#8226;  </td>                            
                        <td> 0h </td>
                    </tr>

                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" >
                           Tempo médio de uso de cec por especialidade cirúrgica
                        </td>
                    </tr>
                    <?php foreach($data['specialties'] as $specialty) : ?>                        
                        <tr class="tr-indent">
                            <td>&#8226; <?=$specialty['name']?> </td>                            
                            <td> 0h </td>
                        </tr>
                    <?php endforeach; ?>

                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" >
                            Tempo médio de uso de cec por característica de cirurgia
                        </td>
                    </tr>                    
                    <tr class="tr-indent">
                        <td>&#8226;  Urgência</td>                            
                        <td> 0h </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226;  Rotina</td>                            
                        <td> 0h </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226;  Emergência</td>                            
                        <td> 0h </td>
                    </tr>


                   <!--  <tr>
                        <td>Tempo médio de uso de cec por cirurgião e tipo de cirurgia rotina urgencia e emergencia</td>
                        <td></td>
                    </tr>  -->

                    <!-- <tr>
                        <td>Tempo médio de uso de clampeamento aórtico</td>
                        <td> 0h </td>
                    </tr> 

                    <tr>
                        <td>Tempo médio de uso de clampeamento aórtico por cirurgião</td>
                        <td></td>
                    </tr> 

                    <tr>
                        <td>Tempo médio de uso de clampeamento aórtico por especialidade cirúrgica</td>
                        <td></td>
                    </tr> 

                    <tr>
                        <td>Tempo médio de uso de clampeamento aórtico por tipo de cirurgia rotina urgencia e emergencia</td>
                        <td></td>
                    </tr> 


                    <tr>
                        <td>Tempo médio de uso de clampeamento aórtico por cirurgião e tipo de cirurgia rotina urgencia e emergencia</td>
                        <td></td>
                    </tr>  -->

                    <tr>
                        <td>Total de cirurgias com uso de ranger</td>
                        <td> 0 </td>
                    </tr> 

                    <tr>
                        <td>Taxa de cirurgias com uso de ranger ( total que usaram ranger / total de cirurgias no periodo )</td>
                        <td> 0% </td>
                    </tr> 

                    <!-- 
                    <tr>
                        <td>Uso de ranger por cirurgião</td>
                        <td></td>
                    </tr>  -->

                    <tr>
                        <td>Tempo médio de uso de ranger</td>
                        <td> 0h </td>
                    </tr> 
 
                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" >
                            Tempo médio de uso de ranger por especialidade cirurgica
                        </td>
                    </tr>
                    <?php foreach($data['specialties'] as $specialty) : ?>                        
                        <tr class="tr-indent">
                            <td>&#8226; <?=$specialty['name']?> </td>                            
                            <td> 0h </td>
                        </tr>
                    <?php endforeach; ?>

                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" >
                            Tempo médio de uso ranger por característica de cirurgia
                        </td>
                    </tr>                    
                    <tr class="tr-indent">
                        <td>&#8226;  Urgência</td>                            
                        <td> 0h </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226;  Rotina</td>                            
                        <td> 0h </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226;  Emergência</td>                            
                        <td> 0h </td>
                    </tr>

                    <tr>
                        <td>Tempo médio de uso de ranger em cirurgias perfusionistas</td>
                        <td> 0h </td>
                    </tr> 

                    <tr>
                        <td>Total de cirurgias com uso de neuronavegador</td>
                        <td> 0 </td>
                    </tr> 

                    <tr>
                        <td>Taxa de cirurgias com uso de neuronavegador ( total que usaram neuronavegador / total de neurocirurgias no periodo )</td>
                        <td> 0% </td>
                    </tr> 

                    <tr>
                        <td colspan="2" class="title" style="font-weight: bold" >
                            Uso de neuronavegador por cirurgião
                        </td>
                    </tr>                    
                    <tr class="tr-indent">
                        <td>&#8226;  </td>                            
                        <td> 0 </td>
                    </tr>

                    <tr>
                        <td>Total de preenchimento de checklist</td>
                        <td> 0 </td>
                    </tr> 

                    <tr>
                        <td>Taxa de preenchimento de checklist ( total de cirurgias com checklist prenchido / total de cirurgias )</td>
                        <td> 0 </td>
                    </tr> 

                    <!-- <tr>
                        <td>Taxa de mortalidade peroperatória ( total de obitos em cirurgia / total de cirurgias )</td>
                        <td> 0% </td>
                    </tr> 

                    <tr>
                        <td>Taxa de mortalidade peroperatória por porte de cirurgia ( total de obitos em cirurgia  por porte/ total de óbitos em cirurgias ) </td>
                        <td></td>
                    </tr>  



                    <tr>
                        <td>Taxa de mortalidade peroperatória especialidade cirurgica ( total de obitos em cirurgia por especialidade  / total de óbito em cirurgias )</td>
                        <td></td>
                    </tr> 

                    <tr>
                        <td>Taxa de mortalidade peroperatóriapor tipo de cirurgia rot urgência e emergência ( total de obitos em cirurgia  por tipo de cirurgia / total de óbitos em cirurgias )</td>
                        <td></td>
                    </tr> 
                    -->

                    <tr>
                        <td>Taxa de infecção por ortese e protese</td>
                        <td> <?= $data['taxa_infeccao_ortese_protese'] ?> </td>
                    </tr> 

                    


                <tbody>
            </table>

            <div id="piechart" style="width: 100%; height: 500px;"></div>
        </div>
    </body>

    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
     <script type="text/javascript">
      google.charts.load('current', {'packages':['corechart']});
      google.charts.setOnLoadCallback(drawChart);

      function drawChart() {

        var data = google.visualization.arrayToDataTable([
            
          ['Task', 'Hours per Day'],
          <?php 
            foreach($data['anestesias'] as $anesthesia) 
            {
                echo "['" . $anesthesia['name'] ."', ".$anesthesia['total']."],";

            } 
            ?>
        ]);

        var options = {
          title: 'Tipos de anestesia realizados no período',
          sliceVisibilityThreshold: 0
        };

        var chart = new google.visualization.PieChart(document.getElementById('piechart'));

        chart.draw(data, options);
      }
    </script>
</html>