<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <?=$this->Html->css('pdf', ['fullBase' => true]);?>
    <?=$this->fetch('css')?>
</head>
<body>
<?=$this->element('header-logo', ['report_title' => 'Relatório de TEV Cirúrgico']);?>
    <div class="container">
        <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
            <thead>
                <tr>
                     <th class="title  th-left">Item</th>
                     <th class="title  th-left">Valor</th>
                     <th class="title  th-left">%</th>
                     <!--
                     <?php foreach ($data['dates'] as $key => $month): ?>
                         <th class="title th-spread"> <?=$month_name[$key];?>  </th>
                     <?php endforeach;?>
                     -->
              </tr>
            </thead>
            <tbody>
                <tr>
                    <td>
                        Taxa de adesão ao protocolo de TEV
                    </td>
                    <td>--</td>
                    <td><?=$data['consolidado']['taxa_adesao_protocolo_tev']?></td>
                </tr>
                <tr>
                    <td colspan="3" style="font-weight: bold; text-align: center;">
                        Taxa de adesão ao protocolo de TEV por setor
                    </td>
                </tr>
                    <?php
                        if(!empty($data['consolidado']['paciente_protocolo_tev']['setor'])){
                            foreach ($data['consolidado']['paciente_protocolo_tev']['setor'] as $key => $setor) {
                                if(!empty($setor['name'])){
                                    ?>
                                    <tr>
                                        <td><?=$setor['name']?></td>
                                        <td>--</td>
                                        <td><?=$setor['percentual']?></td>
                                    </tr>
                                    <?php
                                }
                            }
                        }
                    ?>
                </tr>

                <tr>
                    <td>
                        Valor total de pacientes com risco baixo
                    </td>
                    <td><?=$data['consolidado']['risco_baixo']['tot']?></td>
                    <td><?=$data['consolidado']['risco_baixo']['percen']?></td>
                </tr>

                <tr>
                    <td>
                        Valor total de pacientes com risco intermediário
                    </td>
                     <td><?=$data['consolidado']['risco_intermediario']['tot']?></td>
                    <td><?=$data['consolidado']['risco_intermediario']['percen']?></td>
                </tr>


                <tr>
                    <td>
                        Valor total de pacientes com risco alto
                    </td>
                    <td><?=$data['consolidado']['risco_alto']['tot']?></td>
                    <td><?=$data['consolidado']['risco_alto']['percen']?></td>
                </tr>


                <tr>
                    <td>
                        Pacientes com risco para tev
                    </td>
                    <td><?=$data['consolidado']['tot_pacientes_tev']?></td>
                    <td><?=$data['consolidado']['percen_pacientes_tev']?></td>
                </tr>

                <tr>
                    <td>
                        Contra indicação para profilaxia de TEV
                    </td>
                    <td><?=$data['consolidado']['countContraIndicacaoParaProfilaxiaTev']?></td>
                    <td><?=$data['consolidado']['percentualContraIndicacaoParaProfilaxiaTev']?></td>
                </tr>

                <tr>
                    <td>
                        Taxa de uso de profilaxia medicamentosa
                    </td>
                    <td><?=$data['consolidado']['paciente_profi_medi']['tot']?></td>
                    <td><?=$data['consolidado']['paciente_profi_medi']['percen']?></td>
                </tr>

                <tr>
                    <td>
                        Taxa de uso de profilaxia mecânica
                    </td>
                    <td><?=$data['consolidado']['paciente_profi_meca']['tot']?></td>
                    <td><?=$data['consolidado']['paciente_profi_meca']['percen']?></td>
                </tr>

                <tr>
                    <td>
                        Taxa de não uso de profilaxia em pacientes com risco
                    </td>
                    <td><?=$data['consolidado']['paciente_nao_usou_profilaxia']['tot']?></td>
                    <td><?=$data['consolidado']['paciente_nao_usou_profilaxia']['percen']?></td>
                </tr>

                <tr>
                    <td>
                        Tempo médio de uso de profilaxia
                    </td>
                    <td><?=$data['consolidado']['temp_prof']['tot']?> dias</td>
                    <td>-</td>
                </tr>

                <tr>
                    <td>
                        Tempo médio de uso de profilaxia medicamentosa
                    </td>
                    <td><?=$data['consolidado']['temp_prof_medi']['tot']?></td>
                    <td>-</td>
                </tr>

                <tr>
                    <td>
                        Tempo médio de uso de profilaxia mecânica
                    </td>
                    <td><?=$data['consolidado']['temp_prof_meca']['tot']?> d</td>
                    <td>-</td>
                </tr>

                <tr>
                    <td>
                        Taxa de mortalidade nos pacientes que não receberam profilaxia
                    </td>
                    <td><?=$data['consolidado']['tot_paciente_risco_obito']?> </td>
                    <td><?=$data['consolidado']['percen_paciente_risco_obito']?> </td>

                </tr>

                <tr>
                    <td colspan="3" style="font-weight: bold; text-align: center;">Principais contra indicações para profilaxia de TEV</td>
                </tr>

                <?php
                    $count = 0;
                    foreach ($data['consolidado']['data_principais'] as $key => $principal) {
                        foreach ($principal as $key_2 => $value) {
                            if($count < 10){
                                echo "<tr>";
                                    echo "<td>" . $value['nome'] . "</td>";
                                    echo "<td>" .$value['total'] . "</td>";
                                    echo "<td>" .$value['percentual'] . "</td>";
                                echo "</tr>";
                            }
                            $count++;
                        }
                    }
                ?>

                <tr>
                    <td colspan="3" style="font-weight: bold; text-align: center;">10 principais fatores de risco identificados para TEV</td>
                </tr>

                <?php
                    foreach ($data['consolidado']['fator_risco'] as $key => $fator_risco) {
                        echo "<tr>";
                            echo "<td>" . $fator_risco['nome'] . "</td>";
                            echo "<td>" .$fator_risco['count'] . "</td>";
                            echo "<td>" .$fator_risco['percentual'] . "</td>";
                        echo "</tr>";
                    }
                ?>
            </tbody>
        </table>
    </div>
</body>
</html>