<?php
echo $this->element( 'internacao-menu' );

	$from = new DateTime($patient['birthday']->i18nFormat('dd-MM-yyyy'));
 	$to   = new DateTime('today');
 	$age = null;
 	$age = $from->diff($to)->y;
?>

<div class="bundles form col-md-9 columns content">
    <?= $this->Html->link(__('Impressão'), ['action' => 'printView', $sapsIiiScore->id], ['class'=>'btn btn-primary pull-right','target'=>'blank','style'=>'margin-right:2%;margin-bottom:2%;']);
    ?>
</div>

<div class="sapsIiiScores form col-md-9 columns content">
	<?= $this->Form->create($sapsIiiScore) ?>
	<fieldset>

		<?php

		if($sapsIiiScore->data_de_realizacao){
			$sapsIiiScore->data_de_realizacao = $sapsIiiScore->data_de_realizacao->format('d/m/Y');
		}

		$ph_opt=['<=7,25'=>'<=7,25','>7,25' => '>7,25'];
		$comorbidades = ['Outras'=>'Outras', 'Quimioterapia'=>'Quimioterapia', 'ICC NYHA IV'=>'ICC NYHA IV', 'Neoplasia hematológica'=>'Neoplasia hematológica', 'Cirrose'=>'Cirrose', 'Aids'=>'Aids', 'Metástase'=>'Metástase'];

		$tempo_de_estadia=['<14'=>'<14', '>=14<28'=>'>=14<28', '>=28'=>'>=28'];
		$origem_intra = ['Centro cirúrgico'=>'Centro cirúrgico', 'Emergência'=>'Emergência', 'Outra UTI'=>'Outra UTI', 'Outros'=>'Outros'];
		$uso_das_principais =['Sim'=>'Sim', "Não"=>"Não"];

		$admissao_na_uti = ['Sim'=>'Sim', 'Não'=>'Não'];

		$motivo_para_a_admissao = [
			'Neurológicas' => [
				1 => 'Convulsões',
				2 => 'Coma,confusão mental ou agitação',
				3 => 'Déficit Focal',
				4 => 'Efeito de massa intracraniana'
			],
			'Cardiológicas' => [
				5 => 'Arritmia',
				6 => 'Choque hemorrágico',
				7 => 'Choque hipovolêmico não hemorrágico',
				8 => 'Choque distributivo'
			],
			'Abdômen' => [
				9 => 'Abdômen agudo',
				10 => 'Pancreatite grave',
				11 => 'Falência hepática',
				12 => 'Outras'
			]
		];

		$status_cirurgica_na_admissao_da_uti=['Cirurgia agendada'=>'Cirurgia Agendada', 'Sem cirurgia'=>'Sem Cirurgia', 'Cirurgia Emergencia'=>'Cirurgia Emergencia'];
		$localizacao_anatomica =['cirurgia de transplante: fígado, rim, pâncreas, rim e pâncreas, Transplantation outra'=>'Cirurgia de Transplante: Fígado, Rim, Pâncreas, Rim e pâncreas, Transplantation Outra', 'Trauma - Outros, isolado: (inclui Tórax, Abdome, membro); Trauma - Multiple'=>'Trauma - Outros, Isolado: (inclui Tórax, Abdome, Membro); Trauma - Multiple', 'cirurgia cardíaca: revascularização do miocárdio sem reparo valvular'=>'Cirurgia Cardíaca: Revascularização do Miocárdio Sem Reparo Valvular', 'Neurosurgery: acidente vascular cerebral'=>'Neurosurgery: Acidente Vascular Cerebral', 'Outros'=>'Outros'];
		$infeccao_aguda = ['Nosocomial'=>'Nosocomial', 'Respiratória'=>'Respiratória', 'Outras'=>'Outras'];
		$gcs_estimado_menor = ['3-4'=>'3-4', '5'=>'5', '6'=>'6', '7-12'=>'7-12', '>13'=>'>13'];
		$total_de_bilirubine = ['< 2'=>'< 2', '>=2 < 6'=>'>=2 < 6', '>= 6'=>'>= 6'];
		$temperatura_corporal= ['< 34.5'=>'< 34.5', '>= 34.5'=>'>= 34.5'];
		$creatina=['<1.2'=>'<1.2', '>=1.2 < 2'=>'>=1.2 < 2', '>= 2 < 3.5'=>'>= 2 < 3.5', '>= 3.5'=>'>= 3.5'];
		$frequencia_cardiaca=['<120'=>'<120', '>=120<160'=>'>=120<160', '>=160'=>'>=160'];
		$leucocitos_menor=['<15.000'=>'<15.000', '>=15.000'=>'>=15.000'];
		$concentracao_de_ion=['<=7.25'=>'<=7.25', '>7.25'=>'>7.25'];
		$plaquetas_menor=['<20'=>'<20', '>=20<50'=>'>=20<50', '>=50<100'=>'>=50<100', '>=100'=>'>=100'];
		$pressao_sanguinea=['<40'=>'<40', '>=40<70'=>'>=40<70', '>=70<120'=>'>=70<120', '>=120'=>'>=120'];
		$oxigenacao=[
			'VM relação PaO2/FiO2<100'=>'VM relação PaO2/FiO2 < 100',
			'VM relação >= 100' =>'VM relação >= 100',
			'Sem VM PaO2<60'    =>'Sem VM PaO2<60',
			'Sem VM PaO2>=60'   =>'Sem VM PaO2>=60'
		];

		$caracteristica_da_cirurgia =['Transplantes', 'Trauma', 'Revascularização do miocárdio sem reparo valvar', 'Cirurgia no AVC', 'Outras'];

		$glasgow = ['15'=>'15', '14' =>'14', '13'=>'13', '12'=>'12', '11'=>'11', '10'=>'10', '9'=>'9', '8'=>'8', '7'=>'7', '6'=>'6', '5'=>'5', '4'=>'4', '3'=>'3'];

				  echo $this->Form->input('data_de_realizacao', ['class'=>'date','type' => 'text','label'=>['text'=>'Data de realização:', 'class'=>'form-input'] ]);

					echo $this->Form->input('idade', ['id'=>'age','disabled'=>true, 'value'=>$age, 'label'=>['text'=>'Idade:', 'class'=>'form-input'] ]);

					echo $this->Form->input('comorbidades', ['class'=>'item19', 'empty'=>true,'options'=>$comorbidades, 'label'=>['text'=>'Comorbidades:', 'class'=>'form-input'] ]);

				 echo "<div class='funkyradio'>";
					 echo '<div class="funkyradio-primary">';
			        echo $this->Form->checkbox('houve_admissao_na_uti', ['id'=>'houve_admissao_na_uti']);
			        echo '<label for="houve_admissao_na_uti">Houve admissão na UTI</label>';
			     echo "</div>";
					echo "</div>";
					echo "</br></br>";

		      echo "<div class='houve_admissao_na_uti' style='display:none;'>";

						echo $this->Form->input('tempo_de_estadia_antes_a_adimissao_na_uti', ['class'=>'item1', 'empty'=>true,'options'=>$tempo_de_estadia, 'label'=>['text'=>'Tempo de estadia antes da admissão na UTI (dias):', 'class'=>'form-input'] ]);

						echo $this->Form->input('origem_intra_hospitalar_antes_da_admissao_na_uti', ['class'=>'item2', 'empty'=>true,'options'=>$origem_intra, 'label'=>['text'=>'Origem intra-hospitalar antes da admissão na UTI:', 'class'=>'form-input'] ]);

						echo $this->Form->input('motivo_para_a_admissao_na_uti', ['class'=>'item5', 'empty'=>true,'options'=>$motivo_para_a_admissao, 'label'=>['text'=>'Motivo da internação:', 'class'=>'form-input'] ]);


						echo $this->Form->input('admissao_na_uti_foi_planejada', ['class'=>'item4', 'empty'=>true,'options'=>$admissao_na_uti, 'label'=>['text'=>'A admissão na UTI foi planejada', 'class'=>'form-input'] ]);

					 echo $this->Form->input('infeccao_aguda_na_admissao_da_uti', ['class'=>'item8', 'empty'=>true,'options'=>$infeccao_aguda, 'label'=>['text'=>'Infecção presente na admissão da UTI:', 'class'=>'form-input'] ]);

		      echo "</div>";


					echo $this->Form->input('uso_das_principais_opcoes_terapeuticas', ['class'=>'item3', 'empty'=>true,'options'=>$uso_das_principais, 'label'=>['text'=>'Uso de drogas vasoativas:', 'class'=>'form-input'] ]);

					echo $this->Form->input('tipo_internacao', ['id'=>'tipo_internacao','disabled'=>true, 'value'=>$hospitalization['type'], 'label'=>['text'=>'Tipo de internação:', 'class'=>'form-input'] ]);

					echo $this->Form->input('caracteristica_da_cirurgia', ['class'=>'item20', 'empty'=>true,'options'=>$caracteristica_da_cirurgia, 'label'=>['text'=>'Característica da cirurgia:', 'class'=>'form-input'] ]);


					echo $this->Form->input('glasgow', ['class'=>'item21',  'empty'=>true,'options'=>$glasgow, 'label'=>['text'=>'Escala de coma de Glasgow (menor valor):', 'class'=>'form-input'] ]);

					echo $this->Form->input('total_de_bilirubine', ['class'=>'item10','empty'=>true,'options'=>$total_de_bilirubine, 'label'=>['text'=>'Valor da bilirrubina total (mg/dl):', 'class'=>'form-input'] ]);


					echo $this->Form->input('temperatura_corporal', ['class'=>'item11','empty'=>true,'options'=>$temperatura_corporal, 'label'=>['text'=>'Temperatura corporal ºC ( maior valor):', 'class'=>'form-input'] ]);

					echo $this->Form->input('creatina', ['class'=>'item12', 'empty'=>true,'options'=>$creatina, 'label'=>['text'=>'Creatinina sérica (maior valor):', 'class'=>'form-input'] ]);

					echo $this->Form->input('leucocitos_menor', ['class'=>'item14', 'empty'=>true,'options'=>$leucocitos_menor, 'label'=>['text'=>'Leucócitos (menor) G/L:', 'class'=>'form-input'] ]);

					echo $this->Form->input('ph', ['class'=>'item22', 'empty'=>true,'options'=>$ph_opt, 'label'=>['text'=>'pH:', 'class'=>'form-input'] ]);

					echo $this->Form->input('plaquetas_menor', ['class'=>'item16', 'empty'=>true,'options'=>$plaquetas_menor, 'label'=>['text'=>'Plaquetas (menor valor):', 'class'=>'form-input'] ]);

				 	//echo $this->Form->input('status_cirurgica_na_admissao_da_uti', ['class'=>'item6', 'empty'=>true,'options'=>$status_cirurgica_na_admissao_da_uti, 'label'=>['text'=>'Status Cirúrgica na Admissão da UTI:', 'class'=>'form-input'] ]);

					//echo $this->Form->input('localizacao_anatomica_da_cirurgia', ['class'=>'item7', 'empty'=>true,'options'=>$localizacao_anatomica, 'label'=>['text'=>'Localização anatômica da cirurgia:', 'class'=>'form-input'] ]);

				//echo $this->Form->input('gcs_estimado_menor', ['class'=>'item9', 'empty'=>true,'options'=>$gcs_estimado_menor, 'label'=>['text'=>'GCS estimado (menor):', 'class'=>'form-input'] ]);

				//echo $this->Form->input('concentracao_de_ion_hidrogenio_menor', ['class'=>'item15', 'empty'=>true,'options'=>$concentracao_de_ion, 'label'=>['text'=>'Concentração de Ion Hidrogênio (menor):', 'class'=>'form-input'] ]);

				echo $this->Form->input('pressao_sanguinea_sistolica', ['class'=>'item17', 'empty'=>true,'options'=>$pressao_sanguinea, 'label'=>['text'=>'Pressão arterial sistólica mmHg (menor valor):', 'class'=>'form-input'] ]);

				echo $this->Form->input('frequencia_cardiaca_mais_alta', ['class'=>'item13', 'empty'=>true,'options'=>$frequencia_cardiaca, 'label'=>['text'=>'Frequência cardíaca:', 'class'=>'form-input'] ]);

			 echo $this->Form->input('oxigenacao', ['class'=>'item18', 'empty'=>true,'options'=>$oxigenacao, 'label'=>['text'=>'Oxigenação:', 'class'=>'form-input'] ]);

			 echo $this->Form->hidden('hospitalization_id', ['value' => $hospitalization_id]);

			 echo $this->Form->hidden('active', ['value'=>1]);

			 echo $this->Form->input('pontuation', ['class'=>"hide", 'label'=>false, 'id'=>'pontuation-id']);

			 echo $this->Form->hidden('saps_iii_score', ['id'=>'saps_iii_score']);

		?>

		<h3 id="apache" style="display:inline-block">Probabilidade de óbito: 0%  </h3>
		<span style="font-size:0.9em">&nbsp;&nbsp;(Probabilidade ajustada para a America Latina)</span>
		<h3 id="apache_ptos">Pontuação: 0</h3>
	</fieldset>
	<button type="button" class="btn btn-danger" onclick="goBack()">Cancelar</button>
	<?= $this->Form->button(__('Salvar')) ?>
	<?= $this->Form->end() ?>
	<br><br><br><br><br><br>
</div>


<script>
if ($('#houve_admissao_na_uti').is(':checked')) {
	$(".houve_admissao_na_uti").slideDown();
}

$("#houve_admissao_na_uti").change(function(){

			if ( $(this).is(':checked') ){
					$(".houve_admissao_na_uti").slideDown({
							duration: 500,
							easing: "easeOutQuad"
					});
			}
			else{

					$("#infeccao-aguda-na-admissao-da-uti").val('').trigger("change");
					$("#admissao-na-uti-foi-planejada").val('').trigger("change");
					$("#motivo-para-a-admissao-na-uti").val('').trigger("change");
					$("#origem-intra-hospitalar-antes-da-admissao-na-uti").val('').trigger("change");
					$("#tempo-de-estadia-antes-a-adimissao-na-uti").val('').trigger("change");
					$("#origem-intra-hospitalar-antes-da-admissao-na-uti").val('').trigger("change");

					$(".houve_admissao_na_uti").slideUp({
						duration: 500,
						easing: "easeOutQuad"
					});

			}
	});


$( document ).ready(function() {
	$("select").trigger("change");
});

$('#houve_admissao_na_uti').change(function(){
	$("select").trigger("change");
});


$( "select" ).change(function(){

	var apache = 0;

	console.log("Antes do teste: "+apache);

	$('#houve_admissao_na_uti').change(function(){
		if($(this).is(":checked")){
	     apache += 16;
			 //console.log("Depois do teste: "+apache);
	   }
	});

	if($('#houve_admissao_na_uti').is(":checked")){
		apache += 16;
		console.log("Depois do teste: "+apache);
	}
	//console.log($(elem).val());

	$( "select" ).each(function( index )
	{
		if ($( this ).hasClass( "item1" ))
		{
			switch($(this).val())
			{
				case '>=14<28':
				apache += 6;
				break;
				case '>=28':
				apache += 7;
				break;

			}
		}

		else if ($( this ).hasClass( "item2" ))
		{
			switch($(this).val())
			{
				case 'Emergência':
				apache += 5;
				break;
				case 'Outros':
				apache += 8;
				break;
				case 'Outra UTI':
				apache += 7;
				break;
			}
		}
		else if ($( this ).hasClass( "item3" ))
		{
			switch($(this).val())
			{
				case 'Não':
				apache += 3;
				break;
			}
		}
		else if ($( this ).hasClass( "item4" ))
		{
			switch($(this).val())
			{
				case 'Não':
				apache += 3;
				break;
			}
		}


		else if ($( this ).hasClass( "item5" ))
		{
			switch($(this).val())
			{
				case '1':
				apache += -4;
				break;
				case '2':
				apache += 4;
				break;
				case '3':
				apache += 7;
				break;
				case '4':
				apache += 11;
				break;
				case '5':
				apache += -5;
				break;
				case '6':
				apache += 3;
				break;
				case '7':
				apache += 3;
				break;
				case '8':
				apache += 5;
				break;
				case '9':
				apache += 3;
				break;
				case '10':
				apache += 9;
				break;
				case '11':
				apache += 6;
				break;
			}
		}
		/*
		else if ($( this ).hasClass( "item6" ))
		{
			switch($(this).val())
			{
				case 'Sem cirurgia':
				apache += 3;
				break;
				case 'Cirurgia Emergencia':
				apache += 5;
				break;

			}
		}
		else if ($( this ).hasClass( "item7" ))
		{
			switch($(this).val())
			{
				case 'cirurgia de transplante: fígado, rim, pâncreas, rim e pâncreas, Transplantation outra':
				apache += -11;
				break;
				case 'Trauma - Outros, isolado: (inclui Tórax, Abdome, membro); Trauma - Multiple':
				apache += -8;
				break;
				case 'cirurgia cardíaca: revascularização do miocárdio sem reparo valvular':
				apache += -6;
				break;
				case 'Neurosurgery: acidente vascular cerebral':
				apache += 5;
				break;
			}
		}
		else if ($( this ).hasClass( "item8" ))
		{
			switch($(this).val())
			{
				case 'Nosocomial':
				apache += 4;
				break;
				case 'Respiratória':
				apache += 5;
				break;

			}
		}
		else if ($( this ).hasClass( "item9" ))
		{
			switch($(this).val())
			{
				case '3-4':
				apache += 15;
				break;
				case '5':
				apache += 10;
				break;
				case '6':
				apache += 8;
				break;
				case '7-12':
				apache += 2;
				break;

			}
		}*/
		else if ($( this ).hasClass( "item11" ))
		{
			switch($(this).val())
			{

				case '< 34.5':
				apache += 7;
				break;
			}
		}
		else if ($( this ).hasClass( "item10" ))
		{
			switch($(this).val())

			{
				case '>=2 < 6':
				apache += 4;
				break;
				case '>= 6':
				apache += 5;
				break;
			}
		}

		else if ($( this ).hasClass( "item12" ))
		{
			switch($(this).val())
			{

				case '>=1.2 < 2':
				apache += 2;
				break;

				case '>= 2 < 3.5':
				apache += 7;
				break;

				case '>= 3.5':
				apache += 8;
				break;
			}
		}

		else if ($( this ).hasClass( "item13" ))
		{
			switch($(this).val())
			{
				case '>=120<160':
				apache += 5;
				break;
				case '>=160':
				apache += 2;
				break;
			}
		}


		else if ($( this ).hasClass( "item14" ))
		{
			switch($(this).val())
			{
				case '>=15.000':
				apache += 2;
				break;

			}
		}

		/*else if ($( this ).hasClass( "item15" ))
		{
			switch($(this).val())
			{
				case '14':
				apache += 1;
				break;
				case '13':
				apache += 2;
				break;
				case '13':
				apache += 3;
				break;
				case '11':
				apache += 4;
				break;
				case '10':
				apache += 5;
				break;
				case '9':
				apache += 6;
				break;
				case '8':
				apache += 7;
				break;
				case '7':
				apache += 8;
				break;
				case '6':
				apache += 9;
				break;
				case '5':
				apache += 10 ;
				break;
				case '4':
				apache += 11;
				break;
				case '3':
				apache += 12;
				break;
			}
		}
  */

		else if ($( this ).hasClass( "item16" ))
		{
			switch($(this).val())
			{
				case '<20.000':
				apache += 13;
				break;
				case '>=20.0000 < 50.000':
				apache += 8;
				break;
				case '>=50<100':
				apache += 5;
				break;
			}
		}

		else if ($( this ).hasClass( "item17" ))
		{
			switch($(this).val())
			{
				case '<40':
				apache +=11;
				break;
				case '>=40<70':
				apache += 8;
				break;
				case '>=70<120':
				apache += 3;
				break;
			}
		}

		else if ($( this ).hasClass( "item18" ))
		{
			switch($(this).val())
			{
				case 'VM relação PaO2/FiO2<100':
				apache +=11;
				break;
				case 'VM relação >= 100':
				apache += 7;
				break;
				case 'Sem VM PaO2<60':
				apache += 5;
				break;
			}
		}

		else if ($( this ).hasClass( "item19" ))
		{
			switch($(this).val())
			{
				case 'Quimioterapia':
				apache +=3;
				break;
				case 'ICC NYHA IV':
				apache += 6;
				break;
				case 'Neoplasia hematológica':
				apache += 6;
				break;

				case 'Cirrose':
				apache += 8;
				break;

				case 'Aids':
				apache += 8;
				break;

				case 'Metástase':
				apache += 11;
				break;

			}
		}

		else if ($( this ).hasClass( "item20" ))
		{
			switch($(this).val())
			{
				case '0':
				apache += -11;
				break;
				case '1':
				apache += -8;
				break;
				case '2':
				apache += -6;
				break;
				case '3':
				apache += 5;
				break;
			}
		}

		else if ($( this ).hasClass( "item21" ))
		{
			var glasgow = parseInt($(this).val());

			if (glasgow == 3 || glasgow == 4) {
				apache += 15;
			}
			else if (glasgow == 5) {
				apache += 10;
			}
			else if (glasgow == 6) {
				apache += 7;
			}
			else if (glasgow >= 7 && glasgow <= 12) {
				apache += 2;
			}
		}

		else if ($( this ).hasClass( "item22" ))
		{
			switch($(this).val())
			{
				case '<=7,25':
				apache += 3;
				break;

			}
		}

	});

	var tipo_internacao =  $('#tipo_internacao').val();

	if ( !tipo_internacao.includes("Cirúrgica") ) {
		apache += 5;
	}

	if ( tipo_internacao.includes("Emergencial") ) {
		apache += 6;
	}


	var age =  parseInt($('#age').val());

	if (!isNaN(age)) {
		if (age < 40) {

		}
		else if (age < 60) {
			apache += 5;
		}

		else if (age < 70) {
			apache += 9;
		}

		else if (age < 75) {
			apache += 13;
		}

		else if (age < 80) {
			apache += 15;
		}

		else if (age >= 80 ) {
			apache += 18;
		}

	}



	// function CalcMort(form) {
	// z = eval(form.zigs.value)
	// z = -7.7631+0.0737*z+0.9971*(Math.log(z+1))
	// z = Math.exp(z)/(1 + Math.exp(z))
	// z = Fmt(100 * z) + " %"
	// return z
	// }


	  //Logit = -3,517+( Apache II) * 0,146
  var deathRate = 0;
  var logit     = 0;
  var MortAS    = 0;


	//logit = ( -23.8501 +(apache +5) ) * 5;

	logit = -32.6659+(Math.log(apache+20.5958))*7.3068;

  if ( apache > 0)
  {

	//logit = -3.517 + apache * (0.146);
	//deathRate = Math.exp(logit) / (1 + Math.exp(logit));

	//Mortalidad prevista SAPS 3 = e(Logit)/(1+e(Logit)) donde Logit = -32.6659+ln(SAPS 3 score+20.5958)*7.3068
  //Ajuste por zonas geográfica: Central-South America Logit= 64.5990 + ln (SAPS 3 score + 71.0599) x 13.2322

		MortAS = -64.5990+((Math.log(apache+71.0599))*13.2322);
		MortAS = Math.exp(MortAS )  / (1 + Math.exp(MortAS));

		deathRate = MortAS*100;
		deathRate = deathRate.toFixed(2);

  }

	console.log("apache = "+apache);

	$('#apache_ptos').text("Pontuação: "+ apache);

	$('#apache').text("Probabilidade de morte: "+ deathRate +"%");

	$('#saps_iii_score').val(deathRate);
	$('#pontuation-id').val(apache);



});









(function() {
	// your page initialization code here
	// the DOM will be available here

	var link1 =' <?= $this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
	array('controller' => 'Users', 'action' => 'login'), array('class'=>'btn btn-default ', 'escape' => false)) ?> ';

	var link2 =' <?= $this->Html->link('Pacientes',['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class'=>'btn btn-default ']); ?> ';

	var link3 =' <?= $this->Html->link('Internação',['controller' => 'hospitalizations', 'action' => 'edit', $hospitalization_id, '_full' => true], ['class'=>'btn btn-default ']); ?> ';

	var link4 =' <?= $this->Html->link('Escores',['controller' => 'ApacheIiScores', 'action' => 'index', '_full' => true], ['class'=>'btn btn-default ']); ?> ';

	var html = '';
	html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
	html+= link1;
	html+= link2;
	html+= link3;
	html+= link4;
	html+= '<a href="#" class="breadcumb-active btn btn-default">Editar SAPS III</a>';
	html+= '</div>';
	document.getElementById("breadcumb").innerHTML =html;
})();
</script>
