<?php
$units =  array( $unit_id =>'unidade' );
?>

<br><br>
<div class="row">
    <div class="sectors form col-md-10 col-centered columns content">
        <?= $this->Form->create($sector, ['type' => 'file']) ?>
        <fieldset>
            <legend><h3 class="big-title"><?= 'Adicionar Setor' ?></h3></legend>
            <br>

            <?php
            $options = [];

            foreach ($types as $key => $value) 
            {
                $options[$value->id] = $value->description;
            }

            echo $this->Form->input('name', ['label'=>['text'=>'Nome do Setor:','class'=>'form-input mandatory'], 'type'=>'text']);
            echo $this->Form->input('limit_of_rooms', ['label'=>['text'=>'Número de Leitos:','class'=>'form-input  mandatory'], 'type'=>'number', 'default'=>1, 'min'=>1, 'max'=>999, 'step'=>1, 'maxlength'=>3]);

            $indicadores_arr = 
            [
                "terapia_intensiva"=>
                [
                    ['input'=>'indicators_sectors.taxa_ocupacao', 'text'=>'Taxa de ocupação:'],
                    ['input'=>'indicators_sectors.aas_mg', 'text'=>'AAS MG:'],
                    ['input'=>'indicators_sectors.indice_giro_leito', 'text'=>'Índice giro de leito:'],
                    ['input'=>'indicators_sectors.intervalo_substituicao', 'text'=>'Intervalo de substituição:'],
                    ['input'=>'indicators_sectors.tempo_medio_permanencia', 'text'=>'Tempo Médio de Permanência:', 'class'=>'time'],
                    ['input'=>'indicators_sectors.taxa_reinternacao', 'text'=>'Taxa de Reinternação:'],
                    ['input'=>'indicators_sectors.taxa_reinternacao_24h', 'text'=>'Taxa de Reinternação em <24 horas:'],
                    ['input'=>'indicators_sectors.taxa_saida_hospitalar', 'text'=>'Taxa de Saída Hospitalar:'],
                    ['input'=>'indicators_sectors.taxa_mortalidade', 'text'=>'Taxa de Mortalidade:'],
                    ['input'=>'indicators_sectors.taxa_mortalidade_cirurgico', 'text'=>'Taxa de Mortalidade Pacientes Cirúrgicos:'],
                    ['input'=>'indicators_sectors.taxa_letalidade', 'text'=>'Taxa de Letalidade Padronizada:'],
                    ['input'=>'indicators_sectors.taxa_infeccao_corrente', 'text'=>'Taxa de Infecção de Corrente Sanguínea por Cateter Vascular:'],
                    ['input'=>'indicators_sectors.densidade_cateter_vascular', 'text'=>'Densidade de Uso de Cateter Vascular:'],
                    ['input'=>'indicators_sectors.taxa_infeccao_trato', 'text'=>'Taxa de Infecção de Trato Urinário por Cateter Vesical:'],
                    ['input'=>'indicators_sectors.densidade_cateter_vesical', 'text'=>'Densidade de Uso de Cateter Vesical:'],
                    ['input'=>'indicators_sectors.taxa_penumonia', 'text'=>'Taxa de Pneumonia Associada a Ventilação Mecânica:'],
                    ['input'=>'indicators_sectors.densidade_ventilacao', 'text'=>'Densidade de Uso de Ventilação Mecânica:'],
                    ['input'=>'indicators_sectors.relacao_head', 'text'=>'Relação Head / Bed:'],
                    ['input'=>'indicators_sectors.consumo_total', 'text'=>'Consumo Total:'],
                    ['input'=>'indicators_sectors.consumo_diario', 'text'=>'Consumo Diário:'],
                    ['input'=>'indicators_sectors.consumo_por_paciente', 'text'=>'Consumo Diário por Paciente:'],
                    ['input'=>'indicators_sectors.ticket_total', 'text'=>'Ticket Total:'],
                    ['input'=>'indicators_sectors.ticket_medio_diario', 'text'=>'Ticket Médio Diário:'],
                    ['input'=>'indicators_sectors.ticket_medio_diario_paciente', 'text'=>'Ticket Médio Diário por Paciente:'],
                    ['input'=>'indicators_sectors.ticket_internacao', 'text'=>'Ticket por Internação:'],
                    ['input'=>'indicators_sectors.ticket_internacao_paciente', 'text'=>'Ticket por Internação por Paciente:'],
                    ['input'=>'indicators_sectors.glossa_total', 'text'=>'Valor de Glossa Total:'],
                    ['input'=>'indicators_sectors.glossa_media_paciente', 'text'=>'Glossa Média por Paciente:'],
                ],

                "setor_emergencia"=>
                [
                    ['input'=>'indicators_sectors.total_atendimentos_mes', 'text'=>'Total de Atendimentos da Emergência mês:'],
                    ['input'=>'indicators_sectors.tempo_chegada_triagem', 'text'=>'Tempo Médio de Chegada e Triagem:', 'class'=>'time'],
                    ['input'=>'indicators_sectors.tempo_chegada_atendimento', 'text'=>'Tempo Médio de Chegada e 1º Atendimento:', 'class'=>'time'],
                    ['input'=>'indicators_sectors.tempo_permanencia_emergencia', 'text'=>'Tempo Médio de Permanência na Emergência:', 'class'=>'time'],
                    ['input'=>'indicators_sectors.taxa_captacao_emergencia', 'text'=>'Taxa de Captação da Emergência Total e para Unidade de Internação e UTI:'],
                    ['input'=>'indicators_sectors.taxa_mudanca_cor', 'text'=>'Taxa de Mudança da Cor da Triagem:'],
                    ['input'=>'indicators_sectors.taxa_nao_adesao', 'text'=>'Taxa de Não Adesão ao Protocolo Sugerido na Triagem:'],
                    ['input'=>'indicators_sectors.taxa_transferencia_hospitalar', 'text'=>'Taxa de Transferência Hospitalar:'],
                    ['input'=>'indicators_sectors.taxa_obito_emergencia', 'text'=>'Taxa de Óbito na Emergência:'],
                    ['input'=>'indicators_sectors.taxa_revisita_2', 'text'=>'Taxa de Revisita da Emergência em até 2 dias:'],
                    ['input'=>'indicators_sectors.taxa_revisita_7', 'text'=>'Taxa de Revisita da Emergência em até 7 dias:'],
                    ['input'=>'indicators_sectors.consumo_total', 'text'=>'Consumo Total:'],
                    ['input'=>'indicators_sectors.consumo_diario', 'text'=>'Consumo Diário:'],
                    ['input'=>'indicators_sectors.consumo_diario_paciente', 'text'=>'Consumo Diário por Paciente:'],
                    ['input'=>'indicators_sectors.ticket_total', 'text'=>'Ticket Total:'],
                    ['input'=>'indicators_sectors.ticket_medio_diario', 'text'=>'Ticket Médio Diário:'],
                    ['input'=>'indicators_sectors.ticket_medio_diario_paciente', 'text'=>'Ticket Médio Diário por Paciente:'],
                    ['input'=>'indicators_sectors.glossa_total', 'text'=>'Valor de Glossa Total:'],
                    ['input'=>'indicators_sectors.glossa_media_paciente', 'text'=>'Glossa Média por Paciente:'],
                ],

                "unidade_internacao"=>
                [
                    ['input'=>'indicators_sectors.total_internacoes', 'text'=>'Total de Internações:'],
                    ['input'=>'indicators_sectors.taxa_ocupacao', 'text'=>'Taxa de Ocupação:'],
                    ['input'=>'indicators_sectors.indice_giro_leito', 'text'=>'Índice giro de leito:'],
                    ['input'=>'indicators_sectors.intervalo_substituicao', 'text'=>'Intervalo de substituição:'],
                    ['input'=>'indicators_sectors.tempo_medio_permanencia', 'text'=>'Tempo Médio de Permanência:', 'class'=>'time'],
                    ['input'=>'indicators_sectors.taxa_reinternacao', 'text'=>'Taxa de Reinternação:'],
                    ['input'=>'indicators_sectors.taxa_reinternacao_24h', 'text'=>'Taxa de Reinternação em <24 horas:'],
                    ['input'=>'indicators_sectors.taxa_mortalidade', 'text'=>'Taxa de Mortalidade:'],
                    ['input'=>'indicators_sectors.taxa_mortalidade_cirurgico', 'text'=>'Taxa de Mortalidade Pacientes Cirúrgicos:'],
                    ['input'=>'indicators_sectors.taxa_infeccao_corrente', 'text'=>'Taxa de Infecção de Corrente Sanguínea por Cateter Vascular:'],
                    ['input'=>'indicators_sectors.taxa_infeccao_sitio', 'text'=>'Taxa de Infecção de Sítio Cirúrgico:'],
                    ['input'=>'indicators_sectors.densidade_cateter_vesical', 'text'=>'Densidade de Uso de Cateter Vesical:'],                    
                    ['input'=>'indicators_sectors.cirurgia_risco_infeccao', 'text'=>'Total de Cirurgias com Risco de Infecção:'],
                    ['input'=>'indicators_sectors.relacao_head', 'text'=>'Relação Head / Bed:'],
                    ['input'=>'indicators_sectors.consumo_total', 'text'=>'Consumo Total:'],
                    ['input'=>'indicators_sectors.consumo_diario', 'text'=>'Consumo Diário:'],
                    ['input'=>'indicators_sectors.consumo_por_paciente', 'text'=>'Consumo Diário por Paciente:'],
                    ['input'=>'indicators_sectors.ticket_total', 'text'=>'Ticket Total:'],
                    ['input'=>'indicators_sectors.ticket_medio_diario', 'text'=>'Ticket Médio Diário:'],
                    ['input'=>'indicators_sectors.ticket_medio_diario_paciente', 'text'=>'Ticket Médio Diário por Paciente:'],
                    ['input'=>'indicators_sectors.ticket_internacao', 'text'=>'Ticket por Internação:'],
                    ['input'=>'indicators_sectors.ticket_internacao_paciente', 'text'=>'Ticket por Internação por Paciente:'],
                    ['input'=>'indicators_sectors.glossa_total', 'text'=>'Valor de Glossa Total:'],
                    ['input'=>'indicators_sectors.glossa_media_paciente', 'text'=>'Glossa Média por Paciente:'],
                ],

                "centro_cirurgico"=>
                [
                    ['input'=>'indicators_sectors.taxa_adesao_tci', 'text'=>'Taxa de adesão ao TCI:'],
                    ['input'=>'indicators_sectors.taxa_avalicao_pre_ope', 'text'=>'Taxa de avaliação pré-operatória:'],
                    ['input'=>'indicators_sectors.taxa_cancelamento_cirurgia', 'text'=>'Taxa de cancelamento de cirurgia:'],
                    ['input'=>'indicators_sectors.taxa_conversao_cirurgia', 'text'=>'Taxa de conversão de cirurgia:'],
                    ['input'=>'indicators_sectors.taxa_atraso_cirurgia', 'text'=>'Taxa de atraso de cirurgia:'],
                    ['input'=>'indicators_sectors.total_cirurgias', 'text'=>'Total de cirurgia:'],
                    ['input'=>'indicators_sectors.taxa_ocupacao_sala', 'text'=>'Taxa de ocupação de sala cirúrgica:'],
                    ['input'=>'indicators_sectors.tempo_medio_ociosidade', 'text'=>'Tempo médio de ociosidade de sala cirúrgica:', 'class'=>'time'],
                    ['input'=>'indicators_sectors.taxa_de_adesao_anti', 'text'=>'Taxa de adesão ao antibióticoterapia profilática antes de 60m da cirurgia:'],
                    ['input'=>'indicators_sectors.consumo_medio_compressa', 'text'=>'Consumo médio de compressa:'],
                    ['input'=>'indicators_sectors.taxa_de_abertura', 'text'=>'Taxa de abertura de caixa extra:'],
                    ['input'=>'indicators_sectors.taxa_de_adesao_checklist', 'text'=>'Taxa de adesão ao checklist:'],
                    ['input'=>'indicators_sectors.taxa_de_uso_rpa', 'text'=>'Taxa de uso do RPA:'],
                    ['input'=>'indicators_sectors.taxa_de_efetividade', 'text'=>'Taxa de efetividade na prevenção do óbito no paciente cirúrgico:'],
                    ['input'=>'indicators_sectors.taxa_rearbodagem_cirurgica', 'text'=>'Taxa de reabordagem cirúrgica:'],
                    ['input'=>'indicators_sectors.consumo_total', 'text'=>'Consumo total:'],
                    ['input'=>'indicators_sectors.consumo_por_cirurgia', 'text'=>'Consumo por cirurgia:'],
                    ['input'=>'indicators_sectors.ticket_total', 'text'=>'Ticket Total:'],
                    ['input'=>'indicators_sectors.ticket_medio_por_cirurgia', 'text'=>'Ticket médio por cirurgia:'],
                    ['input'=>'indicators_sectors.glossa_total', 'text'=>'Valor de Glossa Total:'],
                    ['input'=>'indicators_sectors.glossa_media_paciente', 'text'=>'Glossa Média por Paciente:']
                ],
            ];

            echo $this->Form->input('type_id', ['options'=>$options, 'label'=>['text'=>'Tipo de Setor:','class'=>'form-input mandatory']]); 

            echo '<br><br><legend><h3 class="big-title">Meta de Indicadores</h3></legend>';   

            foreach ($indicadores_arr as $tipo => $indice) 
            {
                foreach ($indice as $key => $value) 
                {
                    echo "<div class='row ".$tipo."' style='display:none'><br><br>";                                  
                        echo "<div class='col-md-11'>";            
                            echo $this->Form->input($value['input'], ['type'=>'text', 'class'=> ( isset($value['class']) ?  $value['class'] :  '' )  , 'label'=>['text'=>$value['text'], 'class'=>'form-input']]); 
                        echo "</div>";

                        echo "<div class='col-md-1'>";
                            echo '<div class="funkyradio">';
                                echo '<div class="funkyradio-primary">';
                                    echo $this->Form->checkbox($value['input'].'_advertencia', ['id'=>$value['input'].'_advertencia']);
                                    echo '<label class="no-border" for="'.$value['input'].'_advertencia">&nbsp;</label>';
                                echo "</div>";
                            echo "</div>";
                        echo "</div>";
                    echo "</div>";
                }            
            }
            ?>

            <?= $this->Form->hidden('unit_id', ['value'=>$unit_id]) ?>
            <p class="mandatory-message">Os campos com * são obrigatórios.</p>
            <button type="button" class="btn btn-danger" onclick="goBack()">Cancelar</button>

            <?= $this->Form->button(__('Salvar')) ?>
            <?= $this->Form->end() ?>
        </fieldset>        
        <br><br><br>
    </div>
</div>

<script>
    $( document ).ready( function() 
    {
        $("#type-id").trigger("change");
    });

    $("#type-id").change(function() 
    { 
        console.log( $(this).val() );

        $(".terapia_intensiva").fadeOut();
        $(".unidade_internacao").fadeOut();
        $(".setor_emergencia").fadeOut();
        $(".centro_cirurgico").fadeOut();

        if ( $(this).val() <= 3) 
        {
            console.log("setor_emergencia");
            $(".setor_emergencia").fadeIn();
        }

        if ( $(this).val() >= 4 && $(this).val() <= 6 ) 
        {
            console.log("centro_cirurgico");
            $(".centro_cirurgico").fadeIn();
        }

        if ( $(this).val() >= 7 && $(this).val() <= 11) 
        {
            console.log("unidade_internacao");
            $(".unidade_internacao").fadeIn();
        }

        if ( $(this).val() >= 12 && $(this).val() <= 17 ) 
        {
            console.log("terapia_intensiva");
            $(".terapia_intensiva").fadeIn();
        }

    });

    (function() {
       // your page initialization code here
       // the DOM will be available here
        var link1 =' <?= $this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)', 
        array('controller' => 'Users', 'action' => 'login'), array('class'=>'btn btn-default ', 'escape' => false)) ?> ';


       var link2 =' <?= $this->Html->link('Setores',['controller' => 'Sectors', 'action' => 'index', '_full' => true], ['class'=>'btn btn-default ']); ?> ';

        var html = '';
            html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
            html+= link1;
            html+= link2;
            html+= '<a href="#" class="breadcumb-active btn btn-default">Novo</a>';        
            html+= '</div>';
                document.getElementById("breadcumb").innerHTML =html;
    })();
</script>