<?php

    $from = new DateTime($patient['birthday']->i18nFormat('dd-MM-yyyy'));
    $to   = new DateTime('today');
    $age = null;
    $age = $from->diff($to)->y;

    $desfecho =["Alta", "Óbito", "Transferência"];

    $caso_confirmado_como = [""=>"",0=>"Infecção", 1=>"Sepse", 2=>"Choque séptico", 3=>"Afastado infecção / sepse"];

    $respiratorio_opt = ['>= 400'=>'>= 400', '300 - 399'=>'300 - 399', '200 - 299'=>'200 - 299', '100 – 199 + Sup. Vent.'=>'100 – 199 + Sup. Vent.', '< 100 + Sup. Vent.'=>'< 100 + Sup. Vent.'];

    $cardiovascular_opt = ['Sem hipotensão'=>'Sem hipotensão', 'PAM < 70 mmHg'=>'PAM < 70 mmHg', 'Em uso de Dobbuamina'=>'Em uso de Dobbuamina', 'Em uso de Nora < 0,1 mcg/kg/min'=>'Em uso de Nora < 0,1 mcg/kg/min', 'Em uso de Nora > 0,1 mcg/kg/min'=>'Em uso de Nora > 0,1 mcg/kg/min'];

    $hematologico_opt =['>= 150'=>'>= 150', '100 - 149'=>'100 - 149', '50 - 99'=>'50 - 99', '20 – 49'=>'20 – 49', '< 20'=>'< 20'];
    
    $renal_opt =['< 1,2'=>'< 1,2', '1,2 - 1,9'=>'1,2 - 1,9', '2,0 - 3,4'=>'2,0 - 3,4', '3,5 - 4,9 or < 500ml/24h'=>'3,5 - 4,9 or < 500ml/24h', '>= 5,0 ou < 200ml/24h ou Suporte Renal'=>'>= 5,0 ou < 200ml/24h ou Suporte Renal'];

    $hepatico_opt = ['< 1.2'=>'< 1.2', '1.2 – 1.9'=>'1.2 – 1.9', '2.0 – 5.9'=>'2.0 – 5.9', '6.0-11.9'=>'6.0-11.9', '>= 12'=>'>= 12'];

    $neurologico_opt =['15'=>'15', '13 - 14'=>'13 - 14', '10 - 12'=>'10 - 12', '6 - 9'=>'6 - 9', '< 6'=>'< 6'];



    $checked_img = $this->Html->image('checked.png', ['class' => 'tick-box','alt' => 'GH', 'height'=>'22px', 'style'=>""]);

    $not_checked_img = $this->Html->image('not-checked.png', ['class' => 'tick-box','alt' => 'GH', 'height'=>'22px', 'style'=>""]);


    if(isset($sepseProtocol['qsofa_data'])){$sepseProtocol['qsofa_data']=$sepseProtocol['qsofa_data']->i18nFormat('d/m/Y');}

    if(isset($sepseProtocol['qsofa_hora'])){$sepseProtocol['qsofa_hora']=$sepseProtocol['qsofa_hora']->i18nFormat('HH:mm');}

    if(isset($sepseProtocol['avaliacao_1_hora'])){$sepseProtocol['avaliacao_1_hora']=$sepseProtocol['avaliacao_1_hora']->i18nFormat('HH:mm');}

    if(isset($sepseProtocol['coletar_exame_hora'])){$sepseProtocol['coletar_exame_hora']=$sepseProtocol['coletar_exame_hora']->i18nFormat('HH:mm');}


    if(isset($sepseProtocol['preservar_antibio_hora'])){$sepseProtocol['preservar_antibio_hora']=$sepseProtocol['preservar_antibio_hora']->i18nFormat('HH:mm');}


    if(isset($sepseProtocol['encerrar_atendimento_hora'])){$sepseProtocol['encerrar_atendimento_hora']=$sepseProtocol['encerrar_atendimento_hora']->i18nFormat('HH:mm');}

    if(isset($sepseProtocol['lactato_hora'])){$sepseProtocol['lactato_hora']=$sepseProtocol['lactato_hora']->i18nFormat('HH:mm');}
  
    if(isset($sepseProtocol['segundo_lactato_hora'])){$sepseProtocol['segundo_lactato_hora']=$sepseProtocol['segundo_lactato_hora']->i18nFormat('HH:mm');}

    if(isset($sepseProtocol['hora_primeira_disfuncao'])){$sepseProtocol['hora_primeira_disfuncao']=$sepseProtocol['hora_primeira_disfuncao']->i18nFormat('HH:mm');}
    
    if(isset($sepseProtocol['reconhecimento_sepse_hora'])){$sepseProtocol['reconhecimento_sepse_hora']=$sepseProtocol['reconhecimento_sepse_hora']->i18nFormat('HH:mm');}

  
    if(isset($sepseProtocol['hemocultura_hora'])){$sepseProtocol['hemocultura_hora']=$sepseProtocol['hemocultura_hora']->i18nFormat('HH:mm');}

    if(isset($sepseProtocol['avaliacao_3_hora'])){$sepseProtocol['avaliacao_3_hora']=$sepseProtocol['avaliacao_3_hora']->i18nFormat('HH:mm');}


     if(is_object($sepseProtocol['avaliacao_3_data'])){$sepseProtocol['avaliacao_3_data']=$sepseProtocol['avaliacao_3_data']->format('d/m/Y');}

     if(is_object($sepseProtocol['avaliacao_1_data'])){$sepseProtocol['avaliacao_1_data']=$sepseProtocol['avaliacao_1_data']->format('d/m/Y');}

      if(is_object($sepseProtocol['avaliacao_1_hora'])){$sepseProtocol['avaliacao_1_hora']=$sepseProtocol['avaliacao_1_hora']->i18nFormat('HH:mm');}


      if(is_object($sepseProtocol['avaliacao_2_data'])){$sepseProtocol['avaliacao_2_data']=$sepseProtocol['avaliacao_2_data']->format('d/m/Y');}

      if(is_object($sepseProtocol['avaliacao_2_hora'])){$sepseProtocol['avaliacao_2_hora']=$sepseProtocol['avaliacao_2_hora']->i18nFormat('HH:mm');}


      if(is_object($sepseProtocol['lactato_data'])){$sepseProtocol['lactato_data']=$sepseProtocol['lactato_data']->format('d/m/Y');}

      if(is_object($sepseProtocol['lactato_hora'])){$sepseProtocol['lactato_hora']=$sepseProtocol['lactato_hora']->i18nFormat('HH:mm');}

      if(is_object($sepseProtocol['segundo_lactato_data'])){$sepseProtocol['segundo_lactato_data']=$sepseProtocol['segundo_lactato_data']->format('d/m/Y');}

      if(is_object($sepseProtocol['segundo_lactato_hora'])){$sepseProtocol['segundo_lactato_hora']=$sepseProtocol['segundo_lactato_hora']->i18nFormat('HH:mm');}


      if(is_object($sepseProtocol['sofa_escore']['data_de_realizacao'])){$sepseProtocol['sofa_escore']['data_de_realizacao']=$sepseProtocol['sofa_escore']['data_de_realizacao']->format('d/m/Y');}

      if(is_object($sepseProtocol['encerrar_atendimento_data'])){$sepseProtocol['encerrar_atendimento_data']=$sepseProtocol['encerrar_atendimento_data']->format('d/m/Y');}



      if(is_object($sepseProtocol['preservar_anti_data'])){$sepseProtocol['preservar_anti_data']=$sepseProtocol['preservar_anti_data']->format('d/m/Y');}

      if(is_object($sepseProtocol['coletar_exame_data'])){$sepseProtocol['coletar_exame_data']=$sepseProtocol['coletar_exame_data']->format('d/m/Y');}



      if(is_object($sepseProtocol['reconhecimento_sepse_data'])){$sepseProtocol['reconhecimento_sepse_data']=$sepseProtocol['reconhecimento_sepse_data']->format('d/m/Y');}
      if(is_object($sepseProtocol['reconhecimento_sepse_hora'])){$sepseProtocol['reconhecimento_sepse_hora']=$sepseProtocol['reconhecimento_sepse_hora']->i18nFormat('HH:mm');}



      if(is_object($sepseProtocol['hemocultura_data'])){$sepseProtocol['hemocultura_data']=$sepseProtocol['hemocultura_data']->format('d/m/Y');}
      if(is_object($sepseProtocol['hemocultura_hora'])){$sepseProtocol['hemocultura_hora']=$sepseProtocol['hemocultura_hora']->i18nFormat('HH:mm');}


      if(is_object($sepseProtocol['antibioticoterapia_data'])){$sepseProtocol['antibioticoterapia_data']=$sepseProtocol['antibioticoterapia_data']->format('d/m/Y');}
      if(is_object($sepseProtocol['antibioticoterapia_hora'])){$sepseProtocol['antibioticoterapia_hora']=$sepseProtocol['antibioticoterapia_hora']->i18nFormat('HH:mm');}


      if(is_object($sepseProtocol['data_lactato_inicial'])){$sepseProtocol['data_lactato_inicial']=$sepseProtocol['data_lactato_inicial']->format('d/m/Y');}
      if(is_object($sepseProtocol['hora_lactato_inicial'])){$sepseProtocol['hora_lactato_inicial']=$sepseProtocol['hora_lactato_inicial']->i18nFormat('HH:mm');}

      if(is_object($sepseProtocol['data_lactato_final'])){$sepseProtocol['data_lactato_final']=$sepseProtocol['data_lactato_final']->format('d/m/Y');}
      if(is_object($sepseProtocol['hora_lactato_final'])){$sepseProtocol['hora_lactato_final']=$sepseProtocol['hora_lactato_final']->i18nFormat('HH:mm');}

      if(is_object($sepseProtocol['data_alta_uti'])){$sepseProtocol['data_alta_uti']=$sepseProtocol['data_alta_uti']->format('d/m/Y');}
      if(is_object($sepseProtocol['data_alta_hospitalar'])){$sepseProtocol['data_alta_hospitalar']=$sepseProtocol['data_alta_hospitalar']->format('d/m/Y');}

      

      


    
      


    // if(isset($bundle['hemocultura_hora'])){$bundle['hemocultura_hora']=$bundle['hemocultura_hora']->format('d/m/Y');}

    
?>
<div>
<div class="container unit-header">
        <div class="bundles form col-sm-4 columns content">
            
            <?= 
             $this->Html->image('uploads/'. $unit_logo, ['alt' => 'GH', 'height'=>'50px', 'style'=>"margin-top: 7px;"])
            ?>
            <br><br>
            <p class="unit-data"><b><?= $unit->name ?></b></p>
            <p class="unit-data"><b><?= $unit->telephone ?></b></p>
            <p class="unit-data"><b><?= $unit->street ?></b></p>
            <p class="unit-data"><b><?= $unit->city ?></b></p>
            <br>
        </div>   
        <div class="col-sm-8">
            <h1>Protocolo de Sepse</h1>
        </div>
        
</div>

<div class="col-sm-12 data-field">
  <table class="table table-bordered">
    <tr>
      <td><span class="inline-data"><b>Paciente:</b>&nbsp;<?= $patient->nome ?></span></td>
      <td><span class="inline-data"><b>Idade:</b>&nbsp;<?= $age ?></span></td>
      <td><span class="inline-data"><b>Setor:</b>&nbsp;<?= $hospitalization->sector['name'] ?></span></td>
      <td><span class="inline-data"><b>Leito:</b>&nbsp;<?= $hospitalization->roomName($hospitalization['id'])?></span></td>
      <td><span class="inline-data"><b>Prontuário:</b>&nbsp;<?= $hospitalization->numero_do_prontuario ?></span></td>
    </tr>
  </table>
  <br><br>
</div>

<div class="sepseProtocols form col-md-12 columns content">

                        <?php

                          echo '<div class="page">';

                            echo '<div class="col-sm-12 no-padding">';
                               echo '<legend class="big-title">Internação</legend>';
                            echo '</div>';

                            echo '<div class="col-sm-6 data-field">';
                              echo '<b>Setor:</b>'.$sectors[$sepseProtocol['sector_id']];
                            echo '</div>';

                            echo '<div class="col-sm-12 no-padding">';
                                
                                 echo '<div class="col-sm-6 data-field">';
                                  echo '<b>Data de saída:</b>'.$sepseProtocol['avaliacao_3_data'];
                                 echo '</div>';

                                 echo '<div class="col-sm-6 data-field">';
                                  echo '<b>Hora de saída:</b>'.$sepseProtocol['avaliacao_3_hora'];
                                 echo '</div>';

                            echo '</div>';    

                            echo '<div class="col-sm-12 no-padding">';
                               echo '<legend class="big-title">Sinais qSOFA</legend>';
                            echo '</div>';


                             echo '<div class="col-sm-12 no-padding">';
                               echo '<legend class="sub-title-sections">Assinale os sinais qSOFA presentes no paciente:</legend>';
                            echo '</div>';


                             echo '<div class="col-sm-6 data-field">';
                              echo '<b>Data da avaliação:</b>'.$sepseProtocol['qsofa_data'];
                             echo '</div>';


                             echo '<div class="col-sm-6 data-field">';
                              echo '<b>Hora da avaliação:</b>'.$sepseProtocol['qsofa_hora'];
                             echo '</div>';


                             echo '<div class="col-sm-6 data-field">';
                                 if($sepseProtocol['hipotensao']){
                                  echo $checked_img.'<b>Hipotensão (PA sistólica &lt; 100mmHg)</b>';
                                 }else{
                                  echo $not_checked_img.'<b>Hipotensão (PA sistólica &lt; 100mmHg)</b>';
                                 }
                             echo '</div>';

                             echo '<div class="col-sm-6 data-field">';
                                 if($sepseProtocol['taquipneia']){
                                  echo $checked_img.'<b>Taquipnéia &gt; 20 IRM</b>';
                                 }else{
                                  echo $not_checked_img.'<b>HTaquipnéia &gt; 20 IRM</b>';
                                 }
                             echo '</div>';

                             echo '<div class="col-sm-6 data-field">';
                                 if($sepseProtocol['alteracao_estado_mental']){
                                  echo $checked_img.'<b>Alteração do estado mental (sonolência, agitação, alteração comportamental)</b>';
                                 }else{
                                  echo $not_checked_img.'<b>Alteração do estado mental (sonolência, agitação, alteração comportamental)</b>';
                                 }
                             echo '</div>';


                            echo '<div class="col-sm-12 no-padding">';
                               echo '<br><br><legend class="big-title">Avaliação 1</legend>';
                            echo '</div>';


                            echo '<div class="col-sm-12 no-padding">';
                               echo '<legend class="sub-title-sections">Avaliação Médica 1- paciente apresenta história sugestiva de infecção?</legend>';
                            echo '</div>';

                                echo '<div class="col-sm-6 data-field">';
                                  echo '<b>Data da avaliação:</b>'.$sepseProtocol['avaliacao_1_data'];
                                echo '</div>';

                                echo '<div class="col-sm-6 data-field">';
                                  echo '<b>Hora da avaliação:</b>'.$sepseProtocol['avaliacao_1_hora'];
                                echo '</div>';


                                echo '<div class="col-sm-6 data-field">';
                                    if($sepseProtocol['pneumonia']){
                                      echo $checked_img.'<b>Pneumonia/Empiema</b>';
                                    }else{
                                      echo $not_checked_img.'<b>Pneumonia/Empiema</b>';
                                    }
                                echo '</div>';

                                echo '<div class="col-sm-6 data-field">';
                                    if($sepseProtocol['infeccao_urinaria']){
                                      echo $checked_img.'<b>Infecção urinária/Empiema</b>';
                                    }else{
                                      echo $not_checked_img.'<b>Infecção urinária/Empiema</b>';
                                    }
                                echo '</div>';


                                echo '<div class="col-sm-6 data-field">';
                                    if($sepseProtocol['infeccao_abdominal']){
                                      echo $checked_img.'<b>Infecção abdominal aguda</b>';
                                    }else{
                                      echo $not_checked_img.'<b>Infecção abdominal aguda</b>';
                                    }
                                echo '</div>';


                                echo '<div class="col-sm-6 data-field">';
                                    if($sepseProtocol['meningite']){
                                      echo $checked_img.'<b>Meningite</b>';
                                    }else{
                                      echo $not_checked_img.'<b>Meningite</b>';
                                    }
                                echo '</div>';


                                echo '<div class="col-sm-6 data-field">';
                                    if($sepseProtocol['endocardite']){
                                      echo $checked_img.'<b>Endocardite</b>';
                                    }else{
                                      echo $not_checked_img.'<b>Endocardite</b>';
                                    }
                                echo '</div>';


                                echo '<div class="col-sm-6 data-field">';
                                    if($sepseProtocol['pele_partes_moles']){
                                      echo $checked_img.'<b>Pele e partes moles</b>';
                                    }else{
                                      echo $not_checked_img.'<b>Pele e partes moles</b>';
                                    }
                                echo '</div>';



                                echo '<div class="col-sm-6 data-field">';
                                    if($sepseProtocol['infeccao_protese']){
                                      echo $checked_img.'<b>Infecção de prótese</b>';
                                    }else{
                                      echo $not_checked_img.'<b>Infecção de prótese</b>';
                                    }
                                echo '</div>';


                                echo '<div class="col-sm-6 data-field">';
                                    if($sepseProtocol['infeccao_ossea']){
                                      echo $checked_img.'<b>Infecção óssea/articular</b>';
                                    }else{
                                      echo $not_checked_img.'<b>Infecção óssea/articular</b>';
                                    }
                                echo '</div>';


                                echo '<div class="col-sm-6 data-field">';
                                    if($sepseProtocol['infeccao_ferida_operatoria']){
                                      echo $checked_img.'<b>Infecção de ferida operatória</b>';
                                    }else{
                                      echo $not_checked_img.'<b>Infecção de ferida operatória</b>';
                                    }
                                echo '</div>';


                                echo '<div class="col-sm-6 data-field">';
                                    if($sepseProtocol['infeccao_corrente_sanguinea']){
                                      echo $checked_img.'<b>Infecção de corrente sanguínea associada ao cateter</b>';
                                    }else{
                                      echo $not_checked_img.'<b>Infecção de corrente sanguínea associada ao cateter</b>';
                                    }
                                echo '</div>';


                                echo '<div class="col-sm-6 data-field">';
                                    if($sepseProtocol['sem_foco_definido']){
                                      echo $checked_img.'<b>Sem foco definido</b>';
                                    }else{
                                      echo $not_checked_img.'<b>Sem foco definido</b>';
                                    }
                                echo '</div>';


                                 echo '<div class="col-sm-12 data-field">';
                                   echo '<b>Outras infecções:</b>';
                                echo '</div>';


                                echo '<div class="col-sm-12 data-field">';
                                   echo '<div class="textos">'.$sepseProtocol['outras_infeccoes'].'</div>';
                                echo '</div>';


                          

                            echo '<div class="col-sm-12 no-padding">';
                               echo '<br><br><legend class="big-title">Avaliação 2</legend>';
                            echo '</div>';


                            echo '<div class="col-sm-12 no-padding">';
                               echo '<legend class="sub-title-sections">Avaliação Médica 2 – o paciente apresenta critérios para:</legend>';
                            echo '</div>';

                                  echo '<div class="col-sm-6 data-field">';
                                    echo '<b>Data da avaliação:</b>'.$sepseProtocol['avaliacao_2_data'];
                                  echo '</div>';

                                  echo '<div class="col-sm-6 data-field">';
                                    echo '<b>Hora da avaliação:</b>'.$sepseProtocol['avaliacao_2_hora'];
                                  echo '</div>';


                                  echo '<div class="col-sm-6 data-field">';
                                        if($sepseProtocol['infeccao_nao_complicada']){
                                          echo $checked_img.'<b>Infecção não complicada</b>';
                                        }else{
                                          echo $not_checked_img.'<b>Infecção não complicada</b>';
                                        }
                                  echo '</div>';


                                  echo '<div class="col-sm-6 data-field">';
                                        if($sepseProtocol['sepse']){
                                          echo $checked_img.'<b>Sepse</b>';
                                        }else{
                                          echo $not_checked_img.'<b>Sepse</b>';
                                        }
                                  echo '</div>';


                                  echo '<div class="col-sm-6 data-field">';
                                        if($sepseProtocol['choque_septico']){
                                          echo $checked_img.'<b>Choque séptico</b>';
                                        }else{
                                          echo $not_checked_img.'<b>Choque séptico</b>';
                                        }
                                  echo '</div>';


                                  echo '<div class="col-sm-6 data-field">';
                                        if($sepseProtocol['afastado_sepse']){
                                          echo $checked_img.'<b>Afastado sepse / choque séptico</b>';
                                        }else{
                                          echo $not_checked_img.'<b>Afastado sepse / choque séptico</b>';
                                        }
                                  echo '</div>';


                                  echo '<div class="col-sm-6 data-field">';
                                        if($sepseProtocol['sepse_choque_septico']){
                                          echo $checked_img.'<b>Sepse / choque séptico em cuidados de fim de vida sem conduta específica no momento</b>';
                                        }else{
                                          echo $not_checked_img.'<b>Sepse / choque séptico em cuidados de fim de vida sem conduta específica no momento</b>';
                                        }
                                  echo '</div>';


                                  echo '<div class="col-sm-12 no-padding">';
                                     echo '<legend class="sub-title-sections">Avaliação Médica 2 – ações imediatas:</legend>';
                                  echo '</div>';


                                  echo '<div class="col-sm-6 data-field">';
                                        if($sepseProtocol['coletar_exame']){
                                          echo $checked_img.'<b>Coletar exames do kit sepse</b>';
                                        }else{
                                          echo $not_checked_img.'<b>Coletar exames do kit sepse</b>';
                                        }
                                  echo '</div>';

                                  echo '<div class="col-sm-12 no-padding">';
                                      echo '<div class="col-sm-6 data-field">';
                                        echo '<b>Data da coleta:</b>'.$sepseProtocol['coletar_exame_data'];
                                      echo '</div>';


                                      echo '<div class="col-sm-6 data-field">';
                                        echo '<b>Hora da coleta:</b>'.$sepseProtocol['coletar_exame_hora'];
                                      echo '</div>';
                                   echo '</div>';


                                  echo '<div class="col-sm-6 data-field">';
                                        if($sepseProtocol['preservar_antibio']){
                                          echo $checked_img.'<b>Prescrever antibioticoterapia</b>';
                                        }else{
                                          echo $not_checked_img.'<b>Prescrever antibioticoterapia</b>';
                                        }
                                  echo '</div>';


                                  echo '<div class="col-sm-6 data-field">';
                                    echo '<b>Data da prescrição antibioticoterapia:</b>'.$sepseProtocol['preservar_anti_data'];
                                  echo '</div>';


                                  echo '<div class="col-sm-12 no-padding">';
                                    echo '<div class="col-sm-6 data-field">';
                                      echo '<b>Hora da prescrição antibioticoterapia:</b>'.$sepseProtocol['preservar_antibio_hora'];
                                    echo '</div>';


                                    echo '<div class="col-sm-6 data-field">';
                                          if($sepseProtocol['encerrar_atendimento']){
                                            echo $checked_img.'<b>Encerrar o atendimento</b>';
                                          }else{
                                            echo $not_checked_img.'<b>Encerrar o atendimento</b>';
                                          }
                                    echo '</div>';
                                  echo '</div>';  


                                  echo '<div class="col-sm-6 data-field">';
                                    echo '<b>Data do encerramento:</b>'.$sepseProtocol['encerrar_atendimento_data'];
                                  echo '</div>';


                                  echo '<div class="col-sm-6 data-field">';
                                    echo '<b>Hora do encerramento:</b>'.$sepseProtocol['encerrar_atendimento_hora'];
                                  echo '</div>';


                          echo '</div>';       
                                  
                          

                          echo '<div class="page">';    
                              
                            echo '<div class="col-sm-12 no-padding">';
                               echo '<br><br><legend class="big-title">Avaliação 3</legend>';
                            echo '</div>';


                            echo '<div class="col-sm-12 no-padding">';
                               echo '<legend class="sub-title-sections">Avaliação Médica 3 - após exames, sinalize as disfunções orgânicas</legend>';
                            echo '</div>';


                                  echo '<div class="col-sm-6 data-field">';
                                        if($sepseProtocol['paciente_nao_tem_disfuncao']){
                                          echo $checked_img.'<b>Paciente não tinha disfunção orgânica, somente infecção</b>';
                                        }else{
                                          echo $not_checked_img.'<b>Paciente não tinha disfunção orgânica, somente infecção</b>';
                                        }
                                  echo '</div>';


                                  echo '<div class="col-sm-6 data-field">';
                                        if($sepseProtocol['pas_menor_que_90']){
                                          echo $checked_img.'<b>PAS < 90 mmHg ou PAM 65 mmHg ou queda de PA 40 mmHg</b>';
                                        }else{
                                          echo $not_checked_img.'<b>PAS < 90 mmHg ou PAM 65 mmHg ou queda de PA 40 mmHg</b>';
                                        }
                                  echo '</div>';


                                  echo '<div class="col-sm-6 data-field">';
                                        if($sepseProtocol['relacao_pao']){
                                          echo $checked_img.'<b>Relação PaO 2 /FiO 2 300 ou necessidade de O 2 para manter SpO 2 90</b>';
                                        }else{
                                          echo $not_checked_img.'<b>Relação PaO 2 /FiO 2 300 ou necessidade de O 2 para manter SpO 2 90</b>';
                                        }
                                  echo '</div>';



                                  echo '<div class="col-sm-6 data-field">';
                                        if($sepseProtocol['rebaixamento_do_nivel']){
                                          echo $checked_img.'<b>Rebaixamento do nível de consciência</b>';
                                        }else{
                                          echo $not_checked_img.'<b>Rebaixamento do nível de consciência</b>';
                                        }
                                  echo '</div>';

                                  echo '<div class="col-sm-12 no-padding">';
                                    echo '<div class="col-sm-6 data-field">';
                                          if($sepseProtocol['creatina']){
                                            echo $checked_img.'<b>Creatinina > 2,0 mg/dl ou diurese menor que 0,5ml/Kg/h nas últimas 2 horas</b>';
                                          }else{
                                            echo $not_checked_img.'<b>Creatinina > 2,0 mg/dl ou diurese menor que 0,5ml/Kg/h nas últimas 2 horas</b>';
                                          }
                                    echo '</div>';



                                    echo '<div class="col-sm-6 data-field">';
                                          if($sepseProtocol['bilirrubina']){
                                            echo $checked_img.'<b>Bilirrubina > 2mg/dl</b>';
                                          }else{
                                            echo $not_checked_img.'<b>Bilirrubina > 2mg/dl</b>';
                                          }
                                    echo '</div>';
                                  echo '</div>';


                                  echo '<div class="col-sm-6 data-field">';
                                        if($sepseProtocol['contagem_de_plaquetas']){
                                          echo $checked_img.'<b>Contagem de plaquetas < 100.000</b>';
                                        }else{
                                          echo $not_checked_img.'<b>Contagem de plaquetas < 100.000</b>';
                                        }
                                  echo '</div>';


                                  echo '<div class="col-sm-6 data-field">';
                                        if($sepseProtocol['lactato_acima_do_valor']){
                                          echo $checked_img.'<b>Lactato acima do valor de referência</b>';
                                        }else{
                                          echo $not_checked_img.'<b>Lactato acima do valor de referência</b>';
                                        }
                                  echo '</div>';



                                  echo '<div class="col-sm-6 data-field">';
                                    echo '<b>Lactato:</b>'.$sepseProtocol['lactato'];
                                  echo '</div>';

                                  echo '<div class="col-sm-6 data-field">';
                                    echo '<b>Lactato(hora):</b>'.$sepseProtocol['lactato_hora'];
                                  echo '</div>';

                                  
                                  echo '<div class="col-sm-12 no-padding">';
                                    echo '<div class="col-sm-6 data-field">';
                                      echo '<b>Lactato(data):</b>'.$sepseProtocol['lactato_data'];
                                    echo '</div>';


                                    echo '<div class="col-sm-6 data-field">';
                                          if($sepseProtocol['tem_segundo_lactato']){
                                            echo $checked_img.'<b>Existe outro lactato</b>';
                                          }else{
                                            echo $not_checked_img.'<b>Existe outro lactato</b>';
                                          }
                                    echo '</div>';
                                  echo '</div>';

                                  echo '<div class="col-sm-6 data-field">';
                                    echo '<b>Segundo lactato:</b>'.$sepseProtocol['segundo_lactato'];
                                  echo '</div>';

                                  echo '<div class="col-sm-6 data-field">';
                                    echo '<b>Segundo lactato(hora):</b>'.$sepseProtocol['segundo_lactato_hora'];
                                  echo '</div>';



                                  echo '<div class="col-sm-6 data-field">';
                                    echo '<b>Segundo lactato(data):</b>'.$sepseProtocol['segundo_lactato_data'];
                                  echo '</div>';

                                  echo '<div class="col-sm-6 data-field">';
                                    echo '<b>Data da primeira disfunção orgânica:</b>'.$sepseProtocol['data_primeira_disfuncao'];
                                  echo '</div>';


                                  echo '<div class="col-sm-6 data-field">';
                                    echo '<b>Hora da primeira disfunção orgânica:</b>'.$sepseProtocol['hora_primeira_disfuncao'];
                                  echo '</div>';

                                  echo '<div class="col-sm-6 data-field">';
                                    echo '<b>O caso ficou confirmado como:</b>'.$caso_confirmado_como[$sepseProtocol['caso_confirmado_como']];
                                  echo '</div>';


                                  echo '<div class="col-sm-6 data-field">';
                                        if($sepseProtocol['coagulopatia']){
                                          echo $checked_img.'<b>Coagulopatia (RNI 1,5 ou TTPA 60 seg)</b>';
                                        }else{
                                          echo $not_checked_img.'<b>Coagulopatia (RNI 1,5 ou TTPA 60 seg)</b>';
                                        }
                                  echo '</div>';


                                  echo '<div class="col-sm-6 data-field">';
                                        if($sepseProtocol['liberado_para_tratamento']){
                                          echo $checked_img.'<b>Liberado para tratamento ambulatorial, caso infecção não complicada</b>';
                                        }else{
                                          echo $not_checked_img.'<b>Liberado para tratamento ambulatorial, caso infecção não complicada</b>';
                                        }
                                  echo '</div>';


                                  // echo '<div class="col-sm-6 data-field">';
                                  //       if($sepseProtocol['internacao_em']){
                                  //         echo $checked_img.'<b>Internado</b>';
                                  //       }else{
                                  //         echo $not_checked_img.'<b>Internado</b>';
                                  //       }
                                  // echo '</div>';


                                  // echo '<div class="col-sm-6 data-field">';
                                  //   echo '<b>Setor de destino:</b>'.$sepseProtocol['sectors'];
                                  // echo '</div>';


                                  // echo '<div class="col-sm-12 no-padding">';
                                  //     echo '<div class="col-sm-6 data-field">';
                                  //       echo '<b>Data de saída:</b>'.$sepseProtocol['avaliacao_3_data'];
                                  //     echo '</div>';

                                  //     echo '<div class="col-sm-6 data-field">';
                                  //       echo '<b>Hora de saída:</b>'.$sepseProtocol['avaliacao_3_hora'];
                                  //     echo '</div>';
                                  // echo '</div>';    


                            echo '<div class="col-sm-12 no-padding">';
                               echo '<br><legend class="big-title">SOFA</legend>';
                            echo '</div>';


                            echo '<div class="col-sm-6 data-field">';
                              echo '<b>Respiratório (PaO2/FiO2):</b>'.$sepseProtocol['sofa_escore']['respiratorio'];
                            echo '</div>';

                            echo '<div class="col-sm-6 data-field">';
                              echo '<b>Cardiovascular [Drogas Vasoativas (mcg/Kg/min):</b>'.$sepseProtocol['sofa_escore']['cardiovascular'];
                            echo '</div>';

                            echo '<div class="col-sm-6 data-field">';
                              echo '<b>Hematológico (Plaquetas x 10³ /mm³):</b>'.$sepseProtocol['sofa_escore']['hematologico'];
                            echo '</div>';


                            echo '<div class="col-sm-6 data-field">';
                              echo '<b>Renal (Creatinina mg/dL ou Diurese ml/24h):</b>'.$sepseProtocol['sofa_escore']['renal'];
                            echo '</div>';


                            echo '<div class="col-sm-6 data-field">';
                              echo '<b>Hepático (Bilirrubinas Totais mg/dL):</b>'.$sepseProtocol['sofa_escore']['hepatico'];
                            echo '</div>';


                            echo '<div class="col-sm-6 data-field">';
                              echo '<b>Neurológico (Pontos da Escala de Coma de Glasgow):</b>'.$sepseProtocol['sofa_escore']['neurologico'];
                            echo '</div>';


                            echo '<div class="col-sm-6 data-field">';
                              echo '<b>Data de Realização:</b>'.$sepseProtocol['sofa_escore']['data_de_realizacao'];
                            echo '</div>';

                            echo '<div class="col-sm-6 data-field">';
                              echo '<b>Pontuação:</b>'.$sepseProtocol['sofa_escore']['pontuation'];
                            echo '</div>';


                      echo '<div class="col-sm-12 no-padding">';
                         echo '<br><legend class="big-title">Acompanhamento do protocolo</legend>';
                      echo '</div>';


                            echo '<div class="col-sm-12 no-padding">';
                              echo '<div class="col-sm-12 data-field">';
                                echo '<b>Data de reconhecimento da sepse:</b>'.$sepseProtocol['reconhecimento_sepse_data'];
                              echo '</div>';
                            echo '</div>';


                            echo '<div class="col-sm-12 no-padding">';
                              echo '<div class="col-sm-12 data-field">';
                                echo '<b>Hora de reconhecimento da sepse:</b>'.$sepseProtocol['reconhecimento_sepse_hora'];
                              echo '</div>';
                            echo '</div>';

                            echo '<div class="col-sm-12 no-padding">';
                              echo '<div class="col-sm-12 data-field">';
                                echo '<b>Data da hemocultura:</b>'.$sepseProtocol['hemocultura_data'];
                              echo '</div>';
                            echo '</div>';

                            echo '<div class="col-sm-12 no-padding">';
                              echo '<div class="col-sm-12 data-field">';
                                echo '<b>Hora da hemocultura:</b>'.$sepseProtocol['hemocultura_hora'];
                              echo '</div>';
                            echo '</div>';

                            echo '<div class="col-sm-12 no-padding">';
                              echo '<div class="col-sm-12 data-field">';
                                echo '<b>Data Antibioticoterapia:</b>'.$sepseProtocol['antibioticoterapia_data'];
                              echo '</div>';
                            echo '</div>';


                            echo '<div class="col-sm-12 no-padding">';
                              echo '<div class="col-sm-12 data-field">';
                                echo '<b>Hora Antibioticoterapia:</b>'.$sepseProtocol['antibioticoterapia_hora'];
                              echo '</div>';
                            echo '</div>';


                            echo '<div class="col-sm-12 no-padding">';
                              echo '<div class="col-sm-12 data-field">';
                                echo '<b>Data do lactato inicial:</b>'.$sepseProtocol['data_lactato_inicial'];
                              echo '</div>';
                            echo '</div>';


                            echo '<div class="col-sm-12 no-padding">';
                            echo '<div class="col-sm-6 data-field">';
                              echo '<b>Hora do lactato inicial:</b>'.$sepseProtocol['hora_lactato_inicial'];
                            echo '</div>';
                            echo '</div>';

                            echo '<div class="col-sm-12 no-padding">';
                              echo '<div class="col-sm-12 data-field">';
                                echo '<b>Data do segundo lactato:</b>'.$sepseProtocol['data_lactato_final'];
                              echo '</div>';
                            echo '</div>';


                            echo '<div class="col-sm-12 no-padding">';
                              echo '<div class="col-sm-12 data-field">';
                                echo '<b>Hora do segundo lactato:</b>'.$sepseProtocol['hora_lactato_final'];
                              echo '</div>';
                            echo '</div>';


                             echo '<div class="col-sm-12 no-padding">';
                             echo '<div class="col-sm-12 data-field">';
                              echo '<b>Classificação (Infecção / Sepse / Choque):</b>'.$sepseProtocol['classificacao'];
                             echo '</div>';
                             echo '</div>';


                            echo '<div class="col-sm-12 no-padding">';
                             echo '<div class="col-sm-12 data-field">';
                              echo '<b>Pontuação mínima do SOFA Score na internação:</b>'.$sepseProtocol['pontuacao_minima_sofa'];
                             echo '</div>';
                            echo '</div>'; 


                            echo '<div class="col-sm-12 no-padding">'; 
                             echo '<div class="col-sm-12 data-field">';
                              echo '<b>Delta de cultura:</b>'.$sepseProtocol['delta_de_cultura'];
                             echo '</div>';
                             echo '</div>';


                            echo '<div class="col-sm-12 no-padding">';
                             echo '<div class="col-sm-6 data-field">';
                              echo '<b>Pontuação do SOFA D1 Score (primeira pontuação):</b>'.$sepseProtocol['pontuacao_sofa_d1_score'];
                             echo '</div>';
                            echo '</div>'; 



                            echo '<div class="col-sm-12 no-padding">'; 
                             echo '<div class="col-sm-12 data-field">';
                              echo '<b>Taxa de Clareamento do Lactato (2º Lactato / 1º Lactato ) x 100:</b>'.$sepseProtocol['taxa_clareamento_lactato'];
                             echo '</div>';
                            echo '</div>'; 

                            echo '<div class="col-sm-12 no-padding">'; 
                             echo '<div class="col-sm-12 data-field">';
                              echo '<b>Pontuação Máxima do SOFA Score (máxima pontuação feita na internação) :</b>'.$sepseProtocol['pontuacao_maxima_sofa'];
                             echo '</div>';
                            echo '</div>'; 


                            echo '<div class="col-sm-12 no-padding">';
                             echo '<div class="col-sm-12 data-field">';
                              echo '<b>Desfecho:</b>'.$sepseProtocol['desfecho'];
                             echo '</div>';
                            echo '</div>'; 


                            echo '<div class="col-sm-12 no-padding">'; 
                             echo '<div class="col-sm-12 data-field">';
                              echo '<b>Data de alta UTI:</b>'.$sepseProtocol['data_alta_uti'];
                             echo '</div>';
                            echo '</div>'; 

                            echo '<div class="col-sm-12 no-padding">';
                             echo '<div class="col-sm-12 data-field">';
                              echo '<b>Data de alta hospitalar:</b>'.$sepseProtocol['data_alta_hospitalar'];
                             echo '</div>';
                            echo '</div>';
                         echo '</div>';      

                        ?>

</div>


<script>

window.onload = setTimeout(function(){$.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});},1);
  
  (function(){
    
    $("form :input").prop('readonly', true);
    $("form :input").css('readonly', true);
    $('nav').css('display','none');

    // definindo a função de Print
    function PrintPage() {
        window.print();
        setTimeout(function () {
          $.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});
          window.close();
        },900);
    }

    // chamando a função de imprimir
    setTimeout(function(){ 
      PrintPage();
    },600);

  })();
</script>
