<?php
  $from = new DateTime($patient['birthday']->i18nFormat('dd-MM-yyyy'));
  $to   = new DateTime('today');
  $age  = null;
  $age  = $from->diff($to)->y;
?>
<div class="container unit-header">
        <div class="bundles form col-sm-4 columns content">
            
            <?= 
             $this->Html->image('uploads/'. $unit_logo, ['alt' => 'GH', 'height'=>'50px', 'style'=>"margin-top: 7px;"])
            ?>
            <br><br>
            <p class="unit-data"><b><?= $unit->name ?></b></p>
            <p class="unit-data"><b><?= $unit->telephone ?></b></p>
            <p class="unit-data"><b><?= $unit->street ?></b></p>
            <p class="unit-data"><b><?= $unit->city ?></b></p>
            <br>
        </div>   
        <div class="col-sm-8">
            <h1>Risco Cirúrgico</h1>
        </div>
     
</div>

<div class="col-sm-12 data-field">
  <table class="table table-bordered">
    <tr>
      <td><span class="inline-data"><b>Paciente:</b>&nbsp;<?= $patient->nome ?></span></td>
      <td><span class="inline-data"><b>Idade:</b>&nbsp;<?= $age ?></span></td>
      <td><span class="inline-data"><b>Setor:</b>&nbsp;<?= $hospitalization->sector['name'] ?></span></td>
      <td><span class="inline-data"><b>Leito:</b>&nbsp;<?= $hospitalization->roomName($hospitalization['id'])?></span></td>
      <td><span class="inline-data"><b>Prontuário:</b>&nbsp;<?= $hospitalization->numero_do_prontuario ?></span></td>
    </tr>
  </table>
  <br><br>
</div>

<div class="surgicalRisks form col-md-8 columns content">
  
        <?php

           $checked_img = $this->Html->image('checked.png', ['class' => 'tick-box','alt' => 'GH', 'height'=>'22px', 'style'=>""]);

           $not_checked_img = $this->Html->image('not-checked.png', ['class' => 'tick-box','alt' => 'GH', 'height'=>'22px', 'style'=>""]);
   

            if( $surgicalRisk['data_da_preenchimento'] != ''){

                echo '<div class="col-sm-6 data-field">';
                  echo '<b>Data de preenchimento:</b>'.$surgicalRisk['data_da_preenchimento'];
                echo '</div>';
            
            }


            if( $surgicalRisk['hora_da_preenchimento'] != ''){

                echo '<div class="col-sm-6 data-field">';
                  echo '<b>Hora de preenchimento:</b>'.$surgicalRisk['hora_da_preenchimento'];
                echo '</div>';
            
            }


            if( $surgicalRisk['exame_fisico'] != ''){
                echo '<div class="col-sm-12 data-field">';
                   echo '<b>Exame físico:</b>';
                echo '</div>';

                echo '<div class="col-sm-12 data-field">';
                   echo '<div class="textos">'.$surgicalRisk['exame_fisico'].'</div>';
                echo '</div>';        
            }


            if( $surgicalRisk['exames_laboratoriais'] != ''){
                echo '<div class="col-sm-12 data-field">';
                   echo '<b>Exames laboratoriais:</b>';
                echo '</div>';

                echo '<div class="col-sm-12 data-field">';
                   echo '<div class="textos">'.$surgicalRisk['exames_laboratoriais'].'</div>';
                echo '</div>';        
            }


            if( $surgicalRisk['observacoes'] != ''){
                echo '<div class="col-sm-12 data-field">';
                   echo '<b>Observações:</b>';
                echo '</div>';

                echo '<div class="col-sm-12 data-field">';
                   echo '<div class="textos">'.$surgicalRisk['observacoes'].'</div>';
                echo '</div>';        
            }


            if( $surgicalRisk['risco_cirurgico'] != ''){
                echo '<div class="col-sm-12 data-field">';
                   echo '<b>Risco cirúrgico:</b>';
                echo '</div>';

                echo '<div class="col-sm-12 data-field">';
                   echo '<div class="textos">'.$surgicalRisk['risco_cirurgico'].'</div>';
                echo '</div>';        
            }


            if( $surgicalRisk['classificacao_risco_cirurgico_asa'] != ''){

                echo '<div class="col-sm-12 data-field">';
                  echo '<b>Classificação de risco cirúrgico pela ASA:</b>'.$surgicalRisk['classificacao_risco_cirurgico_asa'];
                echo '</div>';
            
            }


            if( $surgicalRisk['procedimento_emergencial'] != ''){
                echo '<div class="col-sm-6 data-field">';
                  if($surgicalRisk['procedimento_emergencial']){
                    echo $checked_img.'<b>Procedimento emergencial</b>';
                  }else{
                    echo $not_checked_img.'<b>Procedimento emergencial</b>';
                  }
                echo '</div>'; 
            }


            if( $surgicalRisk['tci_preenchido'] != ''){
                echo '<div class="col-sm-6 data-field">';
                  if($surgicalRisk['tci_preenchido']){
                    echo $checked_img.'<b>TCI Anestésico preenchido</b>';
                  }else{
                    echo $not_checked_img.'<b>TCI Anestésico preenchido</b>';
                  }
                echo '</div>'; 
            }


            if( $surgicalRisk['pos_operatorio_em_uti'] != ''){
                echo '<div class="col-sm-6 data-field">';
                  if($surgicalRisk['tci_preenchido']){
                    echo $checked_img.'<b>Pós-Operatório em UTI</b>';
                  }else{
                    echo $not_checked_img.'<b>Pós-Operatório em UTI</b>';
                  }
                echo '</div>'; 
            }


            if( $surgicalRisk['restricoes'] != ''){
                echo '<div class="col-sm-12 data-field">';
                   echo '<b>Restrições:</b>';
                echo '</div>';

                echo '<div class="col-sm-12 data-field">';
                   echo '<div class="textos">'.$surgicalRisk['restricoes'].'</div>';
                echo '</div>';        
            }

            
        ?>
    
</div>




<script>
  window.onload = setTimeout(function(){$.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});},1);
  
  (function(){
    
    $("form :input").prop('readonly', true);
    $("form :input").css('readonly', true);
    $('nav').css('display','none');

    // definindo a função de Print
    function PrintPage() {
        window.print();
        setTimeout(function () {
          $.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});
          window.close();
        },900);
    }

    //chamando a função de imprimir
    setTimeout(function(){ 
      PrintPage();
    },600);

  })();
</script>