<?php
  $from = new DateTime($patient['birthday']->i18nFormat('dd-MM-yyyy'));
  $to   = new DateTime('today');
  $age  = null;
  $age  = $from->diff($to)->y;
?>
<style>
    .sub-th{
        background-color:#337ab7!important;
        color:#fff!important;
        text-align:center!important;
    }
    .sub-th strong{
        text-align:center!important;
    }
    .table td,th{
      text-align:left;
    }
</style>
<div class="container unit-header">
        <div class="bundles form col-sm-4 columns content">
            
            <?= 
             $this->Html->image('uploads/'. $unit_logo, ['alt' => 'GH', 'height'=>'50px', 'style'=>"margin-top: 7px;"])
            ?>
            <br><br>
            <p class="unit-data"><b><?= $unit->name ?></b></p>
            <p class="unit-data"><b><?= $unit->telephone ?></b></p>
            <p class="unit-data"><b><?= $unit->street ?></b></p>
            <p class="unit-data"><b><?= $unit->city ?></b></p>
            <br>
        </div>   
        <div class="col-sm-8">
            <h1>Protocolo de TEV Cirúrgico</h1>
        </div>
        
</div>

<div class="col-sm-12 data-field">
  <table class="table table-bordered">
    <tr>
      <td><span class="inline-data"><b>Paciente:</b>&nbsp;<?= $patient->nome ?></span></td>
      <td><span class="inline-data"><b>Idade:</b>&nbsp;<?= $age ?></span></td>
      <td><span class="inline-data"><b>Setor:</b>&nbsp;<?= $hospitalization->sector['name'] ?></span></td>
      <td><span class="inline-data"><b>Leito:</b>&nbsp;<?= $hospitalization->roomName($hospitalization['id'])?></span></td>
      <td><span class="inline-data"><b>Prontuário:</b>&nbsp;<?= $hospitalization->numero_do_prontuario ?></span></td>
    </tr>
  </table>
  <br><br>
</div>

<div class="surgicalTevProtocols view col-lg-9 col-md-9">

<table class="table table-striped table-hover">

    <tr style="background-color:#337ab7; color:#fff!important;">
        <th class='sub-th' colspan="2"><strong> Avaliação do risco de TEV em paciente cirúrgico  </strong></th>
    </tr>    
     
<?php if($surgicalTevProtocol->risco_da_cirurgica) ?>

        <tr>
            <th>Risco da Cirurgica</th>
            <td>
                <?php
                
                   $risco=['Cirurgia de pequeno porte com duração < 60min e internação < 2 dias', 'Cirurgia de risco alto', 'Cirurgia de porte médio e alto ou duração >= 60min'];

                    if ( isset($surgicalTevProtocol->risco_da_cirurgica) ){
                       echo $risco[h($surgicalTevProtocol->risco_da_cirurgica)];
                    }
                 ?>
             </td>
        </tr>

    <?php if($surgicalTevProtocol->risco_da_cirurgica == 0){ ?>

        <tr>
            <th>Idade</th>
            <td>
                <?= $age ?>
            </td>
        </tr>
        
        <tr>
            <th>Data de preenchimento</th>
            <td>
                <?php 
                  if(isset($surgicalTevProtocol->created)):
                    echo $surgicalTevProtocol->created->format('d/m/Y'); 
                  endif;
                ?>
            </td>
        </tr>

        <tr>
            <th>Endoscopia</th>
            <td><?= $surgicalTevProtocol->endoscopia ? __('Sim') : __('Não'); ?></td>
         </tr>
        <tr>
            <th>Ressecção prostática transuretral</th>
            <td><?= $surgicalTevProtocol->resseccao ? __('Sim') : __('Não'); ?></td>
         </tr>
        <tr>
            <th>Laparoscopica</th>
            <td><?= $surgicalTevProtocol->laparoscopica ? __('Sim') : __('Não'); ?></td>
         </tr>
        <tr>
            <th>Superficial (mama, plástica, dermatológica) </th>
            <td><?= $surgicalTevProtocol->superficial ? __('Sim') : __('Não'); ?></td>
         </tr>
        <tr>
            <th>Oftalmológica </th>
            <td><?= $surgicalTevProtocol->oftamologica ? __('Sim') : __('Não'); ?></td>
         </tr>
        <tr>
            <th> Otorrinolaringológica </th>
            <td><?= $surgicalTevProtocol->otominrigologica ? __('Sim') : __('Não'); ?></td>
         </tr>
        <tr>
            <th>Fisioterapia Motora</th>
            <td><?= $surgicalTevProtocol->fisioterapia_motora ? __('Sim') : __('Não'); ?></td>
         </tr>

         <tr>
            <th> Outras </th>
            <td><?= $surgicalTevProtocol->outras?></td>
         </tr>
       
     <?php }else if($surgicalTevProtocol->risco_da_cirurgica == 1){ ?>
        
        <tr>
            <th>Idade</th>
            <td>
                <?= $age ?>
            </td>
        </tr>
        
        <tr>
            <th>Data de preenchimento</th>
            <td>
                <?php 
                  if(isset($surgicalTevProtocol->created)):
                    echo $surgicalTevProtocol->created->format('d/m/Y'); 
                  endif;
                ?>
            </td>
        </tr>


        <tr>
            <th>Artroplastia de quadril</th>
            <td><?= h($surgicalTevProtocol->artopressia_quadril)  ? __('Sim') : __('Não'); ?></td>
        </tr>
        <tr>
            <th>Artroplastia de joelho</th>
            <td><?= h($surgicalTevProtocol->artopressa_joelho) ? __('Sim') : __('Não'); ?></td>
        </tr>
        <tr>
            <th>Fratura de quadril</th>
            <td><?= h($surgicalTevProtocol->fratura_de_quadril) ? __('Sim') : __('Não'); ?></td>
        </tr>
        <tr>
            <th>Oncológica curativa</th>
            <td><?= h($surgicalTevProtocol->oncologia_curativa) ? __('Sim') : __('Não'); ?></td>
        </tr>
        <tr>
            <th>Trauma raquimendular</th>
            <td><?= $surgicalTevProtocol->trauma_requimedular ? __('Sim') : __('Não'); ?></td>
         </tr>

        <tr>
            <th>Poltrauma</th>
            <td><?= $surgicalTevProtocol->poltrauma ? __('Sim') : __('Não'); ?></td>
         </tr>
        
        <tr style="background-color:#337ab7; color:#fff!important;">
            <th class='sub-th' colspan="2"><strong>Contra indicação para profilaxia medicamentosa</strong></th>
        </tr>
        
        <tr>
            <th>Sangramento Ativo</th>
            <td><?= $surgicalTevProtocol->sangramento_ativo ? __('Sim') : __('Não'); ?></td>
         </tr>
        <tr>
            <th>Ulcera péptica</th>
            <td><?= $surgicalTevProtocol->ulcera_peptica ? __('Sim') : __('Não'); ?></td>
         </tr>
        <tr>
            <th>HAS não controlado (> 180 x 110mmHG)/th>
            <td><?= $surgicalTevProtocol->has_nao_controlada ? __('Sim') : __('Não'); ?></td>
         </tr>
        <tr>
            <th>Coagulopatia (plaquetopenia ou INR > 1,5)</th>
            <td><?= $surgicalTevProtocol->cagulopatia ? __('Sim') : __('Não'); ?></td>
         </tr>
        <tr>
            <th>Alergia ou plaquetopenia por heparina</th>
            <td><?= $surgicalTevProtocol->alergia_ou_plaquetopenia ? __('Sim') : __('Não'); ?></td>
         </tr>
        <tr>
            <th>Insuficiência renal (Cr* < 30mL/min)</th>
            <td><?= $surgicalTevProtocol->insuficiencia_renal ? __('Sim') : __('Não'); ?></td>
         </tr>
        <tr>
            <th>Coleta de LCR < 24h</th>
            <td><?= $surgicalTevProtocol->coleta_de_lcr ? __('Sim') : __('Não'); ?></td>
         </tr>
        <tr>
            <th>Raquinaelose</th>
            <td><?= $surgicalTevProtocol->raquinaelose ? __('Sim') : __('Não'); ?></td>
         </tr>
        <tr>
            <th>Paciente Em Anticuagulante</th>
            <td><?= $surgicalTevProtocol->paciente_em_anticuagulante ? __('Sim') : __('Não'); ?></td>
        </tr>

        <tr class="profilaxia-mecanica-tr" style="background-color:#337ab7;color:#fff!important;">
            <th class='sub-th' colspan="2"><strong>Profilaxia mecânica indicada</strong></th>
        </tr>

        <tr class="profilaxia-mecanica-tr" >
            <th>Meias elásticas de compressão gradual</th>
            <td class="profilaxia-mecanica-td"><?= $surgicalTevProtocol->meias_elasticas ? __('Sim') : __('Não'); ?></td>
        </tr>

        <tr class="profilaxia-mecanica-tr" >
            <th>Compressão pneumática intermitente</th>
            <td class="profilaxia-mecanica-td"><?= $surgicalTevProtocol->compressao_pneumatica ? __('Sim') : __('Não'); ?></td>
        </tr>

        <tr class="profilaxia-mecanica-tr">
            <th>Fisioterapia motora para membros inferiores</th>
            <td class="profilaxia-mecanica-td"><?= $surgicalTevProtocol->fisioterapia_motora ? __('Sim') : __('Não'); ?></td>
        </tr>



        <tr class="profilaxia-medicamentosa-tr" style="background-color:#337ab7; color:#fff!important;">
            <th class='sub-th' colspan="2"><strong>Profilaxia medicamentosa</strong></th>
        </tr>

        <tr class="profilaxia-medicamentosa-tr">
            <th>Enoxaparina</th>
            <td class="profilaxia-medicamentosa-td"><?= $surgicalTevProtocol->enoxaparina ? __('Sim') : __('Não'); ?></td>
        </tr>

        <tr class="profilaxia-medicamentosa-tr">
            <th>Dalteparina</th>
            <td class="profilaxia-medicamentosa-td"><?= $surgicalTevProtocol->dalteparina ? __('Sim') : __('Não'); ?></td>
        </tr>

        <tr class="profilaxia-medicamentosa-tr">
            <th>Fondaparinux</th>
            <td class="profilaxia-medicamentosa-td"><?= $surgicalTevProtocol->fondaparinux ? __('Sim') : __('Não'); ?></td>
        </tr>

        <tr class="profilaxia-medicamentosa-tr">
            <th>Nadroparina</th>
            <td class="profilaxia-medicamentosa-td"><?= $surgicalTevProtocol->nadroparina ? __('Sim') : __('Não'); ?></td>
        </tr>

        <tr class="profilaxia-medicamentosa-tr">
            <th>Heparina não funciona</th>
            <td class="profilaxia-medicamentosa-td"><?= $surgicalTevProtocol->heparina_nao_funciona ? __('Sim') : __('Não'); ?></td>
        </tr>


        <tr class="profilaxia-medicamentosa-tr">
            <th>Data de início de profilaxia medicamentosa</th>
            <td class="profilaxia-medicamentosa-td">
                <?php 
                  if(isset($surgicalTevProtocol->profilaxia_medicamentosa_inicio)):
                    echo $surgicalTevProtocol->profilaxia_medicamentosa_inicio->format('d/m/Y'); 
                  endif;
                ?>
            </td>
        </tr>

        <tr class="profilaxia-medicamentosa-tr">
            <th>Data de término de profilaxia medicamentosa</th>
            <td class="profilaxia-medicamentosa-td">
                <?php 
                  if(isset($surgicalTevProtocol->profilaxia_medicamentosa_termino)):
                    echo $surgicalTevProtocol->profilaxia_medicamentosa_termino->format('d/m/Y'); 
                  endif;
                ?>
            </td>
        </tr>

   <?php }else if($surgicalTevProtocol->risco_da_cirurgica == 2){ ?>
        
        <tr>
            <th>Idade</th>
            <td>
                <?= $age ?>
            </td>
        </tr>

        <tr>
            <th>Data de preenchimento</th>
            <td>
                <?php 
                  if(isset($surgicalTevProtocol->created)):
                    echo $surgicalTevProtocol->created->format('d/m/Y'); 
                  endif;
                ?>
            </td>
        </tr>

        <tr>
            <th>Fatores de Risco Tev</th>
            <td><?= $surgicalTevProtocol->fatores_de_risco_tev ? __('Sim') : __('Não'); ?></td>
        </tr>

        <tr>
            <th>Artroplastia de quadril</th>
            <td><?= h($surgicalTevProtocol->artopressia_quadril)  ? __('Sim') : __('Não'); ?></td>
        </tr>
        <tr>
            <th>Artroplastia de joelho</th>
            <td><?= h($surgicalTevProtocol->artopressa_joelho) ? __('Sim') : __('Não'); ?></td>
        </tr>
        <tr>
            <th>Fratura de quadril</th>
            <td><?= h($surgicalTevProtocol->fratura_de_quadril) ? __('Sim') : __('Não'); ?></td>
        </tr>
        <tr>
            <th>Oncológica curativa</th>
            <td><?= h($surgicalTevProtocol->oncologia_curativa) ? __('Sim') : __('Não'); ?></td>
        </tr>
        <tr>
            <th>Trauma raquimendular</th>
            <td><?= $surgicalTevProtocol->trauma_requimedular ? __('Sim') : __('Não'); ?></td>
         </tr>

        <tr>
            <th>Poltrauma</th>
            <td><?= $surgicalTevProtocol->poltrauma ? __('Sim') : __('Não'); ?></td>
         </tr>
        
        <tr  style="background-color:#337ab7; color:#fff!important;">
            <th class='sub-th' colspan="2"><strong>Contra indicação para profilaxia medicamentosa</strong></th>
        </tr>
        
        <tr>
            <th>Sangramento Ativo</th>
            <td><?= $surgicalTevProtocol->sangramento_ativo ? __('Sim') : __('Não'); ?></td>
         </tr>
        <tr>
            <th>Ulcera péptica</th>
            <td><?= $surgicalTevProtocol->ulcera_peptica ? __('Sim') : __('Não'); ?></td>
         </tr>
        <tr>
            <th>HAS não controlado (> 180 x 110mmHG)/th>
            <td><?= $surgicalTevProtocol->has_nao_controlada ? __('Sim') : __('Não'); ?></td>
         </tr>
        <tr>
            <th>Coagulopatia (plaquetopenia ou INR > 1,5)</th>
            <td><?= $surgicalTevProtocol->cagulopatia ? __('Sim') : __('Não'); ?></td>
         </tr>
        <tr>
            <th>Alergia ou plaquetopenia por heparina</th>
            <td><?= $surgicalTevProtocol->alergia_ou_plaquetopenia ? __('Sim') : __('Não'); ?></td>
         </tr>
        <tr>
            <th>Insuficiência renal (Cr* < 30mL/min)</th>
            <td><?= $surgicalTevProtocol->insuficiencia_renal ? __('Sim') : __('Não'); ?></td>
         </tr>
        <tr>
            <th>Coleta de LCR < 24h</th>
            <td><?= $surgicalTevProtocol->coleta_de_lcr ? __('Sim') : __('Não'); ?></td>
         </tr>
        <tr>
            <th>Raquinaelose</th>
            <td><?= $surgicalTevProtocol->raquinaelose ? __('Sim') : __('Não'); ?></td>
         </tr>
        <tr>
            <th>Paciente Em Anticuagulante</th>
            <td><?= $surgicalTevProtocol->paciente_em_anticuagulante ? __('Sim') : __('Não'); ?></td>
        </tr>

        <tr class="profilaxia-mecanica-tr"  style="background-color:#337ab7;color:#fff!important;">
            <th class='sub-th' colspan="2"><strong>Profilaxia mecânica indicada</strong></th>
        </tr>

        <tr class="profilaxia-mecanica-tr">
            <th>Meias elásticas de compressão gradual</th>
            <td class="profilaxia-mecanica-td"><?= $surgicalTevProtocol->meias_elasticas ? __('Sim') : __('Não'); ?></td>
        </tr>

        <tr class="profilaxia-mecanica-tr">
            <th>Compressão pneumática intermitente</th>
            <td class="profilaxia-mecanica-td"><?= $surgicalTevProtocol->compressao_pneumatica ? __('Sim') : __('Não'); ?></td>
        </tr>

        <tr class="profilaxia-mecanica-tr">
            <th>Fisioterapia motora para membros inferiores</th>
            <td class="profilaxia-mecanica-td"><?= $surgicalTevProtocol->fisioterapia_motora ? __('Sim') : __('Não'); ?></td>
        </tr>

        <tr  class="profilaxia-medicamentosa-tr" style="background-color:#337ab7; color:#fff!important;">
            <th class='sub-th' colspan="2"><strong>Profilaxia medicamentosa</strong></th>
        </tr>

        <tr class="profilaxia-medicamentosa-tr">
            <th>Enoxaparina</th>
            <td class="profilaxia-medicamentosa-td"><?= $surgicalTevProtocol->enoxaparina ? __('Sim') : __('Não'); ?></td>
        </tr>

        <tr class="profilaxia-medicamentosa-tr">
            <th>Dalteparina</th>
            <td class="profilaxia-medicamentosa-td"><?= $surgicalTevProtocol->dalteparina ? __('Sim') : __('Não'); ?></td>
        </tr>

        <tr class="profilaxia-medicamentosa-tr">
            <th>Fondaparinux</th>
            <td class="profilaxia-medicamentosa-td"><?= $surgicalTevProtocol->fondaparinux ? __('Sim') : __('Não'); ?></td>
        </tr>

        <tr class="profilaxia-medicamentosa-tr">
            <th>Nadroparina</th>
            <td class="profilaxia-medicamentosa-td"><?= $surgicalTevProtocol->nadroparina ? __('Sim') : __('Não'); ?></td>
        </tr>

        <tr class="profilaxia-medicamentosa-tr">
            <th>Heparina não funciona</th>
            <td class="profilaxia-medicamentosa-td"><?= $surgicalTevProtocol->heparina_nao_funciona ? __('Sim') : __('Não'); ?></td>
        </tr>


        <tr class="profilaxia-medicamentosa-tr">
            <th>Data de inicio</th>
            <td class="profilaxia-medicamentosa-td">
                <?php 
                  if(isset($surgicalTevProtocol->profilaxia_medicamentosa_inicio)):
                    echo $surgicalTevProtocol->profilaxia_medicamentosa_inicio->format('d/m/Y'); 
                  endif;
                ?>
            </td>
        </tr>

        <tr class="profilaxia-medicamentosa-tr">
            <th>Data de término</th>
            <td class="profilaxia-medicamentosa-td">
               <?php 
                  if(isset($surgicalTevProtocol->profilaxia_medicamentosa_termino)):
                    echo $surgicalTevProtocol->profilaxia_medicamentosa_termino->format('d/m/Y'); 
                  endif;
                ?> 
            </td>
        </tr>


  <?php } ?>

</table>

<div style="min-width:100%;" class="related no-break">
    <?php if (!empty($surgicalTevProtocol->tev_options)): ?>
        <table style="min-width:100%;" class="table table-striped table-hover">
            <tr style="min-width:100%; background-color:#337ab7; color:#fff!important;">
               <th class='sub-th' colspan="2"><strong>Fatores de risco</strong></th>
            </tr>
            <tr style="min-width:100%;">
                <td>
                    
                    <?php
                        $t='';

                        foreach ($surgicalTevProtocol->tev_options as $key => $tevOptions) {
                               $t.= $tevOptions->nome.', ';
                        }

                        $t = trim($t,", ");


                        echo '<div style="min-width:100%;" class="col-sm-12 data-field">';
                          echo '<div style="min-width:100%;" class="textos">'.$t.'</div>';
                        echo '</div>';
                    ?>

                </td>
            </tr>
        </table>
    <?php endif; ?>
</div>

</div>


<script>

  
  
  (function(){
    window.onload = setTimeout(function(){$.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});},1);

    var preenchidosProfilaxiaMecanica = 0;

    $('.profilaxia-mecanica-td').each(function(){
        //console.log($(this).text());
        if( $(this).text() == "Sim" && $(this).text() != '' && $(this).text() != 'Não' ){
            preenchidosProfilaxiaMecanica++;
        }
    });
    
    if(preenchidosProfilaxiaMecanica == 0){
        $('.profilaxia-mecanica-td').remove();
        $('.profilaxia-mecanica-tr').remove();
    }

    //checando os campos preenchidos de Profilaxia Medicamentosa

    var preenchidosProfilaxiaMedicamentosa = 0;

    $('.profilaxia-medicamentosa-td').each(function(){
        console.log($(this).text());
        if( $(this).text() == "Sim" && $(this).text() != '' && $(this).text() != 'Não' ){
            preenchidosProfilaxiaMedicamentosa++;
        }
    });
    console.log("counter>"+preenchidosProfilaxiaMedicamentosa);
    
    if(preenchidosProfilaxiaMedicamentosa == 0){
        $('.profilaxia-medicamentosa-td').remove();
        $('.profilaxia-medicamentosa-tr').remove();
    }
    
    $("form :input").prop('readonly', true);
    $("form :input").css('readonly', true);
    $('nav').css('display','none');

    // definindo a função de Print
    function PrintPage() {
        window.print();
        setTimeout(function () {
          $.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});
          window.close();
        },900);
    }

    //chamando a função de imprimir
    setTimeout(function(){ 
      PrintPage();
    },600);

  })();


</script>
