<?php

    $from = new DateTime($patient['birthday']->i18nFormat('dd-MM-yyyy'));
    $to   = new DateTime('today');
    $age = null;
    $age = $from->diff($to)->y;


    if(isset($suspectedMeProtocol['data_nao_houve_captacao'])){
        $suspectedMeProtocol['data_nao_houve_captacao'] =$suspectedMeProtocol['data_nao_houve_captacao']->format('d/m/Y');
    }

    if(isset($suspectedMeProtocol['2_exame_hora'])){$suspectedMeProtocol['2_exame_hora']=$suspectedMeProtocol['2_exame_hora']->i18nFormat('HH:mm');}
    
    if(isset($suspectedMeProtocol['1_exame_hora'])){$suspectedMeProtocol['1_exame_hora']=$suspectedMeProtocol['1_exame_hora']->i18nFormat('HH:mm');}
    
    if(isset($suspectedMeProtocol['hora_captcao_orgaos'])){$suspectedMeProtocol['hora_captcao_orgaos']=$suspectedMeProtocol['hora_captcao_orgaos']->i18nFormat('HH:mm');}
    
    if(isset($suspectedMeProtocol['data_captcao_orgaos'])){$suspectedMeProtocol['data_captcao_orgaos']=$suspectedMeProtocol['data_captcao_orgaos']->format('d/m/Y');}

    if(isset($suspectedMeProtocol['hora_nao_houve_captacao'])){$suspectedMeProtocol['hora_nao_houve_captacao']=$suspectedMeProtocol['hora_nao_houve_captacao']->i18nFormat('HH:mm');}

    if(isset($suspectedMeProtocol['fechamento_obito_hora'])){$suspectedMeProtocol['fechamento_obito_hora']=$suspectedMeProtocol['fechamento_obito_hora']->i18nFormat('HH:mm');}
    
    if(isset($suspectedMeProtocol['fechamento_obito_data'])){$suspectedMeProtocol['fechamento_obito_data']=$suspectedMeProtocol['fechamento_obito_data']->format('d/m/Y');}

     $causa_do_coma=['Traumatismo Craniano'=>'Traumatismo Craniano', 'Hipoxemia'=>'Hipoxemia', 'Parada Cardiorrespiratória'=>'Parada Cardiorrespiratória', 'AVE Isquêmico'=>'AVE Isquêmico', 'AVE Hemorrágico'=>'AVE Hemorrágico', 'Edema Cerebral'=>'Edema Cerebral', 'Hipertensão Intracraniana'=>'Hipertensão Intracraniana', 'Tumores Cerebrais'=>'Tumores Cerebrais', 'Overdose'=>'Overdose', 'Hipoglicemia'=>'Hipoglicemia'];

    $exame_tipo=[""=>"","Eletroencefalograma"=>'Eletroencefalograma', 'Doppler Transcraniano'=>'Doppler Transcraniano', 'Arteriografia Cerebral'=>'Arteriografia Cerebral', 'Cintilografia Cerebral'=>'Cintilografia Cerebral', 'SPECT'=>'SPECT', 'Potenciais Evocados'=>'Potenciais Evocados'];

     $orgaos=['Córnea', 'Coração', 'Pulmão', 'Rim', 'Fígado', 'Pãncreas', 'Osso'];

    $orgaos_cadaver=["orgaos_doar_cadaver_cornea"=>'Córnea', "orgaos_doar_cadaver_rin"=>'Rim', "orgaos_doar_cadaver_ossos"=>'Osso'];

    $orgaos_potenciais=[
     'potencial_orgao_cornea'=>'Córnea',
     'potencial_orgao_pulmao'=>'Pulmão',
     'potencial_orgao_coracao'=>'Coração',
     'potencial_orgao_rin'=>'Rim',
     'potencial_orgao_figado'=>'Fígado',
     'potencial_orgao_pancreas'=>'Pâncreas',
     'potencial_orgao_ossos'=>'Osso'
    ];
    // $date = new DateTime();
    // $date->setDate('1995', '11', '30');
    // $date->setTime('20', '50');
    // print_r( $date );

     $checked_img = $this->Html->image('checked.png', ['class' => 'tick-box','alt' => 'GH', 'height'=>'22px', 'style'=>""]);

     $not_checked_img = $this->Html->image('not-checked.png', ['class' => 'tick-box','alt' => 'GH', 'height'=>'22px', 'style'=>""]);

?>
<div class="page">

    <div class="container unit-header">
            <div class="bundles form col-sm-4 columns content">

                <?=
                 $this->Html->image('uploads/'. $unit_logo, ['alt' => 'GH', 'height'=>'50px', 'style'=>"margin-top: 7px;"])
                ?>
                <br><br>
                <p class="unit-data"><b><?= $unit->name ?></b></p>
                <p class="unit-data"><b><?= $unit->telephone ?></b></p>
                <p class="unit-data"><b><?= $unit->street ?></b></p>
                <p class="unit-data"><b><?= $unit->city ?></b></p>
                <br>
            </div>
            <div class="col-sm-8">
                <h1>CIHDOT</h1>
            </div>

    </div>

    <div class="col-sm-12 data-field">
      <table class="table table-bordered">
        <tr>
          <td><span class="inline-data"><b>Paciente:</b>&nbsp;<?= $patient->nome ?></span></td>
          <td><span class="inline-data"><b>Idade:</b>&nbsp;<?= $age ?></span></td>
          <td><span class="inline-data"><b>Setor:</b>&nbsp;<?= $hospitalization->sector['name'] ?></span></td>
          <td><span class="inline-data"><b>Leito:</b>&nbsp;<?= $hospitalization->roomName($hospitalization['id'])?></span></td>
          <td><span class="inline-data"><b>Prontuário:</b>&nbsp;<?= $hospitalization->numero_do_prontuario ?></span></td>
        </tr>
      </table>
      <br><br>
    </div>

    <div class="col-sm-12">


    <div class="col-sm-12 no-padding">

        <legend class="big-title">CIHDOT</legend>


        <div class="col-sm-6 data-field">
            <b>Causa do coma:</b><?= $suspectedMeProtocol['causa_do_coma'] ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($suspectedMeProtocol['uso_de_drogas_depressoras']){
              echo $checked_img.'<b>Uso de drogas depressoras do sistema nervoso central</b>';
             }else{
              echo $not_checked_img.'<b>Uso de drogas depressoras do sistema nervoso central</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($suspectedMeProtocol['hiportemia']){
              echo $checked_img.'<b>Hiportemia</b>';
             }else{
              echo $not_checked_img.'<b>Hiportemia</b>';
             }
          ?>
        </div>

            

        <?php  

            $sds='';

            foreach ($suspectedMeProtocol['sedative_drugs'] as $key => $sedative_drug) {
                   $sds .= $sedative_drug['nome'].',';
            }

            $sds = trim($sds,",");

            if($suspectedMeProtocol['paciente_fez_uso_droga_sedativo']){

                echo '<div class="col-sm-12 data-field">';
                   echo '<b>Paciente fez uso de droga com efeito sedativo/hipnótico:</b>';
                echo '</div>';

                echo '<div class="col-sm-12 data-field">';
                  echo '<div class="textos no-break">'.$sds.'</div>';
                echo '</div>';

            }else{

                echo '<div class="col-sm-6 data-field">';
                    echo $not_checked_img.'<b>Paciente fez uso de droga com efeito sedativo/hipnótico</b>';
                echo '</div>';   
            }
        ?>
            
    </div>


    <div class="col-sm-12 no-padding">

        <legend class="big-title">1º Exame</legend>

        <div class="col-sm-6 data-field">
            <b>Data:</b><?= $suspectedMeProtocol['1_exame_data'] ?>
        </div>

        <div class="col-sm-6 data-field">
            <b>Hora:</b><?= $suspectedMeProtocol['1_exame_hora'] ?>
        </div>

        <legend class='subtitle-sections'>Sinais Vitais</legend>

        <div class="col-sm-6 data-field">
            <b>PAS (mmHg):</b><?= $suspectedMeProtocol['1_pas'] ?>
        </div>

        <div class="col-sm-6 data-field">
            <b>PAD (mmHg):</b><?= $suspectedMeProtocol['1_pad'] ?>
        </div>

        <div class="col-sm-6 data-field">
            <b>PAM (mmHg):</b><?= $suspectedMeProtocol['1_pam'] ?>
        </div>

        <div class="col-sm-6 data-field">
            <b>FC (bpm):</b><?= $suspectedMeProtocol['1_fc'] ?>
        </div>

        <div class="col-sm-6 data-field">
            <b>FR (irm):</b><?= $suspectedMeProtocol['1_fr'] ?>
        </div>
        
        <div class="col-sm-6 data-field">
            <b>Sato2 (%):</b><?= $suspectedMeProtocol['1_sato2'] ?>
        </div>

        <div class="col-sm-6 data-field">
            <b>Temp (ºC):</b><?= $suspectedMeProtocol['1_temp'] ?>
        </div>

        <div class="col-sm-6 data-field">
            <b>Glicemia (mg/dl):</b><?= $suspectedMeProtocol['1_glicemia'] ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($suspectedMeProtocol['1_ausencia_reflexo_pupilar']){
              echo $checked_img.'<b>Ausência de reflexo pupilar fotomotor (II e III pares) bilateral</b>';
             }else{
              echo $not_checked_img.'<b>Ausência de reflexo pupilar fotomotor (II e III pares) bilateral</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($suspectedMeProtocol['1_exame_ausencia_de_reflexo_corneo']){
              echo $checked_img.'<b>Ausência de reflexo córneo-palpebral (V e VII pares) bilateral</b>';
             }else{
              echo $not_checked_img.'<b>Ausência de reflexo córneo-palpebral (V e VII pares) bilateral</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($suspectedMeProtocol['1_exame_ausencia_de_reflexos_oculocefalicos']){
              echo $checked_img.'<b>Ausência de reflexo oculoencefálico bilateral (VIII par)</b>';
             }else{
              echo $not_checked_img.'<b>Ausência de reflexo oculoencefálico bilateral (VIII par)</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($suspectedMeProtocol['1_ausencia_reflexo_oculovestibular']){
              echo $checked_img.'<b>Ausência de reflexo oculovestibular (VII, III, VI pares) bilateral</b>';
             }else{
              echo $not_checked_img.'<b>Ausência de reflexo oculovestibular (VII, III, VI pares) bilateral</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($suspectedMeProtocol['1_ausencia_reflexo_tosse']){
              echo $checked_img.'<b>Ausência de reflexo de tosse (IX e X pares)</b>';
             }else{
              echo $not_checked_img.'<b>Ausência de reflexo de tosse (IX e X pares)</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($suspectedMeProtocol['1_ausencia_drive']){
              echo $checked_img.'<b>Ausência de drive respiratório (“teste de apnéia”)</b>';
             }else{
              echo $not_checked_img.'<b>Ausência de drive respiratório (“teste de apnéia”)</b>';
             }
          ?>
        </div>
       

    </div>


    <div class="col-sm-12 no-padding">


        <legend class="big-title">2º Exame</legend>

        <div class="col-sm-6 data-field">
            <b>Data:</b><?= $suspectedMeProtocol['2_exame_data'] ?>
        </div>

        <div class="col-sm-6 data-field">
            <b>Hora:</b><?= $suspectedMeProtocol['2_exame_hora'] ?>
        </div>

        <legend class='subtitle-sections'>Sinais Vitais</legend>


        <div class="col-sm-6 data-field">
            <b>PAS (mmHg):</b><?= $suspectedMeProtocol['2_pas'] ?>
        </div>

        <div class="col-sm-6 data-field">
            <b>PAD (mmHg):</b><?= $suspectedMeProtocol['2_pad'] ?>
        </div>

        <div class="col-sm-6 data-field">
            <b>PAM (mmHg):</b><?= $suspectedMeProtocol['2_pam'] ?>
        </div>

        <div class="col-sm-6 data-field">
            <b>FC (bpm):</b><?= $suspectedMeProtocol['2_fc'] ?>
        </div>

        <div class="col-sm-6 data-field">
            <b>FR (irm):</b><?= $suspectedMeProtocol['2_fr'] ?>
        </div>
        
        <div class="col-sm-6 data-field">
            <b>Sato2 (%):</b><?= $suspectedMeProtocol['2_sato2'] ?>
        </div>

        <div class="col-sm-6 data-field">
            <b>Temp (ºC):</b><?= $suspectedMeProtocol['2_temp'] ?>
        </div>

        <div class="col-sm-6 data-field">
            <b>Glicemia (mg/dl):</b><?= $suspectedMeProtocol['2_glicemia'] ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($suspectedMeProtocol['2_ausencia_reflexo_pupilar']){
              echo $checked_img.'<b>Ausência de reflexo pupilar fotomotor (II e III pares) bilateral</b>';
             }else{
              echo $not_checked_img.'<b>Ausência de reflexo pupilar fotomotor (II e III pares) bilateral</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($suspectedMeProtocol['2_exame_ausencia_de_reflexo_corneo']){
              echo $checked_img.'<b>Ausência de reflexo córneo-palpebral (V e VII pares) bilateral</b>';
             }else{
              echo $not_checked_img.'<b>Ausência de reflexo córneo-palpebral (V e VII pares) bilateral</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($suspectedMeProtocol['2_exame_ausencia_de_reflexos_oculocefalicos']){
              echo $checked_img.'<b>Ausência de reflexo oculoencefálico bilateral (VIII par)</b>';
             }else{
              echo $not_checked_img.'<b>Ausência de reflexo oculoencefálico bilateral (VIII par)</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($suspectedMeProtocol['2_ausencia_reflexo_oculovestibular']){
              echo $checked_img.'<b>Ausência de reflexo oculovestibular (VII, III, VI pares) bilateral</b>';
             }else{
              echo $not_checked_img.'<b>Ausência de reflexo oculovestibular (VII, III, VI pares) bilateral</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($suspectedMeProtocol['2_ausencia_reflexo_tosse']){
              echo $checked_img.'<b>Ausência de reflexo de tosse (IX e X pares)</b>';
             }else{
              echo $not_checked_img.'<b>Ausência de reflexo de tosse (IX e X pares)</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($suspectedMeProtocol['2_ausencia_drive']){
              echo $checked_img.'<b>Ausência de drive respiratório (“teste de apnéia”)</b>';
             }else{
              echo $not_checked_img.'<b>Ausência de drive respiratório (“teste de apnéia”)</b>';
             }
          ?>
        </div>

    </div>


    <?php if(!empty($suspectedMeProtocol['supplementary_examinations'])): ?>

    <div class="col-sm-12 no-padding">

        <?php

            foreach ($suspectedMeProtocol['supplementary_examinations'] as $key => $supplementary_examination) {
                $number = $key + 1;
                echo '<legend class="big-title">Exame Complementar '.$number.'</legend>';
                
                echo  '<div class="col-sm-6 data-field">';
                   echo '<b>Tipo de Exame:</b>'.$exame_tipo[$supplementary_examination['tipo_exame']];
                echo '</div>';

                echo  '<div class="col-sm-6 data-field">';
                   echo '<b>Data:</b>'.$supplementary_examination['data'];
                echo '</div>';

                echo  '<div class="col-sm-6 data-field">';
                   echo '<b>Hora:</b>'.$supplementary_examination['hora'];
                echo '</div>';

                echo '<div class="col-sm-12 data-field">';
                   echo '<b>Laudo:</b>';
                echo '</div>';

                echo '<div class="col-sm-12 data-field">';
                  echo '<div class="textos no-break no-break">'.$supplementary_examination['laudo'].'</div>';
                echo '</div>';
            }
        ?>       

    </div>

    <?php endif;?>

</div>

<div class="page">

<div class="col-sm-12 no-padding">

    <legend class="big-title">Comunicação de óbito à família</legend>

    <div class="col-sm-6 data-field">
        <b>Data:</b><?= $suspectedMeProtocol['fechamento_obito_data'] ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>Hora:</b><?= $suspectedMeProtocol['fechamento_obito_hora'] ?>
    </div>

    <div class="col-sm-6 data-field">
      <?php  
        if($suspectedMeProtocol['1_acolhimento']){
          echo $checked_img.'<b>Realizado acolhimento familiar</b>';
         }else{
          echo $not_checked_img.'<b>Realizado acolhimento familiar</b>';
         }
      ?>
    </div>

    <?php if($suspectedMeProtocol['1_acolhimento']): ?>

        <div class="col-sm-12 data-field">
            <b>Motivo:</b>
        </div>

        <div class="col-sm-12 data-field no-break">
          <div class="textos no-break"><?= $suspectedMeProtocol['1_acolhimento_motivo']?></div>
        </div>
         
        <div class="col-sm-6 data-field">
            <b>Data:&nbsp;</b><?= $suspectedMeProtocol['1_acolhimento_data']; ?>
        </div>

        <div class="col-sm-6 data-field">
            <b>Hora:&nbsp;</b><?= $suspectedMeProtocol['1_acolhimento_hora']; ?>
        </div>

    
    <?php endif;?>



    <div class="col-sm-6 data-field">
      <?php  
        if($suspectedMeProtocol['2_acolhimento']){
          echo $checked_img.'<b>Realizado 2° acolhimento familiar</b>';
         }else{
          echo $not_checked_img.'<b>Realizado acolhimento familiar</b>';
         }
      ?>
    </div>


    <?php if($suspectedMeProtocol['2_acolhimento']): ?>

        <div class="col-sm-12 data-field">
            <b>Motivo:</b>
        </div>

        <div class="col-sm-12 data-field no-break">
          <div class="textos no-break"><?= $suspectedMeProtocol['2_acolhimento_motivo']?></div>
        </div>
         
        <div class="col-sm-6 data-field">
            <b>Data:&nbsp;</b><?= $suspectedMeProtocol['2_acolhimento_data']; ?>
        </div>

        <div class="col-sm-6 data-field">
            <b>Hora:&nbsp;</b><?= $suspectedMeProtocol['2_acolhimento_hora']; ?>
        </div>

    <?php endif;?>


    <legend class="big-title">Doação de Órgãos e Tecidos</legend>

     <!-- exame colhido -->
    <div class="col-sm-6 data-field">
      <?php  
        if($suspectedMeProtocol['fechamento_exame_colhido']){
          echo $checked_img.'<b>Colhidos exames laboratoriais após autorização familiar para sorologia e bioquímica</b>';
         }else{
          echo $not_checked_img.'<b>Colhidos exames laboratoriais após autorização familiar para sorologia e bioquímica</b>';
         }
      ?>
    </div>


    <?php if($suspectedMeProtocol['fechamento_exame_colhido']): ?>

        <div class="col-sm-12 data-field">
            <b>Motivo:</b>
        </div>

        <div class="col-sm-12 data-field no-break">
          <div class="textos no-break"><?= $suspectedMeProtocol['fechamento_exame_colhido_motivo']?></div>
        </div>
         
        <div class="col-sm-6 data-field">
            <b>Data:&nbsp;</b><?= $suspectedMeProtocol['fechamento_exame_colhido_data']; ?>
        </div>

        <div class="col-sm-6 data-field">
            <b>Hora:&nbsp;</b><?= $suspectedMeProtocol['fechamento_exame_colhido_hora']; ?>
        </div>

    <?php endif;?>



   <!-- fechamento exame encaminhado  -->

    <div class="col-sm-6 data-field">
      <?php  
        if($suspectedMeProtocol['fechamento_encaminhado_exame']){
          echo $checked_img.'<b>Exame encaminhado para central de transplante</b>';
         }else{
          echo $not_checked_img.'<b>Exame encaminhado para central de transplante</b>';
         }
      ?>
    </div>


    <?php if($suspectedMeProtocol['fechamento_encaminhado_exame']): ?>

        <div class="col-sm-12 data-field">
            <b>Motivo:</b>
        </div>

        <div class="col-sm-12 data-field no-break">
          <div class="textos no-break"><?= $suspectedMeProtocol['fechamento_encaminhado_exame_motivo']?></div>
        </div>
         
        <div class="col-sm-6 data-field">
            <b>Data:&nbsp;</b><?= $suspectedMeProtocol['fechamento_encaminhado_exame_data']; ?>
        </div>

        <div class="col-sm-6 data-field">
            <b>Hora:&nbsp;</b><?= $suspectedMeProtocol['fechamento_encaminhado_exame_hora']; ?>
        </div>

    <?php endif;?>



    <!-- agendamento de sala  -->

    <div class="col-sm-6 data-field">
      <?php  
        if($suspectedMeProtocol['fechamento_solicitado_agendamento']){
          echo $checked_img.'<b>Solicitado agendamento da sala cirúrgica</b>';
         }else{
          echo $not_checked_img.'<b>Solicitado agendamento da sala cirúrgica</b>';
         }
      ?>
    </div>


    <?php if($suspectedMeProtocol['fechamento_solicitado_agendamento']): ?>

         
        <div class="col-sm-6 data-field">
            <b>Data:&nbsp;</b><?= $suspectedMeProtocol['fechamento_solicitado_agendamento_data']; ?>
        </div>

        <div class="col-sm-6 data-field">
            <b>Hora:&nbsp;</b><?= $suspectedMeProtocol['fechamento_solicitado_agendamento_hora']; ?>
        </div>

    <?php endif;?>



    <!-- não houve captação  -->

    <div class="col-sm-6 data-field">
      <?php  
        if($suspectedMeProtocol['nao_houve_captacao']){
          echo $checked_img.'<b>Não houve captação</b>';
         }else{
          echo $not_checked_img.'<b>Não houve captação</b>';
         }
      ?>
    </div>


    <?php if($suspectedMeProtocol['nao_houve_captacao']): ?>

        <div class="col-sm-12 data-field">
            <b>Motivo:</b>
        </div>

        <div class="col-sm-12 data-field no-break">
          <div class="textos no-break"><?= $suspectedMeProtocol['motivo_nao_houve_captacao']?></div>
        </div>

        <div class="col-sm-6 data-field">
            <b>Data:&nbsp;</b><?= $suspectedMeProtocol['data_nao_houve_captacao']; ?>
        </div>

        <div class="col-sm-6 data-field">
            <b>Hora:&nbsp;</b><?= $suspectedMeProtocol['hora_nao_houve_captacao']; ?>
        </div>

    <?php else: ?>    


        <?php  

            // orgãos em captados
            $orgCap='';

            foreach ($suspectedMeProtocol['organs'] as $key => $orgao_captado) {
                   $orgCap .= $orgao_captado['nome'].',';
            }

            $orgCap = trim($orgCap,",");

            

            // orgãos em potencial
            $orgPot='';

            foreach ($suspectedMeProtocol['potential_organs'] as $key => $orgao_potencial) {
                   $orgPot .= $orgao_potencial['nome'].',';
            }

            $orgPot = trim($orgPot,",");

        ?>
        
        <div class="col-sm-12 data-field">
            <b>Orgãos Captados:</b>
        </div>

        <div class="col-sm-12 data-field">
          <div class="textos no-break"><?= $orgCap ?></div>
        </div>

        <div class="col-sm-12 data-field">
            <b>Potenciais órgãos para doação:</b>
        </div>

        <div class="col-sm-12 data-field">
          <div class="textos no-break"><?= $orgCap ?></div>
        </div>

        <div class="col-sm-6 data-field">
            <b>Data de captação dos orgãos:&nbsp;</b><?= $suspectedMeProtocol['data_captcao_orgaos']; ?>
        </div>

        <div class="col-sm-6 data-field">
            <b>Hora de captação dos orgãos:&nbsp;</b><?= $suspectedMeProtocol['hora_captcao_orgaos']; ?>
        </div>


    <?php endif;?>


    <!-- captação de orgão em cadáver  -->

    <div class="col-sm-6 data-field">
      <?php  
        if($suspectedMeProtocol['captacao_de_orgaos_cadaver']){
          echo $checked_img.'<b>Captação de orgãos em cadáver</b>';
         }else{
          echo $not_checked_img.'<b>Captação de orgãos em cadáver</b>';
         }
      ?>
    </div>


    <?php if($suspectedMeProtocol['captacao_de_orgaos_cadaver']): ?>

        <?php  

            $obtOrg='';

            foreach ($suspectedMeProtocol['obtained_organs_from_corpses'] as $key => $obtained_organ) {
                   $obtOrg .= $obtained_organ['nome'].',';
            }

            $obtOrg = trim($obtOrg,",");

        ?> 

        <div class="col-sm-12 data-field">
            <b>Órgãos captados:</b>
        </div>

        <div class="col-sm-12 data-field">
          <div class="textos no-break"><?= $obtOrg ?></div>
        </div>   

    <?php endif;?>



</div>


<div class="col-sm-12 no-padding">

    <legend class="big-title">Hematológico</legend>

    <div class="col-sm-6 data-field">
        <b>Hemoglobina:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.hemoglobina']; ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>Hematócrito:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.hematocrito']; ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>Leucograma:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.leucograma']; ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>Plaquetas:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.plaquetas']; ?>
    </div>

    <legend class="big-title">Eletrólitos</legend>

    <div class="col-sm-6 data-field">
        <b>Sódio:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.sodio']; ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>Potássio:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.potassio']; ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>Potássio:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.potassio']; ?>
    </div>

    <legend class="big-title">Função pulmonar</legend>

    <div class="col-sm-6 data-field">
        <b>PH:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.ph']; ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>PH:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.ph']; ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>PO2:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.po2']; ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>PCO2:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.pco2']; ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>SaTO2:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.sato2']; ?>
    </div>

    <legend class="big-title">Função cardíaca</legend>

    <div class="col-sm-6 data-field">
        <b>CPK:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.cpk']; ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>CPK:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.ckmb']; ?>
    </div>

    <legend class="big-title">Função renal</legend>

    <div class="col-sm-6 data-field">
        <b>Creatinina:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.creatinuma']; ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>Ureia:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.ureia']; ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>Ureia:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.ureia']; ?>
    </div>

    <legend class="big-title">Função hepática</legend>

    <div class="col-sm-6 data-field">
        <b>TGO:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.tgo']; ?>
    </div>
    
    <div class="col-sm-6 data-field">
        <b>TGP:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.tgp']; ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>GGT:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.ggt']; ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>Bilirrubina total:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.bilirrubina']; ?>
    </div>

    <legend class="big-title">Função pancreática</legend>

    <div class="col-sm-6 data-field">
        <b>Glicemia:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.glicemia']; ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>Amilase:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.amilase']; ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>Lipase:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.lipase']; ?>
    </div>

</div>

    <legend class="big-title">Tipagem sanguínea</legend>

    <div class="col-sm-6 data-field">
        <b>Classificação ABO:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.classificacao_abo']; ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>Fator RA:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.fator_ra']; ?>
    </div>

    <legend class="big-title">Sorologia</legend>

    <div class="col-sm-6 data-field">
        <b>HIV:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.hiv']; ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>Toxoplasmose:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.toxoplasmose']; ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>Sífilis:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.sifilis']; ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>Doença de chagas:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.doenca_chagas']; ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>Hepatite B:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.hepatite_b']; ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>Hepatite C:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.hepatite_c']; ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>Citomegalovírus:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.citomegalovirus']; ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>Vírus linfotrópico humano:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.virus_linfotropico']; ?>
    </div>

    <legend class="big-title">Drogas vasoativas</legend>

    <div class="col-sm-6 data-field">
        <b>Noradrenalina:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.noradrenalina']; ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>Vasopressina:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.vasopressina']; ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>Dopamina:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.dopamina']; ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>Dopamina:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.dopamina']; ?>
    </div>

    <div class="col-sm-6 data-field">
        <b>Dobutamina:&nbsp;</b><?= $suspectedMeProtocol['laboratory_examinations.0.dobutamina']; ?>
    </div>

</div>
</div>



<script>

    window.onload = setTimeout(function(){$.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});},1);


    $('#nao_houve_captacao').change(function(){
        if($(this).is(':checked')){
            

            $('.organ_related_fields input').each(function(){
                $(this).val('');
            });

            $("#organs-ids").val('');

            $('.organ_related_fields').slideUp();


        }else{
            $('.organ_related_fields').slideDown();
        }
    });

    if($('#nao_houve_captacao').is(':checked')){
        
        $('.organ_related_fields input').each(function(){
                $(this).val('');
        });


        $("#organs-ids").val('');


        $('.organ_related_fields').slideUp();
        
        

    }else{
        $('.organ_related_fields').slideDown();
    }


var cont = 1;
var count_orgao = 0;
var count_droga = 0;


function addHtml (type) 
{
    var html ='';

    if (type == "droga") 
    {
        count_droga++;
        console.log("droga");
        html +='<div  class="row" id="row_droga_'+count_droga+'" style="margin-top:15px">';

        html +=' <div class="col-xs-7 col-sm-7 col-md-7 col-lg-7">';
        html +='<input type="text" name="sedative_drugs[][nome]" placeholder="Nome da droga" class="form-control name_list " />';

        html +='</div>';
        html +='<div class="col-xs-2 col-sm-2 col-md-2 col-lg-2">';
        html +='<input type="text" name="sedative_drugs[][data]" placeholder="Data" class="form-control name_list date" /></div>';

        html +='<div class="col-xs-2 col-sm-2 col-md-2 col-lg-2">';
        html +='<input type="text" name="sedative_drugs[][hora]" placeholder="Hora" class="form-control name_list time" /> </div>';

        html +='<div class="col-xs-1">';
        html +='<button style="margin-top:0px;" type="button" name="remove" id="droga_'+count_droga+'" onclick="removeHtml(this, \'droga\', '+count_droga+')" class="btn_remove btn btn-danger btn-md"><i class="glyphicon glyphicon-minus" aria-hidden="true"></i></div></div>';
        $('#dynamic_field_1').append(html);

    } 
    else if (type == "orgao") 
    {
        count_orgao++;

        html +='<div  class="row" id="row_orgao_'+count_orgao+'" style="margin-top:15px">';
        html +='<div class="col-xs-7 col-sm-7 col-md-7 col-lg-7">';
        html +='<select name="obtained_organs[][nome]" id="obtained-organs-nome" class="form-control">';
        html +='<option selected value=""></option>';
        html +='<option value="Córnea">Córnea</option>';
        html +='<option value="Rins">Rins</option>';
        html +='<option value="Ossos">Ossos</option>';
        html +='</select>';
        html +='</div>';

        html +='<div class="col-xs-4 col-sm-4 col-md-4 col-lg-4">';
        html +='<input type="text" name="obtained_organs[][tempo_apos_parada_cardiaca]" placeholder="Tempo após parada cardiáca" class="form-control name_list time" /></div>';

        html +='<div class="col-xs-1">';
        html +='<button style="margin-top:0px;" type="button" name="remove" id="orgao_'+count_orgao+'" onclick="removeHtml(this, \'orgao\', '+count_orgao+')"  class="btn_remove btn btn-danger btn-md"><i class="glyphicon glyphicon-minus" aria-hidden="true"></i></div></div>';
        $('#dynamic_field_2').append(html);
    }


    $(".date").mask("99/99/9999",
    {
        placeholder: "dd/mm/yyyy"
    });
    $('.time').mask('99:99');
}

// $(document).on('click', '.btn_remove', function(){
//         i--;
//        var button_id = $(this).attr("id");
//        $('#row'+button_id+'').remove();
// });

function removeHtml(elem, type, num, deleteFromDb) {

    // var button_id = $(elem).attr("id");
    console.log("removeHtml");

    if (type == "orgao") {
        count_orgao--;
        console.log("remove orgao");
        $('#row_orgao_'+num+'').remove();

    } else if (type == "droga") {
        count_droga--;
        console.log("remove droga");
        $('#row_droga_'+num+'').remove();
    }

    if (deleteFromDb) {
        if (type == "orgao") {
            var html = "<input class='hide-element' name='delete_obtained_organs[]id' value='"+num+"' />";
            $("#myForm").append(html);
        } else if (type == "droga") {
            var html = "<input class='hide-element' name='dlete_sedative_drugs[]id' value='"+num+"' />";
            $("#myForm").append(html);
        }
    }
}


/*$("#paciente_fez_uso_droga_sedativo").change(function() {
    if ( $(this).is(":checked") ) {
        $(".paciente_fez_uso_droga_sedativo").slideDown();
    } else {
        $(".paciente_fez_uso_droga_sedativo").slideUp();
    }
});


$("#1_acolhimento").change(function() {
    console.log("yi");
    if ($(this).is(":checked")) {
        $(".1_acolhimento").slideDown();
    } else {
        $(".1_acolhimento").slideUp();
    }
});

$("#2_acolhimento").change(function() {
    console.log("yi");
    if ($(this).is(":checked")) {
        $(".2_acolhimento").slideDown();
    } else {
        $(".2_acolhimento").slideUp();
    }
});


$("#fechamento_exame_colhido").change(function() {
    console.log("yi");
    if ($(this).is(":checked")) {
        $(".fechamento_exame_colhido").slideDown();
    } else {
        $(".fechamento_exame_colhido").slideUp();
    }
});

$("#fechamento_encaminhado_exame").change(function() {
    console.log("yi");
    if ($(this).is(":checked")) {
        $(".fechamento_encaminhado_exame").slideDown();
    } else {
        $(".fechamento_encaminhado_exame").slideUp();
    }
});

$("#fechamento_solicitado_agendamento").change(function() {
    if ($(this).is(":checked")) {
        $(".fechamento_solicitado_agendamento").slideDown();
    } else {
        $(".fechamento_solicitado_agendamento").slideUp();
    }
});

$("#captacao_de_orgaos_cadaver").change(function() {
    if ($(this).is(":checked")) {
        $(".captacao_de_orgaos_cadaver").slideDown();
    } else {
        $(".captacao_de_orgaos_cadaver").slideUp();
    }
});*/

$( document ).ready(function() {

    setTimeout(function() {
        $(".funkyradio-primary input").trigger("change");
        console.log("BOoom");
    }, 2000);

    $( document ).ready(function() {
        setTimeout(function(){$(".active_checked").trigger("change");},1000);
    });
});

function addAvaliation(){
    cont++;

    var html_form ='<div ><br><br><legend class="big-title">Exame complementar</legend><div class="form-group select"><label class="form-input" for="supplementary-examinations-tipo-exame">Tipo de exame:</label><select name="supplementary_examinations['+cont+'][tipo_exame]" class=" form-control" id="supplementary-examinations-tipo-exame"><option value="Eletroencefalograma">Eletroencefalograma</option><option value="Doppler Transcraniano">Doppler Transcraniano</option><option value="Arteriografia cerebral">Arteriografia cerebral</option><option value="Cintilografia cerebral">Cintilografia cerebral</option><option value="SPECT">SPECT</option><option value="Potenciais Evocados">Potenciais Evocados</option></select></div><div class="form-group text"><label class="form-input" for="supplementary-examinations-data">Data:</label><input type="text" name="supplementary_examinations['+cont+'][data]" class="date form-control" maxlength="45" id="supplementary-examinations-data"></div><div class="form-group text"><label class="form-input" for="supplementary-examinations-hora">Hora:</label><input type="text" name="supplementary_examinations['+cont+'][hora]" class="time form-control" id="supplementary-examinations-hora"></div><div class="form-group textarea"><label class="form-input" for="supplementary-examinations-laudo">Laudo:</label><textarea name="supplementary_examinations['+cont+'][laudo]" class=" form-control" maxlength="450" id="supplementary-examinations-laudo" rows="3"></textarea></div></div>';

    console.log("addAvaliation");
    // html_form.appendTo("#tab_default_4");
    $("#tab_default_4").append(html_form);

    $(".date").mask("99/99/9999",
    {
        placeholder: "dd/mm/yyyy"
    });

    $('.time').mask('99:99');
}



  
  (function(){
    $(".pad-top-20").removeClass('container');
    $(".pad-top-20").addClass('container-fluid');
    $(".pad-top-20").css('padding-top','0px');
    
    $("form :input").prop('readonly', true);
    $("form :input").css('readonly', true);
    $('nav').css('display','none');

    // definindo a função de Print
    function PrintPage() {
        window.print();
        setTimeout(function () {
          $.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});
          window.close();
        },900);
    }

    // chamando a função de imprimir
    setTimeout(function(){ 
      PrintPage();
    },600);

  })();
</script>
