<?php
namespace App\Test\Fixture;

use Cake\TestSuite\Fixture\TestFixture;

/**
 * IndicatorsSectorsFixture
 *
 */
class IndicatorsSectorsFixture extends TestFixture
{

    /**
     * Fields
     *
     * @var array
     */
    // @codingStandardsIgnoreStart
    public $fields = [
        'id' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => false, 'default' => null, 'comment' => '', 'autoIncrement' => true, 'precision' => null],
        'taxa_de_ocupacao' => ['type' => 'float', 'length' => null, 'precision' => null, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => ''],
        'indice_de_giro_de_leito' => ['type' => 'float', 'length' => null, 'precision' => null, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => ''],
        'intervalo_de_substituicao' => ['type' => 'float', 'length' => null, 'precision' => null, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => ''],
        'faixa_de_internacao_menor_que_24h' => ['type' => 'float', 'length' => null, 'precision' => null, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => ''],
        'faixa_de_internacao_ate_7_dias' => ['type' => 'float', 'length' => null, 'precision' => null, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => ''],
        'faixa_de_internacao_ate_21_dias' => ['type' => 'float', 'length' => null, 'precision' => null, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => ''],
        'faixa_de_internacao_superior_28_dias' => ['type' => 'float', 'length' => null, 'precision' => null, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => ''],
        'taxa_de_reinternacao' => ['type' => 'float', 'length' => null, 'precision' => null, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => ''],
        'tempo_medio_decisao_de_alta_e_alta_efetiva' => ['type' => 'time', 'length' => null, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null],
        'tempo_medio_permanencia_paciente_em_obito' => ['type' => 'time', 'length' => null, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null],
        'total_de_pacientes_no_mes' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'percentual_de_altas' => ['type' => 'float', 'length' => null, 'precision' => null, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => ''],
        'tempo_de_permanencia_minimo' => ['type' => 'time', 'length' => null, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null],
        'tempo_de_permanencia_medio' => ['type' => 'time', 'length' => null, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null],
        'tempo_de_permanencia_maximo' => ['type' => 'time', 'length' => null, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null],
        'sector_id' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => false, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        '_indexes' => [
            'fk_indicators_sectors_sectors1_idx' => ['type' => 'index', 'columns' => ['sector_id'], 'length' => []],
        ],
        '_constraints' => [
            'primary' => ['type' => 'primary', 'columns' => ['id'], 'length' => []],
            'fk_indicators_sectors_sectors1' => ['type' => 'foreign', 'columns' => ['sector_id'], 'references' => ['sectors', 'id'], 'update' => 'noAction', 'delete' => 'noAction', 'length' => []],
        ],
        '_options' => [
            'engine' => 'InnoDB',
            'collation' => 'utf8_general_ci'
        ],
    ];
    // @codingStandardsIgnoreEnd

    /**
     * Records
     *
     * @var array
     */
    public $records = [
        [
            'id' => 1,
            'taxa_de_ocupacao' => 1,
            'indice_de_giro_de_leito' => 1,
            'intervalo_de_substituicao' => 1,
            'faixa_de_internacao_menor_que_24h' => 1,
            'faixa_de_internacao_ate_7_dias' => 1,
            'faixa_de_internacao_ate_21_dias' => 1,
            'faixa_de_internacao_superior_28_dias' => 1,
            'taxa_de_reinternacao' => 1,
            'tempo_medio_decisao_de_alta_e_alta_efetiva' => '18:23:15',
            'tempo_medio_permanencia_paciente_em_obito' => '18:23:15',
            'total_de_pacientes_no_mes' => 1,
            'percentual_de_altas' => 1,
            'tempo_de_permanencia_minimo' => '18:23:15',
            'tempo_de_permanencia_medio' => '18:23:15',
            'tempo_de_permanencia_maximo' => '18:23:15',
            'sector_id' => 1
        ],
    ];
}
